// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPRouteDeleteCollectionReader is a Reader for the NetworkIPRouteDeleteCollection structure.
type NetworkIPRouteDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPRouteDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPRouteDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPRouteDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPRouteDeleteCollectionOK creates a NetworkIPRouteDeleteCollectionOK with default headers values
func NewNetworkIPRouteDeleteCollectionOK() *NetworkIPRouteDeleteCollectionOK {
	return &NetworkIPRouteDeleteCollectionOK{}
}

/*
NetworkIPRouteDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPRouteDeleteCollectionOK struct {
}

// IsSuccess returns true when this network Ip route delete collection o k response has a 2xx status code
func (o *NetworkIPRouteDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip route delete collection o k response has a 3xx status code
func (o *NetworkIPRouteDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip route delete collection o k response has a 4xx status code
func (o *NetworkIPRouteDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip route delete collection o k response has a 5xx status code
func (o *NetworkIPRouteDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip route delete collection o k response a status code equal to that given
func (o *NetworkIPRouteDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip route delete collection o k response
func (o *NetworkIPRouteDeleteCollectionOK) Code() int {
	return 200
}

func (o *NetworkIPRouteDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /network/ip/routes][%d] networkIpRouteDeleteCollectionOK", 200)
}

func (o *NetworkIPRouteDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /network/ip/routes][%d] networkIpRouteDeleteCollectionOK", 200)
}

func (o *NetworkIPRouteDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPRouteDeleteCollectionDefault creates a NetworkIPRouteDeleteCollectionDefault with default headers values
func NewNetworkIPRouteDeleteCollectionDefault(code int) *NetworkIPRouteDeleteCollectionDefault {
	return &NetworkIPRouteDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
NetworkIPRouteDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type NetworkIPRouteDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip route delete collection default response has a 2xx status code
func (o *NetworkIPRouteDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip route delete collection default response has a 3xx status code
func (o *NetworkIPRouteDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip route delete collection default response has a 4xx status code
func (o *NetworkIPRouteDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip route delete collection default response has a 5xx status code
func (o *NetworkIPRouteDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip route delete collection default response a status code equal to that given
func (o *NetworkIPRouteDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip route delete collection default response
func (o *NetworkIPRouteDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPRouteDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/routes][%d] network_ip_route_delete_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPRouteDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/routes][%d] network_ip_route_delete_collection default %s", o._statusCode, payload)
}

func (o *NetworkIPRouteDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPRouteDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
NetworkIPRouteDeleteCollectionBody network IP route delete collection body
swagger:model NetworkIPRouteDeleteCollectionBody
*/
type NetworkIPRouteDeleteCollectionBody struct {

	// error
	Error *models.Error `json:"error,omitempty"`

	// network route response inline records
	NetworkRouteResponseInlineRecords []*models.NetworkRoute `json:"records,omitempty"`
}

// Validate validates this network IP route delete collection body
func (o *NetworkIPRouteDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateError(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNetworkRouteResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPRouteDeleteCollectionBody) validateError(formats strfmt.Registry) error {
	if swag.IsZero(o.Error) { // not required
		return nil
	}

	if o.Error != nil {
		if err := o.Error.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPRouteDeleteCollectionBody) validateNetworkRouteResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.NetworkRouteResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.NetworkRouteResponseInlineRecords); i++ {
		if swag.IsZero(o.NetworkRouteResponseInlineRecords[i]) { // not required
			continue
		}

		if o.NetworkRouteResponseInlineRecords[i] != nil {
			if err := o.NetworkRouteResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this network IP route delete collection body based on the context it is used
func (o *NetworkIPRouteDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateError(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNetworkRouteResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *NetworkIPRouteDeleteCollectionBody) contextValidateError(ctx context.Context, formats strfmt.Registry) error {

	if o.Error != nil {
		if err := o.Error.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "error")
			}
			return err
		}
	}

	return nil
}

func (o *NetworkIPRouteDeleteCollectionBody) contextValidateNetworkRouteResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.NetworkRouteResponseInlineRecords); i++ {

		if o.NetworkRouteResponseInlineRecords[i] != nil {
			if err := o.NetworkRouteResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *NetworkIPRouteDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *NetworkIPRouteDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res NetworkIPRouteDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
