// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPRouteDeleteReader is a Reader for the NetworkIPRouteDelete structure.
type NetworkIPRouteDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPRouteDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPRouteDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPRouteDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPRouteDeleteOK creates a NetworkIPRouteDeleteOK with default headers values
func NewNetworkIPRouteDeleteOK() *NetworkIPRouteDeleteOK {
	return &NetworkIPRouteDeleteOK{}
}

/*
NetworkIPRouteDeleteOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPRouteDeleteOK struct {
}

// IsSuccess returns true when this network Ip route delete o k response has a 2xx status code
func (o *NetworkIPRouteDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip route delete o k response has a 3xx status code
func (o *NetworkIPRouteDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip route delete o k response has a 4xx status code
func (o *NetworkIPRouteDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip route delete o k response has a 5xx status code
func (o *NetworkIPRouteDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip route delete o k response a status code equal to that given
func (o *NetworkIPRouteDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip route delete o k response
func (o *NetworkIPRouteDeleteOK) Code() int {
	return 200
}

func (o *NetworkIPRouteDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /network/ip/routes/{uuid}][%d] networkIpRouteDeleteOK", 200)
}

func (o *NetworkIPRouteDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /network/ip/routes/{uuid}][%d] networkIpRouteDeleteOK", 200)
}

func (o *NetworkIPRouteDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewNetworkIPRouteDeleteDefault creates a NetworkIPRouteDeleteDefault with default headers values
func NewNetworkIPRouteDeleteDefault(code int) *NetworkIPRouteDeleteDefault {
	return &NetworkIPRouteDeleteDefault{
		_statusCode: code,
	}
}

/*
NetworkIPRouteDeleteDefault describes a response with status code -1, with default header values.

Error
*/
type NetworkIPRouteDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip route delete default response has a 2xx status code
func (o *NetworkIPRouteDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip route delete default response has a 3xx status code
func (o *NetworkIPRouteDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip route delete default response has a 4xx status code
func (o *NetworkIPRouteDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip route delete default response has a 5xx status code
func (o *NetworkIPRouteDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip route delete default response a status code equal to that given
func (o *NetworkIPRouteDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip route delete default response
func (o *NetworkIPRouteDeleteDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPRouteDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/routes/{uuid}][%d] network_ip_route_delete default %s", o._statusCode, payload)
}

func (o *NetworkIPRouteDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ip/routes/{uuid}][%d] network_ip_route_delete default %s", o._statusCode, payload)
}

func (o *NetworkIPRouteDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPRouteDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
