// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkIPRoutesGetParams creates a new NetworkIPRoutesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkIPRoutesGetParams() *NetworkIPRoutesGetParams {
	return &NetworkIPRoutesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkIPRoutesGetParamsWithTimeout creates a new NetworkIPRoutesGetParams object
// with the ability to set a timeout on a request.
func NewNetworkIPRoutesGetParamsWithTimeout(timeout time.Duration) *NetworkIPRoutesGetParams {
	return &NetworkIPRoutesGetParams{
		timeout: timeout,
	}
}

// NewNetworkIPRoutesGetParamsWithContext creates a new NetworkIPRoutesGetParams object
// with the ability to set a context for a request.
func NewNetworkIPRoutesGetParamsWithContext(ctx context.Context) *NetworkIPRoutesGetParams {
	return &NetworkIPRoutesGetParams{
		Context: ctx,
	}
}

// NewNetworkIPRoutesGetParamsWithHTTPClient creates a new NetworkIPRoutesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkIPRoutesGetParamsWithHTTPClient(client *http.Client) *NetworkIPRoutesGetParams {
	return &NetworkIPRoutesGetParams{
		HTTPClient: client,
	}
}

/*
NetworkIPRoutesGetParams contains all the parameters to send to the API endpoint

	for the network ip routes get operation.

	Typically these are written to a http.Request.
*/
type NetworkIPRoutesGetParams struct {

	/* DestinationAddress.

	   Filter by destination.address
	*/
	DestinationAddress *string

	/* DestinationFamily.

	   Filter by destination.family
	*/
	DestinationFamily *string

	/* DestinationNetmask.

	   Filter by destination.netmask
	*/
	DestinationNetmask *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Gateway.

	   Filter by gateway
	*/
	Gateway *string

	/* InterfacesIPAddress.

	   Filter by interfaces.ip.address
	*/
	InterfacesIPAddress *string

	/* InterfacesName.

	   Filter by interfaces.name
	*/
	InterfacesName *string

	/* InterfacesUUID.

	   Filter by interfaces.uuid
	*/
	InterfacesUUID *string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Metric.

	   Filter by metric
	*/
	Metric *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ip routes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPRoutesGetParams) WithDefaults() *NetworkIPRoutesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ip routes get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPRoutesGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NetworkIPRoutesGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithTimeout(timeout time.Duration) *NetworkIPRoutesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithContext(ctx context.Context) *NetworkIPRoutesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithHTTPClient(client *http.Client) *NetworkIPRoutesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDestinationAddress adds the destinationAddress to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithDestinationAddress(destinationAddress *string) *NetworkIPRoutesGetParams {
	o.SetDestinationAddress(destinationAddress)
	return o
}

// SetDestinationAddress adds the destinationAddress to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetDestinationAddress(destinationAddress *string) {
	o.DestinationAddress = destinationAddress
}

// WithDestinationFamily adds the destinationFamily to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithDestinationFamily(destinationFamily *string) *NetworkIPRoutesGetParams {
	o.SetDestinationFamily(destinationFamily)
	return o
}

// SetDestinationFamily adds the destinationFamily to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetDestinationFamily(destinationFamily *string) {
	o.DestinationFamily = destinationFamily
}

// WithDestinationNetmask adds the destinationNetmask to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithDestinationNetmask(destinationNetmask *string) *NetworkIPRoutesGetParams {
	o.SetDestinationNetmask(destinationNetmask)
	return o
}

// SetDestinationNetmask adds the destinationNetmask to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetDestinationNetmask(destinationNetmask *string) {
	o.DestinationNetmask = destinationNetmask
}

// WithFields adds the fields to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithFields(fields []string) *NetworkIPRoutesGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithGateway adds the gateway to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithGateway(gateway *string) *NetworkIPRoutesGetParams {
	o.SetGateway(gateway)
	return o
}

// SetGateway adds the gateway to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetGateway(gateway *string) {
	o.Gateway = gateway
}

// WithInterfacesIPAddress adds the interfacesIPAddress to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithInterfacesIPAddress(interfacesIPAddress *string) *NetworkIPRoutesGetParams {
	o.SetInterfacesIPAddress(interfacesIPAddress)
	return o
}

// SetInterfacesIPAddress adds the interfacesIpAddress to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetInterfacesIPAddress(interfacesIPAddress *string) {
	o.InterfacesIPAddress = interfacesIPAddress
}

// WithInterfacesName adds the interfacesName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithInterfacesName(interfacesName *string) *NetworkIPRoutesGetParams {
	o.SetInterfacesName(interfacesName)
	return o
}

// SetInterfacesName adds the interfacesName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetInterfacesName(interfacesName *string) {
	o.InterfacesName = interfacesName
}

// WithInterfacesUUID adds the interfacesUUID to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithInterfacesUUID(interfacesUUID *string) *NetworkIPRoutesGetParams {
	o.SetInterfacesUUID(interfacesUUID)
	return o
}

// SetInterfacesUUID adds the interfacesUuid to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetInterfacesUUID(interfacesUUID *string) {
	o.InterfacesUUID = interfacesUUID
}

// WithIpspaceName adds the ipspaceName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithIpspaceName(ipspaceName *string) *NetworkIPRoutesGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithIpspaceUUID(ipspaceUUID *string) *NetworkIPRoutesGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithMaxRecords adds the maxRecords to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithMaxRecords(maxRecords *int64) *NetworkIPRoutesGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetric adds the metric to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithMetric(metric *int64) *NetworkIPRoutesGetParams {
	o.SetMetric(metric)
	return o
}

// SetMetric adds the metric to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetMetric(metric *int64) {
	o.Metric = metric
}

// WithOrderBy adds the orderBy to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithOrderBy(orderBy []string) *NetworkIPRoutesGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithReturnRecords(returnRecords *bool) *NetworkIPRoutesGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithReturnTimeout(returnTimeout *int64) *NetworkIPRoutesGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithScope(scope *string) *NetworkIPRoutesGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithSvmName adds the svmName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithSvmName(svmName *string) *NetworkIPRoutesGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithSvmUUID(svmUUID *string) *NetworkIPRoutesGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the network ip routes get params
func (o *NetworkIPRoutesGetParams) WithUUID(uuid *string) *NetworkIPRoutesGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ip routes get params
func (o *NetworkIPRoutesGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkIPRoutesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.DestinationAddress != nil {

		// query param destination.address
		var qrDestinationAddress string

		if o.DestinationAddress != nil {
			qrDestinationAddress = *o.DestinationAddress
		}
		qDestinationAddress := qrDestinationAddress
		if qDestinationAddress != "" {

			if err := r.SetQueryParam("destination.address", qDestinationAddress); err != nil {
				return err
			}
		}
	}

	if o.DestinationFamily != nil {

		// query param destination.family
		var qrDestinationFamily string

		if o.DestinationFamily != nil {
			qrDestinationFamily = *o.DestinationFamily
		}
		qDestinationFamily := qrDestinationFamily
		if qDestinationFamily != "" {

			if err := r.SetQueryParam("destination.family", qDestinationFamily); err != nil {
				return err
			}
		}
	}

	if o.DestinationNetmask != nil {

		// query param destination.netmask
		var qrDestinationNetmask string

		if o.DestinationNetmask != nil {
			qrDestinationNetmask = *o.DestinationNetmask
		}
		qDestinationNetmask := qrDestinationNetmask
		if qDestinationNetmask != "" {

			if err := r.SetQueryParam("destination.netmask", qDestinationNetmask); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Gateway != nil {

		// query param gateway
		var qrGateway string

		if o.Gateway != nil {
			qrGateway = *o.Gateway
		}
		qGateway := qrGateway
		if qGateway != "" {

			if err := r.SetQueryParam("gateway", qGateway); err != nil {
				return err
			}
		}
	}

	if o.InterfacesIPAddress != nil {

		// query param interfaces.ip.address
		var qrInterfacesIPAddress string

		if o.InterfacesIPAddress != nil {
			qrInterfacesIPAddress = *o.InterfacesIPAddress
		}
		qInterfacesIPAddress := qrInterfacesIPAddress
		if qInterfacesIPAddress != "" {

			if err := r.SetQueryParam("interfaces.ip.address", qInterfacesIPAddress); err != nil {
				return err
			}
		}
	}

	if o.InterfacesName != nil {

		// query param interfaces.name
		var qrInterfacesName string

		if o.InterfacesName != nil {
			qrInterfacesName = *o.InterfacesName
		}
		qInterfacesName := qrInterfacesName
		if qInterfacesName != "" {

			if err := r.SetQueryParam("interfaces.name", qInterfacesName); err != nil {
				return err
			}
		}
	}

	if o.InterfacesUUID != nil {

		// query param interfaces.uuid
		var qrInterfacesUUID string

		if o.InterfacesUUID != nil {
			qrInterfacesUUID = *o.InterfacesUUID
		}
		qInterfacesUUID := qrInterfacesUUID
		if qInterfacesUUID != "" {

			if err := r.SetQueryParam("interfaces.uuid", qInterfacesUUID); err != nil {
				return err
			}
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Metric != nil {

		// query param metric
		var qrMetric int64

		if o.Metric != nil {
			qrMetric = *o.Metric
		}
		qMetric := swag.FormatInt64(qrMetric)
		if qMetric != "" {

			if err := r.SetQueryParam("metric", qMetric); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetworkIPRoutesGet binds the parameter fields
func (o *NetworkIPRoutesGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNetworkIPRoutesGet binds the parameter order_by
func (o *NetworkIPRoutesGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
