// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewNetworkIPServicePoliciesGetParams creates a new NetworkIPServicePoliciesGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewNetworkIPServicePoliciesGetParams() *NetworkIPServicePoliciesGetParams {
	return &NetworkIPServicePoliciesGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewNetworkIPServicePoliciesGetParamsWithTimeout creates a new NetworkIPServicePoliciesGetParams object
// with the ability to set a timeout on a request.
func NewNetworkIPServicePoliciesGetParamsWithTimeout(timeout time.Duration) *NetworkIPServicePoliciesGetParams {
	return &NetworkIPServicePoliciesGetParams{
		timeout: timeout,
	}
}

// NewNetworkIPServicePoliciesGetParamsWithContext creates a new NetworkIPServicePoliciesGetParams object
// with the ability to set a context for a request.
func NewNetworkIPServicePoliciesGetParamsWithContext(ctx context.Context) *NetworkIPServicePoliciesGetParams {
	return &NetworkIPServicePoliciesGetParams{
		Context: ctx,
	}
}

// NewNetworkIPServicePoliciesGetParamsWithHTTPClient creates a new NetworkIPServicePoliciesGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewNetworkIPServicePoliciesGetParamsWithHTTPClient(client *http.Client) *NetworkIPServicePoliciesGetParams {
	return &NetworkIPServicePoliciesGetParams{
		HTTPClient: client,
	}
}

/*
NetworkIPServicePoliciesGetParams contains all the parameters to send to the API endpoint

	for the network ip service policies get operation.

	Typically these are written to a http.Request.
*/
type NetworkIPServicePoliciesGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IpspaceName.

	   Filter by ipspace.name
	*/
	IpspaceName *string

	/* IpspaceUUID.

	   Filter by ipspace.uuid
	*/
	IpspaceUUID *string

	/* IsBuiltIn.

	   Filter by is_built_in
	*/
	IsBuiltIn *bool

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Scope.

	   Filter by scope
	*/
	Scope *string

	/* Services.

	   Filter by services
	*/
	Services *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the network ip service policies get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPServicePoliciesGetParams) WithDefaults() *NetworkIPServicePoliciesGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the network ip service policies get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *NetworkIPServicePoliciesGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := NetworkIPServicePoliciesGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithTimeout(timeout time.Duration) *NetworkIPServicePoliciesGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithContext(ctx context.Context) *NetworkIPServicePoliciesGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithHTTPClient(client *http.Client) *NetworkIPServicePoliciesGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithFields(fields []string) *NetworkIPServicePoliciesGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIpspaceName adds the ipspaceName to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithIpspaceName(ipspaceName *string) *NetworkIPServicePoliciesGetParams {
	o.SetIpspaceName(ipspaceName)
	return o
}

// SetIpspaceName adds the ipspaceName to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetIpspaceName(ipspaceName *string) {
	o.IpspaceName = ipspaceName
}

// WithIpspaceUUID adds the ipspaceUUID to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithIpspaceUUID(ipspaceUUID *string) *NetworkIPServicePoliciesGetParams {
	o.SetIpspaceUUID(ipspaceUUID)
	return o
}

// SetIpspaceUUID adds the ipspaceUuid to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetIpspaceUUID(ipspaceUUID *string) {
	o.IpspaceUUID = ipspaceUUID
}

// WithIsBuiltIn adds the isBuiltIn to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithIsBuiltIn(isBuiltIn *bool) *NetworkIPServicePoliciesGetParams {
	o.SetIsBuiltIn(isBuiltIn)
	return o
}

// SetIsBuiltIn adds the isBuiltIn to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetIsBuiltIn(isBuiltIn *bool) {
	o.IsBuiltIn = isBuiltIn
}

// WithMaxRecords adds the maxRecords to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithMaxRecords(maxRecords *int64) *NetworkIPServicePoliciesGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithName(name *string) *NetworkIPServicePoliciesGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithOrderBy(orderBy []string) *NetworkIPServicePoliciesGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithReturnRecords(returnRecords *bool) *NetworkIPServicePoliciesGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithReturnTimeout(returnTimeout *int64) *NetworkIPServicePoliciesGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithScope adds the scope to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithScope(scope *string) *NetworkIPServicePoliciesGetParams {
	o.SetScope(scope)
	return o
}

// SetScope adds the scope to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetScope(scope *string) {
	o.Scope = scope
}

// WithServices adds the services to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithServices(services *string) *NetworkIPServicePoliciesGetParams {
	o.SetServices(services)
	return o
}

// SetServices adds the services to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetServices(services *string) {
	o.Services = services
}

// WithSvmName adds the svmName to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithSvmName(svmName *string) *NetworkIPServicePoliciesGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithSvmUUID(svmUUID *string) *NetworkIPServicePoliciesGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) WithUUID(uuid *string) *NetworkIPServicePoliciesGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the network ip service policies get params
func (o *NetworkIPServicePoliciesGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *NetworkIPServicePoliciesGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IpspaceName != nil {

		// query param ipspace.name
		var qrIpspaceName string

		if o.IpspaceName != nil {
			qrIpspaceName = *o.IpspaceName
		}
		qIpspaceName := qrIpspaceName
		if qIpspaceName != "" {

			if err := r.SetQueryParam("ipspace.name", qIpspaceName); err != nil {
				return err
			}
		}
	}

	if o.IpspaceUUID != nil {

		// query param ipspace.uuid
		var qrIpspaceUUID string

		if o.IpspaceUUID != nil {
			qrIpspaceUUID = *o.IpspaceUUID
		}
		qIpspaceUUID := qrIpspaceUUID
		if qIpspaceUUID != "" {

			if err := r.SetQueryParam("ipspace.uuid", qIpspaceUUID); err != nil {
				return err
			}
		}
	}

	if o.IsBuiltIn != nil {

		// query param is_built_in
		var qrIsBuiltIn bool

		if o.IsBuiltIn != nil {
			qrIsBuiltIn = *o.IsBuiltIn
		}
		qIsBuiltIn := swag.FormatBool(qrIsBuiltIn)
		if qIsBuiltIn != "" {

			if err := r.SetQueryParam("is_built_in", qIsBuiltIn); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Scope != nil {

		// query param scope
		var qrScope string

		if o.Scope != nil {
			qrScope = *o.Scope
		}
		qScope := qrScope
		if qScope != "" {

			if err := r.SetQueryParam("scope", qScope); err != nil {
				return err
			}
		}
	}

	if o.Services != nil {

		// query param services
		var qrServices string

		if o.Services != nil {
			qrServices = *o.Services
		}
		qServices := qrServices
		if qServices != "" {

			if err := r.SetQueryParam("services", qServices); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamNetworkIPServicePoliciesGet binds the parameter fields
func (o *NetworkIPServicePoliciesGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamNetworkIPServicePoliciesGet binds the parameter order_by
func (o *NetworkIPServicePoliciesGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
