// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NetworkIPServicePolicyGetReader is a Reader for the NetworkIPServicePolicyGet structure.
type NetworkIPServicePolicyGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *NetworkIPServicePolicyGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewNetworkIPServicePolicyGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewNetworkIPServicePolicyGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewNetworkIPServicePolicyGetOK creates a NetworkIPServicePolicyGetOK with default headers values
func NewNetworkIPServicePolicyGetOK() *NetworkIPServicePolicyGetOK {
	return &NetworkIPServicePolicyGetOK{}
}

/*
NetworkIPServicePolicyGetOK describes a response with status code 200, with default header values.

OK
*/
type NetworkIPServicePolicyGetOK struct {
	Payload *models.IPServicePolicy
}

// IsSuccess returns true when this network Ip service policy get o k response has a 2xx status code
func (o *NetworkIPServicePolicyGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this network Ip service policy get o k response has a 3xx status code
func (o *NetworkIPServicePolicyGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this network Ip service policy get o k response has a 4xx status code
func (o *NetworkIPServicePolicyGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this network Ip service policy get o k response has a 5xx status code
func (o *NetworkIPServicePolicyGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this network Ip service policy get o k response a status code equal to that given
func (o *NetworkIPServicePolicyGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the network Ip service policy get o k response
func (o *NetworkIPServicePolicyGetOK) Code() int {
	return 200
}

func (o *NetworkIPServicePolicyGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/service-policies/{uuid}][%d] networkIpServicePolicyGetOK %s", 200, payload)
}

func (o *NetworkIPServicePolicyGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/service-policies/{uuid}][%d] networkIpServicePolicyGetOK %s", 200, payload)
}

func (o *NetworkIPServicePolicyGetOK) GetPayload() *models.IPServicePolicy {
	return o.Payload
}

func (o *NetworkIPServicePolicyGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.IPServicePolicy)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewNetworkIPServicePolicyGetDefault creates a NetworkIPServicePolicyGetDefault with default headers values
func NewNetworkIPServicePolicyGetDefault(code int) *NetworkIPServicePolicyGetDefault {
	return &NetworkIPServicePolicyGetDefault{
		_statusCode: code,
	}
}

/*
NetworkIPServicePolicyGetDefault describes a response with status code -1, with default header values.

Error
*/
type NetworkIPServicePolicyGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this network ip service policy get default response has a 2xx status code
func (o *NetworkIPServicePolicyGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this network ip service policy get default response has a 3xx status code
func (o *NetworkIPServicePolicyGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this network ip service policy get default response has a 4xx status code
func (o *NetworkIPServicePolicyGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this network ip service policy get default response has a 5xx status code
func (o *NetworkIPServicePolicyGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this network ip service policy get default response a status code equal to that given
func (o *NetworkIPServicePolicyGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the network ip service policy get default response
func (o *NetworkIPServicePolicyGetDefault) Code() int {
	return o._statusCode
}

func (o *NetworkIPServicePolicyGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/service-policies/{uuid}][%d] network_ip_service_policy_get default %s", o._statusCode, payload)
}

func (o *NetworkIPServicePolicyGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ip/service-policies/{uuid}][%d] network_ip_service_policy_get default %s", o._statusCode, payload)
}

func (o *NetworkIPServicePolicyGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *NetworkIPServicePolicyGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
