// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new networking API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for networking API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	FabricCollectionGet(params *FabricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FabricCollectionGetOK, error)

	FabricGet(params *FabricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FabricGetOK, error)

	FcInterfaceCollectionGet(params *FcInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceCollectionGetOK, error)

	FcInterfaceCreate(params *FcInterfaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceCreateCreated, error)

	FcInterfaceDelete(params *FcInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceDeleteOK, error)

	FcInterfaceDeleteCollection(params *FcInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceDeleteCollectionOK, error)

	FcInterfaceGet(params *FcInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceGetOK, error)

	FcInterfaceModify(params *FcInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceModifyOK, error)

	FcInterfaceModifyCollection(params *FcInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceModifyCollectionOK, error)

	FcPortCollectionGet(params *FcPortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortCollectionGetOK, error)

	FcPortGet(params *FcPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortGetOK, error)

	FcPortModify(params *FcPortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortModifyOK, error)

	FcPortModifyCollection(params *FcPortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortModifyCollectionOK, error)

	FcSwitchCollectionGet(params *FcSwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcSwitchCollectionGetOK, error)

	FcSwitchGet(params *FcSwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcSwitchGetOK, error)

	FcZoneCollectionGet(params *FcZoneCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcZoneCollectionGetOK, error)

	FcZoneGet(params *FcZoneGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcZoneGetOK, error)

	HTTPProxyCollectionGet(params *HTTPProxyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyCollectionGetOK, error)

	HTTPProxyCreate(params *HTTPProxyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyCreateCreated, error)

	HTTPProxyDelete(params *HTTPProxyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyDeleteOK, error)

	HTTPProxyDeleteCollection(params *HTTPProxyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyDeleteCollectionOK, error)

	HTTPProxyGet(params *HTTPProxyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyGetOK, error)

	HTTPProxyModify(params *HTTPProxyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyModifyOK, error)

	HTTPProxyModifyCollection(params *HTTPProxyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyModifyCollectionOK, error)

	InterfacesMetricsCollectionGet(params *InterfacesMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InterfacesMetricsCollectionGetOK, error)

	IPServicePolicyCreate(params *IPServicePolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyCreateOK, *IPServicePolicyCreateCreated, error)

	IPServicePolicyDelete(params *IPServicePolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyDeleteOK, error)

	IPServicePolicyDeleteCollection(params *IPServicePolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyDeleteCollectionOK, error)

	IPServicePolicyModify(params *IPServicePolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyModifyOK, error)

	IPServicePolicyModifyCollection(params *IPServicePolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyModifyCollectionOK, error)

	IPSubnetCollectionGet(params *IPSubnetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetCollectionGetOK, error)

	IPSubnetCreate(params *IPSubnetCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetCreateCreated, error)

	IPSubnetDelete(params *IPSubnetDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetDeleteOK, error)

	IPSubnetDeleteCollection(params *IPSubnetDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetDeleteCollectionOK, error)

	IPSubnetGet(params *IPSubnetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetGetOK, error)

	IPSubnetModify(params *IPSubnetModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetModifyOK, error)

	IPSubnetModifyCollection(params *IPSubnetModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetModifyCollectionOK, error)

	IpspaceDelete(params *IpspaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceDeleteOK, error)

	IpspaceDeleteCollection(params *IpspaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceDeleteCollectionOK, error)

	IpspaceGet(params *IpspaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceGetOK, error)

	IpspaceModify(params *IpspaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceModifyOK, error)

	IpspaceModifyCollection(params *IpspaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceModifyCollectionOK, error)

	IpspacesCreate(params *IpspacesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspacesCreateCreated, error)

	IpspacesGet(params *IpspacesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspacesGetOK, error)

	NetworkEthernetBroadcastDomainDelete(params *NetworkEthernetBroadcastDomainDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainDeleteOK, error)

	NetworkEthernetBroadcastDomainDeleteCollection(params *NetworkEthernetBroadcastDomainDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainDeleteCollectionOK, error)

	NetworkEthernetBroadcastDomainGet(params *NetworkEthernetBroadcastDomainGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainGetOK, error)

	NetworkEthernetBroadcastDomainModify(params *NetworkEthernetBroadcastDomainModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainModifyOK, error)

	NetworkEthernetBroadcastDomainModifyCollection(params *NetworkEthernetBroadcastDomainModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainModifyCollectionOK, error)

	NetworkEthernetBroadcastDomainsCreate(params *NetworkEthernetBroadcastDomainsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainsCreateCreated, error)

	NetworkEthernetBroadcastDomainsGet(params *NetworkEthernetBroadcastDomainsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainsGetOK, error)

	NetworkEthernetPortDelete(params *NetworkEthernetPortDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortDeleteOK, *NetworkEthernetPortDeleteAccepted, error)

	NetworkEthernetPortDeleteCollection(params *NetworkEthernetPortDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortDeleteCollectionOK, *NetworkEthernetPortDeleteCollectionAccepted, error)

	NetworkEthernetPortGet(params *NetworkEthernetPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortGetOK, error)

	NetworkEthernetPortModify(params *NetworkEthernetPortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortModifyOK, error)

	NetworkEthernetPortModifyCollection(params *NetworkEthernetPortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortModifyCollectionOK, error)

	NetworkEthernetPortsCreate(params *NetworkEthernetPortsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortsCreateCreated, error)

	NetworkEthernetPortsGet(params *NetworkEthernetPortsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortsGetOK, error)

	NetworkIPBgpPeerGroupDelete(params *NetworkIPBgpPeerGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupDeleteOK, error)

	NetworkIPBgpPeerGroupDeleteCollection(params *NetworkIPBgpPeerGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupDeleteCollectionOK, error)

	NetworkIPBgpPeerGroupGet(params *NetworkIPBgpPeerGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupGetOK, error)

	NetworkIPBgpPeerGroupModify(params *NetworkIPBgpPeerGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupModifyOK, error)

	NetworkIPBgpPeerGroupModifyCollection(params *NetworkIPBgpPeerGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupModifyCollectionOK, error)

	NetworkIPBgpPeerGroupsCreate(params *NetworkIPBgpPeerGroupsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupsCreateCreated, error)

	NetworkIPBgpPeerGroupsGet(params *NetworkIPBgpPeerGroupsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupsGetOK, error)

	NetworkIPInterfaceDelete(params *NetworkIPInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceDeleteOK, error)

	NetworkIPInterfaceDeleteCollection(params *NetworkIPInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceDeleteCollectionOK, error)

	NetworkIPInterfaceGet(params *NetworkIPInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceGetOK, error)

	NetworkIPInterfaceModify(params *NetworkIPInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceModifyOK, error)

	NetworkIPInterfaceModifyCollection(params *NetworkIPInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceModifyCollectionOK, error)

	NetworkIPInterfacesCreate(params *NetworkIPInterfacesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfacesCreateCreated, error)

	NetworkIPInterfacesGet(params *NetworkIPInterfacesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfacesGetOK, error)

	NetworkIPRouteDelete(params *NetworkIPRouteDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteDeleteOK, error)

	NetworkIPRouteDeleteCollection(params *NetworkIPRouteDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteDeleteCollectionOK, error)

	NetworkIPRouteGet(params *NetworkIPRouteGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteGetOK, error)

	NetworkIPRoutesCreate(params *NetworkIPRoutesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRoutesCreateCreated, error)

	NetworkIPRoutesGet(params *NetworkIPRoutesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRoutesGetOK, error)

	NetworkIPServicePoliciesGet(params *NetworkIPServicePoliciesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPServicePoliciesGetOK, error)

	NetworkIPServicePolicyGet(params *NetworkIPServicePolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPServicePolicyGetOK, error)

	PerformanceFcInterfaceMetricCollectionGet(params *PerformanceFcInterfaceMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcInterfaceMetricCollectionGetOK, error)

	PerformanceFcInterfaceMetricGet(params *PerformanceFcInterfaceMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcInterfaceMetricGetOK, error)

	PerformanceFcPortMetricCollectionGet(params *PerformanceFcPortMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcPortMetricCollectionGetOK, error)

	PerformanceFcPortMetricGet(params *PerformanceFcPortMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcPortMetricGetOK, error)

	PortMetricsCollectionGet(params *PortMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortMetricsCollectionGetOK, error)

	SwitchCollectionGet(params *SwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchCollectionGetOK, error)

	SwitchCreate(params *SwitchCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchCreateCreated, *SwitchCreateAccepted, error)

	SwitchDelete(params *SwitchDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchDeleteOK, error)

	SwitchDeleteCollection(params *SwitchDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchDeleteCollectionOK, error)

	SwitchGet(params *SwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchGetOK, error)

	SwitchModify(params *SwitchModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchModifyOK, *SwitchModifyAccepted, error)

	SwitchModifyCollection(params *SwitchModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchModifyCollectionOK, *SwitchModifyCollectionAccepted, error)

	SwitchPortCollectionGet(params *SwitchPortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchPortCollectionGetOK, error)

	SwitchPortGet(params *SwitchPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchPortGetOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	FabricCollectionGet Retrieves Fibre Channel fabrics.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connections`
* `zoneset`
### Related ONTAP commands
* `network fcp topology show`
* `network fcp zone show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FabricCollectionGet(params *FabricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FabricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFabricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fabric_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FabricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FabricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FabricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FabricGet Retrieves a Fibre Channel fabric.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `connections`
* `zoneset`
### Related ONTAP commands
* `network fcp topology show`
* `network fcp zone show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FabricGet(params *FabricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FabricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFabricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fabric_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FabricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FabricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FabricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcInterfaceCollectionGet Retrieves FC interfaces.

### Related ONTAP commands
* `network interface show`
* `vserver fcp interface show`
### Learn more
* [`DOC /network/fc/interfaces`](#docs-networking-network_fc_interfaces)
*/
func (a *Client) FcInterfaceCollectionGet(params *FcInterfaceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcInterfaceCreate Creates an FC interface.

### Required properties
* `svm.uuid` or `svm.name` - Existing SVM in which to create the FC interface.
* `name` - Name of the FC interface.
* `location.port.uuid` or both `location.port.name` and `location.port.node.name` - FC port on which to create the FC interface.
* `data_protocol` - Data protocol for the FC interface.
### Default property values
If not specified in POST, the following default property values are assigned.
* `enabled` - _true_
### Related ONTAP commands
* `network interface create`
### Learn more
* [`DOC /network/fc/interfaces`](#docs-networking-network_fc_interfaces)
*/
func (a *Client) FcInterfaceCreate(params *FcInterfaceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_create",
		Method:             "POST",
		PathPattern:        "/network/fc/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcInterfaceDelete Deletes an FC interface.

### Related ONTAP commands
* `network interface delete`
### Learn more
* [`DOC /network/fc/interfaces`](#docs-networking-network_fc_interfaces)
*/
func (a *Client) FcInterfaceDelete(params *FcInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_delete",
		Method:             "DELETE",
		PathPattern:        "/network/fc/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FcInterfaceDeleteCollection fc interface delete collection API
*/
func (a *Client) FcInterfaceDeleteCollection(params *FcInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/fc/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcInterfaceGet Retrieves an FC interface.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `network interface show`
* `vserver fcp interface show`
### Learn more
* [`DOC /network/fc/interfaces`](#docs-networking-network_fc_interfaces)
*/
func (a *Client) FcInterfaceGet(params *FcInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_get",
		Method:             "GET",
		PathPattern:        "/network/fc/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcInterfaceModify Updates an FC interface.

### Related ONTAP commands
* `network interface modify`
### Learn more
* [`DOC /network/fc/interfaces`](#docs-networking-network_fc_interfaces)
*/
func (a *Client) FcInterfaceModify(params *FcInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_modify",
		Method:             "PATCH",
		PathPattern:        "/network/fc/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FcInterfaceModifyCollection fc interface modify collection API
*/
func (a *Client) FcInterfaceModifyCollection(params *FcInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcInterfaceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcInterfaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_interface_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/fc/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcInterfaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcInterfaceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcInterfaceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcPortCollectionGet Retrieves FC ports.<br/>

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `fabric.name`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `network fcp adapter show`
### Learn more
* [`DOC /network/fc/ports`](#docs-networking-network_fc_ports)
*/
func (a *Client) FcPortCollectionGet(params *FcPortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcPortCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_port_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcPortCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcPortCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcPortCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcPortGet Retrieves an FC port.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `fabric.name`
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `network fcp adapter show`
### Learn more
* [`DOC /network/fc/ports`](#docs-networking-network_fc_ports)
*/
func (a *Client) FcPortGet(params *FcPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcPortGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_port_get",
		Method:             "GET",
		PathPattern:        "/network/fc/ports/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcPortGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcPortGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcPortGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcPortModify Updates an FC port.

### Related ONTAP commands
* `network fcp adapter modify`
### Learn more
* [`DOC /network/fc/ports`](#docs-networking-network_fc_ports)
*/
func (a *Client) FcPortModify(params *FcPortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcPortModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_port_modify",
		Method:             "PATCH",
		PathPattern:        "/network/fc/ports/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcPortModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcPortModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcPortModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
FcPortModifyCollection fc port modify collection API
*/
func (a *Client) FcPortModifyCollection(params *FcPortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcPortModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcPortModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_port_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/fc/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcPortModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcPortModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcPortModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcSwitchCollectionGet Retrieves the Fibre Channel switches of a Fibre Channel fabric.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `ports`
### Related ONTAP commands
* `network fcp topology show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FcSwitchCollectionGet(params *FcSwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcSwitchCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcSwitchCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_switch_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics/{fabric.name}/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcSwitchCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcSwitchCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcSwitchCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcSwitchGet Retrieves a Fibre Channel switch.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `ports`
### Related ONTAP commands
* `network fcp topology show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FcSwitchGet(params *FcSwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcSwitchGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcSwitchGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_switch_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics/{fabric.name}/switches/{wwn}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcSwitchGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcSwitchGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcSwitchGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcZoneCollectionGet Retrieves the zones of the active zoneset of a Fibre Channel fabric.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `members`
### Related ONTAP commands
* `network fcp zone show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FcZoneCollectionGet(params *FcZoneCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcZoneCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcZoneCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_zone_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics/{fabric.name}/zones",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcZoneCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcZoneCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcZoneCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	FcZoneGet Retrieves a zone of the active zoneset of a Fibre Channel fabric.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `members`
### Related ONTAP commands
* `network fcp zone show`
### Learn more
* [`DOC /network/fc/fabrics`](#docs-networking-network_fc_fabrics)
*/
func (a *Client) FcZoneGet(params *FcZoneGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*FcZoneGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewFcZoneGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "fc_zone_get",
		Method:             "GET",
		PathPattern:        "/network/fc/fabrics/{fabric.name}/zones/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &FcZoneGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*FcZoneGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*FcZoneGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HTTPProxyCollectionGet Retrieves the HTTP proxy configurations of all the SVMs and Cluster IPspaces.

### Related ONTAP commands
* `vserver http-proxy show`
*/
func (a *Client) HTTPProxyCollectionGet(params *HTTPProxyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_collection_get",
		Method:             "GET",
		PathPattern:        "/network/http-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HTTPProxyCreate Creates an HTTP proxy configuration for an SVM or a Cluster IPspace.

Important notes:
* IPv6 must be enabled if IPv6 family addresses are specified in the "server" field.
* The server and the port combination specified using the "server" and "port" fields is validated during this operation. The validation will fail in the following scenarios:
  - The HTTP proxy service is not configured on the server.
  - The HTTP proxy service is not running on the specified port.
  - The server is unreachable.

### Required properties
* SVM-scoped HTTP proxy
  - `svm.uuid` or `svm.name` - Existing SVM in which to create the HTTP proxy.

* Cluster-scoped HTTP proxy
  - `ipspace.uuid` or `ipspace.name` - Existing Cluster IPspace in which to create the HTTP proxy.

* `server` - HTTP proxy server FQDN or IP address.
* `port` - HTTP proxy server port.
### Optional properties
* `authentication_enabled` - Specifies if authentication is required for the HTTP proxy server.
* `username` - Username used to authenticate with the HTTP proxy server.
* `password` - Password used to authenticate with the HTTP proxy server.
### Related ONTAP commands
* `vserver http-proxy create`
*/
func (a *Client) HTTPProxyCreate(params *HTTPProxyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_create",
		Method:             "POST",
		PathPattern:        "/network/http-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HTTPProxyDelete Deletes the HTTP proxy configuration of the specified SVM or Cluster IPspace.

### Related ONTAP commands
* `vserver http-proxy delete`
*/
func (a *Client) HTTPProxyDelete(params *HTTPProxyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_delete",
		Method:             "DELETE",
		PathPattern:        "/network/http-proxy/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
HTTPProxyDeleteCollection http proxy delete collection API
*/
func (a *Client) HTTPProxyDeleteCollection(params *HTTPProxyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/http-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HTTPProxyGet Displays the HTTP proxy server, port, and IPspace of the specified SVM or Cluster IPspace.

### Related ONTAP commands
* `vserver http-proxy show`
*/
func (a *Client) HTTPProxyGet(params *HTTPProxyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_get",
		Method:             "GET",
		PathPattern:        "/network/http-proxy/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	HTTPProxyModify Updates the proxy server, port, username, and password parameters.

Important notes:
* IPv6 must be enabled if IPv6 family addresses are specified in the "server" field.
* The server and the port combination specified using the "server" and "port" fields is validated during this operation. The validation will fail in the following scenarios:
  - The HTTP proxy service is not configured on the server.
  - The HTTP proxy service is not running on the specified port.
  - The server is unreachable.

### Related ONTAP commands
* `vserver http-proxy modify`
*/
func (a *Client) HTTPProxyModify(params *HTTPProxyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_modify",
		Method:             "PATCH",
		PathPattern:        "/network/http-proxy/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
HTTPProxyModifyCollection http proxy modify collection API
*/
func (a *Client) HTTPProxyModifyCollection(params *HTTPProxyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*HTTPProxyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewHTTPProxyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "http_proxy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/http-proxy",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &HTTPProxyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*HTTPProxyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*HTTPProxyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
InterfacesMetricsCollectionGet Retrieves historical performance metrics for an interface.
*/
func (a *Client) InterfacesMetricsCollectionGet(params *InterfacesMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*InterfacesMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewInterfacesMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "interfaces_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/network/ip/interfaces/{uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &InterfacesMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*InterfacesMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*InterfacesMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPServicePolicyCreate Creates a service policy for network interfaces.

### Related ONTAP commands
* `network interface service-policy create`
### Required properties
* `name` - Name of the service policy to create.
* `ipspace.name` or `ipspace.uuid`
  - Required for cluster-scoped service policies.
  - Optional for SVM-scoped service policies.

* `svm.name` or `svm.uuid`
  - Required for SVM-scoped service policies.
  - Not valid for cluster-scoped service policies.

### Default property values
If not specified in POST, the following default property values are assigned:
* `scope`
  - svm if the svm parameter is specified
  - cluster if the svm parameter is not specified
*/
func (a *Client) IPServicePolicyCreate(params *IPServicePolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyCreateOK, *IPServicePolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPServicePolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_service_policy_create",
		Method:             "POST",
		PathPattern:        "/network/ip/service-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPServicePolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *IPServicePolicyCreateOK:
		return value, nil, nil
	case *IPServicePolicyCreateCreated:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPServicePolicyCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPServicePolicyDelete Deletes a service policy for network interfaces.

### Related ONTAP commands
* `network interface service-policy delete`
*/
func (a *Client) IPServicePolicyDelete(params *IPServicePolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPServicePolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_service_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ip/service-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPServicePolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPServicePolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPServicePolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IPServicePolicyDeleteCollection ip service policy delete collection API
*/
func (a *Client) IPServicePolicyDeleteCollection(params *IPServicePolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPServicePolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_service_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ip/service-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPServicePolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPServicePolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPServicePolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPServicePolicyModify Updates a service policy for network interfaces.

### Related ONTAP commands
* `network interface service-policy add-service`
* `network interface service-policy modify-service`
* `network interface service-policy remove-service`
* `network interface service-policy rename`
*/
func (a *Client) IPServicePolicyModify(params *IPServicePolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPServicePolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_service_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ip/service-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPServicePolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPServicePolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPServicePolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IPServicePolicyModifyCollection ip service policy modify collection API
*/
func (a *Client) IPServicePolicyModifyCollection(params *IPServicePolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPServicePolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPServicePolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_service_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ip/service-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPServicePolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPServicePolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPServicePolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPSubnetCollectionGet Retrieves details for all subnets.

### Related ONTAP Commands
* `network subnet show`
*/
func (a *Client) IPSubnetCollectionGet(params *IPSubnetCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_collection_get",
		Method:             "GET",
		PathPattern:        "/network/ip/subnets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPSubnetCreate Creates a new named subnet.

### Required properties
* `name` - Name of the subnet to create.
* `broadcast_domain` - Broadcast domain containing the subnet.
* `ipspace` - IPspace containing the subnet. Required only if `broadcast_domain.uuid` is not provided.
* `subnet.address` - IP address for the subnet.
* `subnet.netmask` - IP netmask of the subnet.
### Recommended property values
### Default property values
If not specified in POST, the following default property values are assigned:
* `gateway` - no gateway
* `ip_ranges` - empty
* `fail_if_lifs_conflict` - _true_
### Related ONTAP commands
* `network subnet create`
*/
func (a *Client) IPSubnetCreate(params *IPSubnetCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_create",
		Method:             "POST",
		PathPattern:        "/network/ip/subnets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPSubnetDelete Deletes an IP subnet.

### Related ONTAP commands
* `network subnet delete`
*/
func (a *Client) IPSubnetDelete(params *IPSubnetDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ip/subnets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IPSubnetDeleteCollection ip subnet delete collection API
*/
func (a *Client) IPSubnetDeleteCollection(params *IPSubnetDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ip/subnets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPSubnetGet Retrieves details for a specific IP subnet.

### Related ONTAP commands
* `network subnet show`
*/
func (a *Client) IPSubnetGet(params *IPSubnetGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_get",
		Method:             "GET",
		PathPattern:        "/network/ip/subnets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IPSubnetModify Updates an IP subnet.

### Related ONTAP commands
* `network subnet modify`
* `network subnet rename`
* `network subnet add-ranges`
* `network subnet remove-ranges`
*/
func (a *Client) IPSubnetModify(params *IPSubnetModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ip/subnets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IPSubnetModifyCollection ip subnet modify collection API
*/
func (a *Client) IPSubnetModifyCollection(params *IPSubnetModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IPSubnetModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIPSubnetModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ip_subnet_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ip/subnets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IPSubnetModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IPSubnetModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IPSubnetModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpspaceDelete Deletes an IPspace object.

### Related ONTAP commands
* `network ipspace delete`
*/
func (a *Client) IpspaceDelete(params *IpspaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspace_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ipspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspaceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspaceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IpspaceDeleteCollection ipspace delete collection API
*/
func (a *Client) IpspaceDeleteCollection(params *IpspaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspace_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ipspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspaceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspaceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpspaceGet Retrieves information about a specific IPspace.

### Related ONTAP commands
* `network ipspace show`
*/
func (a *Client) IpspaceGet(params *IpspaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspace_get",
		Method:             "GET",
		PathPattern:        "/network/ipspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpspaceModify Updates an IPspace object.

### Related ONTAP commands
* `network ipspace rename`
*/
func (a *Client) IpspaceModify(params *IpspaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspace_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ipspaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspaceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspaceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
IpspaceModifyCollection ipspace modify collection API
*/
func (a *Client) IpspaceModifyCollection(params *IpspaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspaceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspace_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ipspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspaceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspaceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpspacesCreate Creates a new domain within which IP addresses are unique. SVMs, ports, and networks are scoped to a single IPspace.

### Required properties
* `name` - Name of the IPspace to create.
### Related ONTAP commands
* `network ipspace create`
*/
func (a *Client) IpspacesCreate(params *IpspacesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspacesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspacesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspaces_create",
		Method:             "POST",
		PathPattern:        "/network/ipspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspacesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspacesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspacesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	IpspacesGet Retrieves a collection of IPspaces for the entire cluster.

### Related ONTAP commands
* `network ipspace show`
*/
func (a *Client) IpspacesGet(params *IpspacesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*IpspacesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewIpspacesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "ipspaces_get",
		Method:             "GET",
		PathPattern:        "/network/ipspaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &IpspacesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*IpspacesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*IpspacesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetBroadcastDomainDelete Deletes a broadcast domain.

### Related ONTAP commands
* `network port broadcast-domain delete`
*/
func (a *Client) NetworkEthernetBroadcastDomainDelete(params *NetworkEthernetBroadcastDomainDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domain_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/broadcast-domains/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkEthernetBroadcastDomainDeleteCollection network ethernet broadcast domain delete collection API
*/
func (a *Client) NetworkEthernetBroadcastDomainDeleteCollection(params *NetworkEthernetBroadcastDomainDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domain_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/broadcast-domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetBroadcastDomainGet Retrieves details of a broadcast domain.

### Related ONTAP commands
* `network port broadcast-domain show`
*/
func (a *Client) NetworkEthernetBroadcastDomainGet(params *NetworkEthernetBroadcastDomainGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domain_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/broadcast-domains/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetBroadcastDomainModify Updates the properties of a broadcast domain.

### Related ONTAP commands
* `network port broadcast-domain modify`
* `network port broadcast-domain rename`
* `network port broadcast-domain move`
*/
func (a *Client) NetworkEthernetBroadcastDomainModify(params *NetworkEthernetBroadcastDomainModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domain_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/broadcast-domains/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkEthernetBroadcastDomainModifyCollection network ethernet broadcast domain modify collection API
*/
func (a *Client) NetworkEthernetBroadcastDomainModifyCollection(params *NetworkEthernetBroadcastDomainModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domain_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/broadcast-domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetBroadcastDomainsCreate Creates a new broadcast domain.<br/>

### Required properties
* `name` - Name of the broadcast-domain to create.
* `mtu` - Maximum transmission unit (MTU) of the broadcast domain.
### Recommended optional properties
* `ipspace.name` or `ipspace.uuid` - IPspace the broadcast domain belongs to.
### Default property values
If not specified in POST, the following default property values are assigned:
* `ipspace` - _Default_
### Related ONTAP commands
* `network port broadcast-domain create`
*/
func (a *Client) NetworkEthernetBroadcastDomainsCreate(params *NetworkEthernetBroadcastDomainsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domains_create",
		Method:             "POST",
		PathPattern:        "/network/ethernet/broadcast-domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetBroadcastDomainsGet Retrieves a collection of broadcast domains for the entire cluster.

### Related ONTAP commands
* `network port broadcast-domain show`
*/
func (a *Client) NetworkEthernetBroadcastDomainsGet(params *NetworkEthernetBroadcastDomainsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetBroadcastDomainsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetBroadcastDomainsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_broadcast_domains_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/broadcast-domains",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetBroadcastDomainsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetBroadcastDomainsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetBroadcastDomainsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetPortDelete Deletes a VLAN or LAG.

### Related ONTAP commands
* `network port ifgrp delete`
* `network port vlan delete`
*/
func (a *Client) NetworkEthernetPortDelete(params *NetworkEthernetPortDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortDeleteOK, *NetworkEthernetPortDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_port_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/ports/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NetworkEthernetPortDeleteOK:
		return value, nil, nil
	case *NetworkEthernetPortDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkEthernetPortDeleteCollection network ethernet port delete collection API
*/
func (a *Client) NetworkEthernetPortDeleteCollection(params *NetworkEthernetPortDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortDeleteCollectionOK, *NetworkEthernetPortDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_port_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *NetworkEthernetPortDeleteCollectionOK:
		return value, nil, nil
	case *NetworkEthernetPortDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetPortGet Retrieves the details of a physical port, VLAN, or LAG.

### Related ONTAP commands
* `network port show`
* `network port ifgrp show`
* `network port vlan show`
*/
func (a *Client) NetworkEthernetPortGet(params *NetworkEthernetPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_port_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/ports/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetPortGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetPortModify Updates a port.

### Related ONTAP commands
* `network port broadcast-domain add-ports`
* `network port broadcast-domain remove-ports`
* `network port modify`
* `network port ifgrp add-port`
* `network port ifgrp remove-port`
* `network port reachability repair`
*/
func (a *Client) NetworkEthernetPortModify(params *NetworkEthernetPortModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_port_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/ports/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetPortModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkEthernetPortModifyCollection network ethernet port modify collection API
*/
func (a *Client) NetworkEthernetPortModifyCollection(params *NetworkEthernetPortModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_port_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetPortModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetPortsCreate Creates a new VLAN (such as node1:e0a-100) or LAG (ifgrp, such as node2:a0a).

### Required properties
* `node` - Node the port will be created on.
* `vlan` - This field cannot be specified at the same time as `lag`.
  - `vlan.base_port` - Physical port or LAG the VLAN will be created on.
  - `vlan.tag` - Tag used to identify VLAN on the base port.

* `lag` - This field cannot be specified at the same time as `vlan`.
  - `lag.mode` - Policy for the LAG that will be created.
  - `lag.distribution_policy` - Indicates how the packets are distributed between ports.
  - `lag.member_ports` - Set of ports the LAG consists of.

### Optional properties
* `type` - Defines if a VLAN or LAG will be created:
* `broadcast_domain` - The layer-2 broadcast domain the port is associated with. The port will be placed in a broadcast domain if it is not specified.  It may take several minutes for the broadcast domain to be assigned.  During that period the port cannot host interfaces.
### Related ONTAP commands
* `network port ifgrp create`
* `network port vlan create`
*/
func (a *Client) NetworkEthernetPortsCreate(params *NetworkEthernetPortsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_ports_create",
		Method:             "POST",
		PathPattern:        "/network/ethernet/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetPortsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkEthernetPortsGet Retrieves a collection of ports (physical, VLAN and LAG) for an entire cluster.

### Related ONTAP commands
* `network port show`
* `network port ifgrp show`
* `network port vlan show`
*/
func (a *Client) NetworkEthernetPortsGet(params *NetworkEthernetPortsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkEthernetPortsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkEthernetPortsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ethernet_ports_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkEthernetPortsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkEthernetPortsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkEthernetPortsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPBgpPeerGroupDelete Deletes a BGP peer group for VIP.

### Related ONTAP commands
* `network bgp peer-group delete`
*/
func (a *Client) NetworkIPBgpPeerGroupDelete(params *NetworkIPBgpPeerGroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_group_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ip/bgp/peer-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkIPBgpPeerGroupDeleteCollection network ip bgp peer group delete collection API
*/
func (a *Client) NetworkIPBgpPeerGroupDeleteCollection(params *NetworkIPBgpPeerGroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ip/bgp/peer-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPBgpPeerGroupGet Retrieves details of a BGP peer group for VIP.

### Related ONTAP commands
* `network bgp peer-group show`
*/
func (a *Client) NetworkIPBgpPeerGroupGet(params *NetworkIPBgpPeerGroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_group_get",
		Method:             "GET",
		PathPattern:        "/network/ip/bgp/peer-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPBgpPeerGroupModify Updates a BGP peer group for VIP.

### Related ONTAP commands
* `network bgp peer-group modify`
* `network bgp peer-group rename`
*/
func (a *Client) NetworkIPBgpPeerGroupModify(params *NetworkIPBgpPeerGroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_group_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ip/bgp/peer-groups/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkIPBgpPeerGroupModifyCollection network ip bgp peer group modify collection API
*/
func (a *Client) NetworkIPBgpPeerGroupModifyCollection(params *NetworkIPBgpPeerGroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ip/bgp/peer-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPBgpPeerGroupsCreate Creates a new BGP peer group for VIP. Multipath-routing is turned on cluster-wide automatically if the peer group being created results in multiple paths being available for an existing or future VIP interface.<br/>

### Required properties
* `name` - Name of the peer-group to create.
* `ipspace.name` or `ipspace.uuid` or `local.port`
  - Required with local.interface.name or local.ip.address to identify a local interface
  - Optional when local.interface.uuid is specified

* `local.interface.uuid` or `local.interface.name` or `local.ip.address`
  - Required when specifying an existing local interface.

* `local.ip` and `local.port`
  - Required to create a new local interface.

* `peer.address` - IP address of the peer router
### Default property values
If not specified in POST, the following default property values are assigned:
* `is_next_hop` - _false_
* `peer.md5_enabled` - _false_
### Related ONTAP commands
* `network bgp peer-group create`
*/
func (a *Client) NetworkIPBgpPeerGroupsCreate(params *NetworkIPBgpPeerGroupsCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupsCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupsCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_groups_create",
		Method:             "POST",
		PathPattern:        "/network/ip/bgp/peer-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupsCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupsCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupsCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPBgpPeerGroupsGet Retrieves the details of all BGP peer groups for VIP.

### Related ONTAP Commands
* `network bgp peer-group show`
*/
func (a *Client) NetworkIPBgpPeerGroupsGet(params *NetworkIPBgpPeerGroupsGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPBgpPeerGroupsGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPBgpPeerGroupsGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_bgp_peer_groups_get",
		Method:             "GET",
		PathPattern:        "/network/ip/bgp/peer-groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPBgpPeerGroupsGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPBgpPeerGroupsGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPBgpPeerGroupsGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPInterfaceDelete Deletes an IP interface.

### Related ONTAP commands
* `network interface delete`
*/
func (a *Client) NetworkIPInterfaceDelete(params *NetworkIPInterfaceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfaceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interface_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ip/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfaceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfaceDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfaceDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkIPInterfaceDeleteCollection network ip interface delete collection API
*/
func (a *Client) NetworkIPInterfaceDeleteCollection(params *NetworkIPInterfaceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfaceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interface_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ip/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfaceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfaceDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfaceDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPInterfaceGet Retrieves details for a specific IP interface.

### Related ONTAP commands
* `network interface show`
*/
func (a *Client) NetworkIPInterfaceGet(params *NetworkIPInterfaceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfaceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interface_get",
		Method:             "GET",
		PathPattern:        "/network/ip/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfaceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfaceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfaceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPInterfaceModify Updates an IP interface.

### Related ONTAP commands
* `network interface migrate`
* `network interface modify`
* `network interface rename`
* `network interface revert`
*/
func (a *Client) NetworkIPInterfaceModify(params *NetworkIPInterfaceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfaceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interface_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ip/interfaces/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfaceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfaceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfaceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkIPInterfaceModifyCollection network ip interface modify collection API
*/
func (a *Client) NetworkIPInterfaceModifyCollection(params *NetworkIPInterfaceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfaceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfaceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interface_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ip/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfaceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfaceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfaceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPInterfacesCreate Creates a new Cluster-scoped or SVM-scoped interface.<br/>

### Required properties
* `name` - Name of the interface to create.
* `ip` or `subnet`
  - `ip.address` - IP address for the interface.
  - `ip.netmask` - IP subnet of the interface.
  - `subnet.uuid` or `subnet.name`

* `ipspace.name` or `ipspace.uuid`
  - Required for Cluster-scoped interfaces.
  - Optional for SVM-scoped interfaces.

* `svm.name` or `svm.uuid`
  - Required for an SVM-scoped interface.
  - Invalid for a Cluster-scoped interface.

* If a LIF in the subnet of the specified IP address does not already exist, a location.home_port, a location.home_node, or a location.broadcast_domain needs to be provided.
### Recommended property values
* `service_policy`
  - `for SVM scoped interfaces`
  - _default-data-files_ for interfaces carrying file-oriented NAS data traffic
  - _default-data-blocks_ for interfaces carrying block-oriented SAN data traffic
  - _default-data-iscsi_ for interfaces carrying iSCSI data traffic
  - _default-management_ for interfaces carrying SVM management requests
  - `for Cluster scoped interfaces`
  - _default-intercluster_ for interfaces carrying cluster peering traffic
  - _default-management_ for interfaces carrying system management requests
  - _default-route-announce_ for interfaces carrying BGP peer connections

### Default property values
If not specified in POST, the following default property values are assigned:
* `scope`
  - _svm_ if svm parameter is specified.
  - _cluster_ if svm parameter is not specified

* `enabled` - _true_
* `location.auto_revert` - _true_
* `service_policy`
  - **Unified ONTAP**: _default-data-files_ if scope is `svm`
  - **ASA r2**: _default-data-blocks_ if scope is `svm`
  - _default-management_ if scope is `cluster` and IPspace is not `Cluster`
  - _default-cluster_ if scope is `cluster` and IPspace is `Cluster`

* `failover` - Selects the least restrictive failover policy supported by all the services in the service policy.
* `ddns_enabled`
  - _true_ if the interface supports _data_nfs_ or _data_cifs_ services
  - _false_ otherwise

* `fail_if_subnet_conflicts` - _true_
### Related ONTAP commands
* `network interface create`
*/
func (a *Client) NetworkIPInterfacesCreate(params *NetworkIPInterfacesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfacesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfacesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interfaces_create",
		Method:             "POST",
		PathPattern:        "/network/ip/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfacesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfacesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfacesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPInterfacesGet Retrieves the details of all IP interfaces.

### Related ONTAP Commands
* `network interface show`
*/
func (a *Client) NetworkIPInterfacesGet(params *NetworkIPInterfacesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPInterfacesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPInterfacesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_interfaces_get",
		Method:             "GET",
		PathPattern:        "/network/ip/interfaces",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPInterfacesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPInterfacesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPInterfacesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPRouteDelete Deletes a specific IP route.

### Related ONTAP commands
* `network route delete`
*/
func (a *Client) NetworkIPRouteDelete(params *NetworkIPRouteDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPRouteDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_route_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ip/routes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPRouteDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPRouteDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPRouteDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
NetworkIPRouteDeleteCollection network ip route delete collection API
*/
func (a *Client) NetworkIPRouteDeleteCollection(params *NetworkIPRouteDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPRouteDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_route_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ip/routes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPRouteDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPRouteDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPRouteDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPRouteGet Retrieves the details of a specific IP route.

### Related ONTAP commands
* `network route show`
* `network route show-lifs`
*/
func (a *Client) NetworkIPRouteGet(params *NetworkIPRouteGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRouteGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPRouteGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_route_get",
		Method:             "GET",
		PathPattern:        "/network/ip/routes/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPRouteGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPRouteGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPRouteGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPRoutesCreate Creates a Cluster-scoped or SVM-scoped static route.

### Required properties
* `gateway` - IP address to route packets to.
* SVM-scoped routes
  - `svm.name` or `svm.uuid` - SVM that route is applied to.

* cluster-scoped routes
  - There are no additional required fields for Cluster-scoped routes.

### Default property values
If not specified in POST, the following default property values are assigned:
* `destination` - _0.0.0.0/0_ for IPv4 or _::/0_ for IPv6.
* `ipspace.name`
  - _Default_ for Cluster-scoped routes.
  - Name of the SVM's IPspace for SVM-scoped routes.

* `metric` - 20.
### Related ONTAP commands
* `network route create`
*/
func (a *Client) NetworkIPRoutesCreate(params *NetworkIPRoutesCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRoutesCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPRoutesCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_routes_create",
		Method:             "POST",
		PathPattern:        "/network/ip/routes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPRoutesCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPRoutesCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPRoutesCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPRoutesGet Retrieves the collection of IP routes.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `interfaces.*`
### Related ONTAP commands
* `network route show`
* `network route show-lifs`
*/
func (a *Client) NetworkIPRoutesGet(params *NetworkIPRoutesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPRoutesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPRoutesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_routes_get",
		Method:             "GET",
		PathPattern:        "/network/ip/routes",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPRoutesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPRoutesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPRoutesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPServicePoliciesGet Retrieves a collection of service policies.

### Related ONTAP commands
* `network interface service-policy show`
*/
func (a *Client) NetworkIPServicePoliciesGet(params *NetworkIPServicePoliciesGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPServicePoliciesGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPServicePoliciesGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_service_policies_get",
		Method:             "GET",
		PathPattern:        "/network/ip/service-policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPServicePoliciesGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPServicePoliciesGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPServicePoliciesGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	NetworkIPServicePolicyGet Retrieves a specific service policy.

### Related ONTAP commands
* `network interface service-policy show`
*/
func (a *Client) NetworkIPServicePolicyGet(params *NetworkIPServicePolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*NetworkIPServicePolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewNetworkIPServicePolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "network_ip_service_policy_get",
		Method:             "GET",
		PathPattern:        "/network/ip/service-policies/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &NetworkIPServicePolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*NetworkIPServicePolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*NetworkIPServicePolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcInterfaceMetricCollectionGet Retrieves historical performance metrics for a Fibre Channel interface.
*/
func (a *Client) PerformanceFcInterfaceMetricCollectionGet(params *PerformanceFcInterfaceMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcInterfaceMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcInterfaceMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fc_interface_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/interfaces/{fc_interface.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcInterfaceMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcInterfaceMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcInterfaceMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcInterfaceMetricGet Retrieves historical performance metrics for a Fibre Channel interface for a specific time.
*/
func (a *Client) PerformanceFcInterfaceMetricGet(params *PerformanceFcInterfaceMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcInterfaceMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcInterfaceMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fc_interface_metric_get",
		Method:             "GET",
		PathPattern:        "/network/fc/interfaces/{fc_interface.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcInterfaceMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcInterfaceMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcInterfaceMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcPortMetricCollectionGet Retrieves historical performance metrics for a Fibre Channel port.
*/
func (a *Client) PerformanceFcPortMetricCollectionGet(params *PerformanceFcPortMetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcPortMetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcPortMetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fc_port_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/network/fc/ports/{fc_port.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcPortMetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcPortMetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcPortMetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceFcPortMetricGet Retrieves historical performance metrics for a Fibre Channel port for a specific time.
*/
func (a *Client) PerformanceFcPortMetricGet(params *PerformanceFcPortMetricGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceFcPortMetricGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceFcPortMetricGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_fc_port_metric_get",
		Method:             "GET",
		PathPattern:        "/network/fc/ports/{fc_port.uuid}/metrics/{timestamp}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceFcPortMetricGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceFcPortMetricGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceFcPortMetricGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PortMetricsCollectionGet Retrieves historical performance metrics for a port.
*/
func (a *Client) PortMetricsCollectionGet(params *PortMetricsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PortMetricsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPortMetricsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "port_metrics_collection_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/ports/{uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PortMetricsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PortMetricsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PortMetricsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchCollectionGet Retrieves a collection of Ethernet switches.

### Related ONTAP commands
* `system switch ethernet show`
### Learn more
* [`DOC /network/ethernet/switches`](#docs-networking-network_ethernet_switches)
*/
func (a *Client) SwitchCollectionGet(params *SwitchCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_collection_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchCreate Adds an Ethernet switch.

### Required properties
* `name` - Name of the switch to create.
* `address` - Switch IP address.
* `model` - Switch model number.
* `monitoring.enabled` - Whether the switch should be monitored by CSHM.
* `network`
  - _cluster_ for cluster or shared switches.
  - _storage_ for storage switches.

* `snmp.version` - SNMP version.
* `snmp.user` - SNMP user.
### Related ONTAP commands
* `system switch ethernet create`
### Learn more
* [`DOC /network/ethernet/switches`](#docs-networking-network_ethernet_switches)
*/
func (a *Client) SwitchCreate(params *SwitchCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchCreateCreated, *SwitchCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_create",
		Method:             "POST",
		PathPattern:        "/network/ethernet/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SwitchCreateCreated:
		return value, nil, nil
	case *SwitchCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchDelete Deletes an Ethernet switch.

### Related ONTAP commands
* `system switch ethernet delete`
### Learn more
* [`DOC /network/ethernet/switches`](#docs-networking-network_ethernet_switches)
*/
func (a *Client) SwitchDelete(params *SwitchDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_delete",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/switches/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SwitchDeleteCollection switch delete collection API
*/
func (a *Client) SwitchDeleteCollection(params *SwitchDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/network/ethernet/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchGet Retrieves the details of an Ethernet switch.

### Related ONTAP commands
* `system switch ethernet show`
### Learn more
* [`DOC /network/ethernet/switches`](#docs-networking-network_ethernet_switches)
*/
func (a *Client) SwitchGet(params *SwitchGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/switches/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchModify Configures monitoring settings for an Ethernet switch.

### Related ONTAP commands
* `system switch ethernet modify`
### Learn more
* [`DOC /network/ethernet/switches`](#docs-networking-network_ethernet_switches)
*/
func (a *Client) SwitchModify(params *SwitchModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchModifyOK, *SwitchModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_modify",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/switches/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SwitchModifyOK:
		return value, nil, nil
	case *SwitchModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
SwitchModifyCollection switch modify collection API
*/
func (a *Client) SwitchModifyCollection(params *SwitchModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchModifyCollectionOK, *SwitchModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/network/ethernet/switches",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *SwitchModifyCollectionOK:
		return value, nil, nil
	case *SwitchModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchPortCollectionGet Retrieves the ethernet switch ports.

### Related ONTAP commands
* `system switch ethernet interface show`
### Learn more
* [`DOC /network/ethernet/switch/ports`](#docs-networking-network_ethernet_switch_ports)
*/
func (a *Client) SwitchPortCollectionGet(params *SwitchPortCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchPortCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchPortCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_port_collection_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/switch/ports",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchPortCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchPortCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchPortCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	SwitchPortGet Retrieves an ethernet switch port.

### Related ONTAP commands
* `system switch ethernet interface show`
*/
func (a *Client) SwitchPortGet(params *SwitchPortGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*SwitchPortGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewSwitchPortGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "switch_port_get",
		Method:             "GET",
		PathPattern:        "/network/ethernet/switch/ports/{switch}/{identity.name}/{identity.index}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &SwitchPortGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*SwitchPortGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*SwitchPortGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
