// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceFcInterfaceMetricGetReader is a Reader for the PerformanceFcInterfaceMetricGet structure.
type PerformanceFcInterfaceMetricGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceFcInterfaceMetricGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceFcInterfaceMetricGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceFcInterfaceMetricGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceFcInterfaceMetricGetOK creates a PerformanceFcInterfaceMetricGetOK with default headers values
func NewPerformanceFcInterfaceMetricGetOK() *PerformanceFcInterfaceMetricGetOK {
	return &PerformanceFcInterfaceMetricGetOK{}
}

/*
PerformanceFcInterfaceMetricGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceFcInterfaceMetricGetOK struct {
	Payload *models.PerformanceFcInterfaceMetric
}

// IsSuccess returns true when this performance fc interface metric get o k response has a 2xx status code
func (o *PerformanceFcInterfaceMetricGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance fc interface metric get o k response has a 3xx status code
func (o *PerformanceFcInterfaceMetricGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance fc interface metric get o k response has a 4xx status code
func (o *PerformanceFcInterfaceMetricGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance fc interface metric get o k response has a 5xx status code
func (o *PerformanceFcInterfaceMetricGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance fc interface metric get o k response a status code equal to that given
func (o *PerformanceFcInterfaceMetricGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance fc interface metric get o k response
func (o *PerformanceFcInterfaceMetricGetOK) Code() int {
	return 200
}

func (o *PerformanceFcInterfaceMetricGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces/{fc_interface.uuid}/metrics/{timestamp}][%d] performanceFcInterfaceMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcInterfaceMetricGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces/{fc_interface.uuid}/metrics/{timestamp}][%d] performanceFcInterfaceMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcInterfaceMetricGetOK) GetPayload() *models.PerformanceFcInterfaceMetric {
	return o.Payload
}

func (o *PerformanceFcInterfaceMetricGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceFcInterfaceMetric)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceFcInterfaceMetricGetDefault creates a PerformanceFcInterfaceMetricGetDefault with default headers values
func NewPerformanceFcInterfaceMetricGetDefault(code int) *PerformanceFcInterfaceMetricGetDefault {
	return &PerformanceFcInterfaceMetricGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceFcInterfaceMetricGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585947 | No metrics are available for the requested object. |
| 8586225 | An unexpected error occurred retrieving metrics for the requested object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceFcInterfaceMetricGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance fc interface metric get default response has a 2xx status code
func (o *PerformanceFcInterfaceMetricGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance fc interface metric get default response has a 3xx status code
func (o *PerformanceFcInterfaceMetricGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance fc interface metric get default response has a 4xx status code
func (o *PerformanceFcInterfaceMetricGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance fc interface metric get default response has a 5xx status code
func (o *PerformanceFcInterfaceMetricGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance fc interface metric get default response a status code equal to that given
func (o *PerformanceFcInterfaceMetricGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance fc interface metric get default response
func (o *PerformanceFcInterfaceMetricGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceFcInterfaceMetricGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces/{fc_interface.uuid}/metrics/{timestamp}][%d] performance_fc_interface_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcInterfaceMetricGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/interfaces/{fc_interface.uuid}/metrics/{timestamp}][%d] performance_fc_interface_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcInterfaceMetricGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceFcInterfaceMetricGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
