// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPerformanceFcPortMetricGetParams creates a new PerformanceFcPortMetricGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPerformanceFcPortMetricGetParams() *PerformanceFcPortMetricGetParams {
	return &PerformanceFcPortMetricGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPerformanceFcPortMetricGetParamsWithTimeout creates a new PerformanceFcPortMetricGetParams object
// with the ability to set a timeout on a request.
func NewPerformanceFcPortMetricGetParamsWithTimeout(timeout time.Duration) *PerformanceFcPortMetricGetParams {
	return &PerformanceFcPortMetricGetParams{
		timeout: timeout,
	}
}

// NewPerformanceFcPortMetricGetParamsWithContext creates a new PerformanceFcPortMetricGetParams object
// with the ability to set a context for a request.
func NewPerformanceFcPortMetricGetParamsWithContext(ctx context.Context) *PerformanceFcPortMetricGetParams {
	return &PerformanceFcPortMetricGetParams{
		Context: ctx,
	}
}

// NewPerformanceFcPortMetricGetParamsWithHTTPClient creates a new PerformanceFcPortMetricGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPerformanceFcPortMetricGetParamsWithHTTPClient(client *http.Client) *PerformanceFcPortMetricGetParams {
	return &PerformanceFcPortMetricGetParams{
		HTTPClient: client,
	}
}

/*
PerformanceFcPortMetricGetParams contains all the parameters to send to the API endpoint

	for the performance fc port metric get operation.

	Typically these are written to a http.Request.
*/
type PerformanceFcPortMetricGetParams struct {

	/* FcPortUUID.

	   The unique identifier of the Fibre Channel port.

	*/
	FcPortUUID string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Timestamp.

	   The timestamp of the performance data.


	   Format: date-time
	*/
	Timestamp strfmt.DateTime

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the performance fc port metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceFcPortMetricGetParams) WithDefaults() *PerformanceFcPortMetricGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the performance fc port metric get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PerformanceFcPortMetricGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithTimeout(timeout time.Duration) *PerformanceFcPortMetricGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithContext(ctx context.Context) *PerformanceFcPortMetricGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithHTTPClient(client *http.Client) *PerformanceFcPortMetricGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFcPortUUID adds the fcPortUUID to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithFcPortUUID(fcPortUUID string) *PerformanceFcPortMetricGetParams {
	o.SetFcPortUUID(fcPortUUID)
	return o
}

// SetFcPortUUID adds the fcPortUuid to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetFcPortUUID(fcPortUUID string) {
	o.FcPortUUID = fcPortUUID
}

// WithFields adds the fields to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithFields(fields []string) *PerformanceFcPortMetricGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithTimestamp adds the timestamp to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) WithTimestamp(timestamp strfmt.DateTime) *PerformanceFcPortMetricGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the performance fc port metric get params
func (o *PerformanceFcPortMetricGetParams) SetTimestamp(timestamp strfmt.DateTime) {
	o.Timestamp = timestamp
}

// WriteToRequest writes these params to a swagger request
func (o *PerformanceFcPortMetricGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param fc_port.uuid
	if err := r.SetPathParam("fc_port.uuid", o.FcPortUUID); err != nil {
		return err
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param timestamp
	if err := r.SetPathParam("timestamp", o.Timestamp.String()); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPerformanceFcPortMetricGet binds the parameter fields
func (o *PerformanceFcPortMetricGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
