// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// PerformanceFcPortMetricGetReader is a Reader for the PerformanceFcPortMetricGet structure.
type PerformanceFcPortMetricGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *PerformanceFcPortMetricGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewPerformanceFcPortMetricGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewPerformanceFcPortMetricGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewPerformanceFcPortMetricGetOK creates a PerformanceFcPortMetricGetOK with default headers values
func NewPerformanceFcPortMetricGetOK() *PerformanceFcPortMetricGetOK {
	return &PerformanceFcPortMetricGetOK{}
}

/*
PerformanceFcPortMetricGetOK describes a response with status code 200, with default header values.

OK
*/
type PerformanceFcPortMetricGetOK struct {
	Payload *models.PerformanceFcPortMetric
}

// IsSuccess returns true when this performance fc port metric get o k response has a 2xx status code
func (o *PerformanceFcPortMetricGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this performance fc port metric get o k response has a 3xx status code
func (o *PerformanceFcPortMetricGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this performance fc port metric get o k response has a 4xx status code
func (o *PerformanceFcPortMetricGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this performance fc port metric get o k response has a 5xx status code
func (o *PerformanceFcPortMetricGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this performance fc port metric get o k response a status code equal to that given
func (o *PerformanceFcPortMetricGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the performance fc port metric get o k response
func (o *PerformanceFcPortMetricGetOK) Code() int {
	return 200
}

func (o *PerformanceFcPortMetricGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{fc_port.uuid}/metrics/{timestamp}][%d] performanceFcPortMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcPortMetricGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{fc_port.uuid}/metrics/{timestamp}][%d] performanceFcPortMetricGetOK %s", 200, payload)
}

func (o *PerformanceFcPortMetricGetOK) GetPayload() *models.PerformanceFcPortMetric {
	return o.Payload
}

func (o *PerformanceFcPortMetricGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.PerformanceFcPortMetric)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewPerformanceFcPortMetricGetDefault creates a PerformanceFcPortMetricGetDefault with default headers values
func NewPerformanceFcPortMetricGetDefault(code int) *PerformanceFcPortMetricGetDefault {
	return &PerformanceFcPortMetricGetDefault{
		_statusCode: code,
	}
}

/*
	PerformanceFcPortMetricGetDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 8585947 | No metrics are available for the requested object. |
| 8586225 | An unexpected error occurred retrieving metrics for the requested object. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type PerformanceFcPortMetricGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this performance fc port metric get default response has a 2xx status code
func (o *PerformanceFcPortMetricGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this performance fc port metric get default response has a 3xx status code
func (o *PerformanceFcPortMetricGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this performance fc port metric get default response has a 4xx status code
func (o *PerformanceFcPortMetricGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this performance fc port metric get default response has a 5xx status code
func (o *PerformanceFcPortMetricGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this performance fc port metric get default response a status code equal to that given
func (o *PerformanceFcPortMetricGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the performance fc port metric get default response
func (o *PerformanceFcPortMetricGetDefault) Code() int {
	return o._statusCode
}

func (o *PerformanceFcPortMetricGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{fc_port.uuid}/metrics/{timestamp}][%d] performance_fc_port_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcPortMetricGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/fc/ports/{fc_port.uuid}/metrics/{timestamp}][%d] performance_fc_port_metric_get default %s", o._statusCode, payload)
}

func (o *PerformanceFcPortMetricGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *PerformanceFcPortMetricGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
