// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewPortMetricsCollectionGetParams creates a new PortMetricsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewPortMetricsCollectionGetParams() *PortMetricsCollectionGetParams {
	return &PortMetricsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewPortMetricsCollectionGetParamsWithTimeout creates a new PortMetricsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewPortMetricsCollectionGetParamsWithTimeout(timeout time.Duration) *PortMetricsCollectionGetParams {
	return &PortMetricsCollectionGetParams{
		timeout: timeout,
	}
}

// NewPortMetricsCollectionGetParamsWithContext creates a new PortMetricsCollectionGetParams object
// with the ability to set a context for a request.
func NewPortMetricsCollectionGetParamsWithContext(ctx context.Context) *PortMetricsCollectionGetParams {
	return &PortMetricsCollectionGetParams{
		Context: ctx,
	}
}

// NewPortMetricsCollectionGetParamsWithHTTPClient creates a new PortMetricsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewPortMetricsCollectionGetParamsWithHTTPClient(client *http.Client) *PortMetricsCollectionGetParams {
	return &PortMetricsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
PortMetricsCollectionGetParams contains all the parameters to send to the API endpoint

	for the port metrics collection get operation.

	Typically these are written to a http.Request.
*/
type PortMetricsCollectionGetParams struct {

	/* Duration.

	   Filter by duration
	*/
	Duration *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* Interval.

	     The time range for the data. Examples can be 1h, 1d, 1m, 1w, 1y.
	The period for each time range is as follows:
	* 1h: Metrics over the most recent hour sampled over 15 seconds.
	* 1d: Metrics over the most recent day sampled over 5 minutes.
	* 1w: Metrics over the most recent week sampled over 30 minutes.
	* 1m: Metrics over the most recent month sampled over 2 hours.
	* 1y: Metrics over the most recent year sampled over a day.


	     Default: "1h"
	*/
	Interval *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Status.

	   Filter by status
	*/
	Status *string

	/* ThroughputRead.

	   Filter by throughput.read
	*/
	ThroughputRead *int64

	/* ThroughputTotal.

	   Filter by throughput.total
	*/
	ThroughputTotal *int64

	/* ThroughputWrite.

	   Filter by throughput.write
	*/
	ThroughputWrite *int64

	/* Timestamp.

	   Filter by timestamp
	*/
	Timestamp *string

	/* UUID.

	   Unique identifier of the port.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the port metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortMetricsCollectionGetParams) WithDefaults() *PortMetricsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the port metrics collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *PortMetricsCollectionGetParams) SetDefaults() {
	var (
		intervalDefault = string("1h")

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := PortMetricsCollectionGetParams{
		Interval:      &intervalDefault,
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithTimeout(timeout time.Duration) *PortMetricsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithContext(ctx context.Context) *PortMetricsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithHTTPClient(client *http.Client) *PortMetricsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithDuration adds the duration to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithDuration(duration *string) *PortMetricsCollectionGetParams {
	o.SetDuration(duration)
	return o
}

// SetDuration adds the duration to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetDuration(duration *string) {
	o.Duration = duration
}

// WithFields adds the fields to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithFields(fields []string) *PortMetricsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithInterval adds the interval to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithInterval(interval *string) *PortMetricsCollectionGetParams {
	o.SetInterval(interval)
	return o
}

// SetInterval adds the interval to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetInterval(interval *string) {
	o.Interval = interval
}

// WithMaxRecords adds the maxRecords to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithMaxRecords(maxRecords *int64) *PortMetricsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithOrderBy adds the orderBy to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithOrderBy(orderBy []string) *PortMetricsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithReturnRecords(returnRecords *bool) *PortMetricsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *PortMetricsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithStatus adds the status to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithStatus(status *string) *PortMetricsCollectionGetParams {
	o.SetStatus(status)
	return o
}

// SetStatus adds the status to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetStatus(status *string) {
	o.Status = status
}

// WithThroughputRead adds the throughputRead to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithThroughputRead(throughputRead *int64) *PortMetricsCollectionGetParams {
	o.SetThroughputRead(throughputRead)
	return o
}

// SetThroughputRead adds the throughputRead to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetThroughputRead(throughputRead *int64) {
	o.ThroughputRead = throughputRead
}

// WithThroughputTotal adds the throughputTotal to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithThroughputTotal(throughputTotal *int64) *PortMetricsCollectionGetParams {
	o.SetThroughputTotal(throughputTotal)
	return o
}

// SetThroughputTotal adds the throughputTotal to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetThroughputTotal(throughputTotal *int64) {
	o.ThroughputTotal = throughputTotal
}

// WithThroughputWrite adds the throughputWrite to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithThroughputWrite(throughputWrite *int64) *PortMetricsCollectionGetParams {
	o.SetThroughputWrite(throughputWrite)
	return o
}

// SetThroughputWrite adds the throughputWrite to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetThroughputWrite(throughputWrite *int64) {
	o.ThroughputWrite = throughputWrite
}

// WithTimestamp adds the timestamp to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithTimestamp(timestamp *string) *PortMetricsCollectionGetParams {
	o.SetTimestamp(timestamp)
	return o
}

// SetTimestamp adds the timestamp to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetTimestamp(timestamp *string) {
	o.Timestamp = timestamp
}

// WithUUID adds the uuid to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) WithUUID(uuid string) *PortMetricsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the port metrics collection get params
func (o *PortMetricsCollectionGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *PortMetricsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Duration != nil {

		// query param duration
		var qrDuration string

		if o.Duration != nil {
			qrDuration = *o.Duration
		}
		qDuration := qrDuration
		if qDuration != "" {

			if err := r.SetQueryParam("duration", qDuration); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.Interval != nil {

		// query param interval
		var qrInterval string

		if o.Interval != nil {
			qrInterval = *o.Interval
		}
		qInterval := qrInterval
		if qInterval != "" {

			if err := r.SetQueryParam("interval", qInterval); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Status != nil {

		// query param status
		var qrStatus string

		if o.Status != nil {
			qrStatus = *o.Status
		}
		qStatus := qrStatus
		if qStatus != "" {

			if err := r.SetQueryParam("status", qStatus); err != nil {
				return err
			}
		}
	}

	if o.ThroughputRead != nil {

		// query param throughput.read
		var qrThroughputRead int64

		if o.ThroughputRead != nil {
			qrThroughputRead = *o.ThroughputRead
		}
		qThroughputRead := swag.FormatInt64(qrThroughputRead)
		if qThroughputRead != "" {

			if err := r.SetQueryParam("throughput.read", qThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.ThroughputTotal != nil {

		// query param throughput.total
		var qrThroughputTotal int64

		if o.ThroughputTotal != nil {
			qrThroughputTotal = *o.ThroughputTotal
		}
		qThroughputTotal := swag.FormatInt64(qrThroughputTotal)
		if qThroughputTotal != "" {

			if err := r.SetQueryParam("throughput.total", qThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.ThroughputWrite != nil {

		// query param throughput.write
		var qrThroughputWrite int64

		if o.ThroughputWrite != nil {
			qrThroughputWrite = *o.ThroughputWrite
		}
		qThroughputWrite := swag.FormatInt64(qrThroughputWrite)
		if qThroughputWrite != "" {

			if err := r.SetQueryParam("throughput.write", qThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.Timestamp != nil {

		// query param timestamp
		var qrTimestamp string

		if o.Timestamp != nil {
			qrTimestamp = *o.Timestamp
		}
		qTimestamp := qrTimestamp
		if qTimestamp != "" {

			if err := r.SetQueryParam("timestamp", qTimestamp); err != nil {
				return err
			}
		}
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamPortMetricsCollectionGet binds the parameter fields
func (o *PortMetricsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamPortMetricsCollectionGet binds the parameter order_by
func (o *PortMetricsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
