// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSwitchCollectionGetParams creates a new SwitchCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSwitchCollectionGetParams() *SwitchCollectionGetParams {
	return &SwitchCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSwitchCollectionGetParamsWithTimeout creates a new SwitchCollectionGetParams object
// with the ability to set a timeout on a request.
func NewSwitchCollectionGetParamsWithTimeout(timeout time.Duration) *SwitchCollectionGetParams {
	return &SwitchCollectionGetParams{
		timeout: timeout,
	}
}

// NewSwitchCollectionGetParamsWithContext creates a new SwitchCollectionGetParams object
// with the ability to set a context for a request.
func NewSwitchCollectionGetParamsWithContext(ctx context.Context) *SwitchCollectionGetParams {
	return &SwitchCollectionGetParams{
		Context: ctx,
	}
}

// NewSwitchCollectionGetParamsWithHTTPClient creates a new SwitchCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewSwitchCollectionGetParamsWithHTTPClient(client *http.Client) *SwitchCollectionGetParams {
	return &SwitchCollectionGetParams{
		HTTPClient: client,
	}
}

/*
SwitchCollectionGetParams contains all the parameters to send to the API endpoint

	for the switch collection get operation.

	Typically these are written to a http.Request.
*/
type SwitchCollectionGetParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* Discovered.

	   Filter by discovered
	*/
	Discovered *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Model.

	   Filter by model
	*/
	Model *string

	/* MonitoringEnabled.

	   Filter by monitoring.enabled
	*/
	MonitoringEnabled *bool

	/* MonitoringMonitored.

	   Filter by monitoring.monitored
	*/
	MonitoringMonitored *bool

	/* MonitoringReason.

	   Filter by monitoring.reason
	*/
	MonitoringReason *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Network.

	   Filter by network
	*/
	Network *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* RcfVersion.

	   Filter by rcf_version
	*/
	RcfVersion *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SnmpUser.

	   Filter by snmp.user
	*/
	SnmpUser *string

	/* SnmpVersion.

	   Filter by snmp.version
	*/
	SnmpVersion *string

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the switch collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SwitchCollectionGetParams) WithDefaults() *SwitchCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the switch collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SwitchCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := SwitchCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the switch collection get params
func (o *SwitchCollectionGetParams) WithTimeout(timeout time.Duration) *SwitchCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the switch collection get params
func (o *SwitchCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the switch collection get params
func (o *SwitchCollectionGetParams) WithContext(ctx context.Context) *SwitchCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the switch collection get params
func (o *SwitchCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the switch collection get params
func (o *SwitchCollectionGetParams) WithHTTPClient(client *http.Client) *SwitchCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the switch collection get params
func (o *SwitchCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the switch collection get params
func (o *SwitchCollectionGetParams) WithAddress(address *string) *SwitchCollectionGetParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the switch collection get params
func (o *SwitchCollectionGetParams) SetAddress(address *string) {
	o.Address = address
}

// WithDiscovered adds the discovered to the switch collection get params
func (o *SwitchCollectionGetParams) WithDiscovered(discovered *bool) *SwitchCollectionGetParams {
	o.SetDiscovered(discovered)
	return o
}

// SetDiscovered adds the discovered to the switch collection get params
func (o *SwitchCollectionGetParams) SetDiscovered(discovered *bool) {
	o.Discovered = discovered
}

// WithFields adds the fields to the switch collection get params
func (o *SwitchCollectionGetParams) WithFields(fields []string) *SwitchCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the switch collection get params
func (o *SwitchCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the switch collection get params
func (o *SwitchCollectionGetParams) WithMaxRecords(maxRecords *int64) *SwitchCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the switch collection get params
func (o *SwitchCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithModel adds the model to the switch collection get params
func (o *SwitchCollectionGetParams) WithModel(model *string) *SwitchCollectionGetParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the switch collection get params
func (o *SwitchCollectionGetParams) SetModel(model *string) {
	o.Model = model
}

// WithMonitoringEnabled adds the monitoringEnabled to the switch collection get params
func (o *SwitchCollectionGetParams) WithMonitoringEnabled(monitoringEnabled *bool) *SwitchCollectionGetParams {
	o.SetMonitoringEnabled(monitoringEnabled)
	return o
}

// SetMonitoringEnabled adds the monitoringEnabled to the switch collection get params
func (o *SwitchCollectionGetParams) SetMonitoringEnabled(monitoringEnabled *bool) {
	o.MonitoringEnabled = monitoringEnabled
}

// WithMonitoringMonitored adds the monitoringMonitored to the switch collection get params
func (o *SwitchCollectionGetParams) WithMonitoringMonitored(monitoringMonitored *bool) *SwitchCollectionGetParams {
	o.SetMonitoringMonitored(monitoringMonitored)
	return o
}

// SetMonitoringMonitored adds the monitoringMonitored to the switch collection get params
func (o *SwitchCollectionGetParams) SetMonitoringMonitored(monitoringMonitored *bool) {
	o.MonitoringMonitored = monitoringMonitored
}

// WithMonitoringReason adds the monitoringReason to the switch collection get params
func (o *SwitchCollectionGetParams) WithMonitoringReason(monitoringReason *string) *SwitchCollectionGetParams {
	o.SetMonitoringReason(monitoringReason)
	return o
}

// SetMonitoringReason adds the monitoringReason to the switch collection get params
func (o *SwitchCollectionGetParams) SetMonitoringReason(monitoringReason *string) {
	o.MonitoringReason = monitoringReason
}

// WithName adds the name to the switch collection get params
func (o *SwitchCollectionGetParams) WithName(name *string) *SwitchCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the switch collection get params
func (o *SwitchCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNetwork adds the network to the switch collection get params
func (o *SwitchCollectionGetParams) WithNetwork(network *string) *SwitchCollectionGetParams {
	o.SetNetwork(network)
	return o
}

// SetNetwork adds the network to the switch collection get params
func (o *SwitchCollectionGetParams) SetNetwork(network *string) {
	o.Network = network
}

// WithOrderBy adds the orderBy to the switch collection get params
func (o *SwitchCollectionGetParams) WithOrderBy(orderBy []string) *SwitchCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the switch collection get params
func (o *SwitchCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithRcfVersion adds the rcfVersion to the switch collection get params
func (o *SwitchCollectionGetParams) WithRcfVersion(rcfVersion *string) *SwitchCollectionGetParams {
	o.SetRcfVersion(rcfVersion)
	return o
}

// SetRcfVersion adds the rcfVersion to the switch collection get params
func (o *SwitchCollectionGetParams) SetRcfVersion(rcfVersion *string) {
	o.RcfVersion = rcfVersion
}

// WithReturnRecords adds the returnRecords to the switch collection get params
func (o *SwitchCollectionGetParams) WithReturnRecords(returnRecords *bool) *SwitchCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the switch collection get params
func (o *SwitchCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the switch collection get params
func (o *SwitchCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *SwitchCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the switch collection get params
func (o *SwitchCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the switch collection get params
func (o *SwitchCollectionGetParams) WithRole(role *string) *SwitchCollectionGetParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the switch collection get params
func (o *SwitchCollectionGetParams) SetRole(role *string) {
	o.Role = role
}

// WithSerialNumber adds the serialNumber to the switch collection get params
func (o *SwitchCollectionGetParams) WithSerialNumber(serialNumber *string) *SwitchCollectionGetParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the switch collection get params
func (o *SwitchCollectionGetParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSnmpUser adds the snmpUser to the switch collection get params
func (o *SwitchCollectionGetParams) WithSnmpUser(snmpUser *string) *SwitchCollectionGetParams {
	o.SetSnmpUser(snmpUser)
	return o
}

// SetSnmpUser adds the snmpUser to the switch collection get params
func (o *SwitchCollectionGetParams) SetSnmpUser(snmpUser *string) {
	o.SnmpUser = snmpUser
}

// WithSnmpVersion adds the snmpVersion to the switch collection get params
func (o *SwitchCollectionGetParams) WithSnmpVersion(snmpVersion *string) *SwitchCollectionGetParams {
	o.SetSnmpVersion(snmpVersion)
	return o
}

// SetSnmpVersion adds the snmpVersion to the switch collection get params
func (o *SwitchCollectionGetParams) SetSnmpVersion(snmpVersion *string) {
	o.SnmpVersion = snmpVersion
}

// WithVersion adds the version to the switch collection get params
func (o *SwitchCollectionGetParams) WithVersion(version *string) *SwitchCollectionGetParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the switch collection get params
func (o *SwitchCollectionGetParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *SwitchCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.Discovered != nil {

		// query param discovered
		var qrDiscovered bool

		if o.Discovered != nil {
			qrDiscovered = *o.Discovered
		}
		qDiscovered := swag.FormatBool(qrDiscovered)
		if qDiscovered != "" {

			if err := r.SetQueryParam("discovered", qDiscovered); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.MonitoringEnabled != nil {

		// query param monitoring.enabled
		var qrMonitoringEnabled bool

		if o.MonitoringEnabled != nil {
			qrMonitoringEnabled = *o.MonitoringEnabled
		}
		qMonitoringEnabled := swag.FormatBool(qrMonitoringEnabled)
		if qMonitoringEnabled != "" {

			if err := r.SetQueryParam("monitoring.enabled", qMonitoringEnabled); err != nil {
				return err
			}
		}
	}

	if o.MonitoringMonitored != nil {

		// query param monitoring.monitored
		var qrMonitoringMonitored bool

		if o.MonitoringMonitored != nil {
			qrMonitoringMonitored = *o.MonitoringMonitored
		}
		qMonitoringMonitored := swag.FormatBool(qrMonitoringMonitored)
		if qMonitoringMonitored != "" {

			if err := r.SetQueryParam("monitoring.monitored", qMonitoringMonitored); err != nil {
				return err
			}
		}
	}

	if o.MonitoringReason != nil {

		// query param monitoring.reason
		var qrMonitoringReason string

		if o.MonitoringReason != nil {
			qrMonitoringReason = *o.MonitoringReason
		}
		qMonitoringReason := qrMonitoringReason
		if qMonitoringReason != "" {

			if err := r.SetQueryParam("monitoring.reason", qMonitoringReason); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Network != nil {

		// query param network
		var qrNetwork string

		if o.Network != nil {
			qrNetwork = *o.Network
		}
		qNetwork := qrNetwork
		if qNetwork != "" {

			if err := r.SetQueryParam("network", qNetwork); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.RcfVersion != nil {

		// query param rcf_version
		var qrRcfVersion string

		if o.RcfVersion != nil {
			qrRcfVersion = *o.RcfVersion
		}
		qRcfVersion := qrRcfVersion
		if qRcfVersion != "" {

			if err := r.SetQueryParam("rcf_version", qRcfVersion); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SnmpUser != nil {

		// query param snmp.user
		var qrSnmpUser string

		if o.SnmpUser != nil {
			qrSnmpUser = *o.SnmpUser
		}
		qSnmpUser := qrSnmpUser
		if qSnmpUser != "" {

			if err := r.SetQueryParam("snmp.user", qSnmpUser); err != nil {
				return err
			}
		}
	}

	if o.SnmpVersion != nil {

		// query param snmp.version
		var qrSnmpVersion string

		if o.SnmpVersion != nil {
			qrSnmpVersion = *o.SnmpVersion
		}
		qSnmpVersion := qrSnmpVersion
		if qSnmpVersion != "" {

			if err := r.SetQueryParam("snmp.version", qSnmpVersion); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamSwitchCollectionGet binds the parameter fields
func (o *SwitchCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamSwitchCollectionGet binds the parameter order_by
func (o *SwitchCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
