// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SwitchCreateReader is a Reader for the SwitchCreate structure.
type SwitchCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SwitchCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewSwitchCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewSwitchCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSwitchCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSwitchCreateCreated creates a SwitchCreateCreated with default headers values
func NewSwitchCreateCreated() *SwitchCreateCreated {
	return &SwitchCreateCreated{}
}

/*
SwitchCreateCreated describes a response with status code 201, with default header values.

Created
*/
type SwitchCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SwitchJobLinkResponse
}

// IsSuccess returns true when this switch create created response has a 2xx status code
func (o *SwitchCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this switch create created response has a 3xx status code
func (o *SwitchCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this switch create created response has a 4xx status code
func (o *SwitchCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this switch create created response has a 5xx status code
func (o *SwitchCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this switch create created response a status code equal to that given
func (o *SwitchCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the switch create created response
func (o *SwitchCreateCreated) Code() int {
	return 201
}

func (o *SwitchCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switchCreateCreated %s", 201, payload)
}

func (o *SwitchCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switchCreateCreated %s", 201, payload)
}

func (o *SwitchCreateCreated) GetPayload() *models.SwitchJobLinkResponse {
	return o.Payload
}

func (o *SwitchCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SwitchJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSwitchCreateAccepted creates a SwitchCreateAccepted with default headers values
func NewSwitchCreateAccepted() *SwitchCreateAccepted {
	return &SwitchCreateAccepted{}
}

/*
SwitchCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type SwitchCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.SwitchJobLinkResponse
}

// IsSuccess returns true when this switch create accepted response has a 2xx status code
func (o *SwitchCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this switch create accepted response has a 3xx status code
func (o *SwitchCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this switch create accepted response has a 4xx status code
func (o *SwitchCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this switch create accepted response has a 5xx status code
func (o *SwitchCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this switch create accepted response a status code equal to that given
func (o *SwitchCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the switch create accepted response
func (o *SwitchCreateAccepted) Code() int {
	return 202
}

func (o *SwitchCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switchCreateAccepted %s", 202, payload)
}

func (o *SwitchCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switchCreateAccepted %s", 202, payload)
}

func (o *SwitchCreateAccepted) GetPayload() *models.SwitchJobLinkResponse {
	return o.Payload
}

func (o *SwitchCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.SwitchJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSwitchCreateDefault creates a SwitchCreateDefault with default headers values
func NewSwitchCreateDefault(code int) *SwitchCreateDefault {
	return &SwitchCreateDefault{
		_statusCode: code,
	}
}

/*
	SwitchCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 5636148 | Failed to discover SNMPv3 engine ID of the remote switch. |
| 5636149 | The \"<snmp.user>\" must be a valid SNMPv3 user belonging to remote switch \"<name.>\" and must also be configured in ONTAP. |
| 5636152 | 0.0.0.0 cannot be specified as the IP address for the \"<address.>\" parameter. |
| 8912900 | Invalid IP address. |
| 9044009 | SNMPv3 client feature is not available until the effective cluster version is ONTAP 9.3 or later. |
| 12517377 | Model number validation failed. Specify the correct model number and try the command again. |
| 12517378 | The IP \"<address.>\" is not reachable. Verify that the address is valid, or check the network path. |
| 12517380 | SNMP validation request timed out. Verify that the \"<snmp.user>\" parameter is valid. |
| 12517382 | SNMPv3 validation request timed out. Verify that the \"<snmp.user>\" parameter is valid (i.e., the SNMPv3 user exists in ONTAP and on the remote switch). If the \"<snmp.user>\" parameter is valid, verify that the SNMPv3 user's credentials are the same both in ONTAP as well as in the remote switch. If a custom engine-id was provided for the SNMPv3 user, ensure it is the same as that of the remote switch. |
| 12517384 | A switch with the same IP address is already being monitored. |
| 12517385 | The \"<model.>\" is unknown. Use \"OTHER\" if the switch model is not one of the following&#58; {models}. |
| 12517411 | The input value for \"<name.>\", \"<address.>\" and/or \"<network.>\" must match its discovered value. |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SwitchCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this switch create default response has a 2xx status code
func (o *SwitchCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this switch create default response has a 3xx status code
func (o *SwitchCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this switch create default response has a 4xx status code
func (o *SwitchCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this switch create default response has a 5xx status code
func (o *SwitchCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this switch create default response a status code equal to that given
func (o *SwitchCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the switch create default response
func (o *SwitchCreateDefault) Code() int {
	return o._statusCode
}

func (o *SwitchCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switch_create default %s", o._statusCode, payload)
}

func (o *SwitchCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /network/ethernet/switches][%d] switch_create default %s", o._statusCode, payload)
}

func (o *SwitchCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SwitchCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
