// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewSwitchDeleteCollectionParams creates a new SwitchDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewSwitchDeleteCollectionParams() *SwitchDeleteCollectionParams {
	return &SwitchDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewSwitchDeleteCollectionParamsWithTimeout creates a new SwitchDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewSwitchDeleteCollectionParamsWithTimeout(timeout time.Duration) *SwitchDeleteCollectionParams {
	return &SwitchDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewSwitchDeleteCollectionParamsWithContext creates a new SwitchDeleteCollectionParams object
// with the ability to set a context for a request.
func NewSwitchDeleteCollectionParamsWithContext(ctx context.Context) *SwitchDeleteCollectionParams {
	return &SwitchDeleteCollectionParams{
		Context: ctx,
	}
}

// NewSwitchDeleteCollectionParamsWithHTTPClient creates a new SwitchDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewSwitchDeleteCollectionParamsWithHTTPClient(client *http.Client) *SwitchDeleteCollectionParams {
	return &SwitchDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
SwitchDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the switch delete collection operation.

	Typically these are written to a http.Request.
*/
type SwitchDeleteCollectionParams struct {

	/* Address.

	   Filter by address
	*/
	Address *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Discovered.

	   Filter by discovered
	*/
	Discovered *bool

	/* Info.

	   Info specification
	*/
	Info SwitchDeleteCollectionBody

	/* Model.

	   Filter by model
	*/
	Model *string

	/* MonitoringEnabled.

	   Filter by monitoring.enabled
	*/
	MonitoringEnabled *bool

	/* MonitoringMonitored.

	   Filter by monitoring.monitored
	*/
	MonitoringMonitored *bool

	/* MonitoringReason.

	   Filter by monitoring.reason
	*/
	MonitoringReason *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* Network.

	   Filter by network
	*/
	Network *string

	/* RcfVersion.

	   Filter by rcf_version
	*/
	RcfVersion *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* SerialNumber.

	   Filter by serial_number
	*/
	SerialNumber *string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SnmpUser.

	   Filter by snmp.user
	*/
	SnmpUser *string

	/* SnmpVersion.

	   Filter by snmp.version
	*/
	SnmpVersion *string

	/* Version.

	   Filter by version
	*/
	Version *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the switch delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SwitchDeleteCollectionParams) WithDefaults() *SwitchDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the switch delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *SwitchDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := SwitchDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithTimeout(timeout time.Duration) *SwitchDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithContext(ctx context.Context) *SwitchDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithHTTPClient(client *http.Client) *SwitchDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAddress adds the address to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithAddress(address *string) *SwitchDeleteCollectionParams {
	o.SetAddress(address)
	return o
}

// SetAddress adds the address to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetAddress(address *string) {
	o.Address = address
}

// WithContinueOnFailure adds the continueOnFailure to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *SwitchDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithDiscovered adds the discovered to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithDiscovered(discovered *bool) *SwitchDeleteCollectionParams {
	o.SetDiscovered(discovered)
	return o
}

// SetDiscovered adds the discovered to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetDiscovered(discovered *bool) {
	o.Discovered = discovered
}

// WithInfo adds the info to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithInfo(info SwitchDeleteCollectionBody) *SwitchDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetInfo(info SwitchDeleteCollectionBody) {
	o.Info = info
}

// WithModel adds the model to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithModel(model *string) *SwitchDeleteCollectionParams {
	o.SetModel(model)
	return o
}

// SetModel adds the model to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetModel(model *string) {
	o.Model = model
}

// WithMonitoringEnabled adds the monitoringEnabled to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithMonitoringEnabled(monitoringEnabled *bool) *SwitchDeleteCollectionParams {
	o.SetMonitoringEnabled(monitoringEnabled)
	return o
}

// SetMonitoringEnabled adds the monitoringEnabled to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetMonitoringEnabled(monitoringEnabled *bool) {
	o.MonitoringEnabled = monitoringEnabled
}

// WithMonitoringMonitored adds the monitoringMonitored to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithMonitoringMonitored(monitoringMonitored *bool) *SwitchDeleteCollectionParams {
	o.SetMonitoringMonitored(monitoringMonitored)
	return o
}

// SetMonitoringMonitored adds the monitoringMonitored to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetMonitoringMonitored(monitoringMonitored *bool) {
	o.MonitoringMonitored = monitoringMonitored
}

// WithMonitoringReason adds the monitoringReason to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithMonitoringReason(monitoringReason *string) *SwitchDeleteCollectionParams {
	o.SetMonitoringReason(monitoringReason)
	return o
}

// SetMonitoringReason adds the monitoringReason to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetMonitoringReason(monitoringReason *string) {
	o.MonitoringReason = monitoringReason
}

// WithName adds the name to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithName(name *string) *SwitchDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNetwork adds the network to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithNetwork(network *string) *SwitchDeleteCollectionParams {
	o.SetNetwork(network)
	return o
}

// SetNetwork adds the network to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetNetwork(network *string) {
	o.Network = network
}

// WithRcfVersion adds the rcfVersion to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithRcfVersion(rcfVersion *string) *SwitchDeleteCollectionParams {
	o.SetRcfVersion(rcfVersion)
	return o
}

// SetRcfVersion adds the rcfVersion to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetRcfVersion(rcfVersion *string) {
	o.RcfVersion = rcfVersion
}

// WithReturnRecords adds the returnRecords to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *SwitchDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *SwitchDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithRole(role *string) *SwitchDeleteCollectionParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetRole(role *string) {
	o.Role = role
}

// WithSerialNumber adds the serialNumber to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithSerialNumber(serialNumber *string) *SwitchDeleteCollectionParams {
	o.SetSerialNumber(serialNumber)
	return o
}

// SetSerialNumber adds the serialNumber to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetSerialNumber(serialNumber *string) {
	o.SerialNumber = serialNumber
}

// WithSerialRecords adds the serialRecords to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *SwitchDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSnmpUser adds the snmpUser to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithSnmpUser(snmpUser *string) *SwitchDeleteCollectionParams {
	o.SetSnmpUser(snmpUser)
	return o
}

// SetSnmpUser adds the snmpUser to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetSnmpUser(snmpUser *string) {
	o.SnmpUser = snmpUser
}

// WithSnmpVersion adds the snmpVersion to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithSnmpVersion(snmpVersion *string) *SwitchDeleteCollectionParams {
	o.SetSnmpVersion(snmpVersion)
	return o
}

// SetSnmpVersion adds the snmpVersion to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetSnmpVersion(snmpVersion *string) {
	o.SnmpVersion = snmpVersion
}

// WithVersion adds the version to the switch delete collection params
func (o *SwitchDeleteCollectionParams) WithVersion(version *string) *SwitchDeleteCollectionParams {
	o.SetVersion(version)
	return o
}

// SetVersion adds the version to the switch delete collection params
func (o *SwitchDeleteCollectionParams) SetVersion(version *string) {
	o.Version = version
}

// WriteToRequest writes these params to a swagger request
func (o *SwitchDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Address != nil {

		// query param address
		var qrAddress string

		if o.Address != nil {
			qrAddress = *o.Address
		}
		qAddress := qrAddress
		if qAddress != "" {

			if err := r.SetQueryParam("address", qAddress); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Discovered != nil {

		// query param discovered
		var qrDiscovered bool

		if o.Discovered != nil {
			qrDiscovered = *o.Discovered
		}
		qDiscovered := swag.FormatBool(qrDiscovered)
		if qDiscovered != "" {

			if err := r.SetQueryParam("discovered", qDiscovered); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Model != nil {

		// query param model
		var qrModel string

		if o.Model != nil {
			qrModel = *o.Model
		}
		qModel := qrModel
		if qModel != "" {

			if err := r.SetQueryParam("model", qModel); err != nil {
				return err
			}
		}
	}

	if o.MonitoringEnabled != nil {

		// query param monitoring.enabled
		var qrMonitoringEnabled bool

		if o.MonitoringEnabled != nil {
			qrMonitoringEnabled = *o.MonitoringEnabled
		}
		qMonitoringEnabled := swag.FormatBool(qrMonitoringEnabled)
		if qMonitoringEnabled != "" {

			if err := r.SetQueryParam("monitoring.enabled", qMonitoringEnabled); err != nil {
				return err
			}
		}
	}

	if o.MonitoringMonitored != nil {

		// query param monitoring.monitored
		var qrMonitoringMonitored bool

		if o.MonitoringMonitored != nil {
			qrMonitoringMonitored = *o.MonitoringMonitored
		}
		qMonitoringMonitored := swag.FormatBool(qrMonitoringMonitored)
		if qMonitoringMonitored != "" {

			if err := r.SetQueryParam("monitoring.monitored", qMonitoringMonitored); err != nil {
				return err
			}
		}
	}

	if o.MonitoringReason != nil {

		// query param monitoring.reason
		var qrMonitoringReason string

		if o.MonitoringReason != nil {
			qrMonitoringReason = *o.MonitoringReason
		}
		qMonitoringReason := qrMonitoringReason
		if qMonitoringReason != "" {

			if err := r.SetQueryParam("monitoring.reason", qMonitoringReason); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.Network != nil {

		// query param network
		var qrNetwork string

		if o.Network != nil {
			qrNetwork = *o.Network
		}
		qNetwork := qrNetwork
		if qNetwork != "" {

			if err := r.SetQueryParam("network", qNetwork); err != nil {
				return err
			}
		}
	}

	if o.RcfVersion != nil {

		// query param rcf_version
		var qrRcfVersion string

		if o.RcfVersion != nil {
			qrRcfVersion = *o.RcfVersion
		}
		qRcfVersion := qrRcfVersion
		if qRcfVersion != "" {

			if err := r.SetQueryParam("rcf_version", qRcfVersion); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.SerialNumber != nil {

		// query param serial_number
		var qrSerialNumber string

		if o.SerialNumber != nil {
			qrSerialNumber = *o.SerialNumber
		}
		qSerialNumber := qrSerialNumber
		if qSerialNumber != "" {

			if err := r.SetQueryParam("serial_number", qSerialNumber); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SnmpUser != nil {

		// query param snmp.user
		var qrSnmpUser string

		if o.SnmpUser != nil {
			qrSnmpUser = *o.SnmpUser
		}
		qSnmpUser := qrSnmpUser
		if qSnmpUser != "" {

			if err := r.SetQueryParam("snmp.user", qSnmpUser); err != nil {
				return err
			}
		}
	}

	if o.SnmpVersion != nil {

		// query param snmp.version
		var qrSnmpVersion string

		if o.SnmpVersion != nil {
			qrSnmpVersion = *o.SnmpVersion
		}
		qSnmpVersion := qrSnmpVersion
		if qSnmpVersion != "" {

			if err := r.SetQueryParam("snmp.version", qSnmpVersion); err != nil {
				return err
			}
		}
	}

	if o.Version != nil {

		// query param version
		var qrVersion string

		if o.Version != nil {
			qrVersion = *o.Version
		}
		qVersion := qrVersion
		if qVersion != "" {

			if err := r.SetQueryParam("version", qVersion); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
