// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SwitchDeleteCollectionReader is a Reader for the SwitchDeleteCollection structure.
type SwitchDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SwitchDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSwitchDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSwitchDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSwitchDeleteCollectionOK creates a SwitchDeleteCollectionOK with default headers values
func NewSwitchDeleteCollectionOK() *SwitchDeleteCollectionOK {
	return &SwitchDeleteCollectionOK{}
}

/*
SwitchDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type SwitchDeleteCollectionOK struct {
}

// IsSuccess returns true when this switch delete collection o k response has a 2xx status code
func (o *SwitchDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this switch delete collection o k response has a 3xx status code
func (o *SwitchDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this switch delete collection o k response has a 4xx status code
func (o *SwitchDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this switch delete collection o k response has a 5xx status code
func (o *SwitchDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this switch delete collection o k response a status code equal to that given
func (o *SwitchDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the switch delete collection o k response
func (o *SwitchDeleteCollectionOK) Code() int {
	return 200
}

func (o *SwitchDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /network/ethernet/switches][%d] switchDeleteCollectionOK", 200)
}

func (o *SwitchDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /network/ethernet/switches][%d] switchDeleteCollectionOK", 200)
}

func (o *SwitchDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewSwitchDeleteCollectionDefault creates a SwitchDeleteCollectionDefault with default headers values
func NewSwitchDeleteCollectionDefault(code int) *SwitchDeleteCollectionDefault {
	return &SwitchDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	SwitchDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 12517412 | Cannot remove a discovered switch. To stop monitoring the switch, set \"<monitoring.enabled>\" to \"false\". |
Also see the table of common errors in the <a href="#Response_body">Response body</a> overview section of this documentation.
*/
type SwitchDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this switch delete collection default response has a 2xx status code
func (o *SwitchDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this switch delete collection default response has a 3xx status code
func (o *SwitchDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this switch delete collection default response has a 4xx status code
func (o *SwitchDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this switch delete collection default response has a 5xx status code
func (o *SwitchDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this switch delete collection default response a status code equal to that given
func (o *SwitchDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the switch delete collection default response
func (o *SwitchDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *SwitchDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ethernet/switches][%d] switch_delete_collection default %s", o._statusCode, payload)
}

func (o *SwitchDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /network/ethernet/switches][%d] switch_delete_collection default %s", o._statusCode, payload)
}

func (o *SwitchDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SwitchDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
SwitchDeleteCollectionBody switch delete collection body
swagger:model SwitchDeleteCollectionBody
*/
type SwitchDeleteCollectionBody struct {

	// switch response inline records
	SwitchResponseInlineRecords []*models.Switch `json:"records,omitempty"`
}

// Validate validates this switch delete collection body
func (o *SwitchDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSwitchResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SwitchDeleteCollectionBody) validateSwitchResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.SwitchResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.SwitchResponseInlineRecords); i++ {
		if swag.IsZero(o.SwitchResponseInlineRecords[i]) { // not required
			continue
		}

		if o.SwitchResponseInlineRecords[i] != nil {
			if err := o.SwitchResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this switch delete collection body based on the context it is used
func (o *SwitchDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSwitchResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *SwitchDeleteCollectionBody) contextValidateSwitchResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.SwitchResponseInlineRecords); i++ {

		if o.SwitchResponseInlineRecords[i] != nil {
			if err := o.SwitchResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *SwitchDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *SwitchDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res SwitchDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
