// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SwitchGetReader is a Reader for the SwitchGet structure.
type SwitchGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SwitchGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSwitchGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSwitchGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSwitchGetOK creates a SwitchGetOK with default headers values
func NewSwitchGetOK() *SwitchGetOK {
	return &SwitchGetOK{}
}

/*
SwitchGetOK describes a response with status code 200, with default header values.

OK
*/
type SwitchGetOK struct {
	Payload *models.Switch
}

// IsSuccess returns true when this switch get o k response has a 2xx status code
func (o *SwitchGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this switch get o k response has a 3xx status code
func (o *SwitchGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this switch get o k response has a 4xx status code
func (o *SwitchGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this switch get o k response has a 5xx status code
func (o *SwitchGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this switch get o k response a status code equal to that given
func (o *SwitchGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the switch get o k response
func (o *SwitchGetOK) Code() int {
	return 200
}

func (o *SwitchGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switches/{name}][%d] switchGetOK %s", 200, payload)
}

func (o *SwitchGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switches/{name}][%d] switchGetOK %s", 200, payload)
}

func (o *SwitchGetOK) GetPayload() *models.Switch {
	return o.Payload
}

func (o *SwitchGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.Switch)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSwitchGetDefault creates a SwitchGetDefault with default headers values
func NewSwitchGetDefault(code int) *SwitchGetDefault {
	return &SwitchGetDefault{
		_statusCode: code,
	}
}

/*
SwitchGetDefault describes a response with status code -1, with default header values.

Error
*/
type SwitchGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this switch get default response has a 2xx status code
func (o *SwitchGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this switch get default response has a 3xx status code
func (o *SwitchGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this switch get default response has a 4xx status code
func (o *SwitchGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this switch get default response has a 5xx status code
func (o *SwitchGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this switch get default response a status code equal to that given
func (o *SwitchGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the switch get default response
func (o *SwitchGetDefault) Code() int {
	return o._statusCode
}

func (o *SwitchGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switches/{name}][%d] switch_get default %s", o._statusCode, payload)
}

func (o *SwitchGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switches/{name}][%d] switch_get default %s", o._statusCode, payload)
}

func (o *SwitchGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SwitchGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
