// Code generated by go-swagger; DO NOT EDIT.

package networking

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// SwitchPortCollectionGetReader is a Reader for the SwitchPortCollectionGet structure.
type SwitchPortCollectionGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *SwitchPortCollectionGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewSwitchPortCollectionGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewSwitchPortCollectionGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewSwitchPortCollectionGetOK creates a SwitchPortCollectionGetOK with default headers values
func NewSwitchPortCollectionGetOK() *SwitchPortCollectionGetOK {
	return &SwitchPortCollectionGetOK{}
}

/*
SwitchPortCollectionGetOK describes a response with status code 200, with default header values.

OK
*/
type SwitchPortCollectionGetOK struct {
	Payload *models.SwitchPortResponse
}

// IsSuccess returns true when this switch port collection get o k response has a 2xx status code
func (o *SwitchPortCollectionGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this switch port collection get o k response has a 3xx status code
func (o *SwitchPortCollectionGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this switch port collection get o k response has a 4xx status code
func (o *SwitchPortCollectionGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this switch port collection get o k response has a 5xx status code
func (o *SwitchPortCollectionGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this switch port collection get o k response a status code equal to that given
func (o *SwitchPortCollectionGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the switch port collection get o k response
func (o *SwitchPortCollectionGetOK) Code() int {
	return 200
}

func (o *SwitchPortCollectionGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switch/ports][%d] switchPortCollectionGetOK %s", 200, payload)
}

func (o *SwitchPortCollectionGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switch/ports][%d] switchPortCollectionGetOK %s", 200, payload)
}

func (o *SwitchPortCollectionGetOK) GetPayload() *models.SwitchPortResponse {
	return o.Payload
}

func (o *SwitchPortCollectionGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.SwitchPortResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewSwitchPortCollectionGetDefault creates a SwitchPortCollectionGetDefault with default headers values
func NewSwitchPortCollectionGetDefault(code int) *SwitchPortCollectionGetDefault {
	return &SwitchPortCollectionGetDefault{
		_statusCode: code,
	}
}

/*
SwitchPortCollectionGetDefault describes a response with status code -1, with default header values.

Error
*/
type SwitchPortCollectionGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this switch port collection get default response has a 2xx status code
func (o *SwitchPortCollectionGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this switch port collection get default response has a 3xx status code
func (o *SwitchPortCollectionGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this switch port collection get default response has a 4xx status code
func (o *SwitchPortCollectionGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this switch port collection get default response has a 5xx status code
func (o *SwitchPortCollectionGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this switch port collection get default response a status code equal to that given
func (o *SwitchPortCollectionGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the switch port collection get default response
func (o *SwitchPortCollectionGetDefault) Code() int {
	return o._statusCode
}

func (o *SwitchPortCollectionGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switch/ports][%d] switch_port_collection_get default %s", o._statusCode, payload)
}

func (o *SwitchPortCollectionGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /network/ethernet/switch/ports][%d] switch_port_collection_get default %s", o._statusCode, payload)
}

func (o *SwitchPortCollectionGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *SwitchPortCollectionGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
