// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewBucketsCollectionGetParams creates a new BucketsCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewBucketsCollectionGetParams() *BucketsCollectionGetParams {
	return &BucketsCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewBucketsCollectionGetParamsWithTimeout creates a new BucketsCollectionGetParams object
// with the ability to set a timeout on a request.
func NewBucketsCollectionGetParamsWithTimeout(timeout time.Duration) *BucketsCollectionGetParams {
	return &BucketsCollectionGetParams{
		timeout: timeout,
	}
}

// NewBucketsCollectionGetParamsWithContext creates a new BucketsCollectionGetParams object
// with the ability to set a context for a request.
func NewBucketsCollectionGetParamsWithContext(ctx context.Context) *BucketsCollectionGetParams {
	return &BucketsCollectionGetParams{
		Context: ctx,
	}
}

// NewBucketsCollectionGetParamsWithHTTPClient creates a new BucketsCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewBucketsCollectionGetParamsWithHTTPClient(client *http.Client) *BucketsCollectionGetParams {
	return &BucketsCollectionGetParams{
		HTTPClient: client,
	}
}

/*
BucketsCollectionGetParams contains all the parameters to send to the API endpoint

	for the buckets collection get operation.

	Typically these are written to a http.Request.
*/
type BucketsCollectionGetParams struct {

	/* AuditEventSelectorAccess.

	   Filter by audit_event_selector.access
	*/
	AuditEventSelectorAccess *string

	/* AuditEventSelectorPermission.

	   Filter by audit_event_selector.permission
	*/
	AuditEventSelectorPermission *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* CorsRulesAllowedHeaders.

	   Filter by cors.rules.allowed_headers
	*/
	CorsRulesAllowedHeaders *string

	/* CorsRulesAllowedMethods.

	   Filter by cors.rules.allowed_methods
	*/
	CorsRulesAllowedMethods *string

	/* CorsRulesAllowedOrigins.

	   Filter by cors.rules.allowed_origins
	*/
	CorsRulesAllowedOrigins *string

	/* CorsRulesExposeHeaders.

	   Filter by cors.rules.expose_headers
	*/
	CorsRulesExposeHeaders *string

	/* CorsRulesID.

	   Filter by cors.rules.id
	*/
	CorsRulesID *string

	/* CorsRulesMaxAgeSeconds.

	   Filter by cors.rules.max_age_seconds
	*/
	CorsRulesMaxAgeSeconds *int64

	/* EncryptionEnabled.

	   Filter by encryption.enabled
	*/
	EncryptionEnabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsConsistentEtag.

	   Filter by is_consistent_etag
	*/
	IsConsistentEtag *bool

	/* IsNasPathMutable.

	   Filter by is_nas_path_mutable
	*/
	IsNasPathMutable *bool

	/* LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays.

	   Filter by lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days
	*/
	LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64

	/* LifecycleManagementRulesBucketName.

	   Filter by lifecycle_management.rules.bucket_name
	*/
	LifecycleManagementRulesBucketName *string

	/* LifecycleManagementRulesEnabled.

	   Filter by lifecycle_management.rules.enabled
	*/
	LifecycleManagementRulesEnabled *bool

	/* LifecycleManagementRulesExpirationExpiredObjectDeleteMarker.

	   Filter by lifecycle_management.rules.expiration.expired_object_delete_marker
	*/
	LifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool

	/* LifecycleManagementRulesExpirationObjectAgeDays.

	   Filter by lifecycle_management.rules.expiration.object_age_days
	*/
	LifecycleManagementRulesExpirationObjectAgeDays *int64

	/* LifecycleManagementRulesExpirationObjectExpiryDate.

	   Filter by lifecycle_management.rules.expiration.object_expiry_date
	*/
	LifecycleManagementRulesExpirationObjectExpiryDate *string

	/* LifecycleManagementRulesName.

	   Filter by lifecycle_management.rules.name
	*/
	LifecycleManagementRulesName *string

	/* LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions.

	   Filter by lifecycle_management.rules.non_current_version_expiration.new_non_current_versions
	*/
	LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64

	/* LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays.

	   Filter by lifecycle_management.rules.non_current_version_expiration.non_current_days
	*/
	LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64

	/* LifecycleManagementRulesObjectFilterPrefix.

	   Filter by lifecycle_management.rules.object_filter.prefix
	*/
	LifecycleManagementRulesObjectFilterPrefix *string

	/* LifecycleManagementRulesObjectFilterSizeGreaterThan.

	   Filter by lifecycle_management.rules.object_filter.size_greater_than
	*/
	LifecycleManagementRulesObjectFilterSizeGreaterThan *int64

	/* LifecycleManagementRulesObjectFilterSizeLessThan.

	   Filter by lifecycle_management.rules.object_filter.size_less_than
	*/
	LifecycleManagementRulesObjectFilterSizeLessThan *int64

	/* LifecycleManagementRulesObjectFilterTags.

	   Filter by lifecycle_management.rules.object_filter.tags
	*/
	LifecycleManagementRulesObjectFilterTags *string

	/* LifecycleManagementRulesSvmName.

	   Filter by lifecycle_management.rules.svm.name
	*/
	LifecycleManagementRulesSvmName *string

	/* LifecycleManagementRulesSvmUUID.

	   Filter by lifecycle_management.rules.svm.uuid
	*/
	LifecycleManagementRulesSvmUUID *string

	/* LifecycleManagementRulesUUID.

	   Filter by lifecycle_management.rules.uuid
	*/
	LifecycleManagementRulesUUID *string

	/* LogicalUsedSize.

	   Filter by logical_used_size
	*/
	LogicalUsedSize *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NasPath.

	   Filter by nas_path
	*/
	NasPath *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PolicyStatementsActions.

	   Filter by policy.statements.actions
	*/
	PolicyStatementsActions *string

	/* PolicyStatementsConditionsDelimiters.

	   Filter by policy.statements.conditions.delimiters
	*/
	PolicyStatementsConditionsDelimiters *string

	/* PolicyStatementsConditionsMaxKeys.

	   Filter by policy.statements.conditions.max_keys
	*/
	PolicyStatementsConditionsMaxKeys *int64

	/* PolicyStatementsConditionsOperator.

	   Filter by policy.statements.conditions.operator
	*/
	PolicyStatementsConditionsOperator *string

	/* PolicyStatementsConditionsPrefixes.

	   Filter by policy.statements.conditions.prefixes
	*/
	PolicyStatementsConditionsPrefixes *string

	/* PolicyStatementsConditionsSourceIps.

	   Filter by policy.statements.conditions.source_ips
	*/
	PolicyStatementsConditionsSourceIps *string

	/* PolicyStatementsConditionsUsernames.

	   Filter by policy.statements.conditions.usernames
	*/
	PolicyStatementsConditionsUsernames *string

	/* PolicyStatementsEffect.

	   Filter by policy.statements.effect
	*/
	PolicyStatementsEffect *string

	/* PolicyStatementsPrincipals.

	   Filter by policy.statements.principals
	*/
	PolicyStatementsPrincipals *string

	/* PolicyStatementsResources.

	   Filter by policy.statements.resources
	*/
	PolicyStatementsResources *string

	/* PolicyStatementsSid.

	   Filter by policy.statements.sid
	*/
	PolicyStatementsSid *string

	/* ProtectionStatusDestinationIsCloud.

	   Filter by protection_status.destination.is_cloud
	*/
	ProtectionStatusDestinationIsCloud *bool

	/* ProtectionStatusDestinationIsExternalCloud.

	   Filter by protection_status.destination.is_external_cloud
	*/
	ProtectionStatusDestinationIsExternalCloud *bool

	/* ProtectionStatusDestinationIsOntap.

	   Filter by protection_status.destination.is_ontap
	*/
	ProtectionStatusDestinationIsOntap *bool

	/* ProtectionStatusIsProtected.

	   Filter by protection_status.is_protected
	*/
	ProtectionStatusIsProtected *bool

	/* QosPolicyMaxThroughput.

	   Filter by qos_policy.max_throughput
	*/
	QosPolicyMaxThroughput *string

	/* QosPolicyMaxThroughputIops.

	   Filter by qos_policy.max_throughput_iops
	*/
	QosPolicyMaxThroughputIops *int64

	/* QosPolicyMaxThroughputMbps.

	   Filter by qos_policy.max_throughput_mbps
	*/
	QosPolicyMaxThroughputMbps *int64

	/* QosPolicyMinThroughput.

	   Filter by qos_policy.min_throughput
	*/
	QosPolicyMinThroughput *string

	/* QosPolicyMinThroughputIops.

	   Filter by qos_policy.min_throughput_iops
	*/
	QosPolicyMinThroughputIops *int64

	/* QosPolicyMinThroughputMbps.

	   Filter by qos_policy.min_throughput_mbps
	*/
	QosPolicyMinThroughputMbps *int64

	/* QosPolicyName.

	   Filter by qos_policy.name
	*/
	QosPolicyName *string

	/* QosPolicyUUID.

	   Filter by qos_policy.uuid
	*/
	QosPolicyUUID *string

	/* RetentionDefaultPeriod.

	   Filter by retention.default_period
	*/
	RetentionDefaultPeriod *string

	/* RetentionMode.

	   Filter by retention.mode
	*/
	RetentionMode *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* Role.

	   Filter by role
	*/
	Role *string

	/* Size.

	   Filter by size
	*/
	Size *int64

	/* SnapshotPolicyName.

	   Filter by snapshot_policy.name
	*/
	SnapshotPolicyName *string

	/* SnapshotPolicyUUID.

	   Filter by snapshot_policy.uuid
	*/
	SnapshotPolicyUUID *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* Type.

	   Filter by type
	*/
	Type *string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	/* VersioningState.

	   Filter by versioning_state
	*/
	VersioningState *string

	/* VolumeName.

	   Filter by volume.name
	*/
	VolumeName *string

	/* VolumeUUID.

	   Filter by volume.uuid
	*/
	VolumeUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the buckets collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BucketsCollectionGetParams) WithDefaults() *BucketsCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the buckets collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *BucketsCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := BucketsCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the buckets collection get params
func (o *BucketsCollectionGetParams) WithTimeout(timeout time.Duration) *BucketsCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the buckets collection get params
func (o *BucketsCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the buckets collection get params
func (o *BucketsCollectionGetParams) WithContext(ctx context.Context) *BucketsCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the buckets collection get params
func (o *BucketsCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the buckets collection get params
func (o *BucketsCollectionGetParams) WithHTTPClient(client *http.Client) *BucketsCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the buckets collection get params
func (o *BucketsCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAuditEventSelectorAccess adds the auditEventSelectorAccess to the buckets collection get params
func (o *BucketsCollectionGetParams) WithAuditEventSelectorAccess(auditEventSelectorAccess *string) *BucketsCollectionGetParams {
	o.SetAuditEventSelectorAccess(auditEventSelectorAccess)
	return o
}

// SetAuditEventSelectorAccess adds the auditEventSelectorAccess to the buckets collection get params
func (o *BucketsCollectionGetParams) SetAuditEventSelectorAccess(auditEventSelectorAccess *string) {
	o.AuditEventSelectorAccess = auditEventSelectorAccess
}

// WithAuditEventSelectorPermission adds the auditEventSelectorPermission to the buckets collection get params
func (o *BucketsCollectionGetParams) WithAuditEventSelectorPermission(auditEventSelectorPermission *string) *BucketsCollectionGetParams {
	o.SetAuditEventSelectorPermission(auditEventSelectorPermission)
	return o
}

// SetAuditEventSelectorPermission adds the auditEventSelectorPermission to the buckets collection get params
func (o *BucketsCollectionGetParams) SetAuditEventSelectorPermission(auditEventSelectorPermission *string) {
	o.AuditEventSelectorPermission = auditEventSelectorPermission
}

// WithComment adds the comment to the buckets collection get params
func (o *BucketsCollectionGetParams) WithComment(comment *string) *BucketsCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the buckets collection get params
func (o *BucketsCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithCorsRulesAllowedHeaders adds the corsRulesAllowedHeaders to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesAllowedHeaders(corsRulesAllowedHeaders *string) *BucketsCollectionGetParams {
	o.SetCorsRulesAllowedHeaders(corsRulesAllowedHeaders)
	return o
}

// SetCorsRulesAllowedHeaders adds the corsRulesAllowedHeaders to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesAllowedHeaders(corsRulesAllowedHeaders *string) {
	o.CorsRulesAllowedHeaders = corsRulesAllowedHeaders
}

// WithCorsRulesAllowedMethods adds the corsRulesAllowedMethods to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesAllowedMethods(corsRulesAllowedMethods *string) *BucketsCollectionGetParams {
	o.SetCorsRulesAllowedMethods(corsRulesAllowedMethods)
	return o
}

// SetCorsRulesAllowedMethods adds the corsRulesAllowedMethods to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesAllowedMethods(corsRulesAllowedMethods *string) {
	o.CorsRulesAllowedMethods = corsRulesAllowedMethods
}

// WithCorsRulesAllowedOrigins adds the corsRulesAllowedOrigins to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesAllowedOrigins(corsRulesAllowedOrigins *string) *BucketsCollectionGetParams {
	o.SetCorsRulesAllowedOrigins(corsRulesAllowedOrigins)
	return o
}

// SetCorsRulesAllowedOrigins adds the corsRulesAllowedOrigins to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesAllowedOrigins(corsRulesAllowedOrigins *string) {
	o.CorsRulesAllowedOrigins = corsRulesAllowedOrigins
}

// WithCorsRulesExposeHeaders adds the corsRulesExposeHeaders to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesExposeHeaders(corsRulesExposeHeaders *string) *BucketsCollectionGetParams {
	o.SetCorsRulesExposeHeaders(corsRulesExposeHeaders)
	return o
}

// SetCorsRulesExposeHeaders adds the corsRulesExposeHeaders to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesExposeHeaders(corsRulesExposeHeaders *string) {
	o.CorsRulesExposeHeaders = corsRulesExposeHeaders
}

// WithCorsRulesID adds the corsRulesID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesID(corsRulesID *string) *BucketsCollectionGetParams {
	o.SetCorsRulesID(corsRulesID)
	return o
}

// SetCorsRulesID adds the corsRulesId to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesID(corsRulesID *string) {
	o.CorsRulesID = corsRulesID
}

// WithCorsRulesMaxAgeSeconds adds the corsRulesMaxAgeSeconds to the buckets collection get params
func (o *BucketsCollectionGetParams) WithCorsRulesMaxAgeSeconds(corsRulesMaxAgeSeconds *int64) *BucketsCollectionGetParams {
	o.SetCorsRulesMaxAgeSeconds(corsRulesMaxAgeSeconds)
	return o
}

// SetCorsRulesMaxAgeSeconds adds the corsRulesMaxAgeSeconds to the buckets collection get params
func (o *BucketsCollectionGetParams) SetCorsRulesMaxAgeSeconds(corsRulesMaxAgeSeconds *int64) {
	o.CorsRulesMaxAgeSeconds = corsRulesMaxAgeSeconds
}

// WithEncryptionEnabled adds the encryptionEnabled to the buckets collection get params
func (o *BucketsCollectionGetParams) WithEncryptionEnabled(encryptionEnabled *bool) *BucketsCollectionGetParams {
	o.SetEncryptionEnabled(encryptionEnabled)
	return o
}

// SetEncryptionEnabled adds the encryptionEnabled to the buckets collection get params
func (o *BucketsCollectionGetParams) SetEncryptionEnabled(encryptionEnabled *bool) {
	o.EncryptionEnabled = encryptionEnabled
}

// WithFields adds the fields to the buckets collection get params
func (o *BucketsCollectionGetParams) WithFields(fields []string) *BucketsCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the buckets collection get params
func (o *BucketsCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsConsistentEtag adds the isConsistentEtag to the buckets collection get params
func (o *BucketsCollectionGetParams) WithIsConsistentEtag(isConsistentEtag *bool) *BucketsCollectionGetParams {
	o.SetIsConsistentEtag(isConsistentEtag)
	return o
}

// SetIsConsistentEtag adds the isConsistentEtag to the buckets collection get params
func (o *BucketsCollectionGetParams) SetIsConsistentEtag(isConsistentEtag *bool) {
	o.IsConsistentEtag = isConsistentEtag
}

// WithIsNasPathMutable adds the isNasPathMutable to the buckets collection get params
func (o *BucketsCollectionGetParams) WithIsNasPathMutable(isNasPathMutable *bool) *BucketsCollectionGetParams {
	o.SetIsNasPathMutable(isNasPathMutable)
	return o
}

// SetIsNasPathMutable adds the isNasPathMutable to the buckets collection get params
func (o *BucketsCollectionGetParams) SetIsNasPathMutable(isNasPathMutable *bool) {
	o.IsNasPathMutable = isNasPathMutable
}

// WithLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays adds the lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays)
	return o
}

// SetLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays adds the lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64) {
	o.LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays = lifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays
}

// WithLifecycleManagementRulesBucketName adds the lifecycleManagementRulesBucketName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesBucketName(lifecycleManagementRulesBucketName *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesBucketName(lifecycleManagementRulesBucketName)
	return o
}

// SetLifecycleManagementRulesBucketName adds the lifecycleManagementRulesBucketName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesBucketName(lifecycleManagementRulesBucketName *string) {
	o.LifecycleManagementRulesBucketName = lifecycleManagementRulesBucketName
}

// WithLifecycleManagementRulesEnabled adds the lifecycleManagementRulesEnabled to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesEnabled(lifecycleManagementRulesEnabled *bool) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesEnabled(lifecycleManagementRulesEnabled)
	return o
}

// SetLifecycleManagementRulesEnabled adds the lifecycleManagementRulesEnabled to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesEnabled(lifecycleManagementRulesEnabled *bool) {
	o.LifecycleManagementRulesEnabled = lifecycleManagementRulesEnabled
}

// WithLifecycleManagementRulesExpirationExpiredObjectDeleteMarker adds the lifecycleManagementRulesExpirationExpiredObjectDeleteMarker to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(lifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(lifecycleManagementRulesExpirationExpiredObjectDeleteMarker)
	return o
}

// SetLifecycleManagementRulesExpirationExpiredObjectDeleteMarker adds the lifecycleManagementRulesExpirationExpiredObjectDeleteMarker to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(lifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool) {
	o.LifecycleManagementRulesExpirationExpiredObjectDeleteMarker = lifecycleManagementRulesExpirationExpiredObjectDeleteMarker
}

// WithLifecycleManagementRulesExpirationObjectAgeDays adds the lifecycleManagementRulesExpirationObjectAgeDays to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesExpirationObjectAgeDays(lifecycleManagementRulesExpirationObjectAgeDays *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesExpirationObjectAgeDays(lifecycleManagementRulesExpirationObjectAgeDays)
	return o
}

// SetLifecycleManagementRulesExpirationObjectAgeDays adds the lifecycleManagementRulesExpirationObjectAgeDays to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesExpirationObjectAgeDays(lifecycleManagementRulesExpirationObjectAgeDays *int64) {
	o.LifecycleManagementRulesExpirationObjectAgeDays = lifecycleManagementRulesExpirationObjectAgeDays
}

// WithLifecycleManagementRulesExpirationObjectExpiryDate adds the lifecycleManagementRulesExpirationObjectExpiryDate to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesExpirationObjectExpiryDate(lifecycleManagementRulesExpirationObjectExpiryDate *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesExpirationObjectExpiryDate(lifecycleManagementRulesExpirationObjectExpiryDate)
	return o
}

// SetLifecycleManagementRulesExpirationObjectExpiryDate adds the lifecycleManagementRulesExpirationObjectExpiryDate to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesExpirationObjectExpiryDate(lifecycleManagementRulesExpirationObjectExpiryDate *string) {
	o.LifecycleManagementRulesExpirationObjectExpiryDate = lifecycleManagementRulesExpirationObjectExpiryDate
}

// WithLifecycleManagementRulesName adds the lifecycleManagementRulesName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesName(lifecycleManagementRulesName *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesName(lifecycleManagementRulesName)
	return o
}

// SetLifecycleManagementRulesName adds the lifecycleManagementRulesName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesName(lifecycleManagementRulesName *string) {
	o.LifecycleManagementRulesName = lifecycleManagementRulesName
}

// WithLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions adds the lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions)
	return o
}

// SetLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions adds the lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64) {
	o.LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions = lifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions
}

// WithLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays adds the lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays)
	return o
}

// SetLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays adds the lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64) {
	o.LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays = lifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays
}

// WithLifecycleManagementRulesObjectFilterPrefix adds the lifecycleManagementRulesObjectFilterPrefix to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesObjectFilterPrefix(lifecycleManagementRulesObjectFilterPrefix *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesObjectFilterPrefix(lifecycleManagementRulesObjectFilterPrefix)
	return o
}

// SetLifecycleManagementRulesObjectFilterPrefix adds the lifecycleManagementRulesObjectFilterPrefix to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesObjectFilterPrefix(lifecycleManagementRulesObjectFilterPrefix *string) {
	o.LifecycleManagementRulesObjectFilterPrefix = lifecycleManagementRulesObjectFilterPrefix
}

// WithLifecycleManagementRulesObjectFilterSizeGreaterThan adds the lifecycleManagementRulesObjectFilterSizeGreaterThan to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesObjectFilterSizeGreaterThan(lifecycleManagementRulesObjectFilterSizeGreaterThan *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesObjectFilterSizeGreaterThan(lifecycleManagementRulesObjectFilterSizeGreaterThan)
	return o
}

// SetLifecycleManagementRulesObjectFilterSizeGreaterThan adds the lifecycleManagementRulesObjectFilterSizeGreaterThan to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesObjectFilterSizeGreaterThan(lifecycleManagementRulesObjectFilterSizeGreaterThan *int64) {
	o.LifecycleManagementRulesObjectFilterSizeGreaterThan = lifecycleManagementRulesObjectFilterSizeGreaterThan
}

// WithLifecycleManagementRulesObjectFilterSizeLessThan adds the lifecycleManagementRulesObjectFilterSizeLessThan to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesObjectFilterSizeLessThan(lifecycleManagementRulesObjectFilterSizeLessThan *int64) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesObjectFilterSizeLessThan(lifecycleManagementRulesObjectFilterSizeLessThan)
	return o
}

// SetLifecycleManagementRulesObjectFilterSizeLessThan adds the lifecycleManagementRulesObjectFilterSizeLessThan to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesObjectFilterSizeLessThan(lifecycleManagementRulesObjectFilterSizeLessThan *int64) {
	o.LifecycleManagementRulesObjectFilterSizeLessThan = lifecycleManagementRulesObjectFilterSizeLessThan
}

// WithLifecycleManagementRulesObjectFilterTags adds the lifecycleManagementRulesObjectFilterTags to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesObjectFilterTags(lifecycleManagementRulesObjectFilterTags *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesObjectFilterTags(lifecycleManagementRulesObjectFilterTags)
	return o
}

// SetLifecycleManagementRulesObjectFilterTags adds the lifecycleManagementRulesObjectFilterTags to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesObjectFilterTags(lifecycleManagementRulesObjectFilterTags *string) {
	o.LifecycleManagementRulesObjectFilterTags = lifecycleManagementRulesObjectFilterTags
}

// WithLifecycleManagementRulesSvmName adds the lifecycleManagementRulesSvmName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesSvmName(lifecycleManagementRulesSvmName *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesSvmName(lifecycleManagementRulesSvmName)
	return o
}

// SetLifecycleManagementRulesSvmName adds the lifecycleManagementRulesSvmName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesSvmName(lifecycleManagementRulesSvmName *string) {
	o.LifecycleManagementRulesSvmName = lifecycleManagementRulesSvmName
}

// WithLifecycleManagementRulesSvmUUID adds the lifecycleManagementRulesSvmUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesSvmUUID(lifecycleManagementRulesSvmUUID *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesSvmUUID(lifecycleManagementRulesSvmUUID)
	return o
}

// SetLifecycleManagementRulesSvmUUID adds the lifecycleManagementRulesSvmUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesSvmUUID(lifecycleManagementRulesSvmUUID *string) {
	o.LifecycleManagementRulesSvmUUID = lifecycleManagementRulesSvmUUID
}

// WithLifecycleManagementRulesUUID adds the lifecycleManagementRulesUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLifecycleManagementRulesUUID(lifecycleManagementRulesUUID *string) *BucketsCollectionGetParams {
	o.SetLifecycleManagementRulesUUID(lifecycleManagementRulesUUID)
	return o
}

// SetLifecycleManagementRulesUUID adds the lifecycleManagementRulesUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLifecycleManagementRulesUUID(lifecycleManagementRulesUUID *string) {
	o.LifecycleManagementRulesUUID = lifecycleManagementRulesUUID
}

// WithLogicalUsedSize adds the logicalUsedSize to the buckets collection get params
func (o *BucketsCollectionGetParams) WithLogicalUsedSize(logicalUsedSize *int64) *BucketsCollectionGetParams {
	o.SetLogicalUsedSize(logicalUsedSize)
	return o
}

// SetLogicalUsedSize adds the logicalUsedSize to the buckets collection get params
func (o *BucketsCollectionGetParams) SetLogicalUsedSize(logicalUsedSize *int64) {
	o.LogicalUsedSize = logicalUsedSize
}

// WithMaxRecords adds the maxRecords to the buckets collection get params
func (o *BucketsCollectionGetParams) WithMaxRecords(maxRecords *int64) *BucketsCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the buckets collection get params
func (o *BucketsCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the buckets collection get params
func (o *BucketsCollectionGetParams) WithName(name *string) *BucketsCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the buckets collection get params
func (o *BucketsCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNasPath adds the nasPath to the buckets collection get params
func (o *BucketsCollectionGetParams) WithNasPath(nasPath *string) *BucketsCollectionGetParams {
	o.SetNasPath(nasPath)
	return o
}

// SetNasPath adds the nasPath to the buckets collection get params
func (o *BucketsCollectionGetParams) SetNasPath(nasPath *string) {
	o.NasPath = nasPath
}

// WithOrderBy adds the orderBy to the buckets collection get params
func (o *BucketsCollectionGetParams) WithOrderBy(orderBy []string) *BucketsCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the buckets collection get params
func (o *BucketsCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPolicyStatementsActions adds the policyStatementsActions to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsActions(policyStatementsActions *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsActions(policyStatementsActions)
	return o
}

// SetPolicyStatementsActions adds the policyStatementsActions to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsActions(policyStatementsActions *string) {
	o.PolicyStatementsActions = policyStatementsActions
}

// WithPolicyStatementsConditionsDelimiters adds the policyStatementsConditionsDelimiters to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsDelimiters(policyStatementsConditionsDelimiters *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsDelimiters(policyStatementsConditionsDelimiters)
	return o
}

// SetPolicyStatementsConditionsDelimiters adds the policyStatementsConditionsDelimiters to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsDelimiters(policyStatementsConditionsDelimiters *string) {
	o.PolicyStatementsConditionsDelimiters = policyStatementsConditionsDelimiters
}

// WithPolicyStatementsConditionsMaxKeys adds the policyStatementsConditionsMaxKeys to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsMaxKeys(policyStatementsConditionsMaxKeys *int64) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsMaxKeys(policyStatementsConditionsMaxKeys)
	return o
}

// SetPolicyStatementsConditionsMaxKeys adds the policyStatementsConditionsMaxKeys to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsMaxKeys(policyStatementsConditionsMaxKeys *int64) {
	o.PolicyStatementsConditionsMaxKeys = policyStatementsConditionsMaxKeys
}

// WithPolicyStatementsConditionsOperator adds the policyStatementsConditionsOperator to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsOperator(policyStatementsConditionsOperator *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsOperator(policyStatementsConditionsOperator)
	return o
}

// SetPolicyStatementsConditionsOperator adds the policyStatementsConditionsOperator to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsOperator(policyStatementsConditionsOperator *string) {
	o.PolicyStatementsConditionsOperator = policyStatementsConditionsOperator
}

// WithPolicyStatementsConditionsPrefixes adds the policyStatementsConditionsPrefixes to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsPrefixes(policyStatementsConditionsPrefixes *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsPrefixes(policyStatementsConditionsPrefixes)
	return o
}

// SetPolicyStatementsConditionsPrefixes adds the policyStatementsConditionsPrefixes to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsPrefixes(policyStatementsConditionsPrefixes *string) {
	o.PolicyStatementsConditionsPrefixes = policyStatementsConditionsPrefixes
}

// WithPolicyStatementsConditionsSourceIps adds the policyStatementsConditionsSourceIps to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsSourceIps(policyStatementsConditionsSourceIps *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsSourceIps(policyStatementsConditionsSourceIps)
	return o
}

// SetPolicyStatementsConditionsSourceIps adds the policyStatementsConditionsSourceIps to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsSourceIps(policyStatementsConditionsSourceIps *string) {
	o.PolicyStatementsConditionsSourceIps = policyStatementsConditionsSourceIps
}

// WithPolicyStatementsConditionsUsernames adds the policyStatementsConditionsUsernames to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsConditionsUsernames(policyStatementsConditionsUsernames *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsConditionsUsernames(policyStatementsConditionsUsernames)
	return o
}

// SetPolicyStatementsConditionsUsernames adds the policyStatementsConditionsUsernames to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsConditionsUsernames(policyStatementsConditionsUsernames *string) {
	o.PolicyStatementsConditionsUsernames = policyStatementsConditionsUsernames
}

// WithPolicyStatementsEffect adds the policyStatementsEffect to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsEffect(policyStatementsEffect *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsEffect(policyStatementsEffect)
	return o
}

// SetPolicyStatementsEffect adds the policyStatementsEffect to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsEffect(policyStatementsEffect *string) {
	o.PolicyStatementsEffect = policyStatementsEffect
}

// WithPolicyStatementsPrincipals adds the policyStatementsPrincipals to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsPrincipals(policyStatementsPrincipals *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsPrincipals(policyStatementsPrincipals)
	return o
}

// SetPolicyStatementsPrincipals adds the policyStatementsPrincipals to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsPrincipals(policyStatementsPrincipals *string) {
	o.PolicyStatementsPrincipals = policyStatementsPrincipals
}

// WithPolicyStatementsResources adds the policyStatementsResources to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsResources(policyStatementsResources *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsResources(policyStatementsResources)
	return o
}

// SetPolicyStatementsResources adds the policyStatementsResources to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsResources(policyStatementsResources *string) {
	o.PolicyStatementsResources = policyStatementsResources
}

// WithPolicyStatementsSid adds the policyStatementsSid to the buckets collection get params
func (o *BucketsCollectionGetParams) WithPolicyStatementsSid(policyStatementsSid *string) *BucketsCollectionGetParams {
	o.SetPolicyStatementsSid(policyStatementsSid)
	return o
}

// SetPolicyStatementsSid adds the policyStatementsSid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetPolicyStatementsSid(policyStatementsSid *string) {
	o.PolicyStatementsSid = policyStatementsSid
}

// WithProtectionStatusDestinationIsCloud adds the protectionStatusDestinationIsCloud to the buckets collection get params
func (o *BucketsCollectionGetParams) WithProtectionStatusDestinationIsCloud(protectionStatusDestinationIsCloud *bool) *BucketsCollectionGetParams {
	o.SetProtectionStatusDestinationIsCloud(protectionStatusDestinationIsCloud)
	return o
}

// SetProtectionStatusDestinationIsCloud adds the protectionStatusDestinationIsCloud to the buckets collection get params
func (o *BucketsCollectionGetParams) SetProtectionStatusDestinationIsCloud(protectionStatusDestinationIsCloud *bool) {
	o.ProtectionStatusDestinationIsCloud = protectionStatusDestinationIsCloud
}

// WithProtectionStatusDestinationIsExternalCloud adds the protectionStatusDestinationIsExternalCloud to the buckets collection get params
func (o *BucketsCollectionGetParams) WithProtectionStatusDestinationIsExternalCloud(protectionStatusDestinationIsExternalCloud *bool) *BucketsCollectionGetParams {
	o.SetProtectionStatusDestinationIsExternalCloud(protectionStatusDestinationIsExternalCloud)
	return o
}

// SetProtectionStatusDestinationIsExternalCloud adds the protectionStatusDestinationIsExternalCloud to the buckets collection get params
func (o *BucketsCollectionGetParams) SetProtectionStatusDestinationIsExternalCloud(protectionStatusDestinationIsExternalCloud *bool) {
	o.ProtectionStatusDestinationIsExternalCloud = protectionStatusDestinationIsExternalCloud
}

// WithProtectionStatusDestinationIsOntap adds the protectionStatusDestinationIsOntap to the buckets collection get params
func (o *BucketsCollectionGetParams) WithProtectionStatusDestinationIsOntap(protectionStatusDestinationIsOntap *bool) *BucketsCollectionGetParams {
	o.SetProtectionStatusDestinationIsOntap(protectionStatusDestinationIsOntap)
	return o
}

// SetProtectionStatusDestinationIsOntap adds the protectionStatusDestinationIsOntap to the buckets collection get params
func (o *BucketsCollectionGetParams) SetProtectionStatusDestinationIsOntap(protectionStatusDestinationIsOntap *bool) {
	o.ProtectionStatusDestinationIsOntap = protectionStatusDestinationIsOntap
}

// WithProtectionStatusIsProtected adds the protectionStatusIsProtected to the buckets collection get params
func (o *BucketsCollectionGetParams) WithProtectionStatusIsProtected(protectionStatusIsProtected *bool) *BucketsCollectionGetParams {
	o.SetProtectionStatusIsProtected(protectionStatusIsProtected)
	return o
}

// SetProtectionStatusIsProtected adds the protectionStatusIsProtected to the buckets collection get params
func (o *BucketsCollectionGetParams) SetProtectionStatusIsProtected(protectionStatusIsProtected *bool) {
	o.ProtectionStatusIsProtected = protectionStatusIsProtected
}

// WithQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) *BucketsCollectionGetParams {
	o.SetQosPolicyMaxThroughput(qosPolicyMaxThroughput)
	return o
}

// SetQosPolicyMaxThroughput adds the qosPolicyMaxThroughput to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMaxThroughput(qosPolicyMaxThroughput *string) {
	o.QosPolicyMaxThroughput = qosPolicyMaxThroughput
}

// WithQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) *BucketsCollectionGetParams {
	o.SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops)
	return o
}

// SetQosPolicyMaxThroughputIops adds the qosPolicyMaxThroughputIops to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMaxThroughputIops(qosPolicyMaxThroughputIops *int64) {
	o.QosPolicyMaxThroughputIops = qosPolicyMaxThroughputIops
}

// WithQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) *BucketsCollectionGetParams {
	o.SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps)
	return o
}

// SetQosPolicyMaxThroughputMbps adds the qosPolicyMaxThroughputMbps to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMaxThroughputMbps(qosPolicyMaxThroughputMbps *int64) {
	o.QosPolicyMaxThroughputMbps = qosPolicyMaxThroughputMbps
}

// WithQosPolicyMinThroughput adds the qosPolicyMinThroughput to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMinThroughput(qosPolicyMinThroughput *string) *BucketsCollectionGetParams {
	o.SetQosPolicyMinThroughput(qosPolicyMinThroughput)
	return o
}

// SetQosPolicyMinThroughput adds the qosPolicyMinThroughput to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMinThroughput(qosPolicyMinThroughput *string) {
	o.QosPolicyMinThroughput = qosPolicyMinThroughput
}

// WithQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) *BucketsCollectionGetParams {
	o.SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops)
	return o
}

// SetQosPolicyMinThroughputIops adds the qosPolicyMinThroughputIops to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMinThroughputIops(qosPolicyMinThroughputIops *int64) {
	o.QosPolicyMinThroughputIops = qosPolicyMinThroughputIops
}

// WithQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) *BucketsCollectionGetParams {
	o.SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps)
	return o
}

// SetQosPolicyMinThroughputMbps adds the qosPolicyMinThroughputMbps to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyMinThroughputMbps(qosPolicyMinThroughputMbps *int64) {
	o.QosPolicyMinThroughputMbps = qosPolicyMinThroughputMbps
}

// WithQosPolicyName adds the qosPolicyName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyName(qosPolicyName *string) *BucketsCollectionGetParams {
	o.SetQosPolicyName(qosPolicyName)
	return o
}

// SetQosPolicyName adds the qosPolicyName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyName(qosPolicyName *string) {
	o.QosPolicyName = qosPolicyName
}

// WithQosPolicyUUID adds the qosPolicyUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithQosPolicyUUID(qosPolicyUUID *string) *BucketsCollectionGetParams {
	o.SetQosPolicyUUID(qosPolicyUUID)
	return o
}

// SetQosPolicyUUID adds the qosPolicyUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetQosPolicyUUID(qosPolicyUUID *string) {
	o.QosPolicyUUID = qosPolicyUUID
}

// WithRetentionDefaultPeriod adds the retentionDefaultPeriod to the buckets collection get params
func (o *BucketsCollectionGetParams) WithRetentionDefaultPeriod(retentionDefaultPeriod *string) *BucketsCollectionGetParams {
	o.SetRetentionDefaultPeriod(retentionDefaultPeriod)
	return o
}

// SetRetentionDefaultPeriod adds the retentionDefaultPeriod to the buckets collection get params
func (o *BucketsCollectionGetParams) SetRetentionDefaultPeriod(retentionDefaultPeriod *string) {
	o.RetentionDefaultPeriod = retentionDefaultPeriod
}

// WithRetentionMode adds the retentionMode to the buckets collection get params
func (o *BucketsCollectionGetParams) WithRetentionMode(retentionMode *string) *BucketsCollectionGetParams {
	o.SetRetentionMode(retentionMode)
	return o
}

// SetRetentionMode adds the retentionMode to the buckets collection get params
func (o *BucketsCollectionGetParams) SetRetentionMode(retentionMode *string) {
	o.RetentionMode = retentionMode
}

// WithReturnRecords adds the returnRecords to the buckets collection get params
func (o *BucketsCollectionGetParams) WithReturnRecords(returnRecords *bool) *BucketsCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the buckets collection get params
func (o *BucketsCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the buckets collection get params
func (o *BucketsCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *BucketsCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the buckets collection get params
func (o *BucketsCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithRole adds the role to the buckets collection get params
func (o *BucketsCollectionGetParams) WithRole(role *string) *BucketsCollectionGetParams {
	o.SetRole(role)
	return o
}

// SetRole adds the role to the buckets collection get params
func (o *BucketsCollectionGetParams) SetRole(role *string) {
	o.Role = role
}

// WithSize adds the size to the buckets collection get params
func (o *BucketsCollectionGetParams) WithSize(size *int64) *BucketsCollectionGetParams {
	o.SetSize(size)
	return o
}

// SetSize adds the size to the buckets collection get params
func (o *BucketsCollectionGetParams) SetSize(size *int64) {
	o.Size = size
}

// WithSnapshotPolicyName adds the snapshotPolicyName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithSnapshotPolicyName(snapshotPolicyName *string) *BucketsCollectionGetParams {
	o.SetSnapshotPolicyName(snapshotPolicyName)
	return o
}

// SetSnapshotPolicyName adds the snapshotPolicyName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetSnapshotPolicyName(snapshotPolicyName *string) {
	o.SnapshotPolicyName = snapshotPolicyName
}

// WithSnapshotPolicyUUID adds the snapshotPolicyUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithSnapshotPolicyUUID(snapshotPolicyUUID *string) *BucketsCollectionGetParams {
	o.SetSnapshotPolicyUUID(snapshotPolicyUUID)
	return o
}

// SetSnapshotPolicyUUID adds the snapshotPolicyUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetSnapshotPolicyUUID(snapshotPolicyUUID *string) {
	o.SnapshotPolicyUUID = snapshotPolicyUUID
}

// WithSvmName adds the svmName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithSvmName(svmName *string) *BucketsCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithSvmUUID(svmUUID string) *BucketsCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithType adds the typeVar to the buckets collection get params
func (o *BucketsCollectionGetParams) WithType(typeVar *string) *BucketsCollectionGetParams {
	o.SetType(typeVar)
	return o
}

// SetType adds the type to the buckets collection get params
func (o *BucketsCollectionGetParams) SetType(typeVar *string) {
	o.Type = typeVar
}

// WithUUID adds the uuid to the buckets collection get params
func (o *BucketsCollectionGetParams) WithUUID(uuid *string) *BucketsCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WithVersioningState adds the versioningState to the buckets collection get params
func (o *BucketsCollectionGetParams) WithVersioningState(versioningState *string) *BucketsCollectionGetParams {
	o.SetVersioningState(versioningState)
	return o
}

// SetVersioningState adds the versioningState to the buckets collection get params
func (o *BucketsCollectionGetParams) SetVersioningState(versioningState *string) {
	o.VersioningState = versioningState
}

// WithVolumeName adds the volumeName to the buckets collection get params
func (o *BucketsCollectionGetParams) WithVolumeName(volumeName *string) *BucketsCollectionGetParams {
	o.SetVolumeName(volumeName)
	return o
}

// SetVolumeName adds the volumeName to the buckets collection get params
func (o *BucketsCollectionGetParams) SetVolumeName(volumeName *string) {
	o.VolumeName = volumeName
}

// WithVolumeUUID adds the volumeUUID to the buckets collection get params
func (o *BucketsCollectionGetParams) WithVolumeUUID(volumeUUID *string) *BucketsCollectionGetParams {
	o.SetVolumeUUID(volumeUUID)
	return o
}

// SetVolumeUUID adds the volumeUuid to the buckets collection get params
func (o *BucketsCollectionGetParams) SetVolumeUUID(volumeUUID *string) {
	o.VolumeUUID = volumeUUID
}

// WriteToRequest writes these params to a swagger request
func (o *BucketsCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AuditEventSelectorAccess != nil {

		// query param audit_event_selector.access
		var qrAuditEventSelectorAccess string

		if o.AuditEventSelectorAccess != nil {
			qrAuditEventSelectorAccess = *o.AuditEventSelectorAccess
		}
		qAuditEventSelectorAccess := qrAuditEventSelectorAccess
		if qAuditEventSelectorAccess != "" {

			if err := r.SetQueryParam("audit_event_selector.access", qAuditEventSelectorAccess); err != nil {
				return err
			}
		}
	}

	if o.AuditEventSelectorPermission != nil {

		// query param audit_event_selector.permission
		var qrAuditEventSelectorPermission string

		if o.AuditEventSelectorPermission != nil {
			qrAuditEventSelectorPermission = *o.AuditEventSelectorPermission
		}
		qAuditEventSelectorPermission := qrAuditEventSelectorPermission
		if qAuditEventSelectorPermission != "" {

			if err := r.SetQueryParam("audit_event_selector.permission", qAuditEventSelectorPermission); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesAllowedHeaders != nil {

		// query param cors.rules.allowed_headers
		var qrCorsRulesAllowedHeaders string

		if o.CorsRulesAllowedHeaders != nil {
			qrCorsRulesAllowedHeaders = *o.CorsRulesAllowedHeaders
		}
		qCorsRulesAllowedHeaders := qrCorsRulesAllowedHeaders
		if qCorsRulesAllowedHeaders != "" {

			if err := r.SetQueryParam("cors.rules.allowed_headers", qCorsRulesAllowedHeaders); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesAllowedMethods != nil {

		// query param cors.rules.allowed_methods
		var qrCorsRulesAllowedMethods string

		if o.CorsRulesAllowedMethods != nil {
			qrCorsRulesAllowedMethods = *o.CorsRulesAllowedMethods
		}
		qCorsRulesAllowedMethods := qrCorsRulesAllowedMethods
		if qCorsRulesAllowedMethods != "" {

			if err := r.SetQueryParam("cors.rules.allowed_methods", qCorsRulesAllowedMethods); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesAllowedOrigins != nil {

		// query param cors.rules.allowed_origins
		var qrCorsRulesAllowedOrigins string

		if o.CorsRulesAllowedOrigins != nil {
			qrCorsRulesAllowedOrigins = *o.CorsRulesAllowedOrigins
		}
		qCorsRulesAllowedOrigins := qrCorsRulesAllowedOrigins
		if qCorsRulesAllowedOrigins != "" {

			if err := r.SetQueryParam("cors.rules.allowed_origins", qCorsRulesAllowedOrigins); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesExposeHeaders != nil {

		// query param cors.rules.expose_headers
		var qrCorsRulesExposeHeaders string

		if o.CorsRulesExposeHeaders != nil {
			qrCorsRulesExposeHeaders = *o.CorsRulesExposeHeaders
		}
		qCorsRulesExposeHeaders := qrCorsRulesExposeHeaders
		if qCorsRulesExposeHeaders != "" {

			if err := r.SetQueryParam("cors.rules.expose_headers", qCorsRulesExposeHeaders); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesID != nil {

		// query param cors.rules.id
		var qrCorsRulesID string

		if o.CorsRulesID != nil {
			qrCorsRulesID = *o.CorsRulesID
		}
		qCorsRulesID := qrCorsRulesID
		if qCorsRulesID != "" {

			if err := r.SetQueryParam("cors.rules.id", qCorsRulesID); err != nil {
				return err
			}
		}
	}

	if o.CorsRulesMaxAgeSeconds != nil {

		// query param cors.rules.max_age_seconds
		var qrCorsRulesMaxAgeSeconds int64

		if o.CorsRulesMaxAgeSeconds != nil {
			qrCorsRulesMaxAgeSeconds = *o.CorsRulesMaxAgeSeconds
		}
		qCorsRulesMaxAgeSeconds := swag.FormatInt64(qrCorsRulesMaxAgeSeconds)
		if qCorsRulesMaxAgeSeconds != "" {

			if err := r.SetQueryParam("cors.rules.max_age_seconds", qCorsRulesMaxAgeSeconds); err != nil {
				return err
			}
		}
	}

	if o.EncryptionEnabled != nil {

		// query param encryption.enabled
		var qrEncryptionEnabled bool

		if o.EncryptionEnabled != nil {
			qrEncryptionEnabled = *o.EncryptionEnabled
		}
		qEncryptionEnabled := swag.FormatBool(qrEncryptionEnabled)
		if qEncryptionEnabled != "" {

			if err := r.SetQueryParam("encryption.enabled", qEncryptionEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsConsistentEtag != nil {

		// query param is_consistent_etag
		var qrIsConsistentEtag bool

		if o.IsConsistentEtag != nil {
			qrIsConsistentEtag = *o.IsConsistentEtag
		}
		qIsConsistentEtag := swag.FormatBool(qrIsConsistentEtag)
		if qIsConsistentEtag != "" {

			if err := r.SetQueryParam("is_consistent_etag", qIsConsistentEtag); err != nil {
				return err
			}
		}
	}

	if o.IsNasPathMutable != nil {

		// query param is_nas_path_mutable
		var qrIsNasPathMutable bool

		if o.IsNasPathMutable != nil {
			qrIsNasPathMutable = *o.IsNasPathMutable
		}
		qIsNasPathMutable := swag.FormatBool(qrIsNasPathMutable)
		if qIsNasPathMutable != "" {

			if err := r.SetQueryParam("is_nas_path_mutable", qIsNasPathMutable); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != nil {

		// query param lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days
		var qrLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays int64

		if o.LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != nil {
			qrLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays = *o.LifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays
		}
		qLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays := swag.FormatInt64(qrLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays)
		if qLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days", qLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesBucketName != nil {

		// query param lifecycle_management.rules.bucket_name
		var qrLifecycleManagementRulesBucketName string

		if o.LifecycleManagementRulesBucketName != nil {
			qrLifecycleManagementRulesBucketName = *o.LifecycleManagementRulesBucketName
		}
		qLifecycleManagementRulesBucketName := qrLifecycleManagementRulesBucketName
		if qLifecycleManagementRulesBucketName != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.bucket_name", qLifecycleManagementRulesBucketName); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesEnabled != nil {

		// query param lifecycle_management.rules.enabled
		var qrLifecycleManagementRulesEnabled bool

		if o.LifecycleManagementRulesEnabled != nil {
			qrLifecycleManagementRulesEnabled = *o.LifecycleManagementRulesEnabled
		}
		qLifecycleManagementRulesEnabled := swag.FormatBool(qrLifecycleManagementRulesEnabled)
		if qLifecycleManagementRulesEnabled != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.enabled", qLifecycleManagementRulesEnabled); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesExpirationExpiredObjectDeleteMarker != nil {

		// query param lifecycle_management.rules.expiration.expired_object_delete_marker
		var qrLifecycleManagementRulesExpirationExpiredObjectDeleteMarker bool

		if o.LifecycleManagementRulesExpirationExpiredObjectDeleteMarker != nil {
			qrLifecycleManagementRulesExpirationExpiredObjectDeleteMarker = *o.LifecycleManagementRulesExpirationExpiredObjectDeleteMarker
		}
		qLifecycleManagementRulesExpirationExpiredObjectDeleteMarker := swag.FormatBool(qrLifecycleManagementRulesExpirationExpiredObjectDeleteMarker)
		if qLifecycleManagementRulesExpirationExpiredObjectDeleteMarker != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.expiration.expired_object_delete_marker", qLifecycleManagementRulesExpirationExpiredObjectDeleteMarker); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesExpirationObjectAgeDays != nil {

		// query param lifecycle_management.rules.expiration.object_age_days
		var qrLifecycleManagementRulesExpirationObjectAgeDays int64

		if o.LifecycleManagementRulesExpirationObjectAgeDays != nil {
			qrLifecycleManagementRulesExpirationObjectAgeDays = *o.LifecycleManagementRulesExpirationObjectAgeDays
		}
		qLifecycleManagementRulesExpirationObjectAgeDays := swag.FormatInt64(qrLifecycleManagementRulesExpirationObjectAgeDays)
		if qLifecycleManagementRulesExpirationObjectAgeDays != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.expiration.object_age_days", qLifecycleManagementRulesExpirationObjectAgeDays); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesExpirationObjectExpiryDate != nil {

		// query param lifecycle_management.rules.expiration.object_expiry_date
		var qrLifecycleManagementRulesExpirationObjectExpiryDate string

		if o.LifecycleManagementRulesExpirationObjectExpiryDate != nil {
			qrLifecycleManagementRulesExpirationObjectExpiryDate = *o.LifecycleManagementRulesExpirationObjectExpiryDate
		}
		qLifecycleManagementRulesExpirationObjectExpiryDate := qrLifecycleManagementRulesExpirationObjectExpiryDate
		if qLifecycleManagementRulesExpirationObjectExpiryDate != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.expiration.object_expiry_date", qLifecycleManagementRulesExpirationObjectExpiryDate); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesName != nil {

		// query param lifecycle_management.rules.name
		var qrLifecycleManagementRulesName string

		if o.LifecycleManagementRulesName != nil {
			qrLifecycleManagementRulesName = *o.LifecycleManagementRulesName
		}
		qLifecycleManagementRulesName := qrLifecycleManagementRulesName
		if qLifecycleManagementRulesName != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.name", qLifecycleManagementRulesName); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != nil {

		// query param lifecycle_management.rules.non_current_version_expiration.new_non_current_versions
		var qrLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions int64

		if o.LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != nil {
			qrLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions = *o.LifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions
		}
		qLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions := swag.FormatInt64(qrLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions)
		if qLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.non_current_version_expiration.new_non_current_versions", qLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != nil {

		// query param lifecycle_management.rules.non_current_version_expiration.non_current_days
		var qrLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays int64

		if o.LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != nil {
			qrLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays = *o.LifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays
		}
		qLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays := swag.FormatInt64(qrLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays)
		if qLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.non_current_version_expiration.non_current_days", qLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesObjectFilterPrefix != nil {

		// query param lifecycle_management.rules.object_filter.prefix
		var qrLifecycleManagementRulesObjectFilterPrefix string

		if o.LifecycleManagementRulesObjectFilterPrefix != nil {
			qrLifecycleManagementRulesObjectFilterPrefix = *o.LifecycleManagementRulesObjectFilterPrefix
		}
		qLifecycleManagementRulesObjectFilterPrefix := qrLifecycleManagementRulesObjectFilterPrefix
		if qLifecycleManagementRulesObjectFilterPrefix != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.object_filter.prefix", qLifecycleManagementRulesObjectFilterPrefix); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesObjectFilterSizeGreaterThan != nil {

		// query param lifecycle_management.rules.object_filter.size_greater_than
		var qrLifecycleManagementRulesObjectFilterSizeGreaterThan int64

		if o.LifecycleManagementRulesObjectFilterSizeGreaterThan != nil {
			qrLifecycleManagementRulesObjectFilterSizeGreaterThan = *o.LifecycleManagementRulesObjectFilterSizeGreaterThan
		}
		qLifecycleManagementRulesObjectFilterSizeGreaterThan := swag.FormatInt64(qrLifecycleManagementRulesObjectFilterSizeGreaterThan)
		if qLifecycleManagementRulesObjectFilterSizeGreaterThan != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.object_filter.size_greater_than", qLifecycleManagementRulesObjectFilterSizeGreaterThan); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesObjectFilterSizeLessThan != nil {

		// query param lifecycle_management.rules.object_filter.size_less_than
		var qrLifecycleManagementRulesObjectFilterSizeLessThan int64

		if o.LifecycleManagementRulesObjectFilterSizeLessThan != nil {
			qrLifecycleManagementRulesObjectFilterSizeLessThan = *o.LifecycleManagementRulesObjectFilterSizeLessThan
		}
		qLifecycleManagementRulesObjectFilterSizeLessThan := swag.FormatInt64(qrLifecycleManagementRulesObjectFilterSizeLessThan)
		if qLifecycleManagementRulesObjectFilterSizeLessThan != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.object_filter.size_less_than", qLifecycleManagementRulesObjectFilterSizeLessThan); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesObjectFilterTags != nil {

		// query param lifecycle_management.rules.object_filter.tags
		var qrLifecycleManagementRulesObjectFilterTags string

		if o.LifecycleManagementRulesObjectFilterTags != nil {
			qrLifecycleManagementRulesObjectFilterTags = *o.LifecycleManagementRulesObjectFilterTags
		}
		qLifecycleManagementRulesObjectFilterTags := qrLifecycleManagementRulesObjectFilterTags
		if qLifecycleManagementRulesObjectFilterTags != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.object_filter.tags", qLifecycleManagementRulesObjectFilterTags); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesSvmName != nil {

		// query param lifecycle_management.rules.svm.name
		var qrLifecycleManagementRulesSvmName string

		if o.LifecycleManagementRulesSvmName != nil {
			qrLifecycleManagementRulesSvmName = *o.LifecycleManagementRulesSvmName
		}
		qLifecycleManagementRulesSvmName := qrLifecycleManagementRulesSvmName
		if qLifecycleManagementRulesSvmName != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.svm.name", qLifecycleManagementRulesSvmName); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesSvmUUID != nil {

		// query param lifecycle_management.rules.svm.uuid
		var qrLifecycleManagementRulesSvmUUID string

		if o.LifecycleManagementRulesSvmUUID != nil {
			qrLifecycleManagementRulesSvmUUID = *o.LifecycleManagementRulesSvmUUID
		}
		qLifecycleManagementRulesSvmUUID := qrLifecycleManagementRulesSvmUUID
		if qLifecycleManagementRulesSvmUUID != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.svm.uuid", qLifecycleManagementRulesSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.LifecycleManagementRulesUUID != nil {

		// query param lifecycle_management.rules.uuid
		var qrLifecycleManagementRulesUUID string

		if o.LifecycleManagementRulesUUID != nil {
			qrLifecycleManagementRulesUUID = *o.LifecycleManagementRulesUUID
		}
		qLifecycleManagementRulesUUID := qrLifecycleManagementRulesUUID
		if qLifecycleManagementRulesUUID != "" {

			if err := r.SetQueryParam("lifecycle_management.rules.uuid", qLifecycleManagementRulesUUID); err != nil {
				return err
			}
		}
	}

	if o.LogicalUsedSize != nil {

		// query param logical_used_size
		var qrLogicalUsedSize int64

		if o.LogicalUsedSize != nil {
			qrLogicalUsedSize = *o.LogicalUsedSize
		}
		qLogicalUsedSize := swag.FormatInt64(qrLogicalUsedSize)
		if qLogicalUsedSize != "" {

			if err := r.SetQueryParam("logical_used_size", qLogicalUsedSize); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NasPath != nil {

		// query param nas_path
		var qrNasPath string

		if o.NasPath != nil {
			qrNasPath = *o.NasPath
		}
		qNasPath := qrNasPath
		if qNasPath != "" {

			if err := r.SetQueryParam("nas_path", qNasPath); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PolicyStatementsActions != nil {

		// query param policy.statements.actions
		var qrPolicyStatementsActions string

		if o.PolicyStatementsActions != nil {
			qrPolicyStatementsActions = *o.PolicyStatementsActions
		}
		qPolicyStatementsActions := qrPolicyStatementsActions
		if qPolicyStatementsActions != "" {

			if err := r.SetQueryParam("policy.statements.actions", qPolicyStatementsActions); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsDelimiters != nil {

		// query param policy.statements.conditions.delimiters
		var qrPolicyStatementsConditionsDelimiters string

		if o.PolicyStatementsConditionsDelimiters != nil {
			qrPolicyStatementsConditionsDelimiters = *o.PolicyStatementsConditionsDelimiters
		}
		qPolicyStatementsConditionsDelimiters := qrPolicyStatementsConditionsDelimiters
		if qPolicyStatementsConditionsDelimiters != "" {

			if err := r.SetQueryParam("policy.statements.conditions.delimiters", qPolicyStatementsConditionsDelimiters); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsMaxKeys != nil {

		// query param policy.statements.conditions.max_keys
		var qrPolicyStatementsConditionsMaxKeys int64

		if o.PolicyStatementsConditionsMaxKeys != nil {
			qrPolicyStatementsConditionsMaxKeys = *o.PolicyStatementsConditionsMaxKeys
		}
		qPolicyStatementsConditionsMaxKeys := swag.FormatInt64(qrPolicyStatementsConditionsMaxKeys)
		if qPolicyStatementsConditionsMaxKeys != "" {

			if err := r.SetQueryParam("policy.statements.conditions.max_keys", qPolicyStatementsConditionsMaxKeys); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsOperator != nil {

		// query param policy.statements.conditions.operator
		var qrPolicyStatementsConditionsOperator string

		if o.PolicyStatementsConditionsOperator != nil {
			qrPolicyStatementsConditionsOperator = *o.PolicyStatementsConditionsOperator
		}
		qPolicyStatementsConditionsOperator := qrPolicyStatementsConditionsOperator
		if qPolicyStatementsConditionsOperator != "" {

			if err := r.SetQueryParam("policy.statements.conditions.operator", qPolicyStatementsConditionsOperator); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsPrefixes != nil {

		// query param policy.statements.conditions.prefixes
		var qrPolicyStatementsConditionsPrefixes string

		if o.PolicyStatementsConditionsPrefixes != nil {
			qrPolicyStatementsConditionsPrefixes = *o.PolicyStatementsConditionsPrefixes
		}
		qPolicyStatementsConditionsPrefixes := qrPolicyStatementsConditionsPrefixes
		if qPolicyStatementsConditionsPrefixes != "" {

			if err := r.SetQueryParam("policy.statements.conditions.prefixes", qPolicyStatementsConditionsPrefixes); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsSourceIps != nil {

		// query param policy.statements.conditions.source_ips
		var qrPolicyStatementsConditionsSourceIps string

		if o.PolicyStatementsConditionsSourceIps != nil {
			qrPolicyStatementsConditionsSourceIps = *o.PolicyStatementsConditionsSourceIps
		}
		qPolicyStatementsConditionsSourceIps := qrPolicyStatementsConditionsSourceIps
		if qPolicyStatementsConditionsSourceIps != "" {

			if err := r.SetQueryParam("policy.statements.conditions.source_ips", qPolicyStatementsConditionsSourceIps); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsConditionsUsernames != nil {

		// query param policy.statements.conditions.usernames
		var qrPolicyStatementsConditionsUsernames string

		if o.PolicyStatementsConditionsUsernames != nil {
			qrPolicyStatementsConditionsUsernames = *o.PolicyStatementsConditionsUsernames
		}
		qPolicyStatementsConditionsUsernames := qrPolicyStatementsConditionsUsernames
		if qPolicyStatementsConditionsUsernames != "" {

			if err := r.SetQueryParam("policy.statements.conditions.usernames", qPolicyStatementsConditionsUsernames); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsEffect != nil {

		// query param policy.statements.effect
		var qrPolicyStatementsEffect string

		if o.PolicyStatementsEffect != nil {
			qrPolicyStatementsEffect = *o.PolicyStatementsEffect
		}
		qPolicyStatementsEffect := qrPolicyStatementsEffect
		if qPolicyStatementsEffect != "" {

			if err := r.SetQueryParam("policy.statements.effect", qPolicyStatementsEffect); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsPrincipals != nil {

		// query param policy.statements.principals
		var qrPolicyStatementsPrincipals string

		if o.PolicyStatementsPrincipals != nil {
			qrPolicyStatementsPrincipals = *o.PolicyStatementsPrincipals
		}
		qPolicyStatementsPrincipals := qrPolicyStatementsPrincipals
		if qPolicyStatementsPrincipals != "" {

			if err := r.SetQueryParam("policy.statements.principals", qPolicyStatementsPrincipals); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsResources != nil {

		// query param policy.statements.resources
		var qrPolicyStatementsResources string

		if o.PolicyStatementsResources != nil {
			qrPolicyStatementsResources = *o.PolicyStatementsResources
		}
		qPolicyStatementsResources := qrPolicyStatementsResources
		if qPolicyStatementsResources != "" {

			if err := r.SetQueryParam("policy.statements.resources", qPolicyStatementsResources); err != nil {
				return err
			}
		}
	}

	if o.PolicyStatementsSid != nil {

		// query param policy.statements.sid
		var qrPolicyStatementsSid string

		if o.PolicyStatementsSid != nil {
			qrPolicyStatementsSid = *o.PolicyStatementsSid
		}
		qPolicyStatementsSid := qrPolicyStatementsSid
		if qPolicyStatementsSid != "" {

			if err := r.SetQueryParam("policy.statements.sid", qPolicyStatementsSid); err != nil {
				return err
			}
		}
	}

	if o.ProtectionStatusDestinationIsCloud != nil {

		// query param protection_status.destination.is_cloud
		var qrProtectionStatusDestinationIsCloud bool

		if o.ProtectionStatusDestinationIsCloud != nil {
			qrProtectionStatusDestinationIsCloud = *o.ProtectionStatusDestinationIsCloud
		}
		qProtectionStatusDestinationIsCloud := swag.FormatBool(qrProtectionStatusDestinationIsCloud)
		if qProtectionStatusDestinationIsCloud != "" {

			if err := r.SetQueryParam("protection_status.destination.is_cloud", qProtectionStatusDestinationIsCloud); err != nil {
				return err
			}
		}
	}

	if o.ProtectionStatusDestinationIsExternalCloud != nil {

		// query param protection_status.destination.is_external_cloud
		var qrProtectionStatusDestinationIsExternalCloud bool

		if o.ProtectionStatusDestinationIsExternalCloud != nil {
			qrProtectionStatusDestinationIsExternalCloud = *o.ProtectionStatusDestinationIsExternalCloud
		}
		qProtectionStatusDestinationIsExternalCloud := swag.FormatBool(qrProtectionStatusDestinationIsExternalCloud)
		if qProtectionStatusDestinationIsExternalCloud != "" {

			if err := r.SetQueryParam("protection_status.destination.is_external_cloud", qProtectionStatusDestinationIsExternalCloud); err != nil {
				return err
			}
		}
	}

	if o.ProtectionStatusDestinationIsOntap != nil {

		// query param protection_status.destination.is_ontap
		var qrProtectionStatusDestinationIsOntap bool

		if o.ProtectionStatusDestinationIsOntap != nil {
			qrProtectionStatusDestinationIsOntap = *o.ProtectionStatusDestinationIsOntap
		}
		qProtectionStatusDestinationIsOntap := swag.FormatBool(qrProtectionStatusDestinationIsOntap)
		if qProtectionStatusDestinationIsOntap != "" {

			if err := r.SetQueryParam("protection_status.destination.is_ontap", qProtectionStatusDestinationIsOntap); err != nil {
				return err
			}
		}
	}

	if o.ProtectionStatusIsProtected != nil {

		// query param protection_status.is_protected
		var qrProtectionStatusIsProtected bool

		if o.ProtectionStatusIsProtected != nil {
			qrProtectionStatusIsProtected = *o.ProtectionStatusIsProtected
		}
		qProtectionStatusIsProtected := swag.FormatBool(qrProtectionStatusIsProtected)
		if qProtectionStatusIsProtected != "" {

			if err := r.SetQueryParam("protection_status.is_protected", qProtectionStatusIsProtected); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughput != nil {

		// query param qos_policy.max_throughput
		var qrQosPolicyMaxThroughput string

		if o.QosPolicyMaxThroughput != nil {
			qrQosPolicyMaxThroughput = *o.QosPolicyMaxThroughput
		}
		qQosPolicyMaxThroughput := qrQosPolicyMaxThroughput
		if qQosPolicyMaxThroughput != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput", qQosPolicyMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputIops != nil {

		// query param qos_policy.max_throughput_iops
		var qrQosPolicyMaxThroughputIops int64

		if o.QosPolicyMaxThroughputIops != nil {
			qrQosPolicyMaxThroughputIops = *o.QosPolicyMaxThroughputIops
		}
		qQosPolicyMaxThroughputIops := swag.FormatInt64(qrQosPolicyMaxThroughputIops)
		if qQosPolicyMaxThroughputIops != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput_iops", qQosPolicyMaxThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMaxThroughputMbps != nil {

		// query param qos_policy.max_throughput_mbps
		var qrQosPolicyMaxThroughputMbps int64

		if o.QosPolicyMaxThroughputMbps != nil {
			qrQosPolicyMaxThroughputMbps = *o.QosPolicyMaxThroughputMbps
		}
		qQosPolicyMaxThroughputMbps := swag.FormatInt64(qrQosPolicyMaxThroughputMbps)
		if qQosPolicyMaxThroughputMbps != "" {

			if err := r.SetQueryParam("qos_policy.max_throughput_mbps", qQosPolicyMaxThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughput != nil {

		// query param qos_policy.min_throughput
		var qrQosPolicyMinThroughput string

		if o.QosPolicyMinThroughput != nil {
			qrQosPolicyMinThroughput = *o.QosPolicyMinThroughput
		}
		qQosPolicyMinThroughput := qrQosPolicyMinThroughput
		if qQosPolicyMinThroughput != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput", qQosPolicyMinThroughput); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputIops != nil {

		// query param qos_policy.min_throughput_iops
		var qrQosPolicyMinThroughputIops int64

		if o.QosPolicyMinThroughputIops != nil {
			qrQosPolicyMinThroughputIops = *o.QosPolicyMinThroughputIops
		}
		qQosPolicyMinThroughputIops := swag.FormatInt64(qrQosPolicyMinThroughputIops)
		if qQosPolicyMinThroughputIops != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput_iops", qQosPolicyMinThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyMinThroughputMbps != nil {

		// query param qos_policy.min_throughput_mbps
		var qrQosPolicyMinThroughputMbps int64

		if o.QosPolicyMinThroughputMbps != nil {
			qrQosPolicyMinThroughputMbps = *o.QosPolicyMinThroughputMbps
		}
		qQosPolicyMinThroughputMbps := swag.FormatInt64(qrQosPolicyMinThroughputMbps)
		if qQosPolicyMinThroughputMbps != "" {

			if err := r.SetQueryParam("qos_policy.min_throughput_mbps", qQosPolicyMinThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyName != nil {

		// query param qos_policy.name
		var qrQosPolicyName string

		if o.QosPolicyName != nil {
			qrQosPolicyName = *o.QosPolicyName
		}
		qQosPolicyName := qrQosPolicyName
		if qQosPolicyName != "" {

			if err := r.SetQueryParam("qos_policy.name", qQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.QosPolicyUUID != nil {

		// query param qos_policy.uuid
		var qrQosPolicyUUID string

		if o.QosPolicyUUID != nil {
			qrQosPolicyUUID = *o.QosPolicyUUID
		}
		qQosPolicyUUID := qrQosPolicyUUID
		if qQosPolicyUUID != "" {

			if err := r.SetQueryParam("qos_policy.uuid", qQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.RetentionDefaultPeriod != nil {

		// query param retention.default_period
		var qrRetentionDefaultPeriod string

		if o.RetentionDefaultPeriod != nil {
			qrRetentionDefaultPeriod = *o.RetentionDefaultPeriod
		}
		qRetentionDefaultPeriod := qrRetentionDefaultPeriod
		if qRetentionDefaultPeriod != "" {

			if err := r.SetQueryParam("retention.default_period", qRetentionDefaultPeriod); err != nil {
				return err
			}
		}
	}

	if o.RetentionMode != nil {

		// query param retention.mode
		var qrRetentionMode string

		if o.RetentionMode != nil {
			qrRetentionMode = *o.RetentionMode
		}
		qRetentionMode := qrRetentionMode
		if qRetentionMode != "" {

			if err := r.SetQueryParam("retention.mode", qRetentionMode); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.Role != nil {

		// query param role
		var qrRole string

		if o.Role != nil {
			qrRole = *o.Role
		}
		qRole := qrRole
		if qRole != "" {

			if err := r.SetQueryParam("role", qRole); err != nil {
				return err
			}
		}
	}

	if o.Size != nil {

		// query param size
		var qrSize int64

		if o.Size != nil {
			qrSize = *o.Size
		}
		qSize := swag.FormatInt64(qrSize)
		if qSize != "" {

			if err := r.SetQueryParam("size", qSize); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyName != nil {

		// query param snapshot_policy.name
		var qrSnapshotPolicyName string

		if o.SnapshotPolicyName != nil {
			qrSnapshotPolicyName = *o.SnapshotPolicyName
		}
		qSnapshotPolicyName := qrSnapshotPolicyName
		if qSnapshotPolicyName != "" {

			if err := r.SetQueryParam("snapshot_policy.name", qSnapshotPolicyName); err != nil {
				return err
			}
		}
	}

	if o.SnapshotPolicyUUID != nil {

		// query param snapshot_policy.uuid
		var qrSnapshotPolicyUUID string

		if o.SnapshotPolicyUUID != nil {
			qrSnapshotPolicyUUID = *o.SnapshotPolicyUUID
		}
		qSnapshotPolicyUUID := qrSnapshotPolicyUUID
		if qSnapshotPolicyUUID != "" {

			if err := r.SetQueryParam("snapshot_policy.uuid", qSnapshotPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.Type != nil {

		// query param type
		var qrType string

		if o.Type != nil {
			qrType = *o.Type
		}
		qType := qrType
		if qType != "" {

			if err := r.SetQueryParam("type", qType); err != nil {
				return err
			}
		}
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if o.VersioningState != nil {

		// query param versioning_state
		var qrVersioningState string

		if o.VersioningState != nil {
			qrVersioningState = *o.VersioningState
		}
		qVersioningState := qrVersioningState
		if qVersioningState != "" {

			if err := r.SetQueryParam("versioning_state", qVersioningState); err != nil {
				return err
			}
		}
	}

	if o.VolumeName != nil {

		// query param volume.name
		var qrVolumeName string

		if o.VolumeName != nil {
			qrVolumeName = *o.VolumeName
		}
		qVolumeName := qrVolumeName
		if qVolumeName != "" {

			if err := r.SetQueryParam("volume.name", qVolumeName); err != nil {
				return err
			}
		}
	}

	if o.VolumeUUID != nil {

		// query param volume.uuid
		var qrVolumeUUID string

		if o.VolumeUUID != nil {
			qrVolumeUUID = *o.VolumeUUID
		}
		qVolumeUUID := qrVolumeUUID
		if qVolumeUUID != "" {

			if err := r.SetQueryParam("volume.uuid", qVolumeUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamBucketsCollectionGet binds the parameter fields
func (o *BucketsCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamBucketsCollectionGet binds the parameter order_by
func (o *BucketsCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
