// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
)

// New creates a new object store API client.
func New(transport runtime.ClientTransport, formats strfmt.Registry) ClientService {
	return &Client{transport: transport, formats: formats}
}

/*
Client for object store API
*/
type Client struct {
	transport runtime.ClientTransport
	formats   strfmt.Registry
}

// ClientOption is the option for Client methods
type ClientOption func(*runtime.ClientOperation)

// ClientService is the interface for Client methods
type ClientService interface {
	AllSvmBucketsCollectionGet(params *AllSvmBucketsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AllSvmBucketsCollectionGetOK, error)

	BucketsCollectionGet(params *BucketsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BucketsCollectionGetOK, error)

	PerformanceS3MetricCollectionGet(params *PerformanceS3MetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceS3MetricCollectionGetOK, error)

	S3BucketCreate(params *S3BucketCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketCreateCreated, *S3BucketCreateAccepted, error)

	S3BucketDelete(params *S3BucketDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketDeleteOK, *S3BucketDeleteAccepted, error)

	S3BucketDeleteCollection(params *S3BucketDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketDeleteCollectionOK, *S3BucketDeleteCollectionAccepted, error)

	S3BucketGet(params *S3BucketGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketGetOK, error)

	S3BucketLifecycleRuleCollectionGet(params *S3BucketLifecycleRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleCollectionGetOK, error)

	S3BucketLifecycleRuleCreate(params *S3BucketLifecycleRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleCreateCreated, *S3BucketLifecycleRuleCreateAccepted, error)

	S3BucketLifecycleRuleDelete(params *S3BucketLifecycleRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleDeleteOK, error)

	S3BucketLifecycleRuleDeleteCollection(params *S3BucketLifecycleRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleDeleteCollectionOK, error)

	S3BucketLifecycleRuleGet(params *S3BucketLifecycleRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleGetOK, error)

	S3BucketLifecycleRuleModify(params *S3BucketLifecycleRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleModifyOK, *S3BucketLifecycleRuleModifyAccepted, error)

	S3BucketLifecycleRuleModifyCollection(params *S3BucketLifecycleRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleModifyCollectionOK, *S3BucketLifecycleRuleModifyCollectionAccepted, error)

	S3BucketModify(params *S3BucketModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketModifyOK, *S3BucketModifyAccepted, error)

	S3BucketModifyCollection(params *S3BucketModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketModifyCollectionOK, *S3BucketModifyCollectionAccepted, error)

	S3BucketSnapshotCollectionGet(params *S3BucketSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotCollectionGetOK, error)

	S3BucketSnapshotCreate(params *S3BucketSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotCreateCreated, *S3BucketSnapshotCreateAccepted, error)

	S3BucketSnapshotDelete(params *S3BucketSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotDeleteOK, error)

	S3BucketSnapshotDeleteCollection(params *S3BucketSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotDeleteCollectionOK, error)

	S3BucketSnapshotGet(params *S3BucketSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotGetOK, error)

	S3BucketSvmCreate(params *S3BucketSvmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmCreateCreated, *S3BucketSvmCreateAccepted, error)

	S3BucketSvmDelete(params *S3BucketSvmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmDeleteOK, *S3BucketSvmDeleteAccepted, error)

	S3BucketSvmDeleteCollection(params *S3BucketSvmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmDeleteCollectionOK, *S3BucketSvmDeleteCollectionAccepted, error)

	S3BucketSvmGet(params *S3BucketSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmGetOK, error)

	S3BucketSvmModify(params *S3BucketSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmModifyOK, *S3BucketSvmModifyAccepted, error)

	S3BucketSvmModifyCollection(params *S3BucketSvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmModifyCollectionOK, *S3BucketSvmModifyCollectionAccepted, error)

	S3GroupCollectionGet(params *S3GroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupCollectionGetOK, error)

	S3GroupCreate(params *S3GroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupCreateCreated, error)

	S3GroupDelete(params *S3GroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupDeleteOK, error)

	S3GroupDeleteCollection(params *S3GroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupDeleteCollectionOK, error)

	S3GroupGet(params *S3GroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupGetOK, error)

	S3GroupModify(params *S3GroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupModifyOK, error)

	S3GroupModifyCollection(params *S3GroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupModifyCollectionOK, error)

	S3PolicyCollectionGet(params *S3PolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyCollectionGetOK, error)

	S3PolicyCreate(params *S3PolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyCreateCreated, error)

	S3PolicyDelete(params *S3PolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyDeleteOK, error)

	S3PolicyDeleteCollection(params *S3PolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyDeleteCollectionOK, error)

	S3PolicyGet(params *S3PolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyGetOK, error)

	S3PolicyModify(params *S3PolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyModifyOK, error)

	S3PolicyModifyCollection(params *S3PolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyModifyCollectionOK, error)

	S3ServiceCollectionGet(params *S3ServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceCollectionGetOK, error)

	S3ServiceCreate(params *S3ServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceCreateCreated, error)

	S3ServiceDelete(params *S3ServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceDeleteOK, *S3ServiceDeleteAccepted, error)

	S3ServiceDeleteCollection(params *S3ServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceDeleteCollectionOK, *S3ServiceDeleteCollectionAccepted, error)

	S3ServiceGet(params *S3ServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceGetOK, error)

	S3ServiceModify(params *S3ServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceModifyOK, error)

	S3ServiceModifyCollection(params *S3ServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceModifyCollectionOK, error)

	S3UserCollectionGet(params *S3UserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserCollectionGetOK, error)

	S3UserCreate(params *S3UserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserCreateCreated, error)

	S3UserDelete(params *S3UserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserDeleteOK, error)

	S3UserDeleteCollection(params *S3UserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserDeleteCollectionOK, error)

	S3UserGet(params *S3UserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserGetOK, error)

	S3UserModify(params *S3UserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserModifyOK, error)

	S3UserModifyCollection(params *S3UserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserModifyCollectionOK, error)

	SetTransport(transport runtime.ClientTransport)
}

/*
	AllSvmBucketsCollectionGet Retrieves all S3 buckets for all SVMs. Note that in order to retrieve S3 bucket policy conditions, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket show`
* `vserver object-store-server bucket policy statement show`
* `vserver object-store-server bucket policy-statement-condition show`
* `vserver object-store-server bucket lifecycle-management-rule show`
* `vserver object-store-server bucket cors-rule show`
### Learn more
* [`DOC /protocols/s3/buckets`](#docs-object-store-protocols_s3_buckets)
*/
func (a *Client) AllSvmBucketsCollectionGet(params *AllSvmBucketsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*AllSvmBucketsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewAllSvmBucketsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "all_svm_buckets_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &AllSvmBucketsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*AllSvmBucketsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*AllSvmBucketsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	BucketsCollectionGet Retrieves the S3 bucket's configuration of an SVM. Note that in order to retrieve S3 bucket policy conditions, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket show`
* `vserver object-store-server bucket policy statement show`
* `vserver object-store-server bucket policy-statement-condition show`
* `vserver object-store-server bucket lifecycle-management-rule show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets)
*/
func (a *Client) BucketsCollectionGet(params *BucketsCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*BucketsCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewBucketsCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "buckets_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &BucketsCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*BucketsCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*BucketsCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
PerformanceS3MetricCollectionGet Retrieves historical performance metrics for the S3 protocol of an SVM.
*/
func (a *Client) PerformanceS3MetricCollectionGet(params *PerformanceS3MetricCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*PerformanceS3MetricCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewPerformanceS3MetricCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "performance_s3_metric_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/metrics",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &PerformanceS3MetricCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*PerformanceS3MetricCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*PerformanceS3MetricCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketCreate Creates the S3 bucket configuration of an SVM.

<personalities supports=unified,asar2>
### Important notes
- Each SVM can have one or more bucket configurations.
- Aggregate lists should be specified explicitly. If not specified, then the bucket is auto-provisioned as a FlexGroup volume.
- Constituents per aggregate specifies the number of components (or FlexVol volumes) per aggregate. Is specified only when an aggregate list is explicitly defined.
- An access policy can be created along with a bucket create. If creating an access policy fails, bucket configurations are saved and the access policy can be created using the PATCH endpoint.
- "qos_policy" can be specified if a bucket needs to be attached to a QoS group policy during creation time.
- "audit_event_selector" can be specified if a bucket needs to be specify access and permission type for auditing.
- A CORS configuration can be specified along with bucket creation.
</personalities>
<personalities supports=aiml>
### Important notes
- Each SVM can have one or more bucket configurations.
- An access policy can be created along with a bucket create. If creating an access policy fails, bucket configurations are saved and the access policy can be created using the PATCH endpoint.
- "qos_policy" can be specified if a bucket needs to be attached to a QoS group policy during creation time.
- "audit_event_selector" can be specified if a bucket needs to be specify access and permission type for auditing.
- A CORS configuration can be specified along with bucket creation.
</personalities>
### Required properties
* `svm.uuid or svm.name` - Existing SVM in which to create the bucket configuration.
* `name` - Bucket name that is to be created.
<personalities supports=unified,asar2>
### Recommended optional properties
* `aggregates` - List of aggregates for the FlexGroup volume on which the bucket is hosted on.
* `constituents_per_aggregate` - Number of constituents per aggregate.
* `size` - Specifying the bucket size is recommended.
* `policy` - Specifying a policy enables users to perform operations on buckets; specifying the resource permissions is recommended.
* `qos_policy` - A QoS policy for buckets.
* `audit_event_selector` - Audit policy for buckets.
* `versioning_state` - Versioning state for buckets.
* `type` - Type of bucket.
* `nas_path` - NAS path to which the bucket corresponds to.
* `use_mirrored_aggregates` - Specifies whether mirrored aggregates are selected when provisioning a FlexGroup volume.
* `lifecycle_management` - Object store server lifecycle management policy.
* `retention.mode` - Object lock mode supported on the bucket.
* `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
* `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests.
* `snapshot_policy` - Snapshot policy for the bucket.
* `is_nas_path_mutable` - Specifies whether the NAS bucket mapping with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount.
### Default property values
* `size` - 800MB
* `comment` - ""
* `aggregates` - No default value.
* `constituents_per_aggregate` - _4_ , if an aggregates list is specified. Otherwise, no default value.
* `policy.statements.actions` - GetObject, PutObject, DeleteObject, ListBucket, ListBucketMultipartUploads, ListMultipartUploadParts, GetObjectTagging, PutObjectTagging, DeleteObjectTagging, GetBucketVersioning, PutBucketVersioning.
* `policy.statements.principals` - all S3 users and groups in the SVM or the NAS groups.
* `policy.statements.resources` - all objects in the bucket.
* `policy.statements.conditions` - list of bucket policy conditions.
* `versioning_state` - disabled.
* `use_mirrored_aggregates` - _true_ for a MetroCluster configuration and _false_ for a non-MetroCluster configuration.
* `type` - S3
* `retention.mode` - no_lock
</personalities>
<personalities supports=aiml>
### Recommended optional properties
* `size` - Specifying the bucket size is recommended.
* `policy` - Specifying a policy enables users to perform operations on buckets; specifying the resource permissions is recommended.
* `qos_policy` - A QoS policy for buckets.
* `audit_event_selector` - Audit policy for buckets.
* `versioning_state` - Versioning state for buckets.
* `type` - Type of bucket.
* `nas_path` - NAS path to which the bucket corresponds to.
* `lifecycle_management` - Object store server lifecycle management policy.
* `retention.mode` - Object lock mode supported on the bucket.
* `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
* `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests.
* `snapshot_policy` - Snapshot policy for the bucket.
* `is_nas_path_mutable` - Specifies whether the NAS bucket mapping with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount.
### Default property values
* `size` - 800MB
* `comment` - ""
* `policy.statements.actions` - GetObject, PutObject, DeleteObject, ListBucket, ListBucketMultipartUploads, ListMultipartUploadParts, GetObjectTagging, PutObjectTagging, DeleteObjectTagging, GetBucketVersioning, PutBucketVersioning.
* `policy.statements.principals` - all S3 users and groups in the SVM or the NAS groups.
* `policy.statements.resources` - all objects in the bucket.
* `policy.statements.conditions` - list of bucket policy conditions.
* `versioning_state` - disabled.
* `type` - S3
* `retention.mode` - no_lock
</personalities>
### Related ONTAP commands
* `vserver object-store-server bucket create`
* `vserver object-store-server bucket policy statement create`
* `vserver object-store-server bucket lifecycle-management-rule create`
* `vserver object-store-server bucket cors-rule create`
### Learn more
* [`DOC /protocols/s3/buckets`](#docs-object-store-protocols_s3_buckets)
*/
func (a *Client) S3BucketCreate(params *S3BucketCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketCreateCreated, *S3BucketCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketCreateCreated:
		return value, nil, nil
	case *S3BucketCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketDelete Deletes the S3 bucket configuration of an SVM. An access policy is also deleted on an S3 bucket "delete" command.

### Related ONTAP commands
* `vserver object-store-server bucket delete`
* `vserver object-store-server bucket policy statement delete`
* `vserver object-store-server bucket policy-statement-condition delete`
* `vserver object-store-server bucket lifecycle-management-rule delete`
* `vserver object-store-server bucket cors-rule delete`
### Learn more
* [`DOC /protocols/s3/buckets`](#docs-object-store-protocols_s3_buckets)
*/
func (a *Client) S3BucketDelete(params *S3BucketDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketDeleteOK, *S3BucketDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/buckets/{svm.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketDeleteOK:
		return value, nil, nil
	case *S3BucketDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketDeleteCollection s3 bucket delete collection API
*/
func (a *Client) S3BucketDeleteCollection(params *S3BucketDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketDeleteCollectionOK, *S3BucketDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketDeleteCollectionOK:
		return value, nil, nil
	case *S3BucketDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketGet Retrieves the S3 bucket configuration of an SVM. Note that in order to retrieve S3 bucket policy conditions, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket show`
* `vserver object-store-server bucket policy statement show`
* `vserver object-store-server bucket policy-statement-condition show`
* `vserver object-store-server bucket lifecycle-management-rule show`
* `vserver object-store-server bucket cors-rule show`
### Learn more
* [`DOC /protocols/s3/buckets`](#docs-object-store-protocols_s3_buckets)
*/
func (a *Client) S3BucketGet(params *S3BucketGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/buckets/{svm.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketLifecycleRuleCollectionGet Retrieves all S3 Lifecycle rules associated with a bucket. Note that in order to retrieve S3 bucket rule parameters, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket lifecycle-management-rule show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_rules)
*/
func (a *Client) S3BucketLifecycleRuleCollectionGet(params *S3BucketLifecycleRuleCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketLifecycleRuleCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketLifecycleRuleCreate Creates the S3 bucket lifecycle rule configuration.

### Required properties
* `name` - Lifecycle Management rule to be created.
* `expiration` and/or `non_current_version_expiration` and/or `abort_incomplete_multipart_upload`
  - Lifecycle Management actions associated with the lifecycle rule.

### Recommended optional properties
* `enabled` - Lifecycle Management rule is enabled or not.
* `object_filter.prefix` - Lifecycle Management rule filter prefix.
* `object_filter.tags` - Lifecycle Management rule filter tags.
* `object_filter.size_greater_than` - Lifecycle Management rule filter minimum object size.
* `object_filter.size_less_than` - Lifecycle Management rule filter maximum object size.
* `object_age_days` - Number of days since creation after which objects can be deleted.
* `object_expiry_date` - Specific date from when objects can expire.
* `expired_object_delete_marker` - Cleanup object delete markers.
* `new_non_current_versions` - Number of latest non-current versions to be retained.
* `non_current_days` - Number of days after which non-current versions can be deleted.
* `after_initiation_days` - Number of days of initiation after which uploads can be aborted.
### Related ONTAP commands
* `vserver object-store-server bucket lifecycle-management-rule create`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_rules)
*/
func (a *Client) S3BucketLifecycleRuleCreate(params *S3BucketLifecycleRuleCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleCreateCreated, *S3BucketLifecycleRuleCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketLifecycleRuleCreateCreated:
		return value, nil, nil
	case *S3BucketLifecycleRuleCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketLifecycleRuleDelete Deletes the S3 bucket lifecycle rule configuration.

### Related ONTAP commands
* `vserver object-store-server bucket lifecycle-management-rule delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_rules)
*/
func (a *Client) S3BucketLifecycleRuleDelete(params *S3BucketLifecycleRuleDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketLifecycleRuleDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketLifecycleRuleDeleteCollection s3 bucket lifecycle rule delete collection API
*/
func (a *Client) S3BucketLifecycleRuleDeleteCollection(params *S3BucketLifecycleRuleDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketLifecycleRuleDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketLifecycleRuleGet Retrieves all S3 Lifecycle rules associated with a bucket. Note that in order to retrieve S3 bucket rule parameters, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket lifecycle-management-rule show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_rules)
*/
func (a *Client) S3BucketLifecycleRuleGet(params *S3BucketLifecycleRuleGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketLifecycleRuleGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketLifecycleRuleModify Updates the S3 bucket lifecycle rule configuration.

### Important notes
- The following fields can be modified for a bucket:
* `actions` - Lifecycle Management actions associated with the rule.
* `enabled` - Lifecycle Management rule is enabled or not..
* `object_age_days` - Number of days since creation after which objects can be deleted.
* `object_expiry_date` - Specific date from when objects can expire.
* `expired_object_delete_marker` - Cleanup object delete markers.
* `new_non_current_versions` - Number of latest non-current versions to be retained.
* `non_current_days` - Number of days after which non-current versions can be deleted.
* `after_initiation_days` - Number of days of initiation after which uploads can be aborted.
### Related ONTAP commands
* `vserver object-store-server bucket lifecycle-management-rule modify`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_rules)
*/
func (a *Client) S3BucketLifecycleRuleModify(params *S3BucketLifecycleRuleModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleModifyOK, *S3BucketLifecycleRuleModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketLifecycleRuleModifyOK:
		return value, nil, nil
	case *S3BucketLifecycleRuleModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketLifecycleRuleModifyCollection s3 bucket lifecycle rule modify collection API
*/
func (a *Client) S3BucketLifecycleRuleModifyCollection(params *S3BucketLifecycleRuleModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketLifecycleRuleModifyCollectionOK, *S3BucketLifecycleRuleModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketLifecycleRuleModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_lifecycle_rule_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketLifecycleRuleModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketLifecycleRuleModifyCollectionOK:
		return value, nil, nil
	case *S3BucketLifecycleRuleModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketLifecycleRuleModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketModify Updates the S3 bucket configuration of an SVM.

### Important notes
- The following fields can be modified for a bucket:
  - `comment` - Any information related to the bucket.
  - `size` - Bucket size.
  - `policy` - An access policy for resources (buckets and objects) that defines their permissions. New policies are created after existing policies are deleted. To retain any of the existing policy statements, you need to specify those statements again. Also, policy conditions can be specified as part of a bucket policy.
  - `qos_policy` - A QoS policy for buckets.
  - `audit_event_selector` - Audit policy for buckets. None can be specified for both access and permission to remove an audit event selector.
  - `versioning-state` - Versioning state of the buckets.
  - `nas_path` - NAS path to which the bucket corresponds to.
  - `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
  - `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests. Note that the new CORS configuration specified will replace the existing one. If you need to retain any of the existing CORS rules, specify those rules again as part of the new CORS rules. To remove all the existing rules, specify an empty CORS configuration as input.
  - `snapshot_policy` - Snapshot policy for the bucket.

### Related ONTAP commands
* `vserver object-store-server bucket modify`
* `vserver object-store-server bucket policy statement modify`
* `vserver object-store-server bucket policy-statement-condition modify`
* `vserver object-store-server bucket cors-rule create`
* `vserver object-store-server bucket cors-rule delete`
### Learn more
* [`DOC /protocols/s3/buckets`](#docs-object-store-protocols_s3_buckets)
*/
func (a *Client) S3BucketModify(params *S3BucketModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketModifyOK, *S3BucketModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/buckets/{svm.uuid}/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketModifyOK:
		return value, nil, nil
	case *S3BucketModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketModifyCollection s3 bucket modify collection API
*/
func (a *Client) S3BucketModifyCollection(params *S3BucketModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketModifyCollectionOK, *S3BucketModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketModifyCollectionOK:
		return value, nil, nil
	case *S3BucketModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSnapshotCollectionGet Retrieves a collection of S3 bucket snapshots.

### Related ONTAP commands
* `vserver object-store-server bucket snapshot show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_snapshots)
*/
func (a *Client) S3BucketSnapshotCollectionGet(params *S3BucketSnapshotCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSnapshotCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_snapshot_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSnapshotCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketSnapshotCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSnapshotCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSnapshotCreate Creates an S3 bucket snapshot.

### Required properties
* `name` - Name of the S3 bucket snapshot to be created.
### Related ONTAP commands
* `vserver object-store-server bucket snapshot create`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_snapshots)
*/
func (a *Client) S3BucketSnapshotCreate(params *S3BucketSnapshotCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotCreateCreated, *S3BucketSnapshotCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSnapshotCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_snapshot_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSnapshotCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSnapshotCreateCreated:
		return value, nil, nil
	case *S3BucketSnapshotCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSnapshotCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSnapshotDelete Deletes S3 bucket snapshot.

### Related ONTAP commands
* `vserver object-store-server bucket snapshot delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_snapshots)
*/
func (a *Client) S3BucketSnapshotDelete(params *S3BucketSnapshotDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSnapshotDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_snapshot_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSnapshotDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketSnapshotDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSnapshotDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketSnapshotDeleteCollection s3 bucket snapshot delete collection API
*/
func (a *Client) S3BucketSnapshotDeleteCollection(params *S3BucketSnapshotDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSnapshotDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_snapshot_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSnapshotDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketSnapshotDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSnapshotDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSnapshotGet Retrieves details of a specific S3 bucket snapshot.

### Related ONTAP commands
* `vserver object-store-server bucket snapshot show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets_{s3_bucket.uuid}_snapshots)
*/
func (a *Client) S3BucketSnapshotGet(params *S3BucketSnapshotGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSnapshotGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSnapshotGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_snapshot_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSnapshotGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketSnapshotGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSnapshotGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSvmCreate Creates the S3 bucket configuration of an SVM.

<personalities supports=unified,asar2>
### Important notes
- Each SVM can have one or more bucket configurations.
- Aggregate lists should be specified explicitly. If not specified, then the bucket is auto-provisioned as a FlexGroup.
- Constituents per aggregate specifies the number of components (or FlexVols) per aggregate. Is specified only when an aggregate list is explicitly defined.
- An access policy can be created when a bucket is created.
- "qos_policy" can be specified if a bucket needs to be attached to a QoS group policy during creation time.
- "audit_event_selector" can be specified if a bucket needs to be specify access and permission type for auditing.
- Cross-origin resource sharing (CORS) configuration can be specified when a bucket is created.
</personalities>
<personalities supports=aiml>
### Important notes
- Each SVM can have one or more bucket configurations.
- An access policy can be created when a bucket is created.
- "qos_policy" can be specified if a bucket needs to be attached to a QoS group policy during creation time.
- "audit_event_selector" can be specified if a bucket needs to be specify access and permission type for auditing.
- Cross-origin resource sharing (CORS) configuration can be specified when a bucket is created.
</personalities>
### Required properties
* `svm.uuid` - Existing SVM in which to create the bucket configuration.
* `name` - Bucket name that is to be created.
<personalities supports=unified,asar2>
### Recommended optional properties
* `aggregates` - List of aggregates for the FlexGroup on which the bucket is hosted on.
* `constituents_per_aggregate` - Number of constituents per aggregate.
* `size` - Specifying the bucket size is recommended.
* `policy` - Specifying policy enables users to perform operations on buckets; specifying the resource permissions is recommended.
* `qos_policy` - A QoS policy for buckets.
* `audit_event_selector` - Audit policy for buckets.
* `versioning_state` - Versioning state for buckets.
* `type` - Type of bucket.
* `nas_path` - The NAS path to which the NAS bucket corresponds to.
* `use_mirrored_aggregates` - Specifies whether mirrored aggregates are selected when provisioning a FlexGroup volume.
* `lifecycle_management` - Object store server lifecycle management policy.
* `retention.mode` - Object lock mode supported on the bucket.
* `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
* `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests.
* `snapshot_policy` - Snapshot policy for the bucket.
* `is_consistent_etag` - Return a consistent ETag for NAS buckets.
* `is_nas_path_mutable` - Specifies whether the NAS bucket mapping with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount.
### Default property values
* `size` - 800GB
* `comment` - ""
* `aggregates` - No default value.
* `constituents_per_aggregate` - _4_ , if an aggregates list is specified. Otherwise, no default value.
* `policy.statements.actions` - GetObject, PutObject, DeleteObject, ListBucket, ListBucketMultipartUploads, ListMultipartUploadParts, GetObjectTagging, PutObjectTagging, DeleteObjectTagging, GetBucketVersioning, PutBucketVersioning.
* `policy.statements.principals` - all S3 users and groups in the SVM or the NAS groups.
* `policy.statements.resources` - all objects in the bucket.
* `policy.statements.conditions` - list of bucket policy conditions.
* `qos-policy` - No default value.
* `versioning_state` - disabled.
* `use_mirrored_aggregates` - _true_ for a MetroCluster configuration and _false_ for a non-MetroCluster configuration.
* `type` - S3.
* `retention.mode` - no_lock
* `is_consistent_etag` - false
</personalities>
<personalities supports=aiml>
### Recommended optional properties
* `size` - Specifying the bucket size is recommended.
* `policy` - Specifying policy enables users to perform operations on buckets; specifying the resource permissions is recommended.
* `qos_policy` - A QoS policy for buckets.
* `audit_event_selector` - Audit policy for buckets.
* `versioning_state` - Versioning state for buckets.
* `type` - Type of bucket.
* `nas_path` - The NAS path to which the NAS bucket corresponds to.
* `lifecycle_management` - Object store server lifecycle management policy.
* `retention.mode` - Object lock mode supported on the bucket.
* `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
* `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests.
* `snapshot_policy` - Snapshot policy for the bucket.
* `is_consistent_etag` - Return a consistent ETag for NAS buckets.
* `is_nas_path_mutable` - Specifies whether the NAS bucket mapping with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount.
### Default property values
* `size` - 800MB
* `comment` - ""
* `policy.statements.actions` - GetObject, PutObject, DeleteObject, ListBucket, ListBucketMultipartUploads, ListMultipartUploadParts, GetObjectTagging, PutObjectTagging, DeleteObjectTagging, GetBucketVersioning, PutBucketVersioning.
* `policy.statements.principals` - all S3 users and groups in the SVM or the NAS groups.
* `policy.statements.resources` - all objects in the bucket.
* `policy.statements.conditions` - list of bucket policy conditions.
* `qos-policy` - No default value.
* `versioning_state` - disabled.
* `type` - S3.
* `retention.mode` - no_lock
* `is_consistent_etag` - false
</personalities>
### Related ONTAP commands
* `vserver object-store-server bucket create`
* `vserver object-store-server bucket policy statement create`
* `vserver object-store-server bucket policy-statement-condition create`
* `vserver object-store-server bucket lifecycle-management-rule create`
* `vserver object-store-server bucket cors-rule create`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets)
*/
func (a *Client) S3BucketSvmCreate(params *S3BucketSvmCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmCreateCreated, *S3BucketSvmCreateAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSvmCreateCreated:
		return value, nil, nil
	case *S3BucketSvmCreateAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmCreateDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSvmDelete Deletes the S3 bucket configuration of an SVM. An access policy is also deleted on an S3 bucket "delete" command. All CORS rules are also deleted on bucket deletion.

### Related ONTAP commands
* `vserver object-store-server bucket delete`
* `vserver object-store-server bucket policy statement delete`
* `vserver object-store-server bucket policy-statement-condition delete`
* `vserver object-store-server bucket lifecycle-management-rule delete`
* `vserver object-store-server bucket cors-rule delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets)
*/
func (a *Client) S3BucketSvmDelete(params *S3BucketSvmDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmDeleteOK, *S3BucketSvmDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSvmDeleteOK:
		return value, nil, nil
	case *S3BucketSvmDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketSvmDeleteCollection s3 bucket svm delete collection API
*/
func (a *Client) S3BucketSvmDeleteCollection(params *S3BucketSvmDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmDeleteCollectionOK, *S3BucketSvmDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSvmDeleteCollectionOK:
		return value, nil, nil
	case *S3BucketSvmDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSvmGet Retrieves the S3 bucket configuration of an SVM. Note that in order to retrieve S3 bucket policy conditions, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server bucket show`
* `vserver object-store-server bucket policy statement show`
* `vserver object-store-server bucket policy-statement-condition show`
* `vserver object-store-server bucket lifecycle-management-rule show`
* `vserver object-store-server bucket cors-rule show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets)
*/
func (a *Client) S3BucketSvmGet(params *S3BucketSvmGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3BucketSvmGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3BucketSvmModify Updates the S3 bucket configuration of an SVM.

### Important notes
- The following fields can be modified for a bucket:
  - `comment` - Any information related to the bucket.
  - `size` - Bucket size.
  - `policy` - An access policy for resources (buckets and objects) that defines their permissions. New policies are created after existing policies are deleted. To retain any of the existing policy statements, you need to specify those statements again. Policy conditions can also be modified using this API.
  - `qos_policy` - A QoS policy for buckets.
  - `audit_event_selector` - Audit policy for buckets.  None can be specified for both access and permission to remove audit event selector.
  - `versioning_state` - Versioning state for buckets.
  - `nas_path` - NAS path to which the NAS bucket corresponds to.
  - `retention.default_period` - Specifies the duration of default-retention applicable for objects on the object store bucket.
  - `cors` - Specifying CORS rules enables the bucket to service the cross-origin requests. New CORS rules are created after existing rules are deleted. To retain any of the existing rules, you need to specify those CORS rules again. To remove all the existing CORS rules, specify an empty CORS rules list.
  - `snapshot_policy` - Snapshot policy for the bucket.
  - `is_consistent_etag` - Return a consistent ETag for NAS buckets.

### Related ONTAP commands
* `vserver object-store-server bucket modify`
* `vserver object-store-server bucket policy statement modify`
* `vserver object-store-server bucket policy-statement-condition modify`
* `vserver object-store-server bucket cors-rule create`
* `vserver object-store-server bucket cors-rule delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/buckets`](#docs-object-store-protocols_s3_services_{svm.uuid}_buckets)
*/
func (a *Client) S3BucketSvmModify(params *S3BucketSvmModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmModifyOK, *S3BucketSvmModifyAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets/{uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSvmModifyOK:
		return value, nil, nil
	case *S3BucketSvmModifyAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmModifyDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3BucketSvmModifyCollection s3 bucket svm modify collection API
*/
func (a *Client) S3BucketSvmModifyCollection(params *S3BucketSvmModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3BucketSvmModifyCollectionOK, *S3BucketSvmModifyCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3BucketSvmModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_bucket_svm_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/buckets",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3BucketSvmModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3BucketSvmModifyCollectionOK:
		return value, nil, nil
	case *S3BucketSvmModifyCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3BucketSvmModifyCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3GroupCollectionGet Retrieves the S3 group's SVM configuration.

### Related ONTAP commands
* `vserver object-store-server group show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/groups`](#docs-object-store-protocols_s3_services_{svm.uuid}_groups)
*/
func (a *Client) S3GroupCollectionGet(params *S3GroupCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3GroupCreate Creates the S3 group configuration.

### Important notes
- Each SVM can have one or more s3 group configurations.
### Required properties
* `svm.uuid` - Existing SVM in which to create the user configuration.
* `name` - Group name that is to be created.
* `users` - List of users to be added into the group.
* `policies` - List of policies are to be attached to this group.
### Recommended optional properties
* `comment` - Short description about the S3 Group.
### Related ONTAP commands
* `vserver object-store-server group create`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/groups`](#docs-object-store-protocols_s3_services_{svm.uuid}_groups)
*/
func (a *Client) S3GroupCreate(params *S3GroupCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3GroupDelete Deletes the S3 group configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server group delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/groups`](#docs-object-store-protocols_s3_services_{svm.uuid}_groups)
*/
func (a *Client) S3GroupDelete(params *S3GroupDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3GroupDeleteCollection s3 group delete collection API
*/
func (a *Client) S3GroupDeleteCollection(params *S3GroupDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3GroupGet Retrieves the S3 group configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server group show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/groups`](#docs-object-store-protocols_s3_services_{svm.uuid}_groups)
*/
func (a *Client) S3GroupGet(params *S3GroupGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3GroupModify Updates the S3 group configuration of an SVM.

### Important notes
- The following fields can be modified for a group:
* `name` - Group name that needs to be modified.
* `users` - List of users present in the group.
* `policies` - List of policies to be attached to this group.
### Recommended optional properties
* `comment` - Short description about the S3 Group.
### Related ONTAP commands
* `vserver object-store-server group modify`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/groups`](#docs-object-store-protocols_s3_services_{svm.uuid}_groups)
*/
func (a *Client) S3GroupModify(params *S3GroupModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups/{id}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3GroupModifyCollection s3 group modify collection API
*/
func (a *Client) S3GroupModifyCollection(params *S3GroupModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3GroupModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3GroupModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_group_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/groups",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3GroupModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3GroupModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3GroupModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3PolicyCollectionGet Retrieves the S3 policies SVM configuration.

### Related ONTAP commands
* `vserver object-store-server policy show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/policies`](#docs-object-store-protocols_s3_services_{svm.uuid}_policies)
*/
func (a *Client) S3PolicyCollectionGet(params *S3PolicyCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3PolicyCreate Creates the S3 policy configuration.

### Important notes
- Each SVM can have one or more s3 policy configurations.
### Required properties
* `svm.uuid` - Existing SVM in which to create the s3 policy configuration.
* `name` - Policy name that is to be created.
### Recommended optional properties
* `comment` - Short description about the S3 policy.
* `statements.effect` - Indicates whether to allow or deny access.
* `statements.actions` - List of actions that can be allowed or denied access. Example: GetObject, PutObject, DeleteObject, ListBucket, ListMyBuckets, ListBucketMultipartUploads, ListMultipartUploadParts, CreateBucket, DeleteBucket, GetObjectTagging, PutObjectTagging, DeleteObjectTagging, GetBucketVersioning, PutBucketVersioning.
* `statements.resources` - Buckets or objects that can be allowed or denied access.
* `statements.sid` - Statement identifier providing additional information about the statement.
### Related ONTAP commands
* `vserver object-store-server policy create`
* `vserver object-store-server policy add-statement`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/policies`](#docs-object-store-protocols_s3_services_{svm.uuid}_policies)
*/
func (a *Client) S3PolicyCreate(params *S3PolicyCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3PolicyDelete Deletes the S3 policy configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server policy delete`
* `vserver object-store-server policy delete-statement`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/policies`](#docs-object-store-protocols_s3_services_{svm.uuid}_policies)
*/
func (a *Client) S3PolicyDelete(params *S3PolicyDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3PolicyDeleteCollection s3 policy delete collection API
*/
func (a *Client) S3PolicyDeleteCollection(params *S3PolicyDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3PolicyGet Retrieves the S3 policy configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server policy show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/policies`](#docs-object-store-protocols_s3_services_{svm.uuid}_policies)
*/
func (a *Client) S3PolicyGet(params *S3PolicyGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3PolicyModify Updates the S3 policy configuration of an SVM.

### Important notes
- The following fields can be modified for a policy:
  - `comment` - Any information related to the policy.
  - `statements` - Specifies the array of policy statements.

### Related ONTAP commands
* `vserver object-store-server policy modify`
* `vserver object-store-server policy modify-statement`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/policies`](#docs-object-store-protocols_s3_services_{svm.uuid}_policies)
*/
func (a *Client) S3PolicyModify(params *S3PolicyModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3PolicyModifyCollection s3 policy modify collection API
*/
func (a *Client) S3PolicyModifyCollection(params *S3PolicyModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3PolicyModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3PolicyModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_policy_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/policies",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3PolicyModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3PolicyModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3PolicyModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3ServiceCollectionGet Retrieves the S3 server configuration for all SVMs. Note that in order to retrieve S3 bucket policy conditions, 'fields' option should be set to '**'.

### Expensive properties
There is an added computational cost to retrieving values for these properties. They are not included by default in GET results and must be explicitly requested using the `fields` query parameter. See [`Requesting specific fields`](#Requesting_specific_fields) to learn more.
* `statistics.*`
* `metric.*`
### Related ONTAP commands
* `vserver object-store-server show`
### Learn more
* [`DOC /protocols/s3/services`](#docs-object-store-protocols_s3_services)
*/
func (a *Client) S3ServiceCollectionGet(params *S3ServiceCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3ServiceCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3ServiceCreate Creates an S3 server, users, and buckets configurations.

### Important notes
- Each SVM can have one S3 server configuration.
- By default, HTTPS is enabled on the S3 server, so a valid certificate must be provided when creating a S3 Server for the SVM.
- One or more buckets and users can also be created using this end-point.
- If creating a user configuration fails, buckets are not created either and already created users are not saved.
- If creating a bucket configuration fails, all buckets already created are saved with no new buckets created.
### Required properties
* `svm.uuid` - Existing SVM in which to create an S3 server configuration.
### Recommended optional properties
* `enabled` - Specifies the state of the server created.
* `comment` - Any information related to the server created.
### Default property values
* `comment` - ""
* `enabled` - _true_
* `is_https_enabled` - _true_
### Related ONTAP commands
* `vserver object-store-server create`
* `vserver object-store-server bucket create`
* `vserver object-store-server bucket policy statement create`
* `vserver object-store-server bucket policy-statement-condition create`
* `vserver object-store-server bucket cors-rule create`
* `vserver object-store-server user create`
### Learn more
* [`DOC /protocols/s3/services`](#docs-object-store-protocols_s3_services)
*/
func (a *Client) S3ServiceCreate(params *S3ServiceCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3ServiceCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3ServiceDelete Deletes the S3 server configuration of an SVM. If the 'delete_all' parameter is set to false, only the S3 server is deleted. Otherwise S3 users and buckets present on the SVM are also deleted. Note that only empty buckets can be deleted. This endpoint returns the S3 server delete job-uuid in response. To monitor the job status follow /api/cluster/jobs/<job-uuid>.

### Related ONTAP commands
* `vserver object-store-server delete`
### Learn more
* [`DOC /protocols/s3/services`](#docs-object-store-protocols_s3_services)
*/
func (a *Client) S3ServiceDelete(params *S3ServiceDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceDeleteOK, *S3ServiceDeleteAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3ServiceDeleteOK:
		return value, nil, nil
	case *S3ServiceDeleteAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceDeleteDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3ServiceDeleteCollection s3 service delete collection API
*/
func (a *Client) S3ServiceDeleteCollection(params *S3ServiceDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceDeleteCollectionOK, *S3ServiceDeleteCollectionAccepted, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, nil, err
	}
	switch value := result.(type) {
	case *S3ServiceDeleteCollectionOK:
		return value, nil, nil
	case *S3ServiceDeleteCollectionAccepted:
		return nil, value, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceDeleteCollectionDefault)
	return nil, nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3ServiceGet Retrieves the S3 Server configuration of an SVM. Note that in order to retrieve S3 bucket policy conditions, the 'fields' option should be set to '**'.

### Related ONTAP commands
* `vserver object-store-server show`
### Learn more
* [`DOC /protocols/s3/services`](#docs-object-store-protocols_s3_services)
*/
func (a *Client) S3ServiceGet(params *S3ServiceGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3ServiceGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3ServiceModify Updates the S3 Server configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server modify`
### Learn more
* [`DOC /protocols/s3/services`](#docs-object-store-protocols_s3_services)
*/
func (a *Client) S3ServiceModify(params *S3ServiceModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3ServiceModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3ServiceModifyCollection s3 service modify collection API
*/
func (a *Client) S3ServiceModifyCollection(params *S3ServiceModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3ServiceModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3ServiceModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_service_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3ServiceModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3ServiceModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3ServiceModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3UserCollectionGet Retrieves the S3 user's SVM configuration.

### Related ONTAP commands
* `vserver object-store-server user show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/users`](#docs-object-store-protocols_s3_services_{svm.uuid}_users)
*/
func (a *Client) S3UserCollectionGet(params *S3UserCollectionGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserCollectionGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserCollectionGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_collection_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserCollectionGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserCollectionGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserCollectionGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3UserCreate Creates the S3 user configuration.

### Important notes
- Each SVM can have one or more user configurations.
- If the user is a member of Active directory, the user name takes the format "user@FQDN". For example, "user1@domain1.com".
- If user creation is successful, a user access_key and secret_key is returned as part of the response.
- If user keys have expiry configuration, then "key_expiry_time" is also returned as part of the response.
- User access and secret keys can be specified in the input. If not specified, keys are generated automatically.
### Required properties
* `svm.uuid` - Existing SVM in which to create the user configuration.
* `name` - User name that is to be created.
### Default property values
* `comment` - ""
### Related ONTAP commands
* `vserver object-store-server user create`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/users`](#docs-object-store-protocols_s3_services_{svm.uuid}_users)
*/
func (a *Client) S3UserCreate(params *S3UserCreateParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserCreateCreated, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserCreateParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_create",
		Method:             "POST",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserCreateReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserCreateCreated)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserCreateDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3UserDelete Deletes the S3 user configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server user delete`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/users`](#docs-object-store-protocols_s3_services_{svm.uuid}_users)
*/
func (a *Client) S3UserDelete(params *S3UserDeleteParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserDeleteOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserDeleteParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_delete",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserDeleteReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserDeleteOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserDeleteDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3UserDeleteCollection s3 user delete collection API
*/
func (a *Client) S3UserDeleteCollection(params *S3UserDeleteCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserDeleteCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserDeleteCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_delete_collection",
		Method:             "DELETE",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserDeleteCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserDeleteCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserDeleteCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3UserGet Retrieves the S3 user configuration of an SVM.

### Related ONTAP commands
* `vserver object-store-server user show`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/users`](#docs-object-store-protocols_s3_services_{svm.uuid}_users)
*/
func (a *Client) S3UserGet(params *S3UserGetParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserGetOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserGetParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_get",
		Method:             "GET",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserGetReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserGetOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserGetDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
	S3UserModify Updates the S3 user configuration of an SVM.

### Important notes
- User access_key and secret_key pair can be regenerated using the PATCH operation.
- User access_key and secret_key is returned in a PATCH operation if the "regenerate_keys" field is specified as true.
- If "regenerate_keys" is true and user keys have expiry configuration, then "key_expiry_time" is also returned as part of response.
- User access_key and secret_key pair can be deleted using the PATCH operation.
### Recommended optional properties
* `regenerate_keys` - Specifies if secret_key and access_key need to be regenerated.
* `delete_keys` - Specifies if secret_key and access_key need to be deleted.
* `comment` - Any information related to the S3 user.
### Related ONTAP commands
* `vserver object-store-server user show`
* `vserver object-store-server user regenerate-keys`
* `vserver object-store-server user delete-keys`
### Learn more
* [`DOC /protocols/s3/services/{svm.uuid}/users`](#docs-object-store-protocols_s3_services_{svm.uuid}_users)
*/
func (a *Client) S3UserModify(params *S3UserModifyParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserModifyOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserModifyParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_modify",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users/{name}",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserModifyReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserModifyOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserModifyDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

/*
S3UserModifyCollection s3 user modify collection API
*/
func (a *Client) S3UserModifyCollection(params *S3UserModifyCollectionParams, authInfo runtime.ClientAuthInfoWriter, opts ...ClientOption) (*S3UserModifyCollectionOK, error) {
	// TODO: Validate the params before sending
	if params == nil {
		params = NewS3UserModifyCollectionParams()
	}
	op := &runtime.ClientOperation{
		ID:                 "s3_user_modify_collection",
		Method:             "PATCH",
		PathPattern:        "/protocols/s3/services/{svm.uuid}/users",
		ProducesMediaTypes: []string{"application/json", "application/hal+json"},
		ConsumesMediaTypes: []string{"application/json", "application/hal+json"},
		Schemes:            []string{"https"},
		Params:             params,
		Reader:             &S3UserModifyCollectionReader{formats: a.formats},
		AuthInfo:           authInfo,
		Context:            params.Context,
		Client:             params.HTTPClient,
	}
	for _, opt := range opts {
		opt(op)
	}

	result, err := a.transport.Submit(op)
	if err != nil {
		return nil, err
	}
	success, ok := result.(*S3UserModifyCollectionOK)
	if ok {
		return success, nil
	}
	// unexpected success response
	unexpectedSuccess := result.(*S3UserModifyCollectionDefault)
	return nil, runtime.NewAPIError("unexpected success response: content available as default response in error", unexpectedSuccess, unexpectedSuccess.Code())
}

// SetTransport changes the transport on the client
func (a *Client) SetTransport(transport runtime.ClientTransport) {
	a.transport = transport
}
