// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketDeleteParams creates a new S3BucketDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketDeleteParams() *S3BucketDeleteParams {
	return &S3BucketDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketDeleteParamsWithTimeout creates a new S3BucketDeleteParams object
// with the ability to set a timeout on a request.
func NewS3BucketDeleteParamsWithTimeout(timeout time.Duration) *S3BucketDeleteParams {
	return &S3BucketDeleteParams{
		timeout: timeout,
	}
}

// NewS3BucketDeleteParamsWithContext creates a new S3BucketDeleteParams object
// with the ability to set a context for a request.
func NewS3BucketDeleteParamsWithContext(ctx context.Context) *S3BucketDeleteParams {
	return &S3BucketDeleteParams{
		Context: ctx,
	}
}

// NewS3BucketDeleteParamsWithHTTPClient creates a new S3BucketDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketDeleteParamsWithHTTPClient(client *http.Client) *S3BucketDeleteParams {
	return &S3BucketDeleteParams{
		HTTPClient: client,
	}
}

/*
S3BucketDeleteParams contains all the parameters to send to the API endpoint

	for the s3 bucket delete operation.

	Typically these are written to a http.Request.
*/
type S3BucketDeleteParams struct {

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   The unique identifier of the bucket.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketDeleteParams) WithDefaults() *S3BucketDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketDeleteParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := S3BucketDeleteParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithTimeout(timeout time.Duration) *S3BucketDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithContext(ctx context.Context) *S3BucketDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithHTTPClient(client *http.Client) *S3BucketDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithReturnTimeout adds the returnTimeout to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithReturnTimeout(returnTimeout *int64) *S3BucketDeleteParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithSvmUUID(svmUUID string) *S3BucketDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket delete params
func (o *S3BucketDeleteParams) WithUUID(uuid string) *S3BucketDeleteParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket delete params
func (o *S3BucketDeleteParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
