// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketGetParams creates a new S3BucketGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketGetParams() *S3BucketGetParams {
	return &S3BucketGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketGetParamsWithTimeout creates a new S3BucketGetParams object
// with the ability to set a timeout on a request.
func NewS3BucketGetParamsWithTimeout(timeout time.Duration) *S3BucketGetParams {
	return &S3BucketGetParams{
		timeout: timeout,
	}
}

// NewS3BucketGetParamsWithContext creates a new S3BucketGetParams object
// with the ability to set a context for a request.
func NewS3BucketGetParamsWithContext(ctx context.Context) *S3BucketGetParams {
	return &S3BucketGetParams{
		Context: ctx,
	}
}

// NewS3BucketGetParamsWithHTTPClient creates a new S3BucketGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketGetParamsWithHTTPClient(client *http.Client) *S3BucketGetParams {
	return &S3BucketGetParams{
		HTTPClient: client,
	}
}

/*
S3BucketGetParams contains all the parameters to send to the API endpoint

	for the s3 bucket get operation.

	Typically these are written to a http.Request.
*/
type S3BucketGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   The unique identifier of the bucket.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketGetParams) WithDefaults() *S3BucketGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 bucket get params
func (o *S3BucketGetParams) WithTimeout(timeout time.Duration) *S3BucketGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket get params
func (o *S3BucketGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket get params
func (o *S3BucketGetParams) WithContext(ctx context.Context) *S3BucketGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket get params
func (o *S3BucketGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket get params
func (o *S3BucketGetParams) WithHTTPClient(client *http.Client) *S3BucketGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket get params
func (o *S3BucketGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 bucket get params
func (o *S3BucketGetParams) WithFields(fields []string) *S3BucketGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 bucket get params
func (o *S3BucketGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the s3 bucket get params
func (o *S3BucketGetParams) WithSvmUUID(svmUUID string) *S3BucketGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket get params
func (o *S3BucketGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket get params
func (o *S3BucketGetParams) WithUUID(uuid string) *S3BucketGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket get params
func (o *S3BucketGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3BucketGet binds the parameter fields
func (o *S3BucketGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
