// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketLifecycleRuleCollectionGetParams creates a new S3BucketLifecycleRuleCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketLifecycleRuleCollectionGetParams() *S3BucketLifecycleRuleCollectionGetParams {
	return &S3BucketLifecycleRuleCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketLifecycleRuleCollectionGetParamsWithTimeout creates a new S3BucketLifecycleRuleCollectionGetParams object
// with the ability to set a timeout on a request.
func NewS3BucketLifecycleRuleCollectionGetParamsWithTimeout(timeout time.Duration) *S3BucketLifecycleRuleCollectionGetParams {
	return &S3BucketLifecycleRuleCollectionGetParams{
		timeout: timeout,
	}
}

// NewS3BucketLifecycleRuleCollectionGetParamsWithContext creates a new S3BucketLifecycleRuleCollectionGetParams object
// with the ability to set a context for a request.
func NewS3BucketLifecycleRuleCollectionGetParamsWithContext(ctx context.Context) *S3BucketLifecycleRuleCollectionGetParams {
	return &S3BucketLifecycleRuleCollectionGetParams{
		Context: ctx,
	}
}

// NewS3BucketLifecycleRuleCollectionGetParamsWithHTTPClient creates a new S3BucketLifecycleRuleCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketLifecycleRuleCollectionGetParamsWithHTTPClient(client *http.Client) *S3BucketLifecycleRuleCollectionGetParams {
	return &S3BucketLifecycleRuleCollectionGetParams{
		HTTPClient: client,
	}
}

/*
S3BucketLifecycleRuleCollectionGetParams contains all the parameters to send to the API endpoint

	for the s3 bucket lifecycle rule collection get operation.

	Typically these are written to a http.Request.
*/
type S3BucketLifecycleRuleCollectionGetParams struct {

	/* AbortIncompleteMultipartUploadAfterInitiationDays.

	   Filter by abort_incomplete_multipart_upload.after_initiation_days
	*/
	AbortIncompleteMultipartUploadAfterInitiationDays *int64

	/* BucketName.

	   Filter by bucket_name
	*/
	BucketName *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* ExpirationExpiredObjectDeleteMarker.

	   Filter by expiration.expired_object_delete_marker
	*/
	ExpirationExpiredObjectDeleteMarker *bool

	/* ExpirationObjectAgeDays.

	   Filter by expiration.object_age_days
	*/
	ExpirationObjectAgeDays *int64

	/* ExpirationObjectExpiryDate.

	   Filter by expiration.object_expiry_date
	*/
	ExpirationObjectExpiryDate *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NonCurrentVersionExpirationNewNonCurrentVersions.

	   Filter by non_current_version_expiration.new_non_current_versions
	*/
	NonCurrentVersionExpirationNewNonCurrentVersions *int64

	/* NonCurrentVersionExpirationNonCurrentDays.

	   Filter by non_current_version_expiration.non_current_days
	*/
	NonCurrentVersionExpirationNonCurrentDays *int64

	/* ObjectFilterPrefix.

	   Filter by object_filter.prefix
	*/
	ObjectFilterPrefix *string

	/* ObjectFilterSizeGreaterThan.

	   Filter by object_filter.size_greater_than
	*/
	ObjectFilterSizeGreaterThan *int64

	/* ObjectFilterSizeLessThan.

	   Filter by object_filter.size_less_than
	*/
	ObjectFilterSizeLessThan *int64

	/* ObjectFilterTags.

	   Filter by object_filter.tags
	*/
	ObjectFilterTags *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* S3BucketUUID.

	   The unique identifier of the bucket.
	*/
	S3BucketUUID string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket lifecycle rule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleCollectionGetParams) WithDefaults() *S3BucketLifecycleRuleCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket lifecycle rule collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := S3BucketLifecycleRuleCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithTimeout(timeout time.Duration) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithContext(ctx context.Context) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithHTTPClient(client *http.Client) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAbortIncompleteMultipartUploadAfterInitiationDays adds the abortIncompleteMultipartUploadAfterInitiationDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays)
	return o
}

// SetAbortIncompleteMultipartUploadAfterInitiationDays adds the abortIncompleteMultipartUploadAfterInitiationDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays *int64) {
	o.AbortIncompleteMultipartUploadAfterInitiationDays = abortIncompleteMultipartUploadAfterInitiationDays
}

// WithBucketName adds the bucketName to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithBucketName(bucketName *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetBucketName(bucketName *string) {
	o.BucketName = bucketName
}

// WithEnabled adds the enabled to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithEnabled(enabled *bool) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExpirationExpiredObjectDeleteMarker adds the expirationExpiredObjectDeleteMarker to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker *bool) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker)
	return o
}

// SetExpirationExpiredObjectDeleteMarker adds the expirationExpiredObjectDeleteMarker to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker *bool) {
	o.ExpirationExpiredObjectDeleteMarker = expirationExpiredObjectDeleteMarker
}

// WithExpirationObjectAgeDays adds the expirationObjectAgeDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithExpirationObjectAgeDays(expirationObjectAgeDays *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetExpirationObjectAgeDays(expirationObjectAgeDays)
	return o
}

// SetExpirationObjectAgeDays adds the expirationObjectAgeDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetExpirationObjectAgeDays(expirationObjectAgeDays *int64) {
	o.ExpirationObjectAgeDays = expirationObjectAgeDays
}

// WithExpirationObjectExpiryDate adds the expirationObjectExpiryDate to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithExpirationObjectExpiryDate(expirationObjectExpiryDate *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetExpirationObjectExpiryDate(expirationObjectExpiryDate)
	return o
}

// SetExpirationObjectExpiryDate adds the expirationObjectExpiryDate to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetExpirationObjectExpiryDate(expirationObjectExpiryDate *string) {
	o.ExpirationObjectExpiryDate = expirationObjectExpiryDate
}

// WithFields adds the fields to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithFields(fields []string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithMaxRecords adds the maxRecords to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithMaxRecords(maxRecords *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithName(name *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithNonCurrentVersionExpirationNewNonCurrentVersions adds the nonCurrentVersionExpirationNewNonCurrentVersions to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions)
	return o
}

// SetNonCurrentVersionExpirationNewNonCurrentVersions adds the nonCurrentVersionExpirationNewNonCurrentVersions to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions *int64) {
	o.NonCurrentVersionExpirationNewNonCurrentVersions = nonCurrentVersionExpirationNewNonCurrentVersions
}

// WithNonCurrentVersionExpirationNonCurrentDays adds the nonCurrentVersionExpirationNonCurrentDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays)
	return o
}

// SetNonCurrentVersionExpirationNonCurrentDays adds the nonCurrentVersionExpirationNonCurrentDays to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays *int64) {
	o.NonCurrentVersionExpirationNonCurrentDays = nonCurrentVersionExpirationNonCurrentDays
}

// WithObjectFilterPrefix adds the objectFilterPrefix to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithObjectFilterPrefix(objectFilterPrefix *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetObjectFilterPrefix(objectFilterPrefix)
	return o
}

// SetObjectFilterPrefix adds the objectFilterPrefix to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetObjectFilterPrefix(objectFilterPrefix *string) {
	o.ObjectFilterPrefix = objectFilterPrefix
}

// WithObjectFilterSizeGreaterThan adds the objectFilterSizeGreaterThan to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan)
	return o
}

// SetObjectFilterSizeGreaterThan adds the objectFilterSizeGreaterThan to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan *int64) {
	o.ObjectFilterSizeGreaterThan = objectFilterSizeGreaterThan
}

// WithObjectFilterSizeLessThan adds the objectFilterSizeLessThan to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithObjectFilterSizeLessThan(objectFilterSizeLessThan *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetObjectFilterSizeLessThan(objectFilterSizeLessThan)
	return o
}

// SetObjectFilterSizeLessThan adds the objectFilterSizeLessThan to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetObjectFilterSizeLessThan(objectFilterSizeLessThan *int64) {
	o.ObjectFilterSizeLessThan = objectFilterSizeLessThan
}

// WithObjectFilterTags adds the objectFilterTags to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithObjectFilterTags(objectFilterTags *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetObjectFilterTags(objectFilterTags)
	return o
}

// SetObjectFilterTags adds the objectFilterTags to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetObjectFilterTags(objectFilterTags *string) {
	o.ObjectFilterTags = objectFilterTags
}

// WithOrderBy adds the orderBy to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithOrderBy(orderBy []string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithReturnRecords adds the returnRecords to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithReturnRecords(returnRecords *bool) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithS3BucketUUID adds the s3BucketUUID to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithS3BucketUUID(s3BucketUUID string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetS3BucketUUID(s3BucketUUID)
	return o
}

// SetS3BucketUUID adds the s3BucketUuid to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetS3BucketUUID(s3BucketUUID string) {
	o.S3BucketUUID = s3BucketUUID
}

// WithSvmName adds the svmName to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithSvmName(svmName *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithSvmUUID(svmUUID string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) WithUUID(uuid *string) *S3BucketLifecycleRuleCollectionGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket lifecycle rule collection get params
func (o *S3BucketLifecycleRuleCollectionGetParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketLifecycleRuleCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AbortIncompleteMultipartUploadAfterInitiationDays != nil {

		// query param abort_incomplete_multipart_upload.after_initiation_days
		var qrAbortIncompleteMultipartUploadAfterInitiationDays int64

		if o.AbortIncompleteMultipartUploadAfterInitiationDays != nil {
			qrAbortIncompleteMultipartUploadAfterInitiationDays = *o.AbortIncompleteMultipartUploadAfterInitiationDays
		}
		qAbortIncompleteMultipartUploadAfterInitiationDays := swag.FormatInt64(qrAbortIncompleteMultipartUploadAfterInitiationDays)
		if qAbortIncompleteMultipartUploadAfterInitiationDays != "" {

			if err := r.SetQueryParam("abort_incomplete_multipart_upload.after_initiation_days", qAbortIncompleteMultipartUploadAfterInitiationDays); err != nil {
				return err
			}
		}
	}

	if o.BucketName != nil {

		// query param bucket_name
		var qrBucketName string

		if o.BucketName != nil {
			qrBucketName = *o.BucketName
		}
		qBucketName := qrBucketName
		if qBucketName != "" {

			if err := r.SetQueryParam("bucket_name", qBucketName); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExpirationExpiredObjectDeleteMarker != nil {

		// query param expiration.expired_object_delete_marker
		var qrExpirationExpiredObjectDeleteMarker bool

		if o.ExpirationExpiredObjectDeleteMarker != nil {
			qrExpirationExpiredObjectDeleteMarker = *o.ExpirationExpiredObjectDeleteMarker
		}
		qExpirationExpiredObjectDeleteMarker := swag.FormatBool(qrExpirationExpiredObjectDeleteMarker)
		if qExpirationExpiredObjectDeleteMarker != "" {

			if err := r.SetQueryParam("expiration.expired_object_delete_marker", qExpirationExpiredObjectDeleteMarker); err != nil {
				return err
			}
		}
	}

	if o.ExpirationObjectAgeDays != nil {

		// query param expiration.object_age_days
		var qrExpirationObjectAgeDays int64

		if o.ExpirationObjectAgeDays != nil {
			qrExpirationObjectAgeDays = *o.ExpirationObjectAgeDays
		}
		qExpirationObjectAgeDays := swag.FormatInt64(qrExpirationObjectAgeDays)
		if qExpirationObjectAgeDays != "" {

			if err := r.SetQueryParam("expiration.object_age_days", qExpirationObjectAgeDays); err != nil {
				return err
			}
		}
	}

	if o.ExpirationObjectExpiryDate != nil {

		// query param expiration.object_expiry_date
		var qrExpirationObjectExpiryDate string

		if o.ExpirationObjectExpiryDate != nil {
			qrExpirationObjectExpiryDate = *o.ExpirationObjectExpiryDate
		}
		qExpirationObjectExpiryDate := qrExpirationObjectExpiryDate
		if qExpirationObjectExpiryDate != "" {

			if err := r.SetQueryParam("expiration.object_expiry_date", qExpirationObjectExpiryDate); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NonCurrentVersionExpirationNewNonCurrentVersions != nil {

		// query param non_current_version_expiration.new_non_current_versions
		var qrNonCurrentVersionExpirationNewNonCurrentVersions int64

		if o.NonCurrentVersionExpirationNewNonCurrentVersions != nil {
			qrNonCurrentVersionExpirationNewNonCurrentVersions = *o.NonCurrentVersionExpirationNewNonCurrentVersions
		}
		qNonCurrentVersionExpirationNewNonCurrentVersions := swag.FormatInt64(qrNonCurrentVersionExpirationNewNonCurrentVersions)
		if qNonCurrentVersionExpirationNewNonCurrentVersions != "" {

			if err := r.SetQueryParam("non_current_version_expiration.new_non_current_versions", qNonCurrentVersionExpirationNewNonCurrentVersions); err != nil {
				return err
			}
		}
	}

	if o.NonCurrentVersionExpirationNonCurrentDays != nil {

		// query param non_current_version_expiration.non_current_days
		var qrNonCurrentVersionExpirationNonCurrentDays int64

		if o.NonCurrentVersionExpirationNonCurrentDays != nil {
			qrNonCurrentVersionExpirationNonCurrentDays = *o.NonCurrentVersionExpirationNonCurrentDays
		}
		qNonCurrentVersionExpirationNonCurrentDays := swag.FormatInt64(qrNonCurrentVersionExpirationNonCurrentDays)
		if qNonCurrentVersionExpirationNonCurrentDays != "" {

			if err := r.SetQueryParam("non_current_version_expiration.non_current_days", qNonCurrentVersionExpirationNonCurrentDays); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterPrefix != nil {

		// query param object_filter.prefix
		var qrObjectFilterPrefix string

		if o.ObjectFilterPrefix != nil {
			qrObjectFilterPrefix = *o.ObjectFilterPrefix
		}
		qObjectFilterPrefix := qrObjectFilterPrefix
		if qObjectFilterPrefix != "" {

			if err := r.SetQueryParam("object_filter.prefix", qObjectFilterPrefix); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterSizeGreaterThan != nil {

		// query param object_filter.size_greater_than
		var qrObjectFilterSizeGreaterThan int64

		if o.ObjectFilterSizeGreaterThan != nil {
			qrObjectFilterSizeGreaterThan = *o.ObjectFilterSizeGreaterThan
		}
		qObjectFilterSizeGreaterThan := swag.FormatInt64(qrObjectFilterSizeGreaterThan)
		if qObjectFilterSizeGreaterThan != "" {

			if err := r.SetQueryParam("object_filter.size_greater_than", qObjectFilterSizeGreaterThan); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterSizeLessThan != nil {

		// query param object_filter.size_less_than
		var qrObjectFilterSizeLessThan int64

		if o.ObjectFilterSizeLessThan != nil {
			qrObjectFilterSizeLessThan = *o.ObjectFilterSizeLessThan
		}
		qObjectFilterSizeLessThan := swag.FormatInt64(qrObjectFilterSizeLessThan)
		if qObjectFilterSizeLessThan != "" {

			if err := r.SetQueryParam("object_filter.size_less_than", qObjectFilterSizeLessThan); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterTags != nil {

		// query param object_filter.tags
		var qrObjectFilterTags string

		if o.ObjectFilterTags != nil {
			qrObjectFilterTags = *o.ObjectFilterTags
		}
		qObjectFilterTags := qrObjectFilterTags
		if qObjectFilterTags != "" {

			if err := r.SetQueryParam("object_filter.tags", qObjectFilterTags); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param s3_bucket.uuid
	if err := r.SetPathParam("s3_bucket.uuid", o.S3BucketUUID); err != nil {
		return err
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3BucketLifecycleRuleCollectionGet binds the parameter fields
func (o *S3BucketLifecycleRuleCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamS3BucketLifecycleRuleCollectionGet binds the parameter order_by
func (o *S3BucketLifecycleRuleCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
