// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketLifecycleRuleDeleteCollectionParams creates a new S3BucketLifecycleRuleDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketLifecycleRuleDeleteCollectionParams() *S3BucketLifecycleRuleDeleteCollectionParams {
	return &S3BucketLifecycleRuleDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketLifecycleRuleDeleteCollectionParamsWithTimeout creates a new S3BucketLifecycleRuleDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewS3BucketLifecycleRuleDeleteCollectionParamsWithTimeout(timeout time.Duration) *S3BucketLifecycleRuleDeleteCollectionParams {
	return &S3BucketLifecycleRuleDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewS3BucketLifecycleRuleDeleteCollectionParamsWithContext creates a new S3BucketLifecycleRuleDeleteCollectionParams object
// with the ability to set a context for a request.
func NewS3BucketLifecycleRuleDeleteCollectionParamsWithContext(ctx context.Context) *S3BucketLifecycleRuleDeleteCollectionParams {
	return &S3BucketLifecycleRuleDeleteCollectionParams{
		Context: ctx,
	}
}

// NewS3BucketLifecycleRuleDeleteCollectionParamsWithHTTPClient creates a new S3BucketLifecycleRuleDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketLifecycleRuleDeleteCollectionParamsWithHTTPClient(client *http.Client) *S3BucketLifecycleRuleDeleteCollectionParams {
	return &S3BucketLifecycleRuleDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
S3BucketLifecycleRuleDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the s3 bucket lifecycle rule delete collection operation.

	Typically these are written to a http.Request.
*/
type S3BucketLifecycleRuleDeleteCollectionParams struct {

	/* AbortIncompleteMultipartUploadAfterInitiationDays.

	   Filter by abort_incomplete_multipart_upload.after_initiation_days
	*/
	AbortIncompleteMultipartUploadAfterInitiationDays *int64

	/* BucketName.

	   Filter by bucket_name
	*/
	BucketName *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* ExpirationExpiredObjectDeleteMarker.

	   Filter by expiration.expired_object_delete_marker
	*/
	ExpirationExpiredObjectDeleteMarker *bool

	/* ExpirationObjectAgeDays.

	   Filter by expiration.object_age_days
	*/
	ExpirationObjectAgeDays *int64

	/* ExpirationObjectExpiryDate.

	   Filter by expiration.object_expiry_date
	*/
	ExpirationObjectExpiryDate *string

	/* Info.

	   Info specification
	*/
	Info S3BucketLifecycleRuleDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* NonCurrentVersionExpirationNewNonCurrentVersions.

	   Filter by non_current_version_expiration.new_non_current_versions
	*/
	NonCurrentVersionExpirationNewNonCurrentVersions *int64

	/* NonCurrentVersionExpirationNonCurrentDays.

	   Filter by non_current_version_expiration.non_current_days
	*/
	NonCurrentVersionExpirationNonCurrentDays *int64

	/* ObjectFilterPrefix.

	   Filter by object_filter.prefix
	*/
	ObjectFilterPrefix *string

	/* ObjectFilterSizeGreaterThan.

	   Filter by object_filter.size_greater_than
	*/
	ObjectFilterSizeGreaterThan *int64

	/* ObjectFilterSizeLessThan.

	   Filter by object_filter.size_less_than
	*/
	ObjectFilterSizeLessThan *int64

	/* ObjectFilterTags.

	   Filter by object_filter.tags
	*/
	ObjectFilterTags *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* S3BucketUUID.

	   The unique identifier of the bucket.
	*/
	S3BucketUUID string

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   Filter by uuid
	*/
	UUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket lifecycle rule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithDefaults() *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket lifecycle rule delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := S3BucketLifecycleRuleDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithTimeout(timeout time.Duration) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithContext(ctx context.Context) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithHTTPClient(client *http.Client) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithAbortIncompleteMultipartUploadAfterInitiationDays adds the abortIncompleteMultipartUploadAfterInitiationDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays)
	return o
}

// SetAbortIncompleteMultipartUploadAfterInitiationDays adds the abortIncompleteMultipartUploadAfterInitiationDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetAbortIncompleteMultipartUploadAfterInitiationDays(abortIncompleteMultipartUploadAfterInitiationDays *int64) {
	o.AbortIncompleteMultipartUploadAfterInitiationDays = abortIncompleteMultipartUploadAfterInitiationDays
}

// WithBucketName adds the bucketName to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithBucketName(bucketName *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetBucketName(bucketName)
	return o
}

// SetBucketName adds the bucketName to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetBucketName(bucketName *string) {
	o.BucketName = bucketName
}

// WithContinueOnFailure adds the continueOnFailure to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithEnabled adds the enabled to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithEnabled(enabled *bool) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithExpirationExpiredObjectDeleteMarker adds the expirationExpiredObjectDeleteMarker to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker *bool) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker)
	return o
}

// SetExpirationExpiredObjectDeleteMarker adds the expirationExpiredObjectDeleteMarker to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetExpirationExpiredObjectDeleteMarker(expirationExpiredObjectDeleteMarker *bool) {
	o.ExpirationExpiredObjectDeleteMarker = expirationExpiredObjectDeleteMarker
}

// WithExpirationObjectAgeDays adds the expirationObjectAgeDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithExpirationObjectAgeDays(expirationObjectAgeDays *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetExpirationObjectAgeDays(expirationObjectAgeDays)
	return o
}

// SetExpirationObjectAgeDays adds the expirationObjectAgeDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetExpirationObjectAgeDays(expirationObjectAgeDays *int64) {
	o.ExpirationObjectAgeDays = expirationObjectAgeDays
}

// WithExpirationObjectExpiryDate adds the expirationObjectExpiryDate to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithExpirationObjectExpiryDate(expirationObjectExpiryDate *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetExpirationObjectExpiryDate(expirationObjectExpiryDate)
	return o
}

// SetExpirationObjectExpiryDate adds the expirationObjectExpiryDate to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetExpirationObjectExpiryDate(expirationObjectExpiryDate *string) {
	o.ExpirationObjectExpiryDate = expirationObjectExpiryDate
}

// WithInfo adds the info to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithInfo(info S3BucketLifecycleRuleDeleteCollectionBody) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetInfo(info S3BucketLifecycleRuleDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithName(name *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithNonCurrentVersionExpirationNewNonCurrentVersions adds the nonCurrentVersionExpirationNewNonCurrentVersions to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions)
	return o
}

// SetNonCurrentVersionExpirationNewNonCurrentVersions adds the nonCurrentVersionExpirationNewNonCurrentVersions to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetNonCurrentVersionExpirationNewNonCurrentVersions(nonCurrentVersionExpirationNewNonCurrentVersions *int64) {
	o.NonCurrentVersionExpirationNewNonCurrentVersions = nonCurrentVersionExpirationNewNonCurrentVersions
}

// WithNonCurrentVersionExpirationNonCurrentDays adds the nonCurrentVersionExpirationNonCurrentDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays)
	return o
}

// SetNonCurrentVersionExpirationNonCurrentDays adds the nonCurrentVersionExpirationNonCurrentDays to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetNonCurrentVersionExpirationNonCurrentDays(nonCurrentVersionExpirationNonCurrentDays *int64) {
	o.NonCurrentVersionExpirationNonCurrentDays = nonCurrentVersionExpirationNonCurrentDays
}

// WithObjectFilterPrefix adds the objectFilterPrefix to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithObjectFilterPrefix(objectFilterPrefix *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetObjectFilterPrefix(objectFilterPrefix)
	return o
}

// SetObjectFilterPrefix adds the objectFilterPrefix to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetObjectFilterPrefix(objectFilterPrefix *string) {
	o.ObjectFilterPrefix = objectFilterPrefix
}

// WithObjectFilterSizeGreaterThan adds the objectFilterSizeGreaterThan to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan)
	return o
}

// SetObjectFilterSizeGreaterThan adds the objectFilterSizeGreaterThan to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetObjectFilterSizeGreaterThan(objectFilterSizeGreaterThan *int64) {
	o.ObjectFilterSizeGreaterThan = objectFilterSizeGreaterThan
}

// WithObjectFilterSizeLessThan adds the objectFilterSizeLessThan to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithObjectFilterSizeLessThan(objectFilterSizeLessThan *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetObjectFilterSizeLessThan(objectFilterSizeLessThan)
	return o
}

// SetObjectFilterSizeLessThan adds the objectFilterSizeLessThan to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetObjectFilterSizeLessThan(objectFilterSizeLessThan *int64) {
	o.ObjectFilterSizeLessThan = objectFilterSizeLessThan
}

// WithObjectFilterTags adds the objectFilterTags to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithObjectFilterTags(objectFilterTags *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetObjectFilterTags(objectFilterTags)
	return o
}

// SetObjectFilterTags adds the objectFilterTags to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetObjectFilterTags(objectFilterTags *string) {
	o.ObjectFilterTags = objectFilterTags
}

// WithReturnRecords adds the returnRecords to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithS3BucketUUID adds the s3BucketUUID to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithS3BucketUUID(s3BucketUUID string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetS3BucketUUID(s3BucketUUID)
	return o
}

// SetS3BucketUUID adds the s3BucketUuid to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetS3BucketUUID(s3BucketUUID string) {
	o.S3BucketUUID = s3BucketUUID
}

// WithSerialRecords adds the serialRecords to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithSvmName(svmName *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithSvmUUID(svmUUID string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WithUUID(uuid *string) *S3BucketLifecycleRuleDeleteCollectionParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket lifecycle rule delete collection params
func (o *S3BucketLifecycleRuleDeleteCollectionParams) SetUUID(uuid *string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketLifecycleRuleDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.AbortIncompleteMultipartUploadAfterInitiationDays != nil {

		// query param abort_incomplete_multipart_upload.after_initiation_days
		var qrAbortIncompleteMultipartUploadAfterInitiationDays int64

		if o.AbortIncompleteMultipartUploadAfterInitiationDays != nil {
			qrAbortIncompleteMultipartUploadAfterInitiationDays = *o.AbortIncompleteMultipartUploadAfterInitiationDays
		}
		qAbortIncompleteMultipartUploadAfterInitiationDays := swag.FormatInt64(qrAbortIncompleteMultipartUploadAfterInitiationDays)
		if qAbortIncompleteMultipartUploadAfterInitiationDays != "" {

			if err := r.SetQueryParam("abort_incomplete_multipart_upload.after_initiation_days", qAbortIncompleteMultipartUploadAfterInitiationDays); err != nil {
				return err
			}
		}
	}

	if o.BucketName != nil {

		// query param bucket_name
		var qrBucketName string

		if o.BucketName != nil {
			qrBucketName = *o.BucketName
		}
		qBucketName := qrBucketName
		if qBucketName != "" {

			if err := r.SetQueryParam("bucket_name", qBucketName); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.ExpirationExpiredObjectDeleteMarker != nil {

		// query param expiration.expired_object_delete_marker
		var qrExpirationExpiredObjectDeleteMarker bool

		if o.ExpirationExpiredObjectDeleteMarker != nil {
			qrExpirationExpiredObjectDeleteMarker = *o.ExpirationExpiredObjectDeleteMarker
		}
		qExpirationExpiredObjectDeleteMarker := swag.FormatBool(qrExpirationExpiredObjectDeleteMarker)
		if qExpirationExpiredObjectDeleteMarker != "" {

			if err := r.SetQueryParam("expiration.expired_object_delete_marker", qExpirationExpiredObjectDeleteMarker); err != nil {
				return err
			}
		}
	}

	if o.ExpirationObjectAgeDays != nil {

		// query param expiration.object_age_days
		var qrExpirationObjectAgeDays int64

		if o.ExpirationObjectAgeDays != nil {
			qrExpirationObjectAgeDays = *o.ExpirationObjectAgeDays
		}
		qExpirationObjectAgeDays := swag.FormatInt64(qrExpirationObjectAgeDays)
		if qExpirationObjectAgeDays != "" {

			if err := r.SetQueryParam("expiration.object_age_days", qExpirationObjectAgeDays); err != nil {
				return err
			}
		}
	}

	if o.ExpirationObjectExpiryDate != nil {

		// query param expiration.object_expiry_date
		var qrExpirationObjectExpiryDate string

		if o.ExpirationObjectExpiryDate != nil {
			qrExpirationObjectExpiryDate = *o.ExpirationObjectExpiryDate
		}
		qExpirationObjectExpiryDate := qrExpirationObjectExpiryDate
		if qExpirationObjectExpiryDate != "" {

			if err := r.SetQueryParam("expiration.object_expiry_date", qExpirationObjectExpiryDate); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.NonCurrentVersionExpirationNewNonCurrentVersions != nil {

		// query param non_current_version_expiration.new_non_current_versions
		var qrNonCurrentVersionExpirationNewNonCurrentVersions int64

		if o.NonCurrentVersionExpirationNewNonCurrentVersions != nil {
			qrNonCurrentVersionExpirationNewNonCurrentVersions = *o.NonCurrentVersionExpirationNewNonCurrentVersions
		}
		qNonCurrentVersionExpirationNewNonCurrentVersions := swag.FormatInt64(qrNonCurrentVersionExpirationNewNonCurrentVersions)
		if qNonCurrentVersionExpirationNewNonCurrentVersions != "" {

			if err := r.SetQueryParam("non_current_version_expiration.new_non_current_versions", qNonCurrentVersionExpirationNewNonCurrentVersions); err != nil {
				return err
			}
		}
	}

	if o.NonCurrentVersionExpirationNonCurrentDays != nil {

		// query param non_current_version_expiration.non_current_days
		var qrNonCurrentVersionExpirationNonCurrentDays int64

		if o.NonCurrentVersionExpirationNonCurrentDays != nil {
			qrNonCurrentVersionExpirationNonCurrentDays = *o.NonCurrentVersionExpirationNonCurrentDays
		}
		qNonCurrentVersionExpirationNonCurrentDays := swag.FormatInt64(qrNonCurrentVersionExpirationNonCurrentDays)
		if qNonCurrentVersionExpirationNonCurrentDays != "" {

			if err := r.SetQueryParam("non_current_version_expiration.non_current_days", qNonCurrentVersionExpirationNonCurrentDays); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterPrefix != nil {

		// query param object_filter.prefix
		var qrObjectFilterPrefix string

		if o.ObjectFilterPrefix != nil {
			qrObjectFilterPrefix = *o.ObjectFilterPrefix
		}
		qObjectFilterPrefix := qrObjectFilterPrefix
		if qObjectFilterPrefix != "" {

			if err := r.SetQueryParam("object_filter.prefix", qObjectFilterPrefix); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterSizeGreaterThan != nil {

		// query param object_filter.size_greater_than
		var qrObjectFilterSizeGreaterThan int64

		if o.ObjectFilterSizeGreaterThan != nil {
			qrObjectFilterSizeGreaterThan = *o.ObjectFilterSizeGreaterThan
		}
		qObjectFilterSizeGreaterThan := swag.FormatInt64(qrObjectFilterSizeGreaterThan)
		if qObjectFilterSizeGreaterThan != "" {

			if err := r.SetQueryParam("object_filter.size_greater_than", qObjectFilterSizeGreaterThan); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterSizeLessThan != nil {

		// query param object_filter.size_less_than
		var qrObjectFilterSizeLessThan int64

		if o.ObjectFilterSizeLessThan != nil {
			qrObjectFilterSizeLessThan = *o.ObjectFilterSizeLessThan
		}
		qObjectFilterSizeLessThan := swag.FormatInt64(qrObjectFilterSizeLessThan)
		if qObjectFilterSizeLessThan != "" {

			if err := r.SetQueryParam("object_filter.size_less_than", qObjectFilterSizeLessThan); err != nil {
				return err
			}
		}
	}

	if o.ObjectFilterTags != nil {

		// query param object_filter.tags
		var qrObjectFilterTags string

		if o.ObjectFilterTags != nil {
			qrObjectFilterTags = *o.ObjectFilterTags
		}
		qObjectFilterTags := qrObjectFilterTags
		if qObjectFilterTags != "" {

			if err := r.SetQueryParam("object_filter.tags", qObjectFilterTags); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param s3_bucket.uuid
	if err := r.SetPathParam("s3_bucket.uuid", o.S3BucketUUID); err != nil {
		return err
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UUID != nil {

		// query param uuid
		var qrUUID string

		if o.UUID != nil {
			qrUUID = *o.UUID
		}
		qUUID := qrUUID
		if qUUID != "" {

			if err := r.SetQueryParam("uuid", qUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
