// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketLifecycleRuleDeleteCollectionReader is a Reader for the S3BucketLifecycleRuleDeleteCollection structure.
type S3BucketLifecycleRuleDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketLifecycleRuleDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketLifecycleRuleDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketLifecycleRuleDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketLifecycleRuleDeleteCollectionOK creates a S3BucketLifecycleRuleDeleteCollectionOK with default headers values
func NewS3BucketLifecycleRuleDeleteCollectionOK() *S3BucketLifecycleRuleDeleteCollectionOK {
	return &S3BucketLifecycleRuleDeleteCollectionOK{}
}

/*
S3BucketLifecycleRuleDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketLifecycleRuleDeleteCollectionOK struct {
}

// IsSuccess returns true when this s3 bucket lifecycle rule delete collection o k response has a 2xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket lifecycle rule delete collection o k response has a 3xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket lifecycle rule delete collection o k response has a 4xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket lifecycle rule delete collection o k response has a 5xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket lifecycle rule delete collection o k response a status code equal to that given
func (o *S3BucketLifecycleRuleDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket lifecycle rule delete collection o k response
func (o *S3BucketLifecycleRuleDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3BucketLifecycleRuleDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleDeleteCollectionOK", 200)
}

func (o *S3BucketLifecycleRuleDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleDeleteCollectionOK", 200)
}

func (o *S3BucketLifecycleRuleDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3BucketLifecycleRuleDeleteCollectionDefault creates a S3BucketLifecycleRuleDeleteCollectionDefault with default headers values
func NewS3BucketLifecycleRuleDeleteCollectionDefault(code int) *S3BucketLifecycleRuleDeleteCollectionDefault {
	return &S3BucketLifecycleRuleDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketLifecycleRuleDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92406139   | "Lifecycle Management rule for bucket in Vserver with action is a stale entry. Contact technical support for assistance.";
*/
type S3BucketLifecycleRuleDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket lifecycle rule delete collection default response has a 2xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket lifecycle rule delete collection default response has a 3xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket lifecycle rule delete collection default response has a 4xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket lifecycle rule delete collection default response has a 5xx status code
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket lifecycle rule delete collection default response a status code equal to that given
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket lifecycle rule delete collection default response
func (o *S3BucketLifecycleRuleDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketLifecycleRuleDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3_bucket_lifecycle_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3_bucket_lifecycle_rule_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketLifecycleRuleDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketLifecycleRuleDeleteCollectionBody s3 bucket lifecycle rule delete collection body
swagger:model S3BucketLifecycleRuleDeleteCollectionBody
*/
type S3BucketLifecycleRuleDeleteCollectionBody struct {

	// s3 bucket lifecycle rule response inline records
	S3BucketLifecycleRuleResponseInlineRecords []*models.S3BucketLifecycleRule `json:"records,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule delete collection body
func (o *S3BucketLifecycleRuleDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3BucketLifecycleRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleDeleteCollectionBody) validateS3BucketLifecycleRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketLifecycleRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketLifecycleRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketLifecycleRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketLifecycleRuleResponseInlineRecords[i] != nil {
			if err := o.S3BucketLifecycleRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule delete collection body based on the context it is used
func (o *S3BucketLifecycleRuleDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3BucketLifecycleRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleDeleteCollectionBody) contextValidateS3BucketLifecycleRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketLifecycleRuleResponseInlineRecords); i++ {

		if o.S3BucketLifecycleRuleResponseInlineRecords[i] != nil {
			if err := o.S3BucketLifecycleRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
