// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewS3BucketLifecycleRuleDeleteParams creates a new S3BucketLifecycleRuleDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketLifecycleRuleDeleteParams() *S3BucketLifecycleRuleDeleteParams {
	return &S3BucketLifecycleRuleDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketLifecycleRuleDeleteParamsWithTimeout creates a new S3BucketLifecycleRuleDeleteParams object
// with the ability to set a timeout on a request.
func NewS3BucketLifecycleRuleDeleteParamsWithTimeout(timeout time.Duration) *S3BucketLifecycleRuleDeleteParams {
	return &S3BucketLifecycleRuleDeleteParams{
		timeout: timeout,
	}
}

// NewS3BucketLifecycleRuleDeleteParamsWithContext creates a new S3BucketLifecycleRuleDeleteParams object
// with the ability to set a context for a request.
func NewS3BucketLifecycleRuleDeleteParamsWithContext(ctx context.Context) *S3BucketLifecycleRuleDeleteParams {
	return &S3BucketLifecycleRuleDeleteParams{
		Context: ctx,
	}
}

// NewS3BucketLifecycleRuleDeleteParamsWithHTTPClient creates a new S3BucketLifecycleRuleDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketLifecycleRuleDeleteParamsWithHTTPClient(client *http.Client) *S3BucketLifecycleRuleDeleteParams {
	return &S3BucketLifecycleRuleDeleteParams{
		HTTPClient: client,
	}
}

/*
S3BucketLifecycleRuleDeleteParams contains all the parameters to send to the API endpoint

	for the s3 bucket lifecycle rule delete operation.

	Typically these are written to a http.Request.
*/
type S3BucketLifecycleRuleDeleteParams struct {

	/* Name.

	   The unique identifier of the bucket lifecycle_management rule.
	*/
	Name string

	/* S3BucketUUID.

	   The unique identifier of the bucket.
	*/
	S3BucketUUID string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket lifecycle rule delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleDeleteParams) WithDefaults() *S3BucketLifecycleRuleDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket lifecycle rule delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketLifecycleRuleDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithTimeout(timeout time.Duration) *S3BucketLifecycleRuleDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithContext(ctx context.Context) *S3BucketLifecycleRuleDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithHTTPClient(client *http.Client) *S3BucketLifecycleRuleDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithName(name string) *S3BucketLifecycleRuleDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetName(name string) {
	o.Name = name
}

// WithS3BucketUUID adds the s3BucketUUID to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithS3BucketUUID(s3BucketUUID string) *S3BucketLifecycleRuleDeleteParams {
	o.SetS3BucketUUID(s3BucketUUID)
	return o
}

// SetS3BucketUUID adds the s3BucketUuid to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetS3BucketUUID(s3BucketUUID string) {
	o.S3BucketUUID = s3BucketUUID
}

// WithSvmUUID adds the svmUUID to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) WithSvmUUID(svmUUID string) *S3BucketLifecycleRuleDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket lifecycle rule delete params
func (o *S3BucketLifecycleRuleDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketLifecycleRuleDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param s3_bucket.uuid
	if err := r.SetPathParam("s3_bucket.uuid", o.S3BucketUUID); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
