// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketLifecycleRuleGetReader is a Reader for the S3BucketLifecycleRuleGet structure.
type S3BucketLifecycleRuleGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketLifecycleRuleGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketLifecycleRuleGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketLifecycleRuleGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketLifecycleRuleGetOK creates a S3BucketLifecycleRuleGetOK with default headers values
func NewS3BucketLifecycleRuleGetOK() *S3BucketLifecycleRuleGetOK {
	return &S3BucketLifecycleRuleGetOK{}
}

/*
S3BucketLifecycleRuleGetOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketLifecycleRuleGetOK struct {
	Payload *models.S3BucketLifecycleRule
}

// IsSuccess returns true when this s3 bucket lifecycle rule get o k response has a 2xx status code
func (o *S3BucketLifecycleRuleGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket lifecycle rule get o k response has a 3xx status code
func (o *S3BucketLifecycleRuleGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket lifecycle rule get o k response has a 4xx status code
func (o *S3BucketLifecycleRuleGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket lifecycle rule get o k response has a 5xx status code
func (o *S3BucketLifecycleRuleGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket lifecycle rule get o k response a status code equal to that given
func (o *S3BucketLifecycleRuleGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket lifecycle rule get o k response
func (o *S3BucketLifecycleRuleGetOK) Code() int {
	return 200
}

func (o *S3BucketLifecycleRuleGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}][%d] s3BucketLifecycleRuleGetOK %s", 200, payload)
}

func (o *S3BucketLifecycleRuleGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}][%d] s3BucketLifecycleRuleGetOK %s", 200, payload)
}

func (o *S3BucketLifecycleRuleGetOK) GetPayload() *models.S3BucketLifecycleRule {
	return o.Payload
}

func (o *S3BucketLifecycleRuleGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketLifecycleRule)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketLifecycleRuleGetDefault creates a S3BucketLifecycleRuleGetDefault with default headers values
func NewS3BucketLifecycleRuleGetDefault(code int) *S3BucketLifecycleRuleGetDefault {
	return &S3BucketLifecycleRuleGetDefault{
		_statusCode: code,
	}
}

/*
S3BucketLifecycleRuleGetDefault describes a response with status code -1, with default header values.

Error
*/
type S3BucketLifecycleRuleGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket lifecycle rule get default response has a 2xx status code
func (o *S3BucketLifecycleRuleGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket lifecycle rule get default response has a 3xx status code
func (o *S3BucketLifecycleRuleGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket lifecycle rule get default response has a 4xx status code
func (o *S3BucketLifecycleRuleGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket lifecycle rule get default response has a 5xx status code
func (o *S3BucketLifecycleRuleGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket lifecycle rule get default response a status code equal to that given
func (o *S3BucketLifecycleRuleGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket lifecycle rule get default response
func (o *S3BucketLifecycleRuleGetDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketLifecycleRuleGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}][%d] s3_bucket_lifecycle_rule_get default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules/{name}][%d] s3_bucket_lifecycle_rule_get default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketLifecycleRuleGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
