// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketLifecycleRuleModifyCollectionReader is a Reader for the S3BucketLifecycleRuleModifyCollection structure.
type S3BucketLifecycleRuleModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketLifecycleRuleModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketLifecycleRuleModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3BucketLifecycleRuleModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketLifecycleRuleModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketLifecycleRuleModifyCollectionOK creates a S3BucketLifecycleRuleModifyCollectionOK with default headers values
func NewS3BucketLifecycleRuleModifyCollectionOK() *S3BucketLifecycleRuleModifyCollectionOK {
	return &S3BucketLifecycleRuleModifyCollectionOK{}
}

/*
S3BucketLifecycleRuleModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketLifecycleRuleModifyCollectionOK struct {
	Payload *models.S3BucketLifecycleRuleResponse
}

// IsSuccess returns true when this s3 bucket lifecycle rule modify collection o k response has a 2xx status code
func (o *S3BucketLifecycleRuleModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket lifecycle rule modify collection o k response has a 3xx status code
func (o *S3BucketLifecycleRuleModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket lifecycle rule modify collection o k response has a 4xx status code
func (o *S3BucketLifecycleRuleModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket lifecycle rule modify collection o k response has a 5xx status code
func (o *S3BucketLifecycleRuleModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket lifecycle rule modify collection o k response a status code equal to that given
func (o *S3BucketLifecycleRuleModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket lifecycle rule modify collection o k response
func (o *S3BucketLifecycleRuleModifyCollectionOK) Code() int {
	return 200
}

func (o *S3BucketLifecycleRuleModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionOK) GetPayload() *models.S3BucketLifecycleRuleResponse {
	return o.Payload
}

func (o *S3BucketLifecycleRuleModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketLifecycleRuleResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketLifecycleRuleModifyCollectionAccepted creates a S3BucketLifecycleRuleModifyCollectionAccepted with default headers values
func NewS3BucketLifecycleRuleModifyCollectionAccepted() *S3BucketLifecycleRuleModifyCollectionAccepted {
	return &S3BucketLifecycleRuleModifyCollectionAccepted{}
}

/*
S3BucketLifecycleRuleModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3BucketLifecycleRuleModifyCollectionAccepted struct {
	Payload *models.S3BucketLifecycleRuleJobLinkResponse
}

// IsSuccess returns true when this s3 bucket lifecycle rule modify collection accepted response has a 2xx status code
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket lifecycle rule modify collection accepted response has a 3xx status code
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket lifecycle rule modify collection accepted response has a 4xx status code
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket lifecycle rule modify collection accepted response has a 5xx status code
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket lifecycle rule modify collection accepted response a status code equal to that given
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 bucket lifecycle rule modify collection accepted response
func (o *S3BucketLifecycleRuleModifyCollectionAccepted) Code() int {
	return 202
}

func (o *S3BucketLifecycleRuleModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3BucketLifecycleRuleModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionAccepted) GetPayload() *models.S3BucketLifecycleRuleJobLinkResponse {
	return o.Payload
}

func (o *S3BucketLifecycleRuleModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketLifecycleRuleJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketLifecycleRuleModifyCollectionDefault creates a S3BucketLifecycleRuleModifyCollectionDefault with default headers values
func NewS3BucketLifecycleRuleModifyCollectionDefault(code int) *S3BucketLifecycleRuleModifyCollectionDefault {
	return &S3BucketLifecycleRuleModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketLifecycleRuleModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92406114   | "The Expiration action requires specifying either object_expiry_date, object_age_days or expired_object_delete_marker.";
| 92406115   | "The NonCurrentVersionExpiration action requires either new_non_current_versions or non_current_days.";
| 92406116   | "The AbortIncompleteMultipartUpload action requires after_initiation_days.";
| 92406117   | "The \"Expiration\" action cannot have both an expiry date and an age.";
| 92406118   | "Using Lifecycle Management rules requires an effective cluster version of 9.13.1 .";
| 92406122   | "\"expired_object_delete_marker\" cannot be specified with \"object_age_days\" or \"object_expiry_date\".";
| 92406131   | "Lifecycle Management rule \"testcheck2\" for bucket \"testbuck1\" in SVM \"vs0\" cannot be created because \"non_current_days\" must be specified along with \"new_non_current_versions\".";
| 92406132   | "Lifecycle Management rule \"<rule>\" for bucket \"<bucket>\" in SVM \"<SVM>\" requires \"object_age_days\" to be greater than zero.";
| 92406132   | "Lifecycle Management rule \"<rule>\" for bucket \"<bucket>\" in SVM \"<SVM>\" requires \"new_non_current_versions\" to be greater than zero.";
| 92406132   | "Lifecycle Management rule \"<rule>\" for bucket \"<bucket>\" in SVM \"<SVM>\" requires \"after_initiation_days\" to be greater than zero.";
| 92406133   | "Lifecycle Management rule for bucket in Vserver is invalid. The object_expiry_date must be later than January 1, 1970.";
| 92406135   | "MetroCluster is configured on cluster. Object Expiration is not supported in a MetroCluster configuration.";
| 92406136   | "Lifecycle Management rule \"rule1\" for bucket \"buck1\" in SVM \"vs0\" is invalid. The \"object_expiry_date\" must be at midnight GMT.";
| 92406139   | "Lifecycle Management rule for bucket in Vserver with action is a stale entry. Contact technical support for assistance.";
| 92406142   | "Lifecycle Management rule \"rule1\" for bucket \"buck1\" in SVM \"vs0\" with action \"Expiration\" cannot have \"expired_object_delete_marker\" disabled. To disable \"expired_object_delete_marker\", run the \"vserver object-store-server bucket lifecycle-management-rule delete\" command.";
| 92406146   | "Lifecycle Management rule \"rule1\" for bucket \"buck1\" in SVM \"vs0\" already exists. Delete the rule and then try the operation again.";
| 92406148   | "Lifecycle Management rule \"rule1\" for bucket \"buck1\" in SVM \"vs0\" cannot have \"new_non_current_versions\" more than 100.";
| 92406149   | "Lifecycle Management rule \"rule1\" for bucket \"buck1\" in SVM \"vs0\" requires an action to be specified. Retry the operation after adding an action.";
*/
type S3BucketLifecycleRuleModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket lifecycle rule modify collection default response has a 2xx status code
func (o *S3BucketLifecycleRuleModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket lifecycle rule modify collection default response has a 3xx status code
func (o *S3BucketLifecycleRuleModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket lifecycle rule modify collection default response has a 4xx status code
func (o *S3BucketLifecycleRuleModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket lifecycle rule modify collection default response has a 5xx status code
func (o *S3BucketLifecycleRuleModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket lifecycle rule modify collection default response a status code equal to that given
func (o *S3BucketLifecycleRuleModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket lifecycle rule modify collection default response
func (o *S3BucketLifecycleRuleModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketLifecycleRuleModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3_bucket_lifecycle_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/rules][%d] s3_bucket_lifecycle_rule_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketLifecycleRuleModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketLifecycleRuleModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketLifecycleRuleModifyCollectionBody s3 bucket lifecycle rule modify collection body
swagger:model S3BucketLifecycleRuleModifyCollectionBody
*/
type S3BucketLifecycleRuleModifyCollectionBody struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineLinks `json:"_links,omitempty"`

	// abort incomplete multipart upload
	AbortIncompleteMultipartUpload *models.S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload `json:"abort_incomplete_multipart_upload,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	BucketName *string `json:"bucket_name,omitempty"`

	// Specifies whether or not the associated rule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// expiration
	Expiration *models.S3BucketLifecycleRuleInlineExpiration `json:"expiration,omitempty"`

	// Bucket lifecycle management rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	Name *string `json:"name,omitempty"`

	// non current version expiration
	NonCurrentVersionExpiration *models.S3BucketLifecycleRuleInlineNonCurrentVersionExpiration `json:"non_current_version_expiration,omitempty"`

	// object filter
	ObjectFilter *models.S3BucketLifecycleRuleInlineObjectFilter `json:"object_filter,omitempty"`

	// s3 bucket lifecycle rule response inline records
	S3BucketLifecycleRuleResponseInlineRecords []*models.S3BucketLifecycleRule `json:"records,omitempty"`

	// svm
	Svm *models.S3BucketLifecycleRuleInlineSvm `json:"svm,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule modify collection body
func (o *S3BucketLifecycleRuleModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAbortIncompleteMultipartUpload(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNonCurrentVersionExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3BucketLifecycleRuleResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateAbortIncompleteMultipartUpload(formats strfmt.Registry) error {
	if swag.IsZero(o.AbortIncompleteMultipartUpload) { // not required
		return nil
	}

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateBucketName(formats strfmt.Registry) error {
	if swag.IsZero(o.BucketName) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"bucket_name", "body", *o.BucketName, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"bucket_name", "body", *o.BucketName, 63); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.Expiration) { // not required
		return nil
	}

	if o.Expiration != nil {
		if err := o.Expiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateNonCurrentVersionExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.NonCurrentVersionExpiration) { // not required
		return nil
	}

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateObjectFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectFilter) { // not required
		return nil
	}

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateS3BucketLifecycleRuleResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketLifecycleRuleResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketLifecycleRuleResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketLifecycleRuleResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketLifecycleRuleResponseInlineRecords[i] != nil {
			if err := o.S3BucketLifecycleRuleResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule modify collection body based on the context it is used
func (o *S3BucketLifecycleRuleModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAbortIncompleteMultipartUpload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNonCurrentVersionExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateObjectFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3BucketLifecycleRuleResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateAbortIncompleteMultipartUpload(ctx context.Context, formats strfmt.Registry) error {

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.Expiration != nil {
		if err := o.Expiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateNonCurrentVersionExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateObjectFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateS3BucketLifecycleRuleResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketLifecycleRuleResponseInlineRecords); i++ {

		if o.S3BucketLifecycleRuleResponseInlineRecords[i] != nil {
			if err := o.S3BucketLifecycleRuleResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineLinks s3 bucket lifecycle rule inline links
swagger:model s3_bucket_lifecycle_rule_inline__links
*/
type S3BucketLifecycleRuleInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline links
func (o *S3BucketLifecycleRuleInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload Specifies a way to perform abort_incomplete_multipart_upload action on filtered objects within a bucket. It cannot be specified with tags.
swagger:model s3_bucket_lifecycle_rule_inline_abort_incomplete_multipart_upload
*/
type S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks `json:"_links,omitempty"`

	// Number of days of initiation after which uploads can be aborted.
	AfterInitiationDays *int64 `json:"after_initiation_days,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline abort incomplete multipart upload
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline abort incomplete multipart upload based on the context it is used
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineAbortIncompleteMultipartUpload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks s3 bucket lifecycle rule inline abort incomplete multipart upload inline links
swagger:model s3_bucket_lifecycle_rule_inline_abort_incomplete_multipart_upload_inline__links
*/
type S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline abort incomplete multipart upload inline links
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline abort incomplete multipart upload inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineAbortIncompleteMultipartUploadInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineExpiration Specifies a way to perform expiration action on filtered objects within a bucket.
swagger:model s3_bucket_lifecycle_rule_inline_expiration
*/
type S3BucketLifecycleRuleInlineExpiration struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineExpirationInlineLinks `json:"_links,omitempty"`

	// Cleanup object delete markers.
	ExpiredObjectDeleteMarker *bool `json:"expired_object_delete_marker,omitempty"`

	// Number of days since creation after which objects can be deleted. This cannot be used along with object_expiry_date.
	// Example: 100
	ObjectAgeDays *int64 `json:"object_age_days,omitempty"`

	// Specific date from when objects can expire. This cannot be used with object_age_days.
	// Example: 2039-09-23 00:00:00+00:00
	// Format: date-time
	ObjectExpiryDate *strfmt.DateTime `json:"object_expiry_date,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline expiration
func (o *S3BucketLifecycleRuleInlineExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectExpiryDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketLifecycleRuleInlineExpiration) validateObjectExpiryDate(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectExpiryDate) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"expiration"+"."+"object_expiry_date", "body", "date-time", o.ObjectExpiryDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline expiration based on the context it is used
func (o *S3BucketLifecycleRuleInlineExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineExpiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineExpirationInlineLinks s3 bucket lifecycle rule inline expiration inline links
swagger:model s3_bucket_lifecycle_rule_inline_expiration_inline__links
*/
type S3BucketLifecycleRuleInlineExpirationInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline expiration inline links
func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline expiration inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineExpirationInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineExpirationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineNonCurrentVersionExpiration Specifies a way to perform non_current_version_expiration action on filtered objects within a bucket.
swagger:model s3_bucket_lifecycle_rule_inline_non_current_version_expiration
*/
type S3BucketLifecycleRuleInlineNonCurrentVersionExpiration struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks `json:"_links,omitempty"`

	// Number of latest non-current versions to be retained.
	NewNonCurrentVersions *int64 `json:"new_non_current_versions,omitempty"`

	// Number of days after which non-current versions can be deleted.
	NonCurrentDays *int64 `json:"non_current_days,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline non current version expiration
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline non current version expiration based on the context it is used
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineNonCurrentVersionExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks s3 bucket lifecycle rule inline non current version expiration inline links
swagger:model s3_bucket_lifecycle_rule_inline_non_current_version_expiration_inline__links
*/
type S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline non current version expiration inline links
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline non current version expiration inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineNonCurrentVersionExpirationInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineObjectFilter Specifies a way to filter objects within a bucket.
swagger:model s3_bucket_lifecycle_rule_inline_object_filter
*/
type S3BucketLifecycleRuleInlineObjectFilter struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineObjectFilterInlineLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	Tags []*string `json:"tags,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline object filter
func (o *S3BucketLifecycleRuleInlineObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline object filter based on the context it is used
func (o *S3BucketLifecycleRuleInlineObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineObjectFilter) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineObjectFilterInlineLinks s3 bucket lifecycle rule inline object filter inline links
swagger:model s3_bucket_lifecycle_rule_inline_object_filter_inline__links
*/
type S3BucketLifecycleRuleInlineObjectFilterInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline object filter inline links
func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline object filter inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineObjectFilterInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineObjectFilterInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineSvm Specifies the name of the SVM where this bucket exists.
swagger:model s3_bucket_lifecycle_rule_inline_svm
*/
type S3BucketLifecycleRuleInlineSvm struct {

	// links
	Links *models.S3BucketLifecycleRuleInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline svm
func (o *S3BucketLifecycleRuleInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline svm based on the context it is used
func (o *S3BucketLifecycleRuleInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketLifecycleRuleInlineSvmInlineLinks s3 bucket lifecycle rule inline svm inline links
swagger:model s3_bucket_lifecycle_rule_inline_svm_inline__links
*/
type S3BucketLifecycleRuleInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket lifecycle rule inline svm inline links
func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket lifecycle rule inline svm inline links based on the context it is used
func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketLifecycleRuleInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketLifecycleRuleInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
