// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketModifyCollectionReader is a Reader for the S3BucketModifyCollection structure.
type S3BucketModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3BucketModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketModifyCollectionOK creates a S3BucketModifyCollectionOK with default headers values
func NewS3BucketModifyCollectionOK() *S3BucketModifyCollectionOK {
	return &S3BucketModifyCollectionOK{}
}

/*
S3BucketModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketModifyCollectionOK struct {
	Payload *models.S3BucketJobLinkResponse
}

// IsSuccess returns true when this s3 bucket modify collection o k response has a 2xx status code
func (o *S3BucketModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket modify collection o k response has a 3xx status code
func (o *S3BucketModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket modify collection o k response has a 4xx status code
func (o *S3BucketModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket modify collection o k response has a 5xx status code
func (o *S3BucketModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket modify collection o k response a status code equal to that given
func (o *S3BucketModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket modify collection o k response
func (o *S3BucketModifyCollectionOK) Code() int {
	return 200
}

func (o *S3BucketModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3BucketModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3BucketModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketModifyCollectionOK) GetPayload() *models.S3BucketJobLinkResponse {
	return o.Payload
}

func (o *S3BucketModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketModifyCollectionAccepted creates a S3BucketModifyCollectionAccepted with default headers values
func NewS3BucketModifyCollectionAccepted() *S3BucketModifyCollectionAccepted {
	return &S3BucketModifyCollectionAccepted{}
}

/*
S3BucketModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3BucketModifyCollectionAccepted struct {
	Payload *models.S3BucketJobLinkResponse
}

// IsSuccess returns true when this s3 bucket modify collection accepted response has a 2xx status code
func (o *S3BucketModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket modify collection accepted response has a 3xx status code
func (o *S3BucketModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket modify collection accepted response has a 4xx status code
func (o *S3BucketModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket modify collection accepted response has a 5xx status code
func (o *S3BucketModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket modify collection accepted response a status code equal to that given
func (o *S3BucketModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 bucket modify collection accepted response
func (o *S3BucketModifyCollectionAccepted) Code() int {
	return 202
}

func (o *S3BucketModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3BucketModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3BucketModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketModifyCollectionAccepted) GetPayload() *models.S3BucketJobLinkResponse {
	return o.Payload
}

func (o *S3BucketModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketModifyCollectionDefault creates a S3BucketModifyCollectionDefault with default headers values
func NewS3BucketModifyCollectionDefault(code int) *S3BucketModifyCollectionDefault {
	return &S3BucketModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405778   | "Failed to modify bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Reason: {Reason for failure}. ";
| 92405846   | "Failed to modify the object store volume. Reason: {Reason for failure}.";
| 92405811   | "Failed to modify bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Wait a few minutes and try the operation again.";
| 92405858   | "Failed to \\\"modify\\\" the \\\"bucket\\\" because the operation is only supported on data SVMs.";
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92405863   | "An error occurs when creating an access policy. The reason for failure is detailed in the error message.";
| 92405864   | "An error occurs when deleting an access policy. The reason for failure is detailed in the error message.";
| 92405891   | "The resources specified in the access policy are not valid. Valid ways to specify a resource are \\\"*\\\", \\\"<bucket-name>\\\", \\\"<bucket-name>/.../...\\\". Valid characters for a resource are 0-9, A-Z, a-z, \\\"_\\\", \\\"+\\\", \\\",\\\", \\\";\\\", \\\":\\\", \\\";\\\", \\\"=\\\", \\\".\\\", \\\"&\\\", \\\"@\\\", \\\"?\\\", \\\"(\\\", \\\")\\\", \\\"'\\\", \\\"*\\\", \\\"!\\\", \\\"-\\\" and \\\"\\$\\\".";
| 92405894   | "Statements, principals and resources list can have a maximum of 10 entries.";
| 92405897   | "The principals specified in the access policy are not in the correct format. User name must be between 1 and 64 characters. Valid characters for a user name are 0-9, A-Z, a-z, \\\"_\\\", \\\"+\\\", \\\"=\\\", \\\",\\\", \\\".\\\", \\\"@\\\", and \\\"-\\\". ";
| 92405898   | "The SID specified in the access policy is not valid.";
| 92406014   | "Failed to modify event selector for bucket \\\"{bucket name}\\\". If the value of either access or permission is set to none, they both must be set to none.";
| 92733458   | "[Job job number] Job failed: Failed to modify bucket "s3bucket1" for SVM "vs1". Reason: {Reason for failure}. ";
| 8454236    | "Could not assign qtree "qtree1" to QoS policy group "group1". Invalid QoS policy group specified "group1". The specified QoS policy group has a min-throughput value set, and the workload being assigned resides on a platform that does not support min-throughput or the cluster is in a mixed version state and the effective cluster version of ONTAP does not support min-throughput on this platform.";
| 8454323    | "Policy group with UUID "23bwegew-8eqg-121r-bjad-0050e628wq732" does not exist."
| 92406230   | "The value for \\\"retention.default_period\\\" parameter for object store bucket \\\"<bucket>\\\" cannot be greater than the maximum lock retention period set in the object store server for SVM \\\"<SVM>\\\". Check the maximum allowed lock retention period present in the object store server for SVM \\\"<SVM>\\\" and try the operation again.";
| 92406236   | "The value for \\\"retention.default_period\\\" parameter for object store bucket \\\"<bucket>\\\" cannot be less than the minimum lock retention period set in the object store server for SVM \\\"<SVM>\\\". Check the minimum allowed lock retention period present in the object store server for SVM \\\"<SVM>\\\" and try the operation again.";
| 92406217   | "The specified \"allowed_headers\" is not valid because it contains more than one wild card (\"*\") character.";
| 92406224   | "A Cross-Origin Resource Sharing (CORS) rule must have an origin and HTTP method specified.";
| 92406222   | "Cannot specify Cross-Origin Resource Sharing (CORS) configuration for object store bucket \\\"<bucket>\\\" on SVM \\\"<SVM>\\\". Specifying such configuration is supported on object store volumes created in ONTAP 9.8 or later releases only.";
| 92406211   | "The specified method \"DONE\" is not valid. Valid methods are GET, PUT, DELETE, HEAD, and POST.";
| 92405863   | "Failed to create CORS rules for bucket \"bb1\". Reason: \"Field \"index\" cannot be specified for this operation.\". Resolve all the issues and retry the operation.";
| 92406228   | "Cannot exceed the maximum limit of 100 Cross-Origin Resource Sharing (CORS) rules per S3 bucket \\\"<bucket>\\\" in SVM \\\"<SVM>\\\".";;
*/
type S3BucketModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket modify collection default response has a 2xx status code
func (o *S3BucketModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket modify collection default response has a 3xx status code
func (o *S3BucketModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket modify collection default response has a 4xx status code
func (o *S3BucketModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket modify collection default response has a 5xx status code
func (o *S3BucketModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket modify collection default response a status code equal to that given
func (o *S3BucketModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket modify collection default response
func (o *S3BucketModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3_bucket_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/buckets][%d] s3_bucket_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketModifyCollectionBody s3 bucket modify collection body
swagger:model S3BucketModifyCollectionBody
*/
type S3BucketModifyCollectionBody struct {

	// If this is set to true, an SVM administrator can manage the S3 service. If it is false, only the cluster administrator can manage the service. This field cannot be specified in a POST method.
	Allowed *bool `json:"allowed,omitempty"`

	// audit event selector
	AuditEventSelector *models.S3BucketInlineAuditEventSelector `json:"audit_event_selector,omitempty"`

	// Can contain any additional information about the bucket being created or modified.
	// Example: S3 bucket.
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the number of constituents or FlexVol volumes per aggregate. A FlexGroup volume consisting of all such constituents across all specified aggregates is created. This option is used along with the aggregates option and cannot be used independently.
	// Example: 4
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// cors
	Cors *models.S3BucketInlineCors `json:"cors,omitempty"`

	// encryption
	Encryption *models.S3BucketInlineEncryption `json:"encryption,omitempty"`

	// Specifies whether the NAS bucket returns a consistent ETag across different S3 requests.
	IsConsistentEtag *bool `json:"is_consistent_etag,omitempty"`

	// Specifies whether the NAS bucket mapping or association with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount and therefore the NAS bucket will have access to any path in a NAS volume that matches the specified nas-path. Or is immutable and therefore the NAS bucket will always have access to the same nas-path that was specified during bucket creation even if the volume junction-path has undergone changes after the bucket creation.
	IsNasPathMutable *bool `json:"is_nas_path_mutable,omitempty"`

	// lifecycle management
	LifecycleManagement *models.S3BucketInlineLifecycleManagement `json:"lifecycle_management,omitempty"`

	// Specifies the bucket logical used size up to this point. This field cannot be specified using a POST or PATCH method.
	// Read Only: true
	LogicalUsedSize *int64 `json:"logical_used_size,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path to which the nas bucket corresponds to.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *models.S3BucketInlinePolicy `json:"policy,omitempty"`

	// protection status
	ProtectionStatus *models.S3BucketInlineProtectionStatus `json:"protection_status,omitempty"`

	// qos policy
	QosPolicy *models.S3BucketInlineQosPolicy `json:"qos_policy,omitempty"`

	// retention
	Retention *models.S3BucketInlineRetention `json:"retention,omitempty"`

	// Specifies the role of the bucket. This field cannot be specified using a POST method.
	// Read Only: true
	// Enum: ["standalone","active","passive"]
	Role *string `json:"role,omitempty"`

	// A list of aggregates for FlexGroup volume constituents where the bucket is hosted. If this option is not specified, the bucket is auto-provisioned as a FlexGroup volume.
	S3BucketInlineAggregates []*models.S3BucketInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// s3 bucket response inline records
	S3BucketResponseInlineRecords []*models.S3Bucket `json:"records,omitempty"`

	// Specifies the bucket size in bytes; ranges from 100GB to 60PB.
	// Example: 214748364800
	// Maximum: 6.755399441055744e+16
	// Minimum: 1.073741824e+11
	Size *int64 `json:"size,omitempty"`

	// snapshot policy
	SnapshotPolicy *models.S3BucketInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the storage service level of the FlexGroup volume on which the bucket should be created. Valid values are "value", "performance" or "extreme".
	// Example: value
	// Enum: ["value","performance","extreme"]
	StorageServiceLevel *string `json:"storage_service_level,omitempty"`

	// svm
	Svm *models.S3BucketInlineSvm `json:"svm,omitempty"`

	// Specifies the bucket type. Valid values are "s3"and "nas".
	// Example: s3
	// Enum: ["s3","nas"]
	Type *string `json:"type,omitempty"`

	// Specifies whether mirrored aggregates are selected when provisioning a FlexGroup. Only mirrored aggregates are used if this parameter is set to "true" and only unmirrored aggregates are used if this parameter is set to "false". The default value is "true" for a MetroCluster configuration and is "false" for a non-MetroCluster configuration.
	UseMirroredAggregates *bool `json:"use_mirrored_aggregates,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Specifies the versioning state of the bucket. Valid values are "disabled", "enabled" or "suspended". Note that the versioning state cannot be modified to 'disabled' from any other state.
	// Example: enabled
	// Enum: ["disabled","enabled","suspended"]
	VersioningState *string `json:"versioning_state,omitempty"`

	// volume
	Volume *models.S3BucketInlineVolume `json:"volume,omitempty"`
}

// Validate validates this s3 bucket modify collection body
func (o *S3BucketModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAuditEventSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLifecycleManagement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtectionStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3BucketInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3BucketResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageServiceLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersioningState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) validateAuditEventSelector(formats strfmt.Registry) error {
	if swag.IsZero(o.AuditEventSelector) { // not required
		return nil
	}

	if o.AuditEventSelector != nil {
		if err := o.AuditEventSelector.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateCors(formats strfmt.Registry) error {
	if swag.IsZero(o.Cors) { // not required
		return nil
	}

	if o.Cors != nil {
		if err := o.Cors.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cors")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateLifecycleManagement(formats strfmt.Registry) error {
	if swag.IsZero(o.LifecycleManagement) { // not required
		return nil
	}

	if o.LifecycleManagement != nil {
		if err := o.LifecycleManagement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 63); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateProtectionStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.ProtectionStatus) { // not required
		return nil
	}

	if o.ProtectionStatus != nil {
		if err := o.ProtectionStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(o.Retention) { // not required
		return nil
	}

	if o.Retention != nil {
		if err := o.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var s3BucketModifyCollectionBodyTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["standalone","active","passive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketModifyCollectionBodyTypeRolePropEnum = append(s3BucketModifyCollectionBodyTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// role
	// Role
	// standalone
	// END DEBUGGING
	// S3BucketModifyCollectionBodyRoleStandalone captures enum value "standalone"
	S3BucketModifyCollectionBodyRoleStandalone string = "standalone"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// role
	// Role
	// active
	// END DEBUGGING
	// S3BucketModifyCollectionBodyRoleActive captures enum value "active"
	S3BucketModifyCollectionBodyRoleActive string = "active"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// role
	// Role
	// passive
	// END DEBUGGING
	// S3BucketModifyCollectionBodyRolePassive captures enum value "passive"
	S3BucketModifyCollectionBodyRolePassive string = "passive"
)

// prop value enum
func (o *S3BucketModifyCollectionBody) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketModifyCollectionBodyTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(o.Role) { // not required
		return nil
	}

	// value enum
	if err := o.validateRoleEnum("info"+"."+"role", "body", *o.Role); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateS3BucketInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketInlineAggregates); i++ {
		if swag.IsZero(o.S3BucketInlineAggregates[i]) { // not required
			continue
		}

		if o.S3BucketInlineAggregates[i] != nil {
			if err := o.S3BucketInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateS3BucketResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketResponseInlineRecords[i] != nil {
			if err := o.S3BucketResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"size", "body", *o.Size, 1.073741824e+11, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"size", "body", *o.Size, 6.755399441055744e+16, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var s3BucketModifyCollectionBodyTypeStorageServiceLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["value","performance","extreme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketModifyCollectionBodyTypeStorageServiceLevelPropEnum = append(s3BucketModifyCollectionBodyTypeStorageServiceLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// value
	// END DEBUGGING
	// S3BucketModifyCollectionBodyStorageServiceLevelValue captures enum value "value"
	S3BucketModifyCollectionBodyStorageServiceLevelValue string = "value"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// performance
	// END DEBUGGING
	// S3BucketModifyCollectionBodyStorageServiceLevelPerformance captures enum value "performance"
	S3BucketModifyCollectionBodyStorageServiceLevelPerformance string = "performance"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// extreme
	// END DEBUGGING
	// S3BucketModifyCollectionBodyStorageServiceLevelExtreme captures enum value "extreme"
	S3BucketModifyCollectionBodyStorageServiceLevelExtreme string = "extreme"
)

// prop value enum
func (o *S3BucketModifyCollectionBody) validateStorageServiceLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketModifyCollectionBodyTypeStorageServiceLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) validateStorageServiceLevel(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageServiceLevel) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageServiceLevelEnum("info"+"."+"storage_service_level", "body", *o.StorageServiceLevel); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var s3BucketModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["s3","nas"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketModifyCollectionBodyTypeTypePropEnum = append(s3BucketModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// type
	// Type
	// s3
	// END DEBUGGING
	// S3BucketModifyCollectionBodyTypeS3 captures enum value "s3"
	S3BucketModifyCollectionBodyTypeS3 string = "s3"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// type
	// Type
	// nas
	// END DEBUGGING
	// S3BucketModifyCollectionBodyTypeNas captures enum value "nas"
	S3BucketModifyCollectionBodyTypeNas string = "nas"
)

// prop value enum
func (o *S3BucketModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

var s3BucketModifyCollectionBodyTypeVersioningStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","suspended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketModifyCollectionBodyTypeVersioningStatePropEnum = append(s3BucketModifyCollectionBodyTypeVersioningStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// versioning_state
	// VersioningState
	// disabled
	// END DEBUGGING
	// S3BucketModifyCollectionBodyVersioningStateDisabled captures enum value "disabled"
	S3BucketModifyCollectionBodyVersioningStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// versioning_state
	// VersioningState
	// enabled
	// END DEBUGGING
	// S3BucketModifyCollectionBodyVersioningStateEnabled captures enum value "enabled"
	S3BucketModifyCollectionBodyVersioningStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// S3BucketModifyCollectionBody
	// S3BucketModifyCollectionBody
	// versioning_state
	// VersioningState
	// suspended
	// END DEBUGGING
	// S3BucketModifyCollectionBodyVersioningStateSuspended captures enum value "suspended"
	S3BucketModifyCollectionBodyVersioningStateSuspended string = "suspended"
)

// prop value enum
func (o *S3BucketModifyCollectionBody) validateVersioningStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketModifyCollectionBodyTypeVersioningStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) validateVersioningState(formats strfmt.Registry) error {
	if swag.IsZero(o.VersioningState) { // not required
		return nil
	}

	// value enum
	if err := o.validateVersioningStateEnum("info"+"."+"versioning_state", "body", *o.VersioningState); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection body based on the context it is used
func (o *S3BucketModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAuditEventSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLifecycleManagement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtectionStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3BucketInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3BucketResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateAuditEventSelector(ctx context.Context, formats strfmt.Registry) error {

	if o.AuditEventSelector != nil {
		if err := o.AuditEventSelector.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateCors(ctx context.Context, formats strfmt.Registry) error {

	if o.Cors != nil {
		if err := o.Cors.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cors")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateLifecycleManagement(ctx context.Context, formats strfmt.Registry) error {

	if o.LifecycleManagement != nil {
		if err := o.LifecycleManagement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateLogicalUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"logical_used_size", "body", o.LogicalUsedSize); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateProtectionStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.ProtectionStatus != nil {
		if err := o.ProtectionStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if o.Retention != nil {
		if err := o.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"role", "body", o.Role); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateS3BucketInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketInlineAggregates); i++ {

		if o.S3BucketInlineAggregates[i] != nil {
			if err := o.S3BucketInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateS3BucketResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketResponseInlineRecords); i++ {

		if o.S3BucketResponseInlineRecords[i] != nil {
			if err := o.S3BucketResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyCorsRulesItems0 Information about the CORS rule of an S3 bucket.
swagger:model S3BucketModifyCollectionParamsBodyCorsRulesItems0
*/
type S3BucketModifyCollectionParamsBodyCorsRulesItems0 struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links `json:"_links,omitempty"`

	// An array of HTTP headers allowed in the cross-origin requests.
	//
	// Example: ["x-amz-request-id"]
	AllowedHeaders []*string `json:"allowed_headers"`

	// An array of HTTP methods allowed in the cross-origin requests.
	//
	// Example: ["PUT","DELETE"]
	AllowedMethods []*string `json:"allowed_methods"`

	// List of origins from where a cross-origin request is allowed to originate from for the S3 bucket.
	//
	// Example: ["http://www.example.com"]
	AllowedOrigins []*string `json:"allowed_origins"`

	// List of extra headers sent in the response that customers can access from their applications.
	//
	// Example: ["x-amz-date"]
	ExposeHeaders []*string `json:"expose_headers"`

	// Bucket CORS rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	ID *string `json:"id,omitempty"`

	// The time in seconds for your browser to cache the preflight response for the specified resource.
	// Example: 1024
	MaxAgeSeconds *int64 `json:"max_age_seconds,omitempty"`
}

// Validate validates this s3 bucket modify collection params body cors rules items0
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) validateID(formats strfmt.Registry) error {
	if swag.IsZero(o.ID) { // not required
		return nil
	}

	if err := validate.MinLength("id", "body", *o.ID, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("id", "body", *o.ID, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body cors rules items0 based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyCorsRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyCorsRulesItems0Links s3 bucket modify collection params body cors rules items0 links
swagger:model S3BucketModifyCollectionParamsBodyCorsRulesItems0Links
*/
type S3BucketModifyCollectionParamsBodyCorsRulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body cors rules items0 links
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body cors rules items0 links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyCorsRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyCorsRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0 Information about the lifecycle management rule of a bucket.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0 struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links `json:"_links,omitempty"`

	// abort incomplete multipart upload
	AbortIncompleteMultipartUpload *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload `json:"abort_incomplete_multipart_upload,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	BucketName *string `json:"bucket_name,omitempty"`

	// Specifies whether or not the associated rule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// expiration
	Expiration *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration `json:"expiration,omitempty"`

	// Bucket lifecycle management rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	Name *string `json:"name,omitempty"`

	// non current version expiration
	NonCurrentVersionExpiration *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration `json:"non_current_version_expiration,omitempty"`

	// object filter
	ObjectFilter *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter `json:"object_filter,omitempty"`

	// svm
	Svm *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm `json:"svm,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAbortIncompleteMultipartUpload(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNonCurrentVersionExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateAbortIncompleteMultipartUpload(formats strfmt.Registry) error {
	if swag.IsZero(o.AbortIncompleteMultipartUpload) { // not required
		return nil
	}

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateBucketName(formats strfmt.Registry) error {
	if swag.IsZero(o.BucketName) { // not required
		return nil
	}

	if err := validate.MinLength("bucket_name", "body", *o.BucketName, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("bucket_name", "body", *o.BucketName, 63); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.Expiration) { // not required
		return nil
	}

	if o.Expiration != nil {
		if err := o.Expiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateNonCurrentVersionExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.NonCurrentVersionExpiration) { // not required
		return nil
	}

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateObjectFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectFilter) { // not required
		return nil
	}

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAbortIncompleteMultipartUpload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNonCurrentVersionExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateObjectFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateAbortIncompleteMultipartUpload(ctx context.Context, formats strfmt.Registry) error {

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.Expiration != nil {
		if err := o.Expiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateNonCurrentVersionExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateObjectFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload Specifies a way to perform abort_incomplete_multipart_upload action on filtered objects within a bucket. It cannot be specified with tags.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks `json:"_links,omitempty"`

	// Number of days of initiation after which uploads can be aborted.
	AfterInitiationDays *int64 `json:"after_initiation_days,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 abort incomplete multipart upload
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 abort incomplete multipart upload based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks s3 bucket modify collection params body lifecycle management rules items0 abort incomplete multipart upload links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 abort incomplete multipart upload links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 abort incomplete multipart upload links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration Specifies a way to perform expiration action on filtered objects within a bucket.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks `json:"_links,omitempty"`

	// Cleanup object delete markers.
	ExpiredObjectDeleteMarker *bool `json:"expired_object_delete_marker,omitempty"`

	// Number of days since creation after which objects can be deleted. This cannot be used along with object_expiry_date.
	// Example: 100
	ObjectAgeDays *int64 `json:"object_age_days,omitempty"`

	// Specific date from when objects can expire. This cannot be used with object_age_days.
	// Example: 2039-09-23 00:00:00+00:00
	// Format: date-time
	ObjectExpiryDate *strfmt.DateTime `json:"object_expiry_date,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 expiration
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectExpiryDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) validateObjectExpiryDate(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectExpiryDate) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration"+"."+"object_expiry_date", "body", "date-time", o.ObjectExpiryDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 expiration based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks s3 bucket modify collection params body lifecycle management rules items0 expiration links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 expiration links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 expiration links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links s3 bucket modify collection params body lifecycle management rules items0 links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration Specifies a way to perform non_current_version_expiration action on filtered objects within a bucket.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks `json:"_links,omitempty"`

	// Number of latest non-current versions to be retained.
	NewNonCurrentVersions *int64 `json:"new_non_current_versions,omitempty"`

	// Number of days after which non-current versions can be deleted.
	NonCurrentDays *int64 `json:"non_current_days,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 non current version expiration
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 non current version expiration based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks s3 bucket modify collection params body lifecycle management rules items0 non current version expiration links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 non current version expiration links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 non current version expiration links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter Specifies a way to filter objects within a bucket.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	Tags []*string `json:"tags"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 object filter
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 object filter based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks s3 bucket modify collection params body lifecycle management rules items0 object filter links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 object filter links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 object filter links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm Specifies the name of the SVM where this bucket exists.
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm struct {

	// links
	Links *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 svm
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 svm based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks s3 bucket modify collection params body lifecycle management rules items0 svm links
swagger:model S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks
*/
type S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket modify collection params body lifecycle management rules items0 svm links
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket modify collection params body lifecycle management rules items0 svm links based on the context it is used
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineAggregatesInlineArrayItem Aggregate
swagger:model s3_bucket_inline_aggregates_inline_array_item
*/
type S3BucketInlineAggregatesInlineArrayItem struct {

	// links
	Links *models.S3BucketInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline aggregates inline array item
func (o *S3BucketInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline aggregates inline array item based on the context it is used
func (o *S3BucketInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineAggregatesInlineArrayItemInlineLinks s3 bucket inline aggregates inline array item inline links
swagger:model s3_bucket_inline_aggregates_inline_array_item_inline__links
*/
type S3BucketInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline aggregates inline array item inline links
func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline aggregates inline array item inline links based on the context it is used
func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineAuditEventSelector Audit event selector allows you to specify access and permission types to audit.
swagger:model s3_bucket_inline_audit_event_selector
*/
type S3BucketInlineAuditEventSelector struct {

	// Specifies read and write access types.
	//
	// Enum: ["read","write","all","none"]
	Access *string `json:"access,omitempty"`

	// Specifies allow and deny permission types.
	//
	// Enum: ["deny","allow","all","none"]
	Permission *string `json:"permission,omitempty"`
}

// Validate validates this s3 bucket inline audit event selector
func (o *S3BucketInlineAuditEventSelector) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketInlineAuditEventSelectorTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","write","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineAuditEventSelectorTypeAccessPropEnum = append(s3BucketInlineAuditEventSelectorTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// read
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessRead captures enum value "read"
	S3BucketInlineAuditEventSelectorAccessRead string = "read"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// write
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessWrite captures enum value "write"
	S3BucketInlineAuditEventSelectorAccessWrite string = "write"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// all
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessAll captures enum value "all"
	S3BucketInlineAuditEventSelectorAccessAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// access
	// Access
	// none
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorAccessNone captures enum value "none"
	S3BucketInlineAuditEventSelectorAccessNone string = "none"
)

// prop value enum
func (o *S3BucketInlineAuditEventSelector) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineAuditEventSelectorTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketInlineAuditEventSelector) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(o.Access) { // not required
		return nil
	}

	// value enum
	if err := o.validateAccessEnum("info"+"."+"audit_event_selector"+"."+"access", "body", *o.Access); err != nil {
		return err
	}

	return nil
}

var s3BucketInlineAuditEventSelectorTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["deny","allow","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineAuditEventSelectorTypePermissionPropEnum = append(s3BucketInlineAuditEventSelectorTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// deny
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionDeny captures enum value "deny"
	S3BucketInlineAuditEventSelectorPermissionDeny string = "deny"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// allow
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionAllow captures enum value "allow"
	S3BucketInlineAuditEventSelectorPermissionAllow string = "allow"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// all
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionAll captures enum value "all"
	S3BucketInlineAuditEventSelectorPermissionAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_inline_audit_event_selector
	// S3BucketInlineAuditEventSelector
	// permission
	// Permission
	// none
	// END DEBUGGING
	// S3BucketInlineAuditEventSelectorPermissionNone captures enum value "none"
	S3BucketInlineAuditEventSelectorPermissionNone string = "none"
)

// prop value enum
func (o *S3BucketInlineAuditEventSelector) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineAuditEventSelectorTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketInlineAuditEventSelector) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(o.Permission) { // not required
		return nil
	}

	// value enum
	if err := o.validatePermissionEnum("info"+"."+"audit_event_selector"+"."+"permission", "body", *o.Permission); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline audit event selector based on context it is used
func (o *S3BucketInlineAuditEventSelector) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineAuditEventSelector) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineAuditEventSelector) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineAuditEventSelector
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineCors Cross-origin resource sharing (CORS) specifies an object associated with a bucket. The CORS configuration enables the bucket to service the cross-origin requests. A request might typically come from an origin with a domain that is different to that of the bucket. By configuring a CORS rule, you can define a combination of allowed origins, HTTP headers and methods that a bucket can use to filter out the cross-origin requests that it can service successfully.
swagger:model s3_bucket_inline_cors
*/
type S3BucketInlineCors struct {

	// Specifies an object store bucket CORS rule.
	Rules []*S3BucketModifyCollectionParamsBodyCorsRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket inline cors
func (o *S3BucketInlineCors) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineCors) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline cors based on the context it is used
func (o *S3BucketInlineCors) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineCors) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineCors) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineCors) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineCors
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineEncryption s3 bucket inline encryption
swagger:model s3_bucket_inline_encryption
*/
type S3BucketInlineEncryption struct {

	// Specifies whether encryption is enabled on the bucket. By default, encryption is disabled on a bucket. This field cannot be specified in a POST method.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this s3 bucket inline encryption
func (o *S3BucketInlineEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket inline encryption based on the context it is used
func (o *S3BucketInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineEncryption) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineLifecycleManagement Lifecycle management is implemented as an object associated with a bucket. It defines rules to be applied against objects within a bucket. These rules are applied in the background and can delete objects.
swagger:model s3_bucket_inline_lifecycle_management
*/
type S3BucketInlineLifecycleManagement struct {

	// Specifies an object store lifecycle management policy.
	Rules []*S3BucketModifyCollectionParamsBodyLifecycleManagementRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket inline lifecycle management
func (o *S3BucketInlineLifecycleManagement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineLifecycleManagement) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline lifecycle management based on the context it is used
func (o *S3BucketInlineLifecycleManagement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineLifecycleManagement) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineLifecycleManagement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineLifecycleManagement) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineLifecycleManagement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies get evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
swagger:model s3_bucket_inline_policy
*/
type S3BucketInlinePolicy struct {

	// Specifies bucket access policy statement.
	Statements []*models.S3BucketPolicyStatement `json:"statements,omitempty"`
}

// Validate validates this s3 bucket inline policy
func (o *S3BucketInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(o.Statements) { // not required
		return nil
	}

	for i := 0; i < len(o.Statements); i++ {
		if swag.IsZero(o.Statements[i]) { // not required
			continue
		}

		if o.Statements[i] != nil {
			if err := o.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket inline policy based on the context it is used
func (o *S3BucketInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Statements); i++ {

		if o.Statements[i] != nil {
			if err := o.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlinePolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineProtectionStatus Specifies attributes of bucket protection.
swagger:model s3_bucket_inline_protection_status
*/
type S3BucketInlineProtectionStatus struct {

	// destination
	Destination *models.S3BucketInlineProtectionStatusInlineDestination `json:"destination,omitempty"`

	// Specifies whether a bucket is a source and if it is protected within ONTAP and/or an external cloud. This field cannot be specified using a POST method.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this s3 bucket inline protection status
func (o *S3BucketInlineProtectionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineProtectionStatus) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline protection status based on the context it is used
func (o *S3BucketInlineProtectionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineProtectionStatus) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketInlineProtectionStatus) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"is_protected", "body", o.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineProtectionStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineProtectionStatus) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineProtectionStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineProtectionStatusInlineDestination s3 bucket inline protection status inline destination
swagger:model s3_bucket_inline_protection_status_inline_destination
*/
type S3BucketInlineProtectionStatusInlineDestination struct {

	// Specifies whether a bucket is protected within the Cloud. This field cannot be specified using a POST method.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a bucket is protected on external Cloud providers. This field cannot be specified using a POST method.
	// Read Only: true
	IsExternalCloud *bool `json:"is_external_cloud,omitempty"`

	// Specifies whether a bucket is protected within ONTAP. This field cannot be specified using a POST method.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this s3 bucket inline protection status inline destination
func (o *S3BucketInlineProtectionStatusInlineDestination) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket inline protection status inline destination based on the context it is used
func (o *S3BucketInlineProtectionStatusInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsExternalCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_cloud", "body", o.IsCloud); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsExternalCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_external_cloud", "body", o.IsExternalCloud); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketInlineProtectionStatusInlineDestination) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_ontap", "body", o.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineProtectionStatusInlineDestination) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineProtectionStatusInlineDestination) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineProtectionStatusInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineQosPolicy Specifies "qos_policy.max_throughput_iops" and/or "qos_policy.max_throughput_mbps" or "qos_policy.min_throughput_iops" and/or "qos_policy.min_throughput_mbps". Specifying "min_throughput_iops" or "min_throughput_mbps" is only supported on volumes hosted on a node that is flash optimized. A pre-created QoS policy can also be used by specifying "qos_policy.name" or "qos_policy.uuid" properties. Setting or assigning a QoS policy to a bucket is not supported if its containing volume or SVM already has a QoS policy attached.
swagger:model s3_bucket_inline_qos_policy
*/
type S3BucketInlineQosPolicy struct {

	// links
	Links *models.S3BucketInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline qos policy
func (o *S3BucketInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket inline qos policy based on the context it is used
func (o *S3BucketInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineQosPolicyInlineLinks s3 bucket inline qos policy inline links
swagger:model s3_bucket_inline_qos_policy_inline__links
*/
type S3BucketInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline qos policy inline links
func (o *S3BucketInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline qos policy inline links based on the context it is used
func (o *S3BucketInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineRetention Specifies the retention mode and default retention period configured on the bucket.
swagger:model s3_bucket_inline_retention
*/
type S3BucketInlineRetention struct {

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example "P1Y10D" is not supported.
	// Example: P10Y
	DefaultPeriod *string `json:"default_period,omitempty"`

	// The lock mode of the bucket. <br>compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. <br> governance &dash; An administrator can delete a Governance bucket.<br> no_lock &dash; Indicates the bucket does not support object locking.
	// Example: governance
	// Enum: ["no_lock","compliance","governance"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this s3 bucket inline retention
func (o *S3BucketInlineRetention) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketInlineRetentionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_lock","compliance","governance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketInlineRetentionTypeModePropEnum = append(s3BucketInlineRetentionTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// no_lock
	// END DEBUGGING
	// S3BucketInlineRetentionModeNoLock captures enum value "no_lock"
	S3BucketInlineRetentionModeNoLock string = "no_lock"

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// compliance
	// END DEBUGGING
	// S3BucketInlineRetentionModeCompliance captures enum value "compliance"
	S3BucketInlineRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// s3_bucket_inline_retention
	// S3BucketInlineRetention
	// mode
	// Mode
	// governance
	// END DEBUGGING
	// S3BucketInlineRetentionModeGovernance captures enum value "governance"
	S3BucketInlineRetentionModeGovernance string = "governance"
)

// prop value enum
func (o *S3BucketInlineRetention) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketInlineRetentionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketInlineRetention) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"retention"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline retention based on context it is used
func (o *S3BucketInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineRetention) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineRetention) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineSnapshotPolicy Specifies the bucket snapshot policy.
swagger:model s3_bucket_inline_snapshot_policy
*/
type S3BucketInlineSnapshotPolicy struct {

	// Specifies the name of the snapshot policy.
	// Example: default-1weekly
	Name *string `json:"name,omitempty"`

	// Specifies the unique identifier of the snapshot policy.
	// Example: 3675af31-431c-12fa-114a-20675afebc12
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline snapshot policy
func (o *S3BucketInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineSnapshotPolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snapshot_policy"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket inline snapshot policy based on context it is used
func (o *S3BucketInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_bucket_inline_svm
*/
type S3BucketInlineSvm struct {

	// links
	Links *models.S3BucketInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline svm
func (o *S3BucketInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline svm based on the context it is used
func (o *S3BucketInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineSvmInlineLinks s3 bucket inline svm inline links
swagger:model s3_bucket_inline_svm_inline__links
*/
type S3BucketInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline svm inline links
func (o *S3BucketInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline svm inline links based on the context it is used
func (o *S3BucketInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineVolume Specifies the FlexGroup volume name and UUID where the bucket is hosted.
swagger:model s3_bucket_inline_volume
*/
type S3BucketInlineVolume struct {

	// links
	Links *models.S3BucketInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket inline volume
func (o *S3BucketInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline volume based on the context it is used
func (o *S3BucketInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineVolume) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketInlineVolumeInlineLinks s3 bucket inline volume inline links
swagger:model s3_bucket_inline_volume_inline__links
*/
type S3BucketInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket inline volume inline links
func (o *S3BucketInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket inline volume inline links based on the context it is used
func (o *S3BucketInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
