// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSnapshotCreateReader is a Reader for the S3BucketSnapshotCreate structure.
type S3BucketSnapshotCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSnapshotCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewS3BucketSnapshotCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3BucketSnapshotCreateAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSnapshotCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSnapshotCreateCreated creates a S3BucketSnapshotCreateCreated with default headers values
func NewS3BucketSnapshotCreateCreated() *S3BucketSnapshotCreateCreated {
	return &S3BucketSnapshotCreateCreated{}
}

/*
S3BucketSnapshotCreateCreated describes a response with status code 201, with default header values.

Created
*/
type S3BucketSnapshotCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string
}

// IsSuccess returns true when this s3 bucket snapshot create created response has a 2xx status code
func (o *S3BucketSnapshotCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket snapshot create created response has a 3xx status code
func (o *S3BucketSnapshotCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket snapshot create created response has a 4xx status code
func (o *S3BucketSnapshotCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket snapshot create created response has a 5xx status code
func (o *S3BucketSnapshotCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket snapshot create created response a status code equal to that given
func (o *S3BucketSnapshotCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the s3 bucket snapshot create created response
func (o *S3BucketSnapshotCreateCreated) Code() int {
	return 201
}

func (o *S3BucketSnapshotCreateCreated) Error() string {
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotCreateCreated", 201)
}

func (o *S3BucketSnapshotCreateCreated) String() string {
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotCreateCreated", 201)
}

func (o *S3BucketSnapshotCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	return nil
}

// NewS3BucketSnapshotCreateAccepted creates a S3BucketSnapshotCreateAccepted with default headers values
func NewS3BucketSnapshotCreateAccepted() *S3BucketSnapshotCreateAccepted {
	return &S3BucketSnapshotCreateAccepted{}
}

/*
S3BucketSnapshotCreateAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3BucketSnapshotCreateAccepted struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.S3BucketSnapshotJobLinkResponse
}

// IsSuccess returns true when this s3 bucket snapshot create accepted response has a 2xx status code
func (o *S3BucketSnapshotCreateAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket snapshot create accepted response has a 3xx status code
func (o *S3BucketSnapshotCreateAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket snapshot create accepted response has a 4xx status code
func (o *S3BucketSnapshotCreateAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket snapshot create accepted response has a 5xx status code
func (o *S3BucketSnapshotCreateAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket snapshot create accepted response a status code equal to that given
func (o *S3BucketSnapshotCreateAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 bucket snapshot create accepted response
func (o *S3BucketSnapshotCreateAccepted) Code() int {
	return 202
}

func (o *S3BucketSnapshotCreateAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotCreateAccepted %s", 202, payload)
}

func (o *S3BucketSnapshotCreateAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotCreateAccepted %s", 202, payload)
}

func (o *S3BucketSnapshotCreateAccepted) GetPayload() *models.S3BucketSnapshotJobLinkResponse {
	return o.Payload
}

func (o *S3BucketSnapshotCreateAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.S3BucketSnapshotJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSnapshotCreateDefault creates a S3BucketSnapshotCreateDefault with default headers values
func NewS3BucketSnapshotCreateDefault(code int) *S3BucketSnapshotCreateDefault {
	return &S3BucketSnapshotCreateDefault{
		_statusCode: code,
	}
}

/*
	S3BucketSnapshotCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92406249   | "Failed to create S3 bucket snapshot \\\"{snapshot name}\\\" for S3 bucket \\\"{bucket name}\\\" in SVM \\\"{svm name}\\\". Reason: {Reason for failure} ";
*/
type S3BucketSnapshotCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket snapshot create default response has a 2xx status code
func (o *S3BucketSnapshotCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket snapshot create default response has a 3xx status code
func (o *S3BucketSnapshotCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket snapshot create default response has a 4xx status code
func (o *S3BucketSnapshotCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket snapshot create default response has a 5xx status code
func (o *S3BucketSnapshotCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket snapshot create default response a status code equal to that given
func (o *S3BucketSnapshotCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket snapshot create default response
func (o *S3BucketSnapshotCreateDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSnapshotCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3_bucket_snapshot_create default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3_bucket_snapshot_create default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSnapshotCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
