// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSnapshotDeleteCollectionReader is a Reader for the S3BucketSnapshotDeleteCollection structure.
type S3BucketSnapshotDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSnapshotDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketSnapshotDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSnapshotDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSnapshotDeleteCollectionOK creates a S3BucketSnapshotDeleteCollectionOK with default headers values
func NewS3BucketSnapshotDeleteCollectionOK() *S3BucketSnapshotDeleteCollectionOK {
	return &S3BucketSnapshotDeleteCollectionOK{}
}

/*
S3BucketSnapshotDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketSnapshotDeleteCollectionOK struct {
}

// IsSuccess returns true when this s3 bucket snapshot delete collection o k response has a 2xx status code
func (o *S3BucketSnapshotDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket snapshot delete collection o k response has a 3xx status code
func (o *S3BucketSnapshotDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket snapshot delete collection o k response has a 4xx status code
func (o *S3BucketSnapshotDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket snapshot delete collection o k response has a 5xx status code
func (o *S3BucketSnapshotDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket snapshot delete collection o k response a status code equal to that given
func (o *S3BucketSnapshotDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket snapshot delete collection o k response
func (o *S3BucketSnapshotDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3BucketSnapshotDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotDeleteCollectionOK", 200)
}

func (o *S3BucketSnapshotDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3BucketSnapshotDeleteCollectionOK", 200)
}

func (o *S3BucketSnapshotDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3BucketSnapshotDeleteCollectionDefault creates a S3BucketSnapshotDeleteCollectionDefault with default headers values
func NewS3BucketSnapshotDeleteCollectionDefault(code int) *S3BucketSnapshotDeleteCollectionDefault {
	return &S3BucketSnapshotDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketSnapshotDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92406250   | "Failed to delete S3 bucket snapshot \\\"{snapshot name}\\\" for S3 bucket \\\"{bucket name}\\\" in SVM \\\"{svm name}\\\". Reason: {Reason for failure} ";
| 92406278   | "Failed to delete S3 bucket snapshot with UUID \\\"{snapshot uuid}\\\" for S3 bucket \\\"{bucket name}\\\" in SVM \\\"{svm name}\\\". Reason: {Reason for failure} ";
*/
type S3BucketSnapshotDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket snapshot delete collection default response has a 2xx status code
func (o *S3BucketSnapshotDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket snapshot delete collection default response has a 3xx status code
func (o *S3BucketSnapshotDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket snapshot delete collection default response has a 4xx status code
func (o *S3BucketSnapshotDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket snapshot delete collection default response has a 5xx status code
func (o *S3BucketSnapshotDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket snapshot delete collection default response a status code equal to that given
func (o *S3BucketSnapshotDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket snapshot delete collection default response
func (o *S3BucketSnapshotDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSnapshotDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3_bucket_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots][%d] s3_bucket_snapshot_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSnapshotDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketSnapshotDeleteCollectionBody s3 bucket snapshot delete collection body
swagger:model S3BucketSnapshotDeleteCollectionBody
*/
type S3BucketSnapshotDeleteCollectionBody struct {

	// s3 bucket snapshot response inline records
	S3BucketSnapshotResponseInlineRecords []*models.S3BucketSnapshot `json:"records,omitempty"`
}

// Validate validates this s3 bucket snapshot delete collection body
func (o *S3BucketSnapshotDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3BucketSnapshotResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSnapshotDeleteCollectionBody) validateS3BucketSnapshotResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketSnapshotResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketSnapshotResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketSnapshotResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketSnapshotResponseInlineRecords[i] != nil {
			if err := o.S3BucketSnapshotResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket snapshot delete collection body based on the context it is used
func (o *S3BucketSnapshotDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3BucketSnapshotResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSnapshotDeleteCollectionBody) contextValidateS3BucketSnapshotResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketSnapshotResponseInlineRecords); i++ {

		if o.S3BucketSnapshotResponseInlineRecords[i] != nil {
			if err := o.S3BucketSnapshotResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSnapshotDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSnapshotDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketSnapshotDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
