// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSnapshotDeleteReader is a Reader for the S3BucketSnapshotDelete structure.
type S3BucketSnapshotDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSnapshotDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketSnapshotDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSnapshotDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSnapshotDeleteOK creates a S3BucketSnapshotDeleteOK with default headers values
func NewS3BucketSnapshotDeleteOK() *S3BucketSnapshotDeleteOK {
	return &S3BucketSnapshotDeleteOK{}
}

/*
S3BucketSnapshotDeleteOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketSnapshotDeleteOK struct {
}

// IsSuccess returns true when this s3 bucket snapshot delete o k response has a 2xx status code
func (o *S3BucketSnapshotDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket snapshot delete o k response has a 3xx status code
func (o *S3BucketSnapshotDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket snapshot delete o k response has a 4xx status code
func (o *S3BucketSnapshotDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket snapshot delete o k response has a 5xx status code
func (o *S3BucketSnapshotDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket snapshot delete o k response a status code equal to that given
func (o *S3BucketSnapshotDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket snapshot delete o k response
func (o *S3BucketSnapshotDeleteOK) Code() int {
	return 200
}

func (o *S3BucketSnapshotDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}][%d] s3BucketSnapshotDeleteOK", 200)
}

func (o *S3BucketSnapshotDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}][%d] s3BucketSnapshotDeleteOK", 200)
}

func (o *S3BucketSnapshotDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3BucketSnapshotDeleteDefault creates a S3BucketSnapshotDeleteDefault with default headers values
func NewS3BucketSnapshotDeleteDefault(code int) *S3BucketSnapshotDeleteDefault {
	return &S3BucketSnapshotDeleteDefault{
		_statusCode: code,
	}
}

/*
	S3BucketSnapshotDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92406250   | "Failed to delete S3 bucket snapshot \\\"{snapshot name}\\\" for S3 bucket \\\"{bucket name}\\\" in SVM \\\"{svm name}\\\". Reason: {Reason for failure} ";
| 92406278   | "Failed to delete S3 bucket snapshot with UUID \\\"{snapshot uuid}\\\" for S3 bucket \\\"{bucket name}\\\" in SVM \\\"{svm name}\\\". Reason: {Reason for failure} ";
*/
type S3BucketSnapshotDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket snapshot delete default response has a 2xx status code
func (o *S3BucketSnapshotDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket snapshot delete default response has a 3xx status code
func (o *S3BucketSnapshotDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket snapshot delete default response has a 4xx status code
func (o *S3BucketSnapshotDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket snapshot delete default response has a 5xx status code
func (o *S3BucketSnapshotDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket snapshot delete default response a status code equal to that given
func (o *S3BucketSnapshotDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket snapshot delete default response
func (o *S3BucketSnapshotDeleteDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSnapshotDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}][%d] s3_bucket_snapshot_delete default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets/{s3_bucket.uuid}/snapshots/{uuid}][%d] s3_bucket_snapshot_delete default %s", o._statusCode, payload)
}

func (o *S3BucketSnapshotDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSnapshotDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
