// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketSnapshotGetParams creates a new S3BucketSnapshotGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketSnapshotGetParams() *S3BucketSnapshotGetParams {
	return &S3BucketSnapshotGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketSnapshotGetParamsWithTimeout creates a new S3BucketSnapshotGetParams object
// with the ability to set a timeout on a request.
func NewS3BucketSnapshotGetParamsWithTimeout(timeout time.Duration) *S3BucketSnapshotGetParams {
	return &S3BucketSnapshotGetParams{
		timeout: timeout,
	}
}

// NewS3BucketSnapshotGetParamsWithContext creates a new S3BucketSnapshotGetParams object
// with the ability to set a context for a request.
func NewS3BucketSnapshotGetParamsWithContext(ctx context.Context) *S3BucketSnapshotGetParams {
	return &S3BucketSnapshotGetParams{
		Context: ctx,
	}
}

// NewS3BucketSnapshotGetParamsWithHTTPClient creates a new S3BucketSnapshotGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketSnapshotGetParamsWithHTTPClient(client *http.Client) *S3BucketSnapshotGetParams {
	return &S3BucketSnapshotGetParams{
		HTTPClient: client,
	}
}

/*
S3BucketSnapshotGetParams contains all the parameters to send to the API endpoint

	for the s3 bucket snapshot get operation.

	Typically these are written to a http.Request.
*/
type S3BucketSnapshotGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* S3BucketUUID.

	   The unique identifier of the bucket.
	*/
	S3BucketUUID string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   The unique identifier of the S3 bucket snapshot.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket snapshot get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSnapshotGetParams) WithDefaults() *S3BucketSnapshotGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket snapshot get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSnapshotGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithTimeout(timeout time.Duration) *S3BucketSnapshotGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithContext(ctx context.Context) *S3BucketSnapshotGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithHTTPClient(client *http.Client) *S3BucketSnapshotGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithFields(fields []string) *S3BucketSnapshotGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithS3BucketUUID adds the s3BucketUUID to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithS3BucketUUID(s3BucketUUID string) *S3BucketSnapshotGetParams {
	o.SetS3BucketUUID(s3BucketUUID)
	return o
}

// SetS3BucketUUID adds the s3BucketUuid to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetS3BucketUUID(s3BucketUUID string) {
	o.S3BucketUUID = s3BucketUUID
}

// WithSvmUUID adds the svmUUID to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithSvmUUID(svmUUID string) *S3BucketSnapshotGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) WithUUID(uuid string) *S3BucketSnapshotGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket snapshot get params
func (o *S3BucketSnapshotGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketSnapshotGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param s3_bucket.uuid
	if err := r.SetPathParam("s3_bucket.uuid", o.S3BucketUUID); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3BucketSnapshotGet binds the parameter fields
func (o *S3BucketSnapshotGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
