// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSvmDeleteCollectionReader is a Reader for the S3BucketSvmDeleteCollection structure.
type S3BucketSvmDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSvmDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketSvmDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3BucketSvmDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSvmDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSvmDeleteCollectionOK creates a S3BucketSvmDeleteCollectionOK with default headers values
func NewS3BucketSvmDeleteCollectionOK() *S3BucketSvmDeleteCollectionOK {
	return &S3BucketSvmDeleteCollectionOK{}
}

/*
S3BucketSvmDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketSvmDeleteCollectionOK struct {
	Payload *models.S3BucketSvmJobLinkResponse
}

// IsSuccess returns true when this s3 bucket svm delete collection o k response has a 2xx status code
func (o *S3BucketSvmDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket svm delete collection o k response has a 3xx status code
func (o *S3BucketSvmDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket svm delete collection o k response has a 4xx status code
func (o *S3BucketSvmDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket svm delete collection o k response has a 5xx status code
func (o *S3BucketSvmDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket svm delete collection o k response a status code equal to that given
func (o *S3BucketSvmDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket svm delete collection o k response
func (o *S3BucketSvmDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3BucketSvmDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmDeleteCollectionOK %s", 200, payload)
}

func (o *S3BucketSvmDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmDeleteCollectionOK %s", 200, payload)
}

func (o *S3BucketSvmDeleteCollectionOK) GetPayload() *models.S3BucketSvmJobLinkResponse {
	return o.Payload
}

func (o *S3BucketSvmDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketSvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSvmDeleteCollectionAccepted creates a S3BucketSvmDeleteCollectionAccepted with default headers values
func NewS3BucketSvmDeleteCollectionAccepted() *S3BucketSvmDeleteCollectionAccepted {
	return &S3BucketSvmDeleteCollectionAccepted{}
}

/*
S3BucketSvmDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3BucketSvmDeleteCollectionAccepted struct {
	Payload *models.S3BucketSvmJobLinkResponse
}

// IsSuccess returns true when this s3 bucket svm delete collection accepted response has a 2xx status code
func (o *S3BucketSvmDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket svm delete collection accepted response has a 3xx status code
func (o *S3BucketSvmDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket svm delete collection accepted response has a 4xx status code
func (o *S3BucketSvmDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket svm delete collection accepted response has a 5xx status code
func (o *S3BucketSvmDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket svm delete collection accepted response a status code equal to that given
func (o *S3BucketSvmDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 bucket svm delete collection accepted response
func (o *S3BucketSvmDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *S3BucketSvmDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmDeleteCollectionAccepted %s", 202, payload)
}

func (o *S3BucketSvmDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmDeleteCollectionAccepted %s", 202, payload)
}

func (o *S3BucketSvmDeleteCollectionAccepted) GetPayload() *models.S3BucketSvmJobLinkResponse {
	return o.Payload
}

func (o *S3BucketSvmDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketSvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSvmDeleteCollectionDefault creates a S3BucketSvmDeleteCollectionDefault with default headers values
func NewS3BucketSvmDeleteCollectionDefault(code int) *S3BucketSvmDeleteCollectionDefault {
	return &S3BucketSvmDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketSvmDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405811   | "Failed to delete bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Wait a few minutes and try the operation again.";
| 92405858   | "Failed to \\\"delete\\\" the \\\"bucket\\\" because the operation is only supported on data SVMs.";
| 92405861   | "The specified SVM UUID or bucket UUID does not exist.";
| 92405779   | "Failed to remove bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Reason: {Reason for failure}. ";
| 92405813   | "Failed to delete the object store volume. Reason: {Reason for failure}.";
| 92405864   | "An error occurred when deleting an access policy. The reason for failure is detailed in the error message.";
*/
type S3BucketSvmDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket svm delete collection default response has a 2xx status code
func (o *S3BucketSvmDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket svm delete collection default response has a 3xx status code
func (o *S3BucketSvmDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket svm delete collection default response has a 4xx status code
func (o *S3BucketSvmDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket svm delete collection default response has a 5xx status code
func (o *S3BucketSvmDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket svm delete collection default response a status code equal to that given
func (o *S3BucketSvmDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket svm delete collection default response
func (o *S3BucketSvmDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSvmDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3_bucket_svm_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSvmDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/buckets][%d] s3_bucket_svm_delete_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSvmDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSvmDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketSvmDeleteCollectionBody s3 bucket svm delete collection body
swagger:model S3BucketSvmDeleteCollectionBody
*/
type S3BucketSvmDeleteCollectionBody struct {

	// s3 bucket svm response inline records
	S3BucketSvmResponseInlineRecords []*models.S3BucketSvm `json:"records,omitempty"`
}

// Validate validates this s3 bucket svm delete collection body
func (o *S3BucketSvmDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3BucketSvmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmDeleteCollectionBody) validateS3BucketSvmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketSvmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketSvmResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketSvmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketSvmResponseInlineRecords[i] != nil {
			if err := o.S3BucketSvmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm delete collection body based on the context it is used
func (o *S3BucketSvmDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3BucketSvmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmDeleteCollectionBody) contextValidateS3BucketSvmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketSvmResponseInlineRecords); i++ {

		if o.S3BucketSvmResponseInlineRecords[i] != nil {
			if err := o.S3BucketSvmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
