// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3BucketSvmGetParams creates a new S3BucketSvmGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketSvmGetParams() *S3BucketSvmGetParams {
	return &S3BucketSvmGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketSvmGetParamsWithTimeout creates a new S3BucketSvmGetParams object
// with the ability to set a timeout on a request.
func NewS3BucketSvmGetParamsWithTimeout(timeout time.Duration) *S3BucketSvmGetParams {
	return &S3BucketSvmGetParams{
		timeout: timeout,
	}
}

// NewS3BucketSvmGetParamsWithContext creates a new S3BucketSvmGetParams object
// with the ability to set a context for a request.
func NewS3BucketSvmGetParamsWithContext(ctx context.Context) *S3BucketSvmGetParams {
	return &S3BucketSvmGetParams{
		Context: ctx,
	}
}

// NewS3BucketSvmGetParamsWithHTTPClient creates a new S3BucketSvmGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketSvmGetParamsWithHTTPClient(client *http.Client) *S3BucketSvmGetParams {
	return &S3BucketSvmGetParams{
		HTTPClient: client,
	}
}

/*
S3BucketSvmGetParams contains all the parameters to send to the API endpoint

	for the s3 bucket svm get operation.

	Typically these are written to a http.Request.
*/
type S3BucketSvmGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   The unique identifier of the bucket.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket svm get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSvmGetParams) WithDefaults() *S3BucketSvmGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket svm get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSvmGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithTimeout(timeout time.Duration) *S3BucketSvmGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithContext(ctx context.Context) *S3BucketSvmGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithHTTPClient(client *http.Client) *S3BucketSvmGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithFields(fields []string) *S3BucketSvmGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithSvmUUID adds the svmUUID to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithSvmUUID(svmUUID string) *S3BucketSvmGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) WithUUID(uuid string) *S3BucketSvmGetParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket svm get params
func (o *S3BucketSvmGetParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketSvmGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3BucketSvmGet binds the parameter fields
func (o *S3BucketSvmGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
