// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSvmGetReader is a Reader for the S3BucketSvmGet structure.
type S3BucketSvmGetReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSvmGetReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketSvmGetOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSvmGetDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSvmGetOK creates a S3BucketSvmGetOK with default headers values
func NewS3BucketSvmGetOK() *S3BucketSvmGetOK {
	return &S3BucketSvmGetOK{}
}

/*
S3BucketSvmGetOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketSvmGetOK struct {
	Payload *models.S3BucketSvm
}

// IsSuccess returns true when this s3 bucket svm get o k response has a 2xx status code
func (o *S3BucketSvmGetOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket svm get o k response has a 3xx status code
func (o *S3BucketSvmGetOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket svm get o k response has a 4xx status code
func (o *S3BucketSvmGetOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket svm get o k response has a 5xx status code
func (o *S3BucketSvmGetOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket svm get o k response a status code equal to that given
func (o *S3BucketSvmGetOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket svm get o k response
func (o *S3BucketSvmGetOK) Code() int {
	return 200
}

func (o *S3BucketSvmGetOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{uuid}][%d] s3BucketSvmGetOK %s", 200, payload)
}

func (o *S3BucketSvmGetOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{uuid}][%d] s3BucketSvmGetOK %s", 200, payload)
}

func (o *S3BucketSvmGetOK) GetPayload() *models.S3BucketSvm {
	return o.Payload
}

func (o *S3BucketSvmGetOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketSvm)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSvmGetDefault creates a S3BucketSvmGetDefault with default headers values
func NewS3BucketSvmGetDefault(code int) *S3BucketSvmGetDefault {
	return &S3BucketSvmGetDefault{
		_statusCode: code,
	}
}

/*
S3BucketSvmGetDefault describes a response with status code -1, with default header values.

Error
*/
type S3BucketSvmGetDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket svm get default response has a 2xx status code
func (o *S3BucketSvmGetDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket svm get default response has a 3xx status code
func (o *S3BucketSvmGetDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket svm get default response has a 4xx status code
func (o *S3BucketSvmGetDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket svm get default response has a 5xx status code
func (o *S3BucketSvmGetDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket svm get default response a status code equal to that given
func (o *S3BucketSvmGetDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket svm get default response
func (o *S3BucketSvmGetDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSvmGetDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{uuid}][%d] s3_bucket_svm_get default %s", o._statusCode, payload)
}

func (o *S3BucketSvmGetDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[GET /protocols/s3/services/{svm.uuid}/buckets/{uuid}][%d] s3_bucket_svm_get default %s", o._statusCode, payload)
}

func (o *S3BucketSvmGetDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSvmGetDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
