// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3BucketSvmModifyCollectionReader is a Reader for the S3BucketSvmModifyCollection structure.
type S3BucketSvmModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3BucketSvmModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3BucketSvmModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3BucketSvmModifyCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3BucketSvmModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3BucketSvmModifyCollectionOK creates a S3BucketSvmModifyCollectionOK with default headers values
func NewS3BucketSvmModifyCollectionOK() *S3BucketSvmModifyCollectionOK {
	return &S3BucketSvmModifyCollectionOK{}
}

/*
S3BucketSvmModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3BucketSvmModifyCollectionOK struct {
	Payload *models.S3BucketSvmJobLinkResponse
}

// IsSuccess returns true when this s3 bucket svm modify collection o k response has a 2xx status code
func (o *S3BucketSvmModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket svm modify collection o k response has a 3xx status code
func (o *S3BucketSvmModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket svm modify collection o k response has a 4xx status code
func (o *S3BucketSvmModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket svm modify collection o k response has a 5xx status code
func (o *S3BucketSvmModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket svm modify collection o k response a status code equal to that given
func (o *S3BucketSvmModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 bucket svm modify collection o k response
func (o *S3BucketSvmModifyCollectionOK) Code() int {
	return 200
}

func (o *S3BucketSvmModifyCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketSvmModifyCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmModifyCollectionOK %s", 200, payload)
}

func (o *S3BucketSvmModifyCollectionOK) GetPayload() *models.S3BucketSvmJobLinkResponse {
	return o.Payload
}

func (o *S3BucketSvmModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketSvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSvmModifyCollectionAccepted creates a S3BucketSvmModifyCollectionAccepted with default headers values
func NewS3BucketSvmModifyCollectionAccepted() *S3BucketSvmModifyCollectionAccepted {
	return &S3BucketSvmModifyCollectionAccepted{}
}

/*
S3BucketSvmModifyCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3BucketSvmModifyCollectionAccepted struct {
	Payload *models.S3BucketSvmJobLinkResponse
}

// IsSuccess returns true when this s3 bucket svm modify collection accepted response has a 2xx status code
func (o *S3BucketSvmModifyCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 bucket svm modify collection accepted response has a 3xx status code
func (o *S3BucketSvmModifyCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 bucket svm modify collection accepted response has a 4xx status code
func (o *S3BucketSvmModifyCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 bucket svm modify collection accepted response has a 5xx status code
func (o *S3BucketSvmModifyCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 bucket svm modify collection accepted response a status code equal to that given
func (o *S3BucketSvmModifyCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 bucket svm modify collection accepted response
func (o *S3BucketSvmModifyCollectionAccepted) Code() int {
	return 202
}

func (o *S3BucketSvmModifyCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketSvmModifyCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3BucketSvmModifyCollectionAccepted %s", 202, payload)
}

func (o *S3BucketSvmModifyCollectionAccepted) GetPayload() *models.S3BucketSvmJobLinkResponse {
	return o.Payload
}

func (o *S3BucketSvmModifyCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3BucketSvmJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3BucketSvmModifyCollectionDefault creates a S3BucketSvmModifyCollectionDefault with default headers values
func NewS3BucketSvmModifyCollectionDefault(code int) *S3BucketSvmModifyCollectionDefault {
	return &S3BucketSvmModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3BucketSvmModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error code | Message |
| ---------- | ------- |
| 92405778   | "Failed to modify bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Reason: {Reason for failure}. ";
| 92405846   | "Failed to modify the object store volume. Reason: {Reason for failure}.";
| 92405811   | "Failed to modify bucket \\\"{bucket name}\\\" for SVM \\\"{svm.name}\\\". Wait a few minutes and try the operation again.";
| 92405858   | "Failed to \\\"modify\\\" the \\\"bucket\\\" because the operation is only supported on data SVMs.";
| 92405861   | "The specified \\\"{parameter field}\\\", \\\"{parameter value}\\\", does not exist.";
| 92405863   | "Failed to create access policies for bucket \\\"{bucket name}\\\". Reason: \"Principal list can have a maximum of 10 entries.\". Resolve all the issues and retry the operation.";
| 92405864   | "An error occurs when deleting an access policy. The reason for failure is detailed in the error message.";
| 92405891   | "The resources specified in the access policy are not valid. Valid ways to specify a resource are \\\"*\\\", \\\"<bucket-name>\\\", \\\"<bucket-name>/.../...\\\". Valid characters for a resource are 0-9, A-Z, a-z, \\\"_\\\", \\\"+\\\", \\\",\\\", \\\";\\\", \\\":\\\", \\\";\\\", \\\"=\\\", \\\".\\\", \\\"&\\\", \\\"@\\\", \\\"?\\\", \\\"(\\\", \\\")\\\", \\\"'\\\", \\\"*\\\", \\\"!\\\", \\\"-\\\" and \\\"\\$\\\".";
| 92405894   | "Statements, principals and resources list can have a maximum of 10 entries.";
| 92405897   | "The principals specified in the access policy are not in the correct format. User name must be in between 1 and 64 characters. Valid characters for a user name are 0-9, A-Z, a-z, \\\"_\\\", \\\"+\\\", \\\"=\\\", \\\",\\\", \\\".\\\", \\\"@\\\", and \\\"-\\\". ";
| 92405898   | "The SID specified in the access policy is not valid.";
| 92405940   | "The specified condition key is not valid for operator \"ip-address\". Valid choices of keys for this operator: source-ips.";
| 92406014   | "Failed to modify event selector for bucket \\\"{bucket name}\\\". If value of either access or permission is set to none, then the other must be set to none as well.";
| 92406032   | "Modifying the NAS path for a NAS bucket is not supported.";
| 92406230   | "The value for \\\"retention.default_period\\\" parameter for object store bucket \\\"<bucket>\\\" cannot be greater than the maximum lock retention period set in the object store server for SVM \\\"<SVM>\\\". Check the maximum allowed lock retention period present in the object store server for SVM \\\"<SVM>\\\" and try the operation again.";
| 92406236   | "The value for \\\"retention.default_period\\\" parameter for object store bucket \\\"<bucket>\\\" cannot be less than the minimum lock retention period set in the object store server for SVM \\\"<SVM>\\\". Check the minimum allowed lock retention period present in the object store server for SVM \\\"<SVM>\\\" and try the operation again.";
| 92406217   | "The specified \"allowed_headers\" is not valid because it contains more than one wild card (\"*\") character.";
| 92406224   | "A Cross-Origin Resource Sharing (CORS) rule must have an origin and HTTP method specified.";
| 92406222   | "Cannot specify Cross-Origin Resource Sharing (CORS) configuration for object store bucket \\\"<bucket>\\\" on SVM \\\"<SVM>\\\". Specifying such configuration is supported on object store volumes created in ONTAP 9.8 or later releases only.";
| 92406211   | "The specified method \"DONE\" is not valid. Valid methods are GET, PUT, DELETE, HEAD, and POST.";
| 92405863   | "Failed to create CORS rules for bucket \"bb1\". Reason: \"Field \"index\" cannot be specified for this operation.\". Resolve all the issues and retry the operation.";
| 92406228   | "Cannot exceed the maximum limit of 100 Cross-Origin Resource Sharing (CORS) rules per S3 bucket \\\"<bucket>\\\" in SVM \\\"<SVM>\\\".";;
*/
type S3BucketSvmModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 bucket svm modify collection default response has a 2xx status code
func (o *S3BucketSvmModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 bucket svm modify collection default response has a 3xx status code
func (o *S3BucketSvmModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 bucket svm modify collection default response has a 4xx status code
func (o *S3BucketSvmModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 bucket svm modify collection default response has a 5xx status code
func (o *S3BucketSvmModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 bucket svm modify collection default response a status code equal to that given
func (o *S3BucketSvmModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 bucket svm modify collection default response
func (o *S3BucketSvmModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3BucketSvmModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3_bucket_svm_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSvmModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/buckets][%d] s3_bucket_svm_modify_collection default %s", o._statusCode, payload)
}

func (o *S3BucketSvmModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3BucketSvmModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3BucketSvmModifyCollectionBody s3 bucket svm modify collection body
swagger:model S3BucketSvmModifyCollectionBody
*/
type S3BucketSvmModifyCollectionBody struct {

	// audit event selector
	AuditEventSelector *models.S3BucketSvmInlineAuditEventSelector `json:"audit_event_selector,omitempty"`

	// Can contain any additional information about the bucket being created or modified.
	// Example: S3 bucket.
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the number of constituents or FlexVol volumes per aggregate. A FlexGroup volume consisting of all such constituents across all specified aggregates is created. This option is used along with the aggregates option and cannot be used independently. This field cannot be set using the PATCH method.
	// Example: 4
	// Maximum: 1000
	// Minimum: 1
	ConstituentsPerAggregate *int64 `json:"constituents_per_aggregate,omitempty"`

	// cors
	Cors *models.S3BucketSvmInlineCors `json:"cors,omitempty"`

	// encryption
	Encryption *models.S3BucketSvmInlineEncryption `json:"encryption,omitempty"`

	// Specifies whether the NAS bucket returns a consistent ETag across different S3 requests.
	IsConsistentEtag *bool `json:"is_consistent_etag,omitempty"`

	// Specifies whether the NAS bucket mapping or association with a NAS volume can change according to the changes in the NAS volume junction-path due to volume operations like mount and unmount and therefore the NAS bucket will have access to any path in a NAS volume that matches the specified nas-path. Or is immutable and therefore the NAS bucket will always have access to the same nas-path that was specified during bucket creation even if the volume junction-path has undergone changes after the bucket creation.
	IsNasPathMutable *bool `json:"is_nas_path_mutable,omitempty"`

	// lifecycle management
	LifecycleManagement *models.S3BucketSvmInlineLifecycleManagement `json:"lifecycle_management,omitempty"`

	// Specifies the bucket logical used size up to this point. This field cannot be set using the PATCH method.
	// Read Only: true
	LogicalUsedSize *int64 `json:"logical_used_size,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	Name *string `json:"name,omitempty"`

	// Specifies the NAS path to which the nas bucket corresponds to.
	// Example: /
	NasPath *string `json:"nas_path,omitempty"`

	// policy
	Policy *models.S3BucketSvmInlinePolicy `json:"policy,omitempty"`

	// protection status
	ProtectionStatus *models.S3BucketSvmInlineProtectionStatus `json:"protection_status,omitempty"`

	// qos policy
	QosPolicy *models.S3BucketSvmInlineQosPolicy `json:"qos_policy,omitempty"`

	// retention
	Retention *models.S3BucketSvmInlineRetention `json:"retention,omitempty"`

	// Specifies the role of the bucket. This field cannot be set in a POST method.
	// Read Only: true
	// Enum: ["standalone","active","passive"]
	Role *string `json:"role,omitempty"`

	// A list of aggregates for FlexGroup volume constituents where the bucket is hosted. If this option is not specified, the bucket is auto-provisioned as a FlexGroup volume. The "uuid" field cannot be used with the field "storage_service_level".
	S3BucketSvmInlineAggregates []*models.S3BucketSvmInlineAggregatesInlineArrayItem `json:"aggregates,omitempty"`

	// s3 bucket svm response inline records
	S3BucketSvmResponseInlineRecords []*models.S3BucketSvm `json:"records,omitempty"`

	// Specifies the bucket size in bytes; ranges from 190MB to 62PB.
	// Example: 819200000
	// Maximum: 6.2672162783232e+16
	// Minimum: 1.9922944e+08
	Size *int64 `json:"size,omitempty"`

	// snapshot policy
	SnapshotPolicy *models.S3BucketSvmInlineSnapshotPolicy `json:"snapshot_policy,omitempty"`

	// Specifies the storage service level of the FlexGroup volume on which the bucket should be created. Valid values are "value", "performance" or "extreme". This field cannot be used with the field "aggregates.uuid" or with the "constituents_per_aggregate" in a POST method. This field cannot be set using the PATCH method.
	// Example: value
	// Enum: ["value","performance","extreme"]
	StorageServiceLevel *string `json:"storage_service_level,omitempty"`

	// svm
	Svm *models.S3BucketSvmInlineSvm `json:"svm,omitempty"`

	// Specifies the bucket type. Valid values are "s3"and "nas". This field cannot be set using the PATCH method.
	// Example: s3
	// Enum: ["s3","nas"]
	Type *string `json:"type,omitempty"`

	// Specifies the unique identifier of the bucket. This field cannot be specified in a POST or PATCH method.
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`

	// Specifies the versioning state of the bucket. Valid values are "disabled", "enabled" or "suspended". Note that the versioning state cannot be modified to 'disabled' from any other state.
	// Example: enabled
	// Enum: ["disabled","enabled","suspended"]
	VersioningState *string `json:"versioning_state,omitempty"`

	// volume
	Volume *models.S3BucketSvmInlineVolume `json:"volume,omitempty"`
}

// Validate validates this s3 bucket svm modify collection body
func (o *S3BucketSvmModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAuditEventSelector(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateConstituentsPerAggregate(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateCors(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateEncryption(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateLifecycleManagement(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateProtectionStatus(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateQosPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRetention(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateRole(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3BucketSvmInlineAggregates(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3BucketSvmResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSize(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSnapshotPolicy(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateStorageServiceLevel(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateType(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVersioningState(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateVolume(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateAuditEventSelector(formats strfmt.Registry) error {
	if swag.IsZero(o.AuditEventSelector) { // not required
		return nil
	}

	if o.AuditEventSelector != nil {
		if err := o.AuditEventSelector.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateConstituentsPerAggregate(formats strfmt.Registry) error {
	if swag.IsZero(o.ConstituentsPerAggregate) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"constituents_per_aggregate", "body", *o.ConstituentsPerAggregate, 1000, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateCors(formats strfmt.Registry) error {
	if swag.IsZero(o.Cors) { // not required
		return nil
	}

	if o.Cors != nil {
		if err := o.Cors.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cors")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateEncryption(formats strfmt.Registry) error {
	if swag.IsZero(o.Encryption) { // not required
		return nil
	}

	if o.Encryption != nil {
		if err := o.Encryption.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateLifecycleManagement(formats strfmt.Registry) error {
	if swag.IsZero(o.LifecycleManagement) { // not required
		return nil
	}

	if o.LifecycleManagement != nil {
		if err := o.LifecycleManagement.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 63); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validatePolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.Policy) { // not required
		return nil
	}

	if o.Policy != nil {
		if err := o.Policy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateProtectionStatus(formats strfmt.Registry) error {
	if swag.IsZero(o.ProtectionStatus) { // not required
		return nil
	}

	if o.ProtectionStatus != nil {
		if err := o.ProtectionStatus.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateQosPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.QosPolicy) { // not required
		return nil
	}

	if o.QosPolicy != nil {
		if err := o.QosPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateRetention(formats strfmt.Registry) error {
	if swag.IsZero(o.Retention) { // not required
		return nil
	}

	if o.Retention != nil {
		if err := o.Retention.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmModifyCollectionBodyTypeRolePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["standalone","active","passive"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmModifyCollectionBodyTypeRolePropEnum = append(s3BucketSvmModifyCollectionBodyTypeRolePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// role
	// Role
	// standalone
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyRoleStandalone captures enum value "standalone"
	S3BucketSvmModifyCollectionBodyRoleStandalone string = "standalone"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// role
	// Role
	// active
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyRoleActive captures enum value "active"
	S3BucketSvmModifyCollectionBodyRoleActive string = "active"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// role
	// Role
	// passive
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyRolePassive captures enum value "passive"
	S3BucketSvmModifyCollectionBodyRolePassive string = "passive"
)

// prop value enum
func (o *S3BucketSvmModifyCollectionBody) validateRoleEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmModifyCollectionBodyTypeRolePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateRole(formats strfmt.Registry) error {
	if swag.IsZero(o.Role) { // not required
		return nil
	}

	// value enum
	if err := o.validateRoleEnum("info"+"."+"role", "body", *o.Role); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateS3BucketSvmInlineAggregates(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketSvmInlineAggregates) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketSvmInlineAggregates); i++ {
		if swag.IsZero(o.S3BucketSvmInlineAggregates[i]) { // not required
			continue
		}

		if o.S3BucketSvmInlineAggregates[i] != nil {
			if err := o.S3BucketSvmInlineAggregates[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateS3BucketSvmResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3BucketSvmResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3BucketSvmResponseInlineRecords); i++ {
		if swag.IsZero(o.S3BucketSvmResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3BucketSvmResponseInlineRecords[i] != nil {
			if err := o.S3BucketSvmResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateSize(formats strfmt.Registry) error {
	if swag.IsZero(o.Size) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"size", "body", *o.Size, 1.9922944e+08, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"size", "body", *o.Size, 6.2672162783232e+16, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateSnapshotPolicy(formats strfmt.Registry) error {
	if swag.IsZero(o.SnapshotPolicy) { // not required
		return nil
	}

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmModifyCollectionBodyTypeStorageServiceLevelPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["value","performance","extreme"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmModifyCollectionBodyTypeStorageServiceLevelPropEnum = append(s3BucketSvmModifyCollectionBodyTypeStorageServiceLevelPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// value
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyStorageServiceLevelValue captures enum value "value"
	S3BucketSvmModifyCollectionBodyStorageServiceLevelValue string = "value"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// performance
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyStorageServiceLevelPerformance captures enum value "performance"
	S3BucketSvmModifyCollectionBodyStorageServiceLevelPerformance string = "performance"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// storage_service_level
	// StorageServiceLevel
	// extreme
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyStorageServiceLevelExtreme captures enum value "extreme"
	S3BucketSvmModifyCollectionBodyStorageServiceLevelExtreme string = "extreme"
)

// prop value enum
func (o *S3BucketSvmModifyCollectionBody) validateStorageServiceLevelEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmModifyCollectionBodyTypeStorageServiceLevelPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateStorageServiceLevel(formats strfmt.Registry) error {
	if swag.IsZero(o.StorageServiceLevel) { // not required
		return nil
	}

	// value enum
	if err := o.validateStorageServiceLevelEnum("info"+"."+"storage_service_level", "body", *o.StorageServiceLevel); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

var s3BucketSvmModifyCollectionBodyTypeTypePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["s3","nas"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmModifyCollectionBodyTypeTypePropEnum = append(s3BucketSvmModifyCollectionBodyTypeTypePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// type
	// Type
	// s3
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyTypeS3 captures enum value "s3"
	S3BucketSvmModifyCollectionBodyTypeS3 string = "s3"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// type
	// Type
	// nas
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyTypeNas captures enum value "nas"
	S3BucketSvmModifyCollectionBodyTypeNas string = "nas"
)

// prop value enum
func (o *S3BucketSvmModifyCollectionBody) validateTypeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmModifyCollectionBodyTypeTypePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateType(formats strfmt.Registry) error {
	if swag.IsZero(o.Type) { // not required
		return nil
	}

	// value enum
	if err := o.validateTypeEnum("info"+"."+"type", "body", *o.Type); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

var s3BucketSvmModifyCollectionBodyTypeVersioningStatePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["disabled","enabled","suspended"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmModifyCollectionBodyTypeVersioningStatePropEnum = append(s3BucketSvmModifyCollectionBodyTypeVersioningStatePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// versioning_state
	// VersioningState
	// disabled
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyVersioningStateDisabled captures enum value "disabled"
	S3BucketSvmModifyCollectionBodyVersioningStateDisabled string = "disabled"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// versioning_state
	// VersioningState
	// enabled
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyVersioningStateEnabled captures enum value "enabled"
	S3BucketSvmModifyCollectionBodyVersioningStateEnabled string = "enabled"

	// BEGIN DEBUGGING
	// S3BucketSvmModifyCollectionBody
	// S3BucketSvmModifyCollectionBody
	// versioning_state
	// VersioningState
	// suspended
	// END DEBUGGING
	// S3BucketSvmModifyCollectionBodyVersioningStateSuspended captures enum value "suspended"
	S3BucketSvmModifyCollectionBodyVersioningStateSuspended string = "suspended"
)

// prop value enum
func (o *S3BucketSvmModifyCollectionBody) validateVersioningStateEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmModifyCollectionBodyTypeVersioningStatePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateVersioningState(formats strfmt.Registry) error {
	if swag.IsZero(o.VersioningState) { // not required
		return nil
	}

	// value enum
	if err := o.validateVersioningStateEnum("info"+"."+"versioning_state", "body", *o.VersioningState); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) validateVolume(formats strfmt.Registry) error {
	if swag.IsZero(o.Volume) { // not required
		return nil
	}

	if o.Volume != nil {
		if err := o.Volume.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection body based on the context it is used
func (o *S3BucketSvmModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateAuditEventSelector(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateCors(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateEncryption(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLifecycleManagement(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateLogicalUsedSize(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidatePolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateProtectionStatus(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateQosPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRetention(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateRole(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3BucketSvmInlineAggregates(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3BucketSvmResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSnapshotPolicy(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateVolume(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateAuditEventSelector(ctx context.Context, formats strfmt.Registry) error {

	if o.AuditEventSelector != nil {
		if err := o.AuditEventSelector.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "audit_event_selector")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateCors(ctx context.Context, formats strfmt.Registry) error {

	if o.Cors != nil {
		if err := o.Cors.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "cors")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateEncryption(ctx context.Context, formats strfmt.Registry) error {

	if o.Encryption != nil {
		if err := o.Encryption.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "encryption")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateLifecycleManagement(ctx context.Context, formats strfmt.Registry) error {

	if o.LifecycleManagement != nil {
		if err := o.LifecycleManagement.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "lifecycle_management")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateLogicalUsedSize(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"logical_used_size", "body", o.LogicalUsedSize); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidatePolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.Policy != nil {
		if err := o.Policy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateProtectionStatus(ctx context.Context, formats strfmt.Registry) error {

	if o.ProtectionStatus != nil {
		if err := o.ProtectionStatus.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateQosPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.QosPolicy != nil {
		if err := o.QosPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateRetention(ctx context.Context, formats strfmt.Registry) error {

	if o.Retention != nil {
		if err := o.Retention.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "retention")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateRole(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"role", "body", o.Role); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateS3BucketSvmInlineAggregates(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketSvmInlineAggregates); i++ {

		if o.S3BucketSvmInlineAggregates[i] != nil {
			if err := o.S3BucketSvmInlineAggregates[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "aggregates" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateS3BucketSvmResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3BucketSvmResponseInlineRecords); i++ {

		if o.S3BucketSvmResponseInlineRecords[i] != nil {
			if err := o.S3BucketSvmResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateSnapshotPolicy(ctx context.Context, formats strfmt.Registry) error {

	if o.SnapshotPolicy != nil {
		if err := o.SnapshotPolicy.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "snapshot_policy")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionBody) contextValidateVolume(ctx context.Context, formats strfmt.Registry) error {

	if o.Volume != nil {
		if err := o.Volume.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0 Information about the CORS rule of an S3 bucket.
swagger:model S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0
*/
type S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0 struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links `json:"_links,omitempty"`

	// An array of HTTP headers allowed in the cross-origin requests.
	//
	// Example: ["x-amz-request-id"]
	AllowedHeaders []*string `json:"allowed_headers"`

	// An array of HTTP methods allowed in the cross-origin requests.
	//
	// Example: ["PUT","DELETE"]
	AllowedMethods []*string `json:"allowed_methods"`

	// List of origins from where a cross-origin request is allowed to originate from for the S3 bucket.
	//
	// Example: ["http://www.example.com"]
	AllowedOrigins []*string `json:"allowed_origins"`

	// List of extra headers sent in the response that customers can access from their applications.
	//
	// Example: ["x-amz-date"]
	ExposeHeaders []*string `json:"expose_headers"`

	// Bucket CORS rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	ID *string `json:"id,omitempty"`

	// The time in seconds for your browser to cache the preflight response for the specified resource.
	// Example: 1024
	MaxAgeSeconds *int64 `json:"max_age_seconds,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body cors rules items0
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) validateID(formats strfmt.Registry) error {
	if swag.IsZero(o.ID) { // not required
		return nil
	}

	if err := validate.MinLength("id", "body", *o.ID, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("id", "body", *o.ID, 256); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body cors rules items0 based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links s3 bucket svm modify collection params body cors rules items0 links
swagger:model S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links
*/
type S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body cors rules items0 links
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body cors rules items0 links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0 Information about the lifecycle management rule of a bucket.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0 struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links `json:"_links,omitempty"`

	// abort incomplete multipart upload
	AbortIncompleteMultipartUpload *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload `json:"abort_incomplete_multipart_upload,omitempty"`

	// Specifies the name of the bucket. Bucket name is a string that can only contain the following combination of ASCII-range alphanumeric characters 0-9, a-z, ".", and "-".
	// Example: bucket1
	// Max Length: 63
	// Min Length: 3
	BucketName *string `json:"bucket_name,omitempty"`

	// Specifies whether or not the associated rule is enabled.
	Enabled *bool `json:"enabled,omitempty"`

	// expiration
	Expiration *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration `json:"expiration,omitempty"`

	// Bucket lifecycle management rule identifier. The length of the name can range from 0 to 256 characters.
	// Max Length: 256
	// Min Length: 0
	Name *string `json:"name,omitempty"`

	// non current version expiration
	NonCurrentVersionExpiration *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration `json:"non_current_version_expiration,omitempty"`

	// object filter
	ObjectFilter *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter `json:"object_filter,omitempty"`

	// svm
	Svm *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm `json:"svm,omitempty"`

	// Specifies the unique identifier of the bucket.
	// Example: 414b29a1-3b26-11e9-bd58-0050568ea055
	// Read Only: true
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateAbortIncompleteMultipartUpload(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateBucketName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateNonCurrentVersionExpiration(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectFilter(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateAbortIncompleteMultipartUpload(formats strfmt.Registry) error {
	if swag.IsZero(o.AbortIncompleteMultipartUpload) { // not required
		return nil
	}

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateBucketName(formats strfmt.Registry) error {
	if swag.IsZero(o.BucketName) { // not required
		return nil
	}

	if err := validate.MinLength("bucket_name", "body", *o.BucketName, 3); err != nil {
		return err
	}

	if err := validate.MaxLength("bucket_name", "body", *o.BucketName, 63); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.Expiration) { // not required
		return nil
	}

	if o.Expiration != nil {
		if err := o.Expiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateNonCurrentVersionExpiration(formats strfmt.Registry) error {
	if swag.IsZero(o.NonCurrentVersionExpiration) { // not required
		return nil
	}

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateObjectFilter(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectFilter) { // not required
		return nil
	}

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateAbortIncompleteMultipartUpload(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateNonCurrentVersionExpiration(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateObjectFilter(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateUUID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateAbortIncompleteMultipartUpload(ctx context.Context, formats strfmt.Registry) error {

	if o.AbortIncompleteMultipartUpload != nil {
		if err := o.AbortIncompleteMultipartUpload.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.Expiration != nil {
		if err := o.Expiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateNonCurrentVersionExpiration(ctx context.Context, formats strfmt.Registry) error {

	if o.NonCurrentVersionExpiration != nil {
		if err := o.NonCurrentVersionExpiration.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateObjectFilter(ctx context.Context, formats strfmt.Registry) error {

	if o.ObjectFilter != nil {
		if err := o.ObjectFilter.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) contextValidateUUID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "uuid", "body", o.UUID); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload Specifies a way to perform abort_incomplete_multipart_upload action on filtered objects within a bucket. It cannot be specified with tags.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks `json:"_links,omitempty"`

	// Number of days of initiation after which uploads can be aborted.
	AfterInitiationDays *int64 `json:"after_initiation_days,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 abort incomplete multipart upload
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 abort incomplete multipart upload based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUpload
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks s3 bucket svm modify collection params body lifecycle management rules items0 abort incomplete multipart upload links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 abort incomplete multipart upload links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 abort incomplete multipart upload links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("abort_incomplete_multipart_upload" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0AbortIncompleteMultipartUploadLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration Specifies a way to perform expiration action on filtered objects within a bucket.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks `json:"_links,omitempty"`

	// Cleanup object delete markers.
	ExpiredObjectDeleteMarker *bool `json:"expired_object_delete_marker,omitempty"`

	// Number of days since creation after which objects can be deleted. This cannot be used along with object_expiry_date.
	// Example: 100
	ObjectAgeDays *int64 `json:"object_age_days,omitempty"`

	// Specific date from when objects can expire. This cannot be used with object_age_days.
	// Example: 2039-09-23 00:00:00+00:00
	// Format: date-time
	ObjectExpiryDate *strfmt.DateTime `json:"object_expiry_date,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 expiration
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateObjectExpiryDate(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) validateObjectExpiryDate(formats strfmt.Registry) error {
	if swag.IsZero(o.ObjectExpiryDate) { // not required
		return nil
	}

	if err := validate.FormatOf("expiration"+"."+"object_expiry_date", "body", "date-time", o.ObjectExpiryDate.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 expiration based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Expiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks s3 bucket svm modify collection params body lifecycle management rules items0 expiration links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 expiration links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 expiration links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links s3 bucket svm modify collection params body lifecycle management rules items0 links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Links
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration Specifies a way to perform non_current_version_expiration action on filtered objects within a bucket.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks `json:"_links,omitempty"`

	// Number of latest non-current versions to be retained.
	NewNonCurrentVersions *int64 `json:"new_non_current_versions,omitempty"`

	// Number of days after which non-current versions can be deleted.
	NonCurrentDays *int64 `json:"non_current_days,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 non current version expiration
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 non current version expiration based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpiration
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks s3 bucket svm modify collection params body lifecycle management rules items0 non current version expiration links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 non current version expiration links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 non current version expiration links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("non_current_version_expiration" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0NonCurrentVersionExpirationLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter Specifies a way to filter objects within a bucket.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks `json:"_links,omitempty"`

	// A prefix that is matched against object-names within a bucket.
	// Example: /logs
	Prefix *string `json:"prefix,omitempty"`

	// Size of the object greater than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10240
	SizeGreaterThan *int64 `json:"size_greater_than,omitempty"`

	// Size of the object smaller than specified for which the corresponding lifecycle rule is to be applied.
	// Example: 10485760
	SizeLessThan *int64 `json:"size_less_than,omitempty"`

	// An array of key-value paired tags of the form <tag> or <tag=value>.
	//
	// Example: ["project1=projA","project2=projB"]
	Tags []*string `json:"tags"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 object filter
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 object filter based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilter
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks s3 bucket svm modify collection params body lifecycle management rules items0 object filter links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 object filter links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 object filter links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("object_filter" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0ObjectFilterLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm Specifies the name of the SVM where this bucket exists.
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm struct {

	// links
	Links *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 svm
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 svm based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0Svm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks s3 bucket svm modify collection params body lifecycle management rules items0 svm links
swagger:model S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks
*/
type S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm modify collection params body lifecycle management rules items0 svm links
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm modify collection params body lifecycle management rules items0 svm links based on the context it is used
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0SvmLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineAggregatesInlineArrayItem Aggregate
swagger:model s3_bucket_svm_inline_aggregates_inline_array_item
*/
type S3BucketSvmInlineAggregatesInlineArrayItem struct {

	// links
	Links *models.S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// name
	// Example: aggr1
	Name *string `json:"name,omitempty"`

	// uuid
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline aggregates inline array item
func (o *S3BucketSvmInlineAggregatesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineAggregatesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline aggregates inline array item based on the context it is used
func (o *S3BucketSvmInlineAggregatesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineAggregatesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineAggregatesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineAggregatesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAggregatesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks s3 bucket svm inline aggregates inline array item inline links
swagger:model s3_bucket_svm_inline_aggregates_inline_array_item_inline__links
*/
type S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline aggregates inline array item inline links
func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline aggregates inline array item inline links based on the context it is used
func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAggregatesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineAuditEventSelector Event selector allows you to specify access and permission types to audit.
swagger:model s3_bucket_svm_inline_audit_event_selector
*/
type S3BucketSvmInlineAuditEventSelector struct {

	// Specifies read and write access types.
	//
	// Enum: ["read","write","all","none"]
	Access *string `json:"access,omitempty"`

	// Specifies allow and deny permission types.
	//
	// Enum: ["deny","allow","all","none"]
	Permission *string `json:"permission,omitempty"`
}

// Validate validates this s3 bucket svm inline audit event selector
func (o *S3BucketSvmInlineAuditEventSelector) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateAccess(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validatePermission(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["read","write","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum = append(s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// read
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessRead captures enum value "read"
	S3BucketSvmInlineAuditEventSelectorAccessRead string = "read"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// write
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessWrite captures enum value "write"
	S3BucketSvmInlineAuditEventSelectorAccessWrite string = "write"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// all
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessAll captures enum value "all"
	S3BucketSvmInlineAuditEventSelectorAccessAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// access
	// Access
	// none
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorAccessNone captures enum value "none"
	S3BucketSvmInlineAuditEventSelectorAccessNone string = "none"
)

// prop value enum
func (o *S3BucketSvmInlineAuditEventSelector) validateAccessEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineAuditEventSelectorTypeAccessPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmInlineAuditEventSelector) validateAccess(formats strfmt.Registry) error {
	if swag.IsZero(o.Access) { // not required
		return nil
	}

	// value enum
	if err := o.validateAccessEnum("info"+"."+"audit_event_selector"+"."+"access", "body", *o.Access); err != nil {
		return err
	}

	return nil
}

var s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["deny","allow","all","none"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum = append(s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// deny
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionDeny captures enum value "deny"
	S3BucketSvmInlineAuditEventSelectorPermissionDeny string = "deny"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// allow
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionAllow captures enum value "allow"
	S3BucketSvmInlineAuditEventSelectorPermissionAllow string = "allow"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// all
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionAll captures enum value "all"
	S3BucketSvmInlineAuditEventSelectorPermissionAll string = "all"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_audit_event_selector
	// S3BucketSvmInlineAuditEventSelector
	// permission
	// Permission
	// none
	// END DEBUGGING
	// S3BucketSvmInlineAuditEventSelectorPermissionNone captures enum value "none"
	S3BucketSvmInlineAuditEventSelectorPermissionNone string = "none"
)

// prop value enum
func (o *S3BucketSvmInlineAuditEventSelector) validatePermissionEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineAuditEventSelectorTypePermissionPropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmInlineAuditEventSelector) validatePermission(formats strfmt.Registry) error {
	if swag.IsZero(o.Permission) { // not required
		return nil
	}

	// value enum
	if err := o.validatePermissionEnum("info"+"."+"audit_event_selector"+"."+"permission", "body", *o.Permission); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline audit event selector based on context it is used
func (o *S3BucketSvmInlineAuditEventSelector) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineAuditEventSelector) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineAuditEventSelector) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineAuditEventSelector
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineCors Cross-origin resource sharing (CORS) specifies an object associated with a bucket. The CORS configuration enables the bucket to service the cross-origin requests. A request might typically come from an origin with a domain that is different to that of the bucket. By configuring a CORS rule, you can define a combination of allowed origins, HTTP headers and methods that a bucket can use to filter out the cross-origin requests that it can service successfully.
swagger:model s3_bucket_svm_inline_cors
*/
type S3BucketSvmInlineCors struct {

	// Specifies an object store bucket CORS rule.
	Rules []*S3BucketSvmModifyCollectionParamsBodyCorsRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket svm inline cors
func (o *S3BucketSvmInlineCors) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineCors) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline cors based on the context it is used
func (o *S3BucketSvmInlineCors) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineCors) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "cors" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineCors) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineCors) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineCors
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineEncryption s3 bucket svm inline encryption
swagger:model s3_bucket_svm_inline_encryption
*/
type S3BucketSvmInlineEncryption struct {

	// Specifies whether encryption is enabled on the bucket. By default, encryption is disabled on a bucket. This field cannot be set in a POST or PATCH method.
	Enabled *bool `json:"enabled,omitempty"`
}

// Validate validates this s3 bucket svm inline encryption
func (o *S3BucketSvmInlineEncryption) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket svm inline encryption based on the context it is used
func (o *S3BucketSvmInlineEncryption) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineEncryption) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineEncryption) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineEncryption
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineLifecycleManagement Lifecycle management is implemented as an object associated with a bucket. It defines rules to be applied against objects within a bucket. These rules are applied in the background and can delete objects.
swagger:model s3_bucket_svm_inline_lifecycle_management
*/
type S3BucketSvmInlineLifecycleManagement struct {

	// Specifies an object store lifecycle management policy. This field cannot be set using the PATCH method.
	Rules []*S3BucketSvmModifyCollectionParamsBodyLifecycleManagementRulesItems0 `json:"rules,omitempty"`
}

// Validate validates this s3 bucket svm inline lifecycle management
func (o *S3BucketSvmInlineLifecycleManagement) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateRules(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineLifecycleManagement) validateRules(formats strfmt.Registry) error {
	if swag.IsZero(o.Rules) { // not required
		return nil
	}

	for i := 0; i < len(o.Rules); i++ {
		if swag.IsZero(o.Rules[i]) { // not required
			continue
		}

		if o.Rules[i] != nil {
			if err := o.Rules[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline lifecycle management based on the context it is used
func (o *S3BucketSvmInlineLifecycleManagement) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateRules(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineLifecycleManagement) contextValidateRules(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Rules); i++ {

		if o.Rules[i] != nil {
			if err := o.Rules[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "lifecycle_management" + "." + "rules" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineLifecycleManagement) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineLifecycleManagement) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineLifecycleManagement
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlinePolicy A policy is an object associated with a bucket. It defines resource (bucket, folder, or object) permissions. These policies get evaluated when an S3 user makes a request by executing a specific command. The user must be part of the principal (user or group) specified in the policy. Permissions in the policies determine whether the request is allowed or denied.
swagger:model s3_bucket_svm_inline_policy
*/
type S3BucketSvmInlinePolicy struct {

	// Specifies bucket access policy statement.
	Statements []*models.S3BucketPolicyStatement `json:"statements,omitempty"`
}

// Validate validates this s3 bucket svm inline policy
func (o *S3BucketSvmInlinePolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateStatements(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlinePolicy) validateStatements(formats strfmt.Registry) error {
	if swag.IsZero(o.Statements) { // not required
		return nil
	}

	for i := 0; i < len(o.Statements); i++ {
		if swag.IsZero(o.Statements[i]) { // not required
			continue
		}

		if o.Statements[i] != nil {
			if err := o.Statements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline policy based on the context it is used
func (o *S3BucketSvmInlinePolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlinePolicy) contextValidateStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.Statements); i++ {

		if o.Statements[i] != nil {
			if err := o.Statements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policy" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlinePolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlinePolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlinePolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineProtectionStatus Specifies attributes of bucket protection.
swagger:model s3_bucket_svm_inline_protection_status
*/
type S3BucketSvmInlineProtectionStatus struct {

	// destination
	Destination *models.S3BucketSvmInlineProtectionStatusInlineDestination `json:"destination,omitempty"`

	// Specifies whether a bucket is a source and if it is protected within ONTAP and/or an external cloud. This field cannot be set in a POST method.
	// Read Only: true
	IsProtected *bool `json:"is_protected,omitempty"`
}

// Validate validates this s3 bucket svm inline protection status
func (o *S3BucketSvmInlineProtectionStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateDestination(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineProtectionStatus) validateDestination(formats strfmt.Registry) error {
	if swag.IsZero(o.Destination) { // not required
		return nil
	}

	if o.Destination != nil {
		if err := o.Destination.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline protection status based on the context it is used
func (o *S3BucketSvmInlineProtectionStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateDestination(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsProtected(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineProtectionStatus) contextValidateDestination(ctx context.Context, formats strfmt.Registry) error {

	if o.Destination != nil {
		if err := o.Destination.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "protection_status" + "." + "destination")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmInlineProtectionStatus) contextValidateIsProtected(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"is_protected", "body", o.IsProtected); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineProtectionStatus) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineProtectionStatus) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineProtectionStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineProtectionStatusInlineDestination s3 bucket svm inline protection status inline destination
swagger:model s3_bucket_svm_inline_protection_status_inline_destination
*/
type S3BucketSvmInlineProtectionStatusInlineDestination struct {

	// Specifies whether a bucket is protected within the Cloud.
	// Read Only: true
	IsCloud *bool `json:"is_cloud,omitempty"`

	// Specifies whether a bucket is protected on external Cloud providers.
	// Read Only: true
	IsExternalCloud *bool `json:"is_external_cloud,omitempty"`

	// Specifies whether a bucket is protected within ONTAP.
	// Read Only: true
	IsOntap *bool `json:"is_ontap,omitempty"`
}

// Validate validates this s3 bucket svm inline protection status inline destination
func (o *S3BucketSvmInlineProtectionStatusInlineDestination) Validate(formats strfmt.Registry) error {
	return nil
}

// ContextValidate validate this s3 bucket svm inline protection status inline destination based on the context it is used
func (o *S3BucketSvmInlineProtectionStatusInlineDestination) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateIsCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsExternalCloud(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateIsOntap(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_cloud", "body", o.IsCloud); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsExternalCloud(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_external_cloud", "body", o.IsExternalCloud); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmInlineProtectionStatusInlineDestination) contextValidateIsOntap(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"protection_status"+"."+"destination"+"."+"is_ontap", "body", o.IsOntap); err != nil {
		return err
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineProtectionStatusInlineDestination) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineProtectionStatusInlineDestination) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineProtectionStatusInlineDestination
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineQosPolicy Specifies "qos_policy.max_throughput_iops" and/or "qos_policy.max_throughput_mbps" or "qos_policy.min_throughput_iops" and/or "qos_policy.min_throughput_mbps". Specifying "min_throughput_iops" or "min_throughput_mbps" is only supported on volumes hosted on a node that is flash optimized. A pre-created QoS policy can also be used by specifying "qos_policy.name" or "qos_policy.uuid" properties. Setting or assigning a QoS policy to a bucket is not supported if its containing volume or SVM already has a QoS policy attached.
swagger:model s3_bucket_svm_inline_qos_policy
*/
type S3BucketSvmInlineQosPolicy struct {

	// links
	Links *models.S3BucketSvmInlineQosPolicyInlineLinks `json:"_links,omitempty"`

	// Specifies the maximum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either max_throughput_mbps or max_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MaxThroughput *string `json:"max_throughput,omitempty"`

	// Specifies the maximum throughput in IOPS, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 10000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MaxThroughputIops *int64 `json:"max_throughput_iops,omitempty"`

	// Specifies the maximum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when max_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MaxThroughputMbps *int64 `json:"max_throughput_mbps,omitempty"`

	// Specifies the minimum throughput in Kilobytes per sec, Megabytes per sec or Gigabytes per sec along with or without IOPS. 0 means none.Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when either min_throughput_mbps or min_throughput_iops are set during POST or PATCH. During GET, the returned value is rounded to the largest unit with a value greater than 1.
	// Example: ["900KB/s","500MB/s","120GB/s","5000IOPS","5000IOPS,500KB/s","2500IOPS,100MB/s","1000IOPS,25MB/s"]
	MinThroughput *string `json:"min_throughput,omitempty"`

	// Specifies the minimum throughput in IOPS, 0 means none. Setting "min_throughput" is supported on AFF platforms only, unless FabricPool tiering policies are set. This is mutually exclusive with name and UUID during POST and PATCH. This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 2000
	// Maximum: 2.147483647e+09
	// Minimum: 0
	MinThroughputIops *int64 `json:"min_throughput_iops,omitempty"`

	// Specifies the minimum throughput in Megabytes per sec, 0 means none. This is mutually exclusive with name and UUID during POST and PATCH.This cannot be set when min_throughput is set during POST or PATCH.
	// Example: 500
	// Maximum: 4.194303e+06
	// Minimum: 0
	MinThroughputMbps *int64 `json:"min_throughput_mbps,omitempty"`

	// The QoS policy group name. This is mutually exclusive with UUID and other QoS attributes during POST and PATCH.
	// Example: performance
	Name *string `json:"name,omitempty"`

	// The QoS policy group UUID. This is mutually exclusive with name and other QoS attributes during POST and PATCH.
	// Example: 1cd8a442-86d1-11e0-ae1c-123478563412
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline qos policy
func (o *S3BucketSvmInlineQosPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMaxThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputIops(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateMinThroughputMbps(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineQosPolicy) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3BucketSvmInlineQosPolicy) validateMaxThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_iops", "body", *o.MaxThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmInlineQosPolicy) validateMaxThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MaxThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"max_throughput_mbps", "body", *o.MaxThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmInlineQosPolicy) validateMinThroughputIops(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputIops) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_iops", "body", *o.MinThroughputIops, 2.147483647e+09, false); err != nil {
		return err
	}

	return nil
}

func (o *S3BucketSvmInlineQosPolicy) validateMinThroughputMbps(formats strfmt.Registry) error {
	if swag.IsZero(o.MinThroughputMbps) { // not required
		return nil
	}

	if err := validate.MinimumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 0, false); err != nil {
		return err
	}

	if err := validate.MaximumInt("info"+"."+"qos_policy"+"."+"min_throughput_mbps", "body", *o.MinThroughputMbps, 4.194303e+06, false); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline qos policy based on the context it is used
func (o *S3BucketSvmInlineQosPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineQosPolicy) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineQosPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineQosPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineQosPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineQosPolicyInlineLinks s3 bucket svm inline qos policy inline links
swagger:model s3_bucket_svm_inline_qos_policy_inline__links
*/
type S3BucketSvmInlineQosPolicyInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline qos policy inline links
func (o *S3BucketSvmInlineQosPolicyInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineQosPolicyInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline qos policy inline links based on the context it is used
func (o *S3BucketSvmInlineQosPolicyInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineQosPolicyInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "qos_policy" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineQosPolicyInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineQosPolicyInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineQosPolicyInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineRetention Specifies the retention mode and default retention period configured on the bucket.
swagger:model s3_bucket_svm_inline_retention
*/
type S3BucketSvmInlineRetention struct {

	// Specifies the default retention period that is applied to objects while committing them to the WORM state without an associated retention period. The retention period can be in years, or days. The retention period value represents a duration and must be specified in the ISO-8601 duration format.  A period specified for years and days is represented in the ISO-8601 format as "P<num>Y" and "P<num>D" respectively, for example "P10Y" represents a duration of 10 years. The period string must contain only a single time element that is, either years, or days. A duration which combines different periods is not supported, for example "P1Y10D" is not supported.
	// Example: P10Y
	DefaultPeriod *string `json:"default_period,omitempty"`

	// The lock mode of the bucket. <br>compliance &dash; A SnapLock Compliance (SLC) bucket provides the highest level of WORM protection and an administrator cannot destroy a compliance bucket if it contains unexpired WORM objects. <br> governance &dash; An administrator can delete a Governance bucket.<br> no_lock &dash; Indicates the bucket does not support object locking.
	// Example: governance
	// Enum: ["no_lock","compliance","governance"]
	Mode *string `json:"mode,omitempty"`
}

// Validate validates this s3 bucket svm inline retention
func (o *S3BucketSvmInlineRetention) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateMode(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

var s3BucketSvmInlineRetentionTypeModePropEnum []interface{}

func init() {
	var res []string
	if err := json.Unmarshal([]byte(`["no_lock","compliance","governance"]`), &res); err != nil {
		panic(err)
	}
	for _, v := range res {
		s3BucketSvmInlineRetentionTypeModePropEnum = append(s3BucketSvmInlineRetentionTypeModePropEnum, v)
	}
}

const (

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// no_lock
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeNoLock captures enum value "no_lock"
	S3BucketSvmInlineRetentionModeNoLock string = "no_lock"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// compliance
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeCompliance captures enum value "compliance"
	S3BucketSvmInlineRetentionModeCompliance string = "compliance"

	// BEGIN DEBUGGING
	// s3_bucket_svm_inline_retention
	// S3BucketSvmInlineRetention
	// mode
	// Mode
	// governance
	// END DEBUGGING
	// S3BucketSvmInlineRetentionModeGovernance captures enum value "governance"
	S3BucketSvmInlineRetentionModeGovernance string = "governance"
)

// prop value enum
func (o *S3BucketSvmInlineRetention) validateModeEnum(path, location string, value string) error {
	if err := validate.EnumCase(path, location, value, s3BucketSvmInlineRetentionTypeModePropEnum, true); err != nil {
		return err
	}
	return nil
}

func (o *S3BucketSvmInlineRetention) validateMode(formats strfmt.Registry) error {
	if swag.IsZero(o.Mode) { // not required
		return nil
	}

	// value enum
	if err := o.validateModeEnum("info"+"."+"retention"+"."+"mode", "body", *o.Mode); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline retention based on context it is used
func (o *S3BucketSvmInlineRetention) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineRetention) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineRetention) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineRetention
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineSnapshotPolicy Specifies the bucket snapshot policy.
swagger:model s3_bucket_svm_inline_snapshot_policy
*/
type S3BucketSvmInlineSnapshotPolicy struct {

	// Specifies the name of the snapshot policy.
	// Example: default-1weekly
	Name *string `json:"name,omitempty"`

	// Specifies the unique identifier of the snapshot policy.
	// Example: 3675af31-431c-12fa-114a-20675afebc12
	// Format: uuid
	UUID *strfmt.UUID `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline snapshot policy
func (o *S3BucketSvmInlineSnapshotPolicy) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateUUID(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineSnapshotPolicy) validateUUID(formats strfmt.Registry) error {
	if swag.IsZero(o.UUID) { // not required
		return nil
	}

	if err := validate.FormatOf("info"+"."+"snapshot_policy"+"."+"uuid", "body", "uuid", o.UUID.String(), formats); err != nil {
		return err
	}

	return nil
}

// ContextValidate validates this s3 bucket svm inline snapshot policy based on context it is used
func (o *S3BucketSvmInlineSnapshotPolicy) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineSnapshotPolicy) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineSnapshotPolicy) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSnapshotPolicy
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_bucket_svm_inline_svm
*/
type S3BucketSvmInlineSvm struct {

	// links
	Links *models.S3BucketSvmInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline svm
func (o *S3BucketSvmInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline svm based on the context it is used
func (o *S3BucketSvmInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineSvmInlineLinks s3 bucket svm inline svm inline links
swagger:model s3_bucket_svm_inline_svm_inline__links
*/
type S3BucketSvmInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline svm inline links
func (o *S3BucketSvmInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline svm inline links based on the context it is used
func (o *S3BucketSvmInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineVolume Specifies the FlexGroup volume name and UUID where the bucket is hosted. This field cannot be set in a POST method.
swagger:model s3_bucket_svm_inline_volume
*/
type S3BucketSvmInlineVolume struct {

	// links
	Links *models.S3BucketSvmInlineVolumeInlineLinks `json:"_links,omitempty"`

	// The name of the volume. This field cannot be specified in a PATCH method.
	// Example: volume1
	Name *string `json:"name,omitempty"`

	// Unique identifier for the volume. This corresponds to the instance-uuid that is exposed in the CLI and ONTAPI. It does not change due to a volume move.
	// Example: 028baa66-41bd-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 bucket svm inline volume
func (o *S3BucketSvmInlineVolume) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineVolume) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline volume based on the context it is used
func (o *S3BucketSvmInlineVolume) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineVolume) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineVolume) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineVolume) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineVolume
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3BucketSvmInlineVolumeInlineLinks s3 bucket svm inline volume inline links
swagger:model s3_bucket_svm_inline_volume_inline__links
*/
type S3BucketSvmInlineVolumeInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 bucket svm inline volume inline links
func (o *S3BucketSvmInlineVolumeInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineVolumeInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 bucket svm inline volume inline links based on the context it is used
func (o *S3BucketSvmInlineVolumeInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3BucketSvmInlineVolumeInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "volume" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3BucketSvmInlineVolumeInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3BucketSvmInlineVolumeInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3BucketSvmInlineVolumeInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
