// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// NewS3BucketSvmModifyParams creates a new S3BucketSvmModifyParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3BucketSvmModifyParams() *S3BucketSvmModifyParams {
	return &S3BucketSvmModifyParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3BucketSvmModifyParamsWithTimeout creates a new S3BucketSvmModifyParams object
// with the ability to set a timeout on a request.
func NewS3BucketSvmModifyParamsWithTimeout(timeout time.Duration) *S3BucketSvmModifyParams {
	return &S3BucketSvmModifyParams{
		timeout: timeout,
	}
}

// NewS3BucketSvmModifyParamsWithContext creates a new S3BucketSvmModifyParams object
// with the ability to set a context for a request.
func NewS3BucketSvmModifyParamsWithContext(ctx context.Context) *S3BucketSvmModifyParams {
	return &S3BucketSvmModifyParams{
		Context: ctx,
	}
}

// NewS3BucketSvmModifyParamsWithHTTPClient creates a new S3BucketSvmModifyParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3BucketSvmModifyParamsWithHTTPClient(client *http.Client) *S3BucketSvmModifyParams {
	return &S3BucketSvmModifyParams{
		HTTPClient: client,
	}
}

/*
S3BucketSvmModifyParams contains all the parameters to send to the API endpoint

	for the s3 bucket svm modify operation.

	Typically these are written to a http.Request.
*/
type S3BucketSvmModifyParams struct {

	/* Info.

	   Info specification
	*/
	Info *models.S3BucketSvm

	/* RestoreToSnapshotName.

	   Name of the snapshot to restore. The bucket will be restored to the point in time the snapshot was taken.
	*/
	RestoreToSnapshotName *string

	/* RestoreToSnapshotUUID.

	   UUID of the snapshot to restore. The bucket will be restored to the point in time the snapshot was taken.
	*/
	RestoreToSnapshotUUID *string

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning. When doing a POST, PATCH, or DELETE operation on a single record, the default is 0 seconds.  This means that if an asynchronous operation is started, the server immediately returns HTTP code 202 (Accepted) along with a link to the job.  If a non-zero value is specified for POST, PATCH, or DELETE operations, ONTAP waits that length of time to see if the job completes so it can return something other than 202.
	*/
	ReturnTimeout *int64

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UUID.

	   The unique identifier of the bucket.
	*/
	UUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 bucket svm modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSvmModifyParams) WithDefaults() *S3BucketSvmModifyParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 bucket svm modify params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3BucketSvmModifyParams) SetDefaults() {
	var (
		returnTimeoutDefault = int64(0)
	)

	val := S3BucketSvmModifyParams{
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithTimeout(timeout time.Duration) *S3BucketSvmModifyParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithContext(ctx context.Context) *S3BucketSvmModifyParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithHTTPClient(client *http.Client) *S3BucketSvmModifyParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithInfo adds the info to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithInfo(info *models.S3BucketSvm) *S3BucketSvmModifyParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetInfo(info *models.S3BucketSvm) {
	o.Info = info
}

// WithRestoreToSnapshotName adds the restoreToSnapshotName to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithRestoreToSnapshotName(restoreToSnapshotName *string) *S3BucketSvmModifyParams {
	o.SetRestoreToSnapshotName(restoreToSnapshotName)
	return o
}

// SetRestoreToSnapshotName adds the restoreToSnapshotName to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetRestoreToSnapshotName(restoreToSnapshotName *string) {
	o.RestoreToSnapshotName = restoreToSnapshotName
}

// WithRestoreToSnapshotUUID adds the restoreToSnapshotUUID to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithRestoreToSnapshotUUID(restoreToSnapshotUUID *string) *S3BucketSvmModifyParams {
	o.SetRestoreToSnapshotUUID(restoreToSnapshotUUID)
	return o
}

// SetRestoreToSnapshotUUID adds the restoreToSnapshotUuid to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetRestoreToSnapshotUUID(restoreToSnapshotUUID *string) {
	o.RestoreToSnapshotUUID = restoreToSnapshotUUID
}

// WithReturnTimeout adds the returnTimeout to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithReturnTimeout(returnTimeout *int64) *S3BucketSvmModifyParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmUUID adds the svmUUID to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithSvmUUID(svmUUID string) *S3BucketSvmModifyParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUUID adds the uuid to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) WithUUID(uuid string) *S3BucketSvmModifyParams {
	o.SetUUID(uuid)
	return o
}

// SetUUID adds the uuid to the s3 bucket svm modify params
func (o *S3BucketSvmModifyParams) SetUUID(uuid string) {
	o.UUID = uuid
}

// WriteToRequest writes these params to a swagger request
func (o *S3BucketSvmModifyParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Info != nil {
		if err := r.SetBodyParam(o.Info); err != nil {
			return err
		}
	}

	if o.RestoreToSnapshotName != nil {

		// query param restore_to.snapshot.name
		var qrRestoreToSnapshotName string

		if o.RestoreToSnapshotName != nil {
			qrRestoreToSnapshotName = *o.RestoreToSnapshotName
		}
		qRestoreToSnapshotName := qrRestoreToSnapshotName
		if qRestoreToSnapshotName != "" {

			if err := r.SetQueryParam("restore_to.snapshot.name", qRestoreToSnapshotName); err != nil {
				return err
			}
		}
	}

	if o.RestoreToSnapshotUUID != nil {

		// query param restore_to.snapshot.uuid
		var qrRestoreToSnapshotUUID string

		if o.RestoreToSnapshotUUID != nil {
			qrRestoreToSnapshotUUID = *o.RestoreToSnapshotUUID
		}
		qRestoreToSnapshotUUID := qrRestoreToSnapshotUUID
		if qRestoreToSnapshotUUID != "" {

			if err := r.SetQueryParam("restore_to.snapshot.uuid", qRestoreToSnapshotUUID); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	// path param uuid
	if err := r.SetPathParam("uuid", o.UUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
