// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3GroupCollectionGetParams creates a new S3GroupCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3GroupCollectionGetParams() *S3GroupCollectionGetParams {
	return &S3GroupCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3GroupCollectionGetParamsWithTimeout creates a new S3GroupCollectionGetParams object
// with the ability to set a timeout on a request.
func NewS3GroupCollectionGetParamsWithTimeout(timeout time.Duration) *S3GroupCollectionGetParams {
	return &S3GroupCollectionGetParams{
		timeout: timeout,
	}
}

// NewS3GroupCollectionGetParamsWithContext creates a new S3GroupCollectionGetParams object
// with the ability to set a context for a request.
func NewS3GroupCollectionGetParamsWithContext(ctx context.Context) *S3GroupCollectionGetParams {
	return &S3GroupCollectionGetParams{
		Context: ctx,
	}
}

// NewS3GroupCollectionGetParamsWithHTTPClient creates a new S3GroupCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3GroupCollectionGetParamsWithHTTPClient(client *http.Client) *S3GroupCollectionGetParams {
	return &S3GroupCollectionGetParams{
		HTTPClient: client,
	}
}

/*
S3GroupCollectionGetParams contains all the parameters to send to the API endpoint

	for the s3 group collection get operation.

	Typically these are written to a http.Request.
*/
type S3GroupCollectionGetParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* PoliciesName.

	   Filter by policies.name
	*/
	PoliciesName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupCollectionGetParams) WithDefaults() *S3GroupCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 group collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := S3GroupCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithTimeout(timeout time.Duration) *S3GroupCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithContext(ctx context.Context) *S3GroupCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithHTTPClient(client *http.Client) *S3GroupCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithComment(comment *string) *S3GroupCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithFields adds the fields to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithFields(fields []string) *S3GroupCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithID(id *int64) *S3GroupCollectionGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetID(id *int64) {
	o.ID = id
}

// WithMaxRecords adds the maxRecords to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithMaxRecords(maxRecords *int64) *S3GroupCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithName adds the name to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithName(name *string) *S3GroupCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithOrderBy(orderBy []string) *S3GroupCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPoliciesName adds the policiesName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithPoliciesName(policiesName *string) *S3GroupCollectionGetParams {
	o.SetPoliciesName(policiesName)
	return o
}

// SetPoliciesName adds the policiesName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetPoliciesName(policiesName *string) {
	o.PoliciesName = policiesName
}

// WithReturnRecords adds the returnRecords to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithReturnRecords(returnRecords *bool) *S3GroupCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *S3GroupCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSvmName adds the svmName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithSvmName(svmName *string) *S3GroupCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithSvmUUID(svmUUID string) *S3GroupCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUsersName adds the usersName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) WithUsersName(usersName *string) *S3GroupCollectionGetParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the s3 group collection get params
func (o *S3GroupCollectionGetParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WriteToRequest writes these params to a swagger request
func (o *S3GroupCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.PoliciesName != nil {

		// query param policies.name
		var qrPoliciesName string

		if o.PoliciesName != nil {
			qrPoliciesName = *o.PoliciesName
		}
		qPoliciesName := qrPoliciesName
		if qPoliciesName != "" {

			if err := r.SetQueryParam("policies.name", qPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3GroupCollectionGet binds the parameter fields
func (o *S3GroupCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamS3GroupCollectionGet binds the parameter order_by
func (o *S3GroupCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
