// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3GroupCreateReader is a Reader for the S3GroupCreate structure.
type S3GroupCreateReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3GroupCreateReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 201:
		result := NewS3GroupCreateCreated()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3GroupCreateDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3GroupCreateCreated creates a S3GroupCreateCreated with default headers values
func NewS3GroupCreateCreated() *S3GroupCreateCreated {
	return &S3GroupCreateCreated{}
}

/*
S3GroupCreateCreated describes a response with status code 201, with default header values.

Created
*/
type S3GroupCreateCreated struct {

	/* Useful for tracking the resource location
	 */
	Location string

	Payload *models.S3GroupResponse
}

// IsSuccess returns true when this s3 group create created response has a 2xx status code
func (o *S3GroupCreateCreated) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 group create created response has a 3xx status code
func (o *S3GroupCreateCreated) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 group create created response has a 4xx status code
func (o *S3GroupCreateCreated) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 group create created response has a 5xx status code
func (o *S3GroupCreateCreated) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 group create created response a status code equal to that given
func (o *S3GroupCreateCreated) IsCode(code int) bool {
	return code == 201
}

// Code gets the status code for the s3 group create created response
func (o *S3GroupCreateCreated) Code() int {
	return 201
}

func (o *S3GroupCreateCreated) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupCreateCreated %s", 201, payload)
}

func (o *S3GroupCreateCreated) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupCreateCreated %s", 201, payload)
}

func (o *S3GroupCreateCreated) GetPayload() *models.S3GroupResponse {
	return o.Payload
}

func (o *S3GroupCreateCreated) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	// hydrates response header Location
	hdrLocation := response.GetHeader("Location")

	if hdrLocation != "" {
		o.Location = hdrLocation
	}

	o.Payload = new(models.S3GroupResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3GroupCreateDefault creates a S3GroupCreateDefault with default headers values
func NewS3GroupCreateDefault(code int) *S3GroupCreateDefault {
	return &S3GroupCreateDefault{
		_statusCode: code,
	}
}

/*
	S3GroupCreateDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92406207   | An object store group cannot have an empty list of users.
| 92405930   | Group name \\\"{group name}\\\" is not valid. Group names must have between 1 and 128 characters.
| 92405931   | Group name \\\"{group name}\\\" contains invalid characters. Valid characters for a group name are 0-9, A-Z, a-z, "_", "+", "=", ",", ".", "@", and "-".
| 92405932   | Creating an object store group requires an effective cluster version of 9.8 or later.
| 92405933   | Failed to create group for SVM. Reason: "{reason of failure}".
| 92405934   | Users {user name} specified in the user list do not exist for SVM \\\"{vserver name}\\\". Use the \"object-store-server user create\" command to create a user.
| 92405935   | Internal Error. Unable to generate unique ID for the group.
| 92405936   | Query characters such as * are not supported in the user list.
| 92405937   | Policies {policy name} specified in the policy list do not exist for SVM \\\"{vserver name}\\\".
| 92405942   | Group name \\\"{group name}\\\" already exists for SVM \\\"{vserver name}\\\".
| 92405858   | Failed to \"create\" the \"group\" because the operation is only supported on data SVMs.
| 262222     | User name is present more than once in the users field.
| 92406154   | Users {user} specified in the user list do not exist for SVM "vs1". Use the "/protocols/s3/services/{svm.uuid}/users" endpoint to create a user.
| 92406307   | Cannot add object store user \"user1\" in SVM \"vs1\" to the group. Reason: The user is disabled, because it does not have keys generated.
*/
type S3GroupCreateDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 group create default response has a 2xx status code
func (o *S3GroupCreateDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 group create default response has a 3xx status code
func (o *S3GroupCreateDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 group create default response has a 4xx status code
func (o *S3GroupCreateDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 group create default response has a 5xx status code
func (o *S3GroupCreateDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 group create default response a status code equal to that given
func (o *S3GroupCreateDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 group create default response
func (o *S3GroupCreateDefault) Code() int {
	return o._statusCode
}

func (o *S3GroupCreateDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_create default %s", o._statusCode, payload)
}

func (o *S3GroupCreateDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[POST /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_create default %s", o._statusCode, payload)
}

func (o *S3GroupCreateDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3GroupCreateDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
