// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3GroupDeleteCollectionParams creates a new S3GroupDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3GroupDeleteCollectionParams() *S3GroupDeleteCollectionParams {
	return &S3GroupDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3GroupDeleteCollectionParamsWithTimeout creates a new S3GroupDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewS3GroupDeleteCollectionParamsWithTimeout(timeout time.Duration) *S3GroupDeleteCollectionParams {
	return &S3GroupDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewS3GroupDeleteCollectionParamsWithContext creates a new S3GroupDeleteCollectionParams object
// with the ability to set a context for a request.
func NewS3GroupDeleteCollectionParamsWithContext(ctx context.Context) *S3GroupDeleteCollectionParams {
	return &S3GroupDeleteCollectionParams{
		Context: ctx,
	}
}

// NewS3GroupDeleteCollectionParamsWithHTTPClient creates a new S3GroupDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3GroupDeleteCollectionParamsWithHTTPClient(client *http.Client) *S3GroupDeleteCollectionParams {
	return &S3GroupDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
S3GroupDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the s3 group delete collection operation.

	Typically these are written to a http.Request.
*/
type S3GroupDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* ID.

	   Filter by id
	*/
	ID *int64

	/* Info.

	   Info specification
	*/
	Info S3GroupDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* PoliciesName.

	   Filter by policies.name
	*/
	PoliciesName *string

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 group delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupDeleteCollectionParams) WithDefaults() *S3GroupDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 group delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := S3GroupDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithTimeout(timeout time.Duration) *S3GroupDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithContext(ctx context.Context) *S3GroupDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithHTTPClient(client *http.Client) *S3GroupDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithComment(comment *string) *S3GroupDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *S3GroupDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithID adds the id to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithID(id *int64) *S3GroupDeleteCollectionParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetID(id *int64) {
	o.ID = id
}

// WithInfo adds the info to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithInfo(info S3GroupDeleteCollectionBody) *S3GroupDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetInfo(info S3GroupDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithName(name *string) *S3GroupDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithPoliciesName adds the policiesName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithPoliciesName(policiesName *string) *S3GroupDeleteCollectionParams {
	o.SetPoliciesName(policiesName)
	return o
}

// SetPoliciesName adds the policiesName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetPoliciesName(policiesName *string) {
	o.PoliciesName = policiesName
}

// WithReturnRecords adds the returnRecords to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *S3GroupDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *S3GroupDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *S3GroupDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithSvmName adds the svmName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithSvmName(svmName *string) *S3GroupDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithSvmUUID(svmUUID string) *S3GroupDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WithUsersName adds the usersName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) WithUsersName(usersName *string) *S3GroupDeleteCollectionParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the s3 group delete collection params
func (o *S3GroupDeleteCollectionParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WriteToRequest writes these params to a swagger request
func (o *S3GroupDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}

	if o.ID != nil {

		// query param id
		var qrID int64

		if o.ID != nil {
			qrID = *o.ID
		}
		qID := swag.FormatInt64(qrID)
		if qID != "" {

			if err := r.SetQueryParam("id", qID); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.PoliciesName != nil {

		// query param policies.name
		var qrPoliciesName string

		if o.PoliciesName != nil {
			qrPoliciesName = *o.PoliciesName
		}
		qPoliciesName := qrPoliciesName
		if qPoliciesName != "" {

			if err := r.SetQueryParam("policies.name", qPoliciesName); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
