// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3GroupDeleteCollectionReader is a Reader for the S3GroupDeleteCollection structure.
type S3GroupDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3GroupDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3GroupDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3GroupDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3GroupDeleteCollectionOK creates a S3GroupDeleteCollectionOK with default headers values
func NewS3GroupDeleteCollectionOK() *S3GroupDeleteCollectionOK {
	return &S3GroupDeleteCollectionOK{}
}

/*
S3GroupDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3GroupDeleteCollectionOK struct {
}

// IsSuccess returns true when this s3 group delete collection o k response has a 2xx status code
func (o *S3GroupDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 group delete collection o k response has a 3xx status code
func (o *S3GroupDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 group delete collection o k response has a 4xx status code
func (o *S3GroupDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 group delete collection o k response has a 5xx status code
func (o *S3GroupDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 group delete collection o k response a status code equal to that given
func (o *S3GroupDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 group delete collection o k response
func (o *S3GroupDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3GroupDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupDeleteCollectionOK", 200)
}

func (o *S3GroupDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupDeleteCollectionOK", 200)
}

func (o *S3GroupDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3GroupDeleteCollectionDefault creates a S3GroupDeleteCollectionDefault with default headers values
func NewS3GroupDeleteCollectionDefault(code int) *S3GroupDeleteCollectionDefault {
	return &S3GroupDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
S3GroupDeleteCollectionDefault describes a response with status code -1, with default header values.

Error
*/
type S3GroupDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 group delete collection default response has a 2xx status code
func (o *S3GroupDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 group delete collection default response has a 3xx status code
func (o *S3GroupDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 group delete collection default response has a 4xx status code
func (o *S3GroupDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 group delete collection default response has a 5xx status code
func (o *S3GroupDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 group delete collection default response a status code equal to that given
func (o *S3GroupDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 group delete collection default response
func (o *S3GroupDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3GroupDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_delete_collection default %s", o._statusCode, payload)
}

func (o *S3GroupDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_delete_collection default %s", o._statusCode, payload)
}

func (o *S3GroupDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3GroupDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3GroupDeleteCollectionBody s3 group delete collection body
swagger:model S3GroupDeleteCollectionBody
*/
type S3GroupDeleteCollectionBody struct {

	// s3 group response inline records
	S3GroupResponseInlineRecords []*models.S3Group `json:"records,omitempty"`
}

// Validate validates this s3 group delete collection body
func (o *S3GroupDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3GroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupDeleteCollectionBody) validateS3GroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3GroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3GroupResponseInlineRecords); i++ {
		if swag.IsZero(o.S3GroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3GroupResponseInlineRecords[i] != nil {
			if err := o.S3GroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 group delete collection body based on the context it is used
func (o *S3GroupDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3GroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupDeleteCollectionBody) contextValidateS3GroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3GroupResponseInlineRecords); i++ {

		if o.S3GroupResponseInlineRecords[i] != nil {
			if err := o.S3GroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3GroupDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
