// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3GroupGetParams creates a new S3GroupGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3GroupGetParams() *S3GroupGetParams {
	return &S3GroupGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3GroupGetParamsWithTimeout creates a new S3GroupGetParams object
// with the ability to set a timeout on a request.
func NewS3GroupGetParamsWithTimeout(timeout time.Duration) *S3GroupGetParams {
	return &S3GroupGetParams{
		timeout: timeout,
	}
}

// NewS3GroupGetParamsWithContext creates a new S3GroupGetParams object
// with the ability to set a context for a request.
func NewS3GroupGetParamsWithContext(ctx context.Context) *S3GroupGetParams {
	return &S3GroupGetParams{
		Context: ctx,
	}
}

// NewS3GroupGetParamsWithHTTPClient creates a new S3GroupGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3GroupGetParamsWithHTTPClient(client *http.Client) *S3GroupGetParams {
	return &S3GroupGetParams{
		HTTPClient: client,
	}
}

/*
S3GroupGetParams contains all the parameters to send to the API endpoint

	for the s3 group get operation.

	Typically these are written to a http.Request.
*/
type S3GroupGetParams struct {

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* ID.

	   Group identifier that identifies the unique group.
	*/
	ID string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupGetParams) WithDefaults() *S3GroupGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 group get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3GroupGetParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 group get params
func (o *S3GroupGetParams) WithTimeout(timeout time.Duration) *S3GroupGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 group get params
func (o *S3GroupGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 group get params
func (o *S3GroupGetParams) WithContext(ctx context.Context) *S3GroupGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 group get params
func (o *S3GroupGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 group get params
func (o *S3GroupGetParams) WithHTTPClient(client *http.Client) *S3GroupGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 group get params
func (o *S3GroupGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithFields adds the fields to the s3 group get params
func (o *S3GroupGetParams) WithFields(fields []string) *S3GroupGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 group get params
func (o *S3GroupGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithID adds the id to the s3 group get params
func (o *S3GroupGetParams) WithID(id string) *S3GroupGetParams {
	o.SetID(id)
	return o
}

// SetID adds the id to the s3 group get params
func (o *S3GroupGetParams) SetID(id string) {
	o.ID = id
}

// WithSvmUUID adds the svmUUID to the s3 group get params
func (o *S3GroupGetParams) WithSvmUUID(svmUUID string) *S3GroupGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 group get params
func (o *S3GroupGetParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3GroupGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	// path param id
	if err := r.SetPathParam("id", o.ID); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3GroupGet binds the parameter fields
func (o *S3GroupGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}
