// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3GroupModifyCollectionReader is a Reader for the S3GroupModifyCollection structure.
type S3GroupModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3GroupModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3GroupModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3GroupModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3GroupModifyCollectionOK creates a S3GroupModifyCollectionOK with default headers values
func NewS3GroupModifyCollectionOK() *S3GroupModifyCollectionOK {
	return &S3GroupModifyCollectionOK{}
}

/*
S3GroupModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3GroupModifyCollectionOK struct {
}

// IsSuccess returns true when this s3 group modify collection o k response has a 2xx status code
func (o *S3GroupModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 group modify collection o k response has a 3xx status code
func (o *S3GroupModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 group modify collection o k response has a 4xx status code
func (o *S3GroupModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 group modify collection o k response has a 5xx status code
func (o *S3GroupModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 group modify collection o k response a status code equal to that given
func (o *S3GroupModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 group modify collection o k response
func (o *S3GroupModifyCollectionOK) Code() int {
	return 200
}

func (o *S3GroupModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupModifyCollectionOK", 200)
}

func (o *S3GroupModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups][%d] s3GroupModifyCollectionOK", 200)
}

func (o *S3GroupModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3GroupModifyCollectionDefault creates a S3GroupModifyCollectionDefault with default headers values
func NewS3GroupModifyCollectionDefault(code int) *S3GroupModifyCollectionDefault {
	return &S3GroupModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3GroupModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405896   | Users list cannot be empty.
| 92405930   | Group name \\\"{group name}\\\" is not valid. Group names must have between 1 and 128 characters.
| 92405931   | Group name \\\"{group name}\\\" contains invalid characters. Valid characters for a group name are 0-9, A-Z, a-z, "_", "+", "=", ",", ".", "@", and "-".
| 92405934   | Users {user name} specified in the user list do not exist for SVM \\\"{vserver name}\\\". Use the \"object-store-server user create\" command to create a user.
| 92405936   | Query characters such as * are not supported in the user list.
| 92405937   | Policies {policy name} specified in the policy list do not exist for SVM \\\"{vserver name}\\\".
| 262222     | User name is present more than once in the users field.
| 2621706    | The specified \\\"{svm.uuid}\\\" and \\\"{svm.name}\\\" refer to different SVMs.
| 92406154   | Users {user} specified in the user list do not exist for SVM "vs1". Use the "/protocols/s3/services/{svm.uuid}/users" endpoint to create a user.
| 92406307   | Cannot add object store user \"user1\" in SVM \"vs1\" to the group. Reason: The user is disabled, because it does not have keys generated.
*/
type S3GroupModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 group modify collection default response has a 2xx status code
func (o *S3GroupModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 group modify collection default response has a 3xx status code
func (o *S3GroupModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 group modify collection default response has a 4xx status code
func (o *S3GroupModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 group modify collection default response has a 5xx status code
func (o *S3GroupModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 group modify collection default response a status code equal to that given
func (o *S3GroupModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 group modify collection default response
func (o *S3GroupModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3GroupModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_modify_collection default %s", o._statusCode, payload)
}

func (o *S3GroupModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups][%d] s3_group_modify_collection default %s", o._statusCode, payload)
}

func (o *S3GroupModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3GroupModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3GroupModifyCollectionBody s3 group modify collection body
swagger:model S3GroupModifyCollectionBody
*/
type S3GroupModifyCollectionBody struct {

	// Can contain any additional information about the group being created or modified.
	// Example: Admin group
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies a unique Group ID used to identify a particular group. This parameter should not be specified in the POST or PATCH method. A Group ID is automatically generated and it is retrieved using the GET method. Group ID is SVM-scoped.
	// Example: 5
	// Read Only: true
	ID *int64 `json:"id,omitempty"`

	// Specifies the name of the group. A group name length can range from 1 to 128 characters and can only contain the following combination of characters 0-9, A-Z, a-z, "_", "+", "=", ",", ".","@", and "-".
	// Example: Admin-Group
	// Max Length: 128
	// Min Length: 1
	// Pattern: ^[0-9A-Za-z_+=,.@-]{1,128}$
	Name *string `json:"name,omitempty"`

	// Specifies a list of policies that are attached to the group. The wildcard character "*" is a valid value for specifying all policies.
	S3GroupInlinePolicies []*models.S3GroupInlinePoliciesInlineArrayItem `json:"policies,omitempty"`

	// Specifies the list of users who belong to the group.
	S3GroupInlineUsers []*models.S3GroupInlineUsersInlineArrayItem `json:"users,omitempty"`

	// s3 group response inline records
	S3GroupResponseInlineRecords []*models.S3Group `json:"records,omitempty"`

	// svm
	Svm *models.S3GroupInlineSvm `json:"svm,omitempty"`
}

// Validate validates this s3 group modify collection body
func (o *S3GroupModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3GroupInlinePolicies(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3GroupInlineUsers(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3GroupResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3GroupModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 128); err != nil {
		return err
	}

	if err := validate.Pattern("info"+"."+"name", "body", *o.Name, `^[0-9A-Za-z_+=,.@-]{1,128}$`); err != nil {
		return err
	}

	return nil
}

func (o *S3GroupModifyCollectionBody) validateS3GroupInlinePolicies(formats strfmt.Registry) error {
	if swag.IsZero(o.S3GroupInlinePolicies) { // not required
		return nil
	}

	for i := 0; i < len(o.S3GroupInlinePolicies); i++ {
		if swag.IsZero(o.S3GroupInlinePolicies[i]) { // not required
			continue
		}

		if o.S3GroupInlinePolicies[i] != nil {
			if err := o.S3GroupInlinePolicies[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) validateS3GroupInlineUsers(formats strfmt.Registry) error {
	if swag.IsZero(o.S3GroupInlineUsers) { // not required
		return nil
	}

	for i := 0; i < len(o.S3GroupInlineUsers); i++ {
		if swag.IsZero(o.S3GroupInlineUsers[i]) { // not required
			continue
		}

		if o.S3GroupInlineUsers[i] != nil {
			if err := o.S3GroupInlineUsers[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) validateS3GroupResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3GroupResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3GroupResponseInlineRecords); i++ {
		if swag.IsZero(o.S3GroupResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3GroupResponseInlineRecords[i] != nil {
			if err := o.S3GroupResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 group modify collection body based on the context it is used
func (o *S3GroupModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateID(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3GroupInlinePolicies(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3GroupInlineUsers(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3GroupResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupModifyCollectionBody) contextValidateID(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"id", "body", o.ID); err != nil {
		return err
	}

	return nil
}

func (o *S3GroupModifyCollectionBody) contextValidateS3GroupInlinePolicies(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3GroupInlinePolicies); i++ {

		if o.S3GroupInlinePolicies[i] != nil {
			if err := o.S3GroupInlinePolicies[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "policies" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) contextValidateS3GroupInlineUsers(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3GroupInlineUsers); i++ {

		if o.S3GroupInlineUsers[i] != nil {
			if err := o.S3GroupInlineUsers[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "users" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) contextValidateS3GroupResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3GroupResponseInlineRecords); i++ {

		if o.S3GroupResponseInlineRecords[i] != nil {
			if err := o.S3GroupResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3GroupModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3GroupModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlinePoliciesInlineArrayItem s3 group inline policies inline array item
swagger:model s3_group_inline_policies_inline_array_item
*/
type S3GroupInlinePoliciesInlineArrayItem struct {

	// links
	Links *models.S3GroupInlinePoliciesInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Specifies the name of the policy. A policy name length can range from 1 to 128 characters and can only contain the following combination of characters 0-9, A-Z, a-z, "_", "+", "=", ",", ".","@", and "-".
	// Example: Policy1
	// Max Length: 128
	// Min Length: 1
	// Pattern: ^[0-9A-Za-z_+=,.@-]{1,128}$
	Name *string `json:"name,omitempty"`
}

// Validate validates this s3 group inline policies inline array item
func (o *S3GroupInlinePoliciesInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlinePoliciesInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3GroupInlinePoliciesInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 128); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", *o.Name, `^[0-9A-Za-z_+=,.@-]{1,128}$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 group inline policies inline array item based on the context it is used
func (o *S3GroupInlinePoliciesInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlinePoliciesInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlinePoliciesInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlinePoliciesInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3GroupInlinePoliciesInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlinePoliciesInlineArrayItemInlineLinks s3 group inline policies inline array item inline links
swagger:model s3_group_inline_policies_inline_array_item_inline__links
*/
type S3GroupInlinePoliciesInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 group inline policies inline array item inline links
func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 group inline policies inline array item inline links based on the context it is used
func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlinePoliciesInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3GroupInlinePoliciesInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_group_inline_svm
*/
type S3GroupInlineSvm struct {

	// links
	Links *models.S3GroupInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 group inline svm
func (o *S3GroupInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 group inline svm based on the context it is used
func (o *S3GroupInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3GroupInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlineSvmInlineLinks s3 group inline svm inline links
swagger:model s3_group_inline_svm_inline__links
*/
type S3GroupInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 group inline svm inline links
func (o *S3GroupInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 group inline svm inline links based on the context it is used
func (o *S3GroupInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3GroupInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlineUsersInlineArrayItem s3 group inline users inline array item
swagger:model s3_group_inline_users_inline_array_item
*/
type S3GroupInlineUsersInlineArrayItem struct {

	// links
	Links *models.S3GroupInlineUsersInlineArrayItemInlineLinks `json:"_links,omitempty"`

	// Specifies the name of the user. A user name length can range from 1 to 64 characters and can only contain the following combination of characters 0-9, A-Z, a-z, "_", "+", "=", ",", ".","@", and "-".
	// Example: user-1
	// Max Length: 64
	// Min Length: 1
	// Pattern: ^[0-9A-Za-z_+=,.@-]{1,64}$
	Name *string `json:"name,omitempty"`
}

// Validate validates this s3 group inline users inline array item
func (o *S3GroupInlineUsersInlineArrayItem) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineUsersInlineArrayItem) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

func (o *S3GroupInlineUsersInlineArrayItem) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("name", "body", *o.Name, 64); err != nil {
		return err
	}

	if err := validate.Pattern("name", "body", *o.Name, `^[0-9A-Za-z_+=,.@-]{1,64}$`); err != nil {
		return err
	}

	return nil
}

// ContextValidate validate this s3 group inline users inline array item based on the context it is used
func (o *S3GroupInlineUsersInlineArrayItem) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineUsersInlineArrayItem) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlineUsersInlineArrayItem) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlineUsersInlineArrayItem) UnmarshalBinary(b []byte) error {
	var res S3GroupInlineUsersInlineArrayItem
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3GroupInlineUsersInlineArrayItemInlineLinks s3 group inline users inline array item inline links
swagger:model s3_group_inline_users_inline_array_item_inline__links
*/
type S3GroupInlineUsersInlineArrayItemInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 group inline users inline array item inline links
func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 group inline users inline array item inline links based on the context it is used
func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3GroupInlineUsersInlineArrayItemInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3GroupInlineUsersInlineArrayItemInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
