// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3GroupModifyReader is a Reader for the S3GroupModify structure.
type S3GroupModifyReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3GroupModifyReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3GroupModifyOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3GroupModifyDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3GroupModifyOK creates a S3GroupModifyOK with default headers values
func NewS3GroupModifyOK() *S3GroupModifyOK {
	return &S3GroupModifyOK{}
}

/*
S3GroupModifyOK describes a response with status code 200, with default header values.

OK
*/
type S3GroupModifyOK struct {
}

// IsSuccess returns true when this s3 group modify o k response has a 2xx status code
func (o *S3GroupModifyOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 group modify o k response has a 3xx status code
func (o *S3GroupModifyOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 group modify o k response has a 4xx status code
func (o *S3GroupModifyOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 group modify o k response has a 5xx status code
func (o *S3GroupModifyOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 group modify o k response a status code equal to that given
func (o *S3GroupModifyOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 group modify o k response
func (o *S3GroupModifyOK) Code() int {
	return 200
}

func (o *S3GroupModifyOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups/{id}][%d] s3GroupModifyOK", 200)
}

func (o *S3GroupModifyOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups/{id}][%d] s3GroupModifyOK", 200)
}

func (o *S3GroupModifyOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3GroupModifyDefault creates a S3GroupModifyDefault with default headers values
func NewS3GroupModifyDefault(code int) *S3GroupModifyDefault {
	return &S3GroupModifyDefault{
		_statusCode: code,
	}
}

/*
	S3GroupModifyDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405896   | Users list cannot be empty.
| 92405930   | Group name \\\"{group name}\\\" is not valid. Group names must have between 1 and 128 characters.
| 92405931   | Group name \\\"{group name}\\\" contains invalid characters. Valid characters for a group name are 0-9, A-Z, a-z, "_", "+", "=", ",", ".", "@", and "-".
| 92405934   | Users {user name} specified in the user list do not exist for SVM \\\"{vserver name}\\\". Use the \"object-store-server user create\" command to create a user.
| 92405936   | Query characters such as * are not supported in the user list.
| 92405937   | Policies {policy name} specified in the policy list do not exist for SVM \\\"{vserver name}\\\".
| 262222     | User name is present more than once in the users field.
| 2621706    | The specified \\\"{svm.uuid}\\\" and \\\"{svm.name}\\\" refer to different SVMs.
| 92406154   | Users {user} specified in the user list do not exist for SVM "vs1". Use the "/protocols/s3/services/{svm.uuid}/users" endpoint to create a user.
| 92406307   | Cannot add object store user \"user1\" in SVM \"vs1\" to the group. Reason: The user is disabled, because it does not have keys generated.
*/
type S3GroupModifyDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 group modify default response has a 2xx status code
func (o *S3GroupModifyDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 group modify default response has a 3xx status code
func (o *S3GroupModifyDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 group modify default response has a 4xx status code
func (o *S3GroupModifyDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 group modify default response has a 5xx status code
func (o *S3GroupModifyDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 group modify default response a status code equal to that given
func (o *S3GroupModifyDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 group modify default response
func (o *S3GroupModifyDefault) Code() int {
	return o._statusCode
}

func (o *S3GroupModifyDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups/{id}][%d] s3_group_modify default %s", o._statusCode, payload)
}

func (o *S3GroupModifyDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/groups/{id}][%d] s3_group_modify default %s", o._statusCode, payload)
}

func (o *S3GroupModifyDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3GroupModifyDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
