// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3PolicyDeleteCollectionParams creates a new S3PolicyDeleteCollectionParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3PolicyDeleteCollectionParams() *S3PolicyDeleteCollectionParams {
	return &S3PolicyDeleteCollectionParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3PolicyDeleteCollectionParamsWithTimeout creates a new S3PolicyDeleteCollectionParams object
// with the ability to set a timeout on a request.
func NewS3PolicyDeleteCollectionParamsWithTimeout(timeout time.Duration) *S3PolicyDeleteCollectionParams {
	return &S3PolicyDeleteCollectionParams{
		timeout: timeout,
	}
}

// NewS3PolicyDeleteCollectionParamsWithContext creates a new S3PolicyDeleteCollectionParams object
// with the ability to set a context for a request.
func NewS3PolicyDeleteCollectionParamsWithContext(ctx context.Context) *S3PolicyDeleteCollectionParams {
	return &S3PolicyDeleteCollectionParams{
		Context: ctx,
	}
}

// NewS3PolicyDeleteCollectionParamsWithHTTPClient creates a new S3PolicyDeleteCollectionParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3PolicyDeleteCollectionParamsWithHTTPClient(client *http.Client) *S3PolicyDeleteCollectionParams {
	return &S3PolicyDeleteCollectionParams{
		HTTPClient: client,
	}
}

/*
S3PolicyDeleteCollectionParams contains all the parameters to send to the API endpoint

	for the s3 policy delete collection operation.

	Typically these are written to a http.Request.
*/
type S3PolicyDeleteCollectionParams struct {

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* ContinueOnFailure.

	   Continue even when the operation fails on one of the records.
	*/
	ContinueOnFailure *bool

	/* Info.

	   Info specification
	*/
	Info S3PolicyDeleteCollectionBody

	/* Name.

	   Filter by name
	*/
	Name *string

	/* ReadOnly.

	   Filter by read-only
	*/
	ReadOnly *bool

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SerialRecords.

	   Perform the operation on the records synchronously.
	*/
	SerialRecords *bool

	/* StatementsActions.

	   Filter by statements.actions
	*/
	StatementsActions *string

	/* StatementsEffect.

	   Filter by statements.effect
	*/
	StatementsEffect *string

	/* StatementsIndex.

	   Filter by statements.index
	*/
	StatementsIndex *int64

	/* StatementsResources.

	   Filter by statements.resources
	*/
	StatementsResources *string

	/* StatementsSid.

	   Filter by statements.sid
	*/
	StatementsSid *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 policy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3PolicyDeleteCollectionParams) WithDefaults() *S3PolicyDeleteCollectionParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 policy delete collection params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3PolicyDeleteCollectionParams) SetDefaults() {
	var (
		continueOnFailureDefault = bool(false)

		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)

		serialRecordsDefault = bool(false)
	)

	val := S3PolicyDeleteCollectionParams{
		ContinueOnFailure: &continueOnFailureDefault,
		ReturnRecords:     &returnRecordsDefault,
		ReturnTimeout:     &returnTimeoutDefault,
		SerialRecords:     &serialRecordsDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithTimeout(timeout time.Duration) *S3PolicyDeleteCollectionParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithContext(ctx context.Context) *S3PolicyDeleteCollectionParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithHTTPClient(client *http.Client) *S3PolicyDeleteCollectionParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithComment adds the comment to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithComment(comment *string) *S3PolicyDeleteCollectionParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithContinueOnFailure adds the continueOnFailure to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithContinueOnFailure(continueOnFailure *bool) *S3PolicyDeleteCollectionParams {
	o.SetContinueOnFailure(continueOnFailure)
	return o
}

// SetContinueOnFailure adds the continueOnFailure to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetContinueOnFailure(continueOnFailure *bool) {
	o.ContinueOnFailure = continueOnFailure
}

// WithInfo adds the info to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithInfo(info S3PolicyDeleteCollectionBody) *S3PolicyDeleteCollectionParams {
	o.SetInfo(info)
	return o
}

// SetInfo adds the info to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetInfo(info S3PolicyDeleteCollectionBody) {
	o.Info = info
}

// WithName adds the name to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithName(name *string) *S3PolicyDeleteCollectionParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetName(name *string) {
	o.Name = name
}

// WithReadOnly adds the readOnly to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithReadOnly(readOnly *bool) *S3PolicyDeleteCollectionParams {
	o.SetReadOnly(readOnly)
	return o
}

// SetReadOnly adds the readOnly to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetReadOnly(readOnly *bool) {
	o.ReadOnly = readOnly
}

// WithReturnRecords adds the returnRecords to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithReturnRecords(returnRecords *bool) *S3PolicyDeleteCollectionParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithReturnTimeout(returnTimeout *int64) *S3PolicyDeleteCollectionParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSerialRecords adds the serialRecords to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithSerialRecords(serialRecords *bool) *S3PolicyDeleteCollectionParams {
	o.SetSerialRecords(serialRecords)
	return o
}

// SetSerialRecords adds the serialRecords to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetSerialRecords(serialRecords *bool) {
	o.SerialRecords = serialRecords
}

// WithStatementsActions adds the statementsActions to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithStatementsActions(statementsActions *string) *S3PolicyDeleteCollectionParams {
	o.SetStatementsActions(statementsActions)
	return o
}

// SetStatementsActions adds the statementsActions to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetStatementsActions(statementsActions *string) {
	o.StatementsActions = statementsActions
}

// WithStatementsEffect adds the statementsEffect to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithStatementsEffect(statementsEffect *string) *S3PolicyDeleteCollectionParams {
	o.SetStatementsEffect(statementsEffect)
	return o
}

// SetStatementsEffect adds the statementsEffect to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetStatementsEffect(statementsEffect *string) {
	o.StatementsEffect = statementsEffect
}

// WithStatementsIndex adds the statementsIndex to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithStatementsIndex(statementsIndex *int64) *S3PolicyDeleteCollectionParams {
	o.SetStatementsIndex(statementsIndex)
	return o
}

// SetStatementsIndex adds the statementsIndex to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetStatementsIndex(statementsIndex *int64) {
	o.StatementsIndex = statementsIndex
}

// WithStatementsResources adds the statementsResources to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithStatementsResources(statementsResources *string) *S3PolicyDeleteCollectionParams {
	o.SetStatementsResources(statementsResources)
	return o
}

// SetStatementsResources adds the statementsResources to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetStatementsResources(statementsResources *string) {
	o.StatementsResources = statementsResources
}

// WithStatementsSid adds the statementsSid to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithStatementsSid(statementsSid *string) *S3PolicyDeleteCollectionParams {
	o.SetStatementsSid(statementsSid)
	return o
}

// SetStatementsSid adds the statementsSid to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetStatementsSid(statementsSid *string) {
	o.StatementsSid = statementsSid
}

// WithSvmName adds the svmName to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithSvmName(svmName *string) *S3PolicyDeleteCollectionParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) WithSvmUUID(svmUUID string) *S3PolicyDeleteCollectionParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 policy delete collection params
func (o *S3PolicyDeleteCollectionParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3PolicyDeleteCollectionParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.ContinueOnFailure != nil {

		// query param continue_on_failure
		var qrContinueOnFailure bool

		if o.ContinueOnFailure != nil {
			qrContinueOnFailure = *o.ContinueOnFailure
		}
		qContinueOnFailure := swag.FormatBool(qrContinueOnFailure)
		if qContinueOnFailure != "" {

			if err := r.SetQueryParam("continue_on_failure", qContinueOnFailure); err != nil {
				return err
			}
		}
	}
	if err := r.SetBodyParam(o.Info); err != nil {
		return err
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.ReadOnly != nil {

		// query param read-only
		var qrReadOnly bool

		if o.ReadOnly != nil {
			qrReadOnly = *o.ReadOnly
		}
		qReadOnly := swag.FormatBool(qrReadOnly)
		if qReadOnly != "" {

			if err := r.SetQueryParam("read-only", qReadOnly); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SerialRecords != nil {

		// query param serial_records
		var qrSerialRecords bool

		if o.SerialRecords != nil {
			qrSerialRecords = *o.SerialRecords
		}
		qSerialRecords := swag.FormatBool(qrSerialRecords)
		if qSerialRecords != "" {

			if err := r.SetQueryParam("serial_records", qSerialRecords); err != nil {
				return err
			}
		}
	}

	if o.StatementsActions != nil {

		// query param statements.actions
		var qrStatementsActions string

		if o.StatementsActions != nil {
			qrStatementsActions = *o.StatementsActions
		}
		qStatementsActions := qrStatementsActions
		if qStatementsActions != "" {

			if err := r.SetQueryParam("statements.actions", qStatementsActions); err != nil {
				return err
			}
		}
	}

	if o.StatementsEffect != nil {

		// query param statements.effect
		var qrStatementsEffect string

		if o.StatementsEffect != nil {
			qrStatementsEffect = *o.StatementsEffect
		}
		qStatementsEffect := qrStatementsEffect
		if qStatementsEffect != "" {

			if err := r.SetQueryParam("statements.effect", qStatementsEffect); err != nil {
				return err
			}
		}
	}

	if o.StatementsIndex != nil {

		// query param statements.index
		var qrStatementsIndex int64

		if o.StatementsIndex != nil {
			qrStatementsIndex = *o.StatementsIndex
		}
		qStatementsIndex := swag.FormatInt64(qrStatementsIndex)
		if qStatementsIndex != "" {

			if err := r.SetQueryParam("statements.index", qStatementsIndex); err != nil {
				return err
			}
		}
	}

	if o.StatementsResources != nil {

		// query param statements.resources
		var qrStatementsResources string

		if o.StatementsResources != nil {
			qrStatementsResources = *o.StatementsResources
		}
		qStatementsResources := qrStatementsResources
		if qStatementsResources != "" {

			if err := r.SetQueryParam("statements.resources", qStatementsResources); err != nil {
				return err
			}
		}
	}

	if o.StatementsSid != nil {

		// query param statements.sid
		var qrStatementsSid string

		if o.StatementsSid != nil {
			qrStatementsSid = *o.StatementsSid
		}
		qStatementsSid := qrStatementsSid
		if qStatementsSid != "" {

			if err := r.SetQueryParam("statements.sid", qStatementsSid); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
