// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3PolicyDeleteCollectionReader is a Reader for the S3PolicyDeleteCollection structure.
type S3PolicyDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3PolicyDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3PolicyDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3PolicyDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3PolicyDeleteCollectionOK creates a S3PolicyDeleteCollectionOK with default headers values
func NewS3PolicyDeleteCollectionOK() *S3PolicyDeleteCollectionOK {
	return &S3PolicyDeleteCollectionOK{}
}

/*
S3PolicyDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3PolicyDeleteCollectionOK struct {
}

// IsSuccess returns true when this s3 policy delete collection o k response has a 2xx status code
func (o *S3PolicyDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 policy delete collection o k response has a 3xx status code
func (o *S3PolicyDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 policy delete collection o k response has a 4xx status code
func (o *S3PolicyDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 policy delete collection o k response has a 5xx status code
func (o *S3PolicyDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 policy delete collection o k response a status code equal to that given
func (o *S3PolicyDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 policy delete collection o k response
func (o *S3PolicyDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3PolicyDeleteCollectionOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies][%d] s3PolicyDeleteCollectionOK", 200)
}

func (o *S3PolicyDeleteCollectionOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies][%d] s3PolicyDeleteCollectionOK", 200)
}

func (o *S3PolicyDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3PolicyDeleteCollectionDefault creates a S3PolicyDeleteCollectionDefault with default headers values
func NewS3PolicyDeleteCollectionDefault(code int) *S3PolicyDeleteCollectionDefault {
	return &S3PolicyDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3PolicyDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405858   | Failed to \"delete\" the \"policy\" because the operation is only supported on data SVMs.
*/
type S3PolicyDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 policy delete collection default response has a 2xx status code
func (o *S3PolicyDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 policy delete collection default response has a 3xx status code
func (o *S3PolicyDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 policy delete collection default response has a 4xx status code
func (o *S3PolicyDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 policy delete collection default response has a 5xx status code
func (o *S3PolicyDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 policy delete collection default response a status code equal to that given
func (o *S3PolicyDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 policy delete collection default response
func (o *S3PolicyDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3PolicyDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies][%d] s3_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *S3PolicyDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies][%d] s3_policy_delete_collection default %s", o._statusCode, payload)
}

func (o *S3PolicyDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3PolicyDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3PolicyDeleteCollectionBody s3 policy delete collection body
swagger:model S3PolicyDeleteCollectionBody
*/
type S3PolicyDeleteCollectionBody struct {

	// s3 policy response inline records
	S3PolicyResponseInlineRecords []*models.S3Policy `json:"records,omitempty"`
}

// Validate validates this s3 policy delete collection body
func (o *S3PolicyDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3PolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyDeleteCollectionBody) validateS3PolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3PolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3PolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.S3PolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3PolicyResponseInlineRecords[i] != nil {
			if err := o.S3PolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 policy delete collection body based on the context it is used
func (o *S3PolicyDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3PolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyDeleteCollectionBody) contextValidateS3PolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3PolicyResponseInlineRecords); i++ {

		if o.S3PolicyResponseInlineRecords[i] != nil {
			if err := o.S3PolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3PolicyDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3PolicyDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3PolicyDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
