// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewS3PolicyDeleteParams creates a new S3PolicyDeleteParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3PolicyDeleteParams() *S3PolicyDeleteParams {
	return &S3PolicyDeleteParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3PolicyDeleteParamsWithTimeout creates a new S3PolicyDeleteParams object
// with the ability to set a timeout on a request.
func NewS3PolicyDeleteParamsWithTimeout(timeout time.Duration) *S3PolicyDeleteParams {
	return &S3PolicyDeleteParams{
		timeout: timeout,
	}
}

// NewS3PolicyDeleteParamsWithContext creates a new S3PolicyDeleteParams object
// with the ability to set a context for a request.
func NewS3PolicyDeleteParamsWithContext(ctx context.Context) *S3PolicyDeleteParams {
	return &S3PolicyDeleteParams{
		Context: ctx,
	}
}

// NewS3PolicyDeleteParamsWithHTTPClient creates a new S3PolicyDeleteParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3PolicyDeleteParamsWithHTTPClient(client *http.Client) *S3PolicyDeleteParams {
	return &S3PolicyDeleteParams{
		HTTPClient: client,
	}
}

/*
S3PolicyDeleteParams contains all the parameters to send to the API endpoint

	for the s3 policy delete operation.

	Typically these are written to a http.Request.
*/
type S3PolicyDeleteParams struct {

	/* Name.

	   Policy name
	*/
	Name string

	/* SvmUUID.

	   UUID of the SVM to which this object belongs.
	*/
	SvmUUID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 policy delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3PolicyDeleteParams) WithDefaults() *S3PolicyDeleteParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 policy delete params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3PolicyDeleteParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the s3 policy delete params
func (o *S3PolicyDeleteParams) WithTimeout(timeout time.Duration) *S3PolicyDeleteParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 policy delete params
func (o *S3PolicyDeleteParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 policy delete params
func (o *S3PolicyDeleteParams) WithContext(ctx context.Context) *S3PolicyDeleteParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 policy delete params
func (o *S3PolicyDeleteParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 policy delete params
func (o *S3PolicyDeleteParams) WithHTTPClient(client *http.Client) *S3PolicyDeleteParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 policy delete params
func (o *S3PolicyDeleteParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithName adds the name to the s3 policy delete params
func (o *S3PolicyDeleteParams) WithName(name string) *S3PolicyDeleteParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 policy delete params
func (o *S3PolicyDeleteParams) SetName(name string) {
	o.Name = name
}

// WithSvmUUID adds the svmUUID to the s3 policy delete params
func (o *S3PolicyDeleteParams) WithSvmUUID(svmUUID string) *S3PolicyDeleteParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 policy delete params
func (o *S3PolicyDeleteParams) SetSvmUUID(svmUUID string) {
	o.SvmUUID = svmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3PolicyDeleteParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	// path param name
	if err := r.SetPathParam("name", o.Name); err != nil {
		return err
	}

	// path param svm.uuid
	if err := r.SetPathParam("svm.uuid", o.SvmUUID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
