// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"encoding/json"
	"fmt"
	"io"

	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3PolicyDeleteReader is a Reader for the S3PolicyDelete structure.
type S3PolicyDeleteReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3PolicyDeleteReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3PolicyDeleteOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3PolicyDeleteDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3PolicyDeleteOK creates a S3PolicyDeleteOK with default headers values
func NewS3PolicyDeleteOK() *S3PolicyDeleteOK {
	return &S3PolicyDeleteOK{}
}

/*
S3PolicyDeleteOK describes a response with status code 200, with default header values.

OK
*/
type S3PolicyDeleteOK struct {
}

// IsSuccess returns true when this s3 policy delete o k response has a 2xx status code
func (o *S3PolicyDeleteOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 policy delete o k response has a 3xx status code
func (o *S3PolicyDeleteOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 policy delete o k response has a 4xx status code
func (o *S3PolicyDeleteOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 policy delete o k response has a 5xx status code
func (o *S3PolicyDeleteOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 policy delete o k response a status code equal to that given
func (o *S3PolicyDeleteOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 policy delete o k response
func (o *S3PolicyDeleteOK) Code() int {
	return 200
}

func (o *S3PolicyDeleteOK) Error() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies/{name}][%d] s3PolicyDeleteOK", 200)
}

func (o *S3PolicyDeleteOK) String() string {
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies/{name}][%d] s3PolicyDeleteOK", 200)
}

func (o *S3PolicyDeleteOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3PolicyDeleteDefault creates a S3PolicyDeleteDefault with default headers values
func NewS3PolicyDeleteDefault(code int) *S3PolicyDeleteDefault {
	return &S3PolicyDeleteDefault{
		_statusCode: code,
	}
}

/*
	S3PolicyDeleteDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405858   | Failed to \"delete\" the \"policy\" because the operation is only supported on data SVMs.
*/
type S3PolicyDeleteDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 policy delete default response has a 2xx status code
func (o *S3PolicyDeleteDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 policy delete default response has a 3xx status code
func (o *S3PolicyDeleteDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 policy delete default response has a 4xx status code
func (o *S3PolicyDeleteDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 policy delete default response has a 5xx status code
func (o *S3PolicyDeleteDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 policy delete default response a status code equal to that given
func (o *S3PolicyDeleteDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 policy delete default response
func (o *S3PolicyDeleteDefault) Code() int {
	return o._statusCode
}

func (o *S3PolicyDeleteDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies/{name}][%d] s3_policy_delete default %s", o._statusCode, payload)
}

func (o *S3PolicyDeleteDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services/{svm.uuid}/policies/{name}][%d] s3_policy_delete default %s", o._statusCode, payload)
}

func (o *S3PolicyDeleteDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3PolicyDeleteDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}
