// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
	"github.com/go-openapi/validate"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3PolicyModifyCollectionReader is a Reader for the S3PolicyModifyCollection structure.
type S3PolicyModifyCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3PolicyModifyCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3PolicyModifyCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3PolicyModifyCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3PolicyModifyCollectionOK creates a S3PolicyModifyCollectionOK with default headers values
func NewS3PolicyModifyCollectionOK() *S3PolicyModifyCollectionOK {
	return &S3PolicyModifyCollectionOK{}
}

/*
S3PolicyModifyCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3PolicyModifyCollectionOK struct {
}

// IsSuccess returns true when this s3 policy modify collection o k response has a 2xx status code
func (o *S3PolicyModifyCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 policy modify collection o k response has a 3xx status code
func (o *S3PolicyModifyCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 policy modify collection o k response has a 4xx status code
func (o *S3PolicyModifyCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 policy modify collection o k response has a 5xx status code
func (o *S3PolicyModifyCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 policy modify collection o k response a status code equal to that given
func (o *S3PolicyModifyCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 policy modify collection o k response
func (o *S3PolicyModifyCollectionOK) Code() int {
	return 200
}

func (o *S3PolicyModifyCollectionOK) Error() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/policies][%d] s3PolicyModifyCollectionOK", 200)
}

func (o *S3PolicyModifyCollectionOK) String() string {
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/policies][%d] s3PolicyModifyCollectionOK", 200)
}

func (o *S3PolicyModifyCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	return nil
}

// NewS3PolicyModifyCollectionDefault creates a S3PolicyModifyCollectionDefault with default headers values
func NewS3PolicyModifyCollectionDefault(code int) *S3PolicyModifyCollectionDefault {
	return &S3PolicyModifyCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3PolicyModifyCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405906   | The specified action name is invalid.
| 92405963   | Failed to create s3 policy statements \\\"{policy name}\\\". Reason: "{reason of failure}". Resolve all issues and retry the operation.
| 92405953   | Object store server read-only policies do not support create, modify, delete, add-statement, remove-statement and modify-statement operations.
| 92406075   | Failed to modify policy statement for policy \\\"{policy name}\\\". Reason: "{reason of failure}". Valid ways to specify a resource are \"*\", \"<bucket-name>\", \"<bucket-name>/.../...\".\".
*/
type S3PolicyModifyCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 policy modify collection default response has a 2xx status code
func (o *S3PolicyModifyCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 policy modify collection default response has a 3xx status code
func (o *S3PolicyModifyCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 policy modify collection default response has a 4xx status code
func (o *S3PolicyModifyCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 policy modify collection default response has a 5xx status code
func (o *S3PolicyModifyCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 policy modify collection default response a status code equal to that given
func (o *S3PolicyModifyCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 policy modify collection default response
func (o *S3PolicyModifyCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3PolicyModifyCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/policies][%d] s3_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *S3PolicyModifyCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[PATCH /protocols/s3/services/{svm.uuid}/policies][%d] s3_policy_modify_collection default %s", o._statusCode, payload)
}

func (o *S3PolicyModifyCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3PolicyModifyCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3PolicyModifyCollectionBody s3 policy modify collection body
swagger:model S3PolicyModifyCollectionBody
*/
type S3PolicyModifyCollectionBody struct {

	// Can contain any additional information about the S3 policy.
	// Example: S3 policy.
	// Max Length: 256
	// Min Length: 0
	Comment *string `json:"comment,omitempty"`

	// Specifies the name of the policy. A policy name length can range from 1 to 128 characters and can only contain the following combination of characters 0-9, A-Z, a-z, "_", "+", "=", ",", ".","@", and "-". It cannot be specified in a PATCH method.
	// Example: Policy1
	// Max Length: 128
	// Min Length: 1
	// Pattern: ^[0-9A-Za-z_+=,.@-]{1,128}$
	Name *string `json:"name,omitempty"`

	// Specifies whether or not the s3 policy is read only. This parameter should not be specified in the POST method.
	// Read Only: true
	ReadOnly *bool `json:"read-only,omitempty"`

	// Specifies the policy statements.
	S3PolicyInlineStatements []*models.S3PolicyStatement `json:"statements,omitempty"`

	// s3 policy response inline records
	S3PolicyResponseInlineRecords []*models.S3Policy `json:"records,omitempty"`

	// svm
	Svm *models.S3PolicyInlineSvm `json:"svm,omitempty"`
}

// Validate validates this s3 policy modify collection body
func (o *S3PolicyModifyCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateComment(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateName(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3PolicyInlineStatements(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateS3PolicyResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if err := o.validateSvm(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyModifyCollectionBody) validateComment(formats strfmt.Registry) error {
	if swag.IsZero(o.Comment) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"comment", "body", *o.Comment, 0); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"comment", "body", *o.Comment, 256); err != nil {
		return err
	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) validateName(formats strfmt.Registry) error {
	if swag.IsZero(o.Name) { // not required
		return nil
	}

	if err := validate.MinLength("info"+"."+"name", "body", *o.Name, 1); err != nil {
		return err
	}

	if err := validate.MaxLength("info"+"."+"name", "body", *o.Name, 128); err != nil {
		return err
	}

	if err := validate.Pattern("info"+"."+"name", "body", *o.Name, `^[0-9A-Za-z_+=,.@-]{1,128}$`); err != nil {
		return err
	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) validateS3PolicyInlineStatements(formats strfmt.Registry) error {
	if swag.IsZero(o.S3PolicyInlineStatements) { // not required
		return nil
	}

	for i := 0; i < len(o.S3PolicyInlineStatements); i++ {
		if swag.IsZero(o.S3PolicyInlineStatements[i]) { // not required
			continue
		}

		if o.S3PolicyInlineStatements[i] != nil {
			if err := o.S3PolicyInlineStatements[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) validateS3PolicyResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3PolicyResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3PolicyResponseInlineRecords); i++ {
		if swag.IsZero(o.S3PolicyResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3PolicyResponseInlineRecords[i] != nil {
			if err := o.S3PolicyResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) validateSvm(formats strfmt.Registry) error {
	if swag.IsZero(o.Svm) { // not required
		return nil
	}

	if o.Svm != nil {
		if err := o.Svm.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 policy modify collection body based on the context it is used
func (o *S3PolicyModifyCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateReadOnly(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3PolicyInlineStatements(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateS3PolicyResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := o.contextValidateSvm(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyModifyCollectionBody) contextValidateReadOnly(ctx context.Context, formats strfmt.Registry) error {

	if err := validate.ReadOnly(ctx, "info"+"."+"read-only", "body", o.ReadOnly); err != nil {
		return err
	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) contextValidateS3PolicyInlineStatements(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3PolicyInlineStatements); i++ {

		if o.S3PolicyInlineStatements[i] != nil {
			if err := o.S3PolicyInlineStatements[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "statements" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) contextValidateS3PolicyResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3PolicyResponseInlineRecords); i++ {

		if o.S3PolicyResponseInlineRecords[i] != nil {
			if err := o.S3PolicyResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

func (o *S3PolicyModifyCollectionBody) contextValidateSvm(ctx context.Context, formats strfmt.Registry) error {

	if o.Svm != nil {
		if err := o.Svm.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3PolicyModifyCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3PolicyModifyCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3PolicyModifyCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3PolicyInlineSvm SVM, applies only to SVM-scoped objects.
swagger:model s3_policy_inline_svm
*/
type S3PolicyInlineSvm struct {

	// links
	Links *models.S3PolicyInlineSvmInlineLinks `json:"_links,omitempty"`

	// The name of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: svm1
	Name *string `json:"name,omitempty"`

	// The unique identifier of the SVM. This field cannot be specified in a PATCH method.
	//
	// Example: 02c9e252-41be-11e9-81d5-00a0986138f7
	UUID *string `json:"uuid,omitempty"`
}

// Validate validates this s3 policy inline svm
func (o *S3PolicyInlineSvm) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateLinks(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyInlineSvm) validateLinks(formats strfmt.Registry) error {
	if swag.IsZero(o.Links) { // not required
		return nil
	}

	if o.Links != nil {
		if err := o.Links.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 policy inline svm based on the context it is used
func (o *S3PolicyInlineSvm) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateLinks(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyInlineSvm) contextValidateLinks(ctx context.Context, formats strfmt.Registry) error {

	if o.Links != nil {
		if err := o.Links.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3PolicyInlineSvm) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3PolicyInlineSvm) UnmarshalBinary(b []byte) error {
	var res S3PolicyInlineSvm
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}

/*
S3PolicyInlineSvmInlineLinks s3 policy inline svm inline links
swagger:model s3_policy_inline_svm_inline__links
*/
type S3PolicyInlineSvmInlineLinks struct {

	// self
	Self *models.Href `json:"self,omitempty"`
}

// Validate validates this s3 policy inline svm inline links
func (o *S3PolicyInlineSvmInlineLinks) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateSelf(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyInlineSvmInlineLinks) validateSelf(formats strfmt.Registry) error {
	if swag.IsZero(o.Self) { // not required
		return nil
	}

	if o.Self != nil {
		if err := o.Self.Validate(formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// ContextValidate validate this s3 policy inline svm inline links based on the context it is used
func (o *S3PolicyInlineSvmInlineLinks) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateSelf(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3PolicyInlineSvmInlineLinks) contextValidateSelf(ctx context.Context, formats strfmt.Registry) error {

	if o.Self != nil {
		if err := o.Self.ContextValidate(ctx, formats); err != nil {
			if ve, ok := err.(*errors.Validation); ok {
				return ve.ValidateName("info" + "." + "svm" + "." + "_links" + "." + "self")
			}
			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3PolicyInlineSvmInlineLinks) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3PolicyInlineSvmInlineLinks) UnmarshalBinary(b []byte) error {
	var res S3PolicyInlineSvmInlineLinks
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
