// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NewS3ServiceCollectionGetParams creates a new S3ServiceCollectionGetParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewS3ServiceCollectionGetParams() *S3ServiceCollectionGetParams {
	return &S3ServiceCollectionGetParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewS3ServiceCollectionGetParamsWithTimeout creates a new S3ServiceCollectionGetParams object
// with the ability to set a timeout on a request.
func NewS3ServiceCollectionGetParamsWithTimeout(timeout time.Duration) *S3ServiceCollectionGetParams {
	return &S3ServiceCollectionGetParams{
		timeout: timeout,
	}
}

// NewS3ServiceCollectionGetParamsWithContext creates a new S3ServiceCollectionGetParams object
// with the ability to set a context for a request.
func NewS3ServiceCollectionGetParamsWithContext(ctx context.Context) *S3ServiceCollectionGetParams {
	return &S3ServiceCollectionGetParams{
		Context: ctx,
	}
}

// NewS3ServiceCollectionGetParamsWithHTTPClient creates a new S3ServiceCollectionGetParams object
// with the ability to set a custom HTTPClient for a request.
func NewS3ServiceCollectionGetParamsWithHTTPClient(client *http.Client) *S3ServiceCollectionGetParams {
	return &S3ServiceCollectionGetParams{
		HTTPClient: client,
	}
}

/*
S3ServiceCollectionGetParams contains all the parameters to send to the API endpoint

	for the s3 service collection get operation.

	Typically these are written to a http.Request.
*/
type S3ServiceCollectionGetParams struct {

	/* BucketsAllowed.

	   Filter by buckets.allowed
	*/
	BucketsAllowed *bool

	/* BucketsAuditEventSelectorAccess.

	   Filter by buckets.audit_event_selector.access
	*/
	BucketsAuditEventSelectorAccess *string

	/* BucketsAuditEventSelectorPermission.

	   Filter by buckets.audit_event_selector.permission
	*/
	BucketsAuditEventSelectorPermission *string

	/* BucketsComment.

	   Filter by buckets.comment
	*/
	BucketsComment *string

	/* BucketsCorsRulesAllowedHeaders.

	   Filter by buckets.cors.rules.allowed_headers
	*/
	BucketsCorsRulesAllowedHeaders *string

	/* BucketsCorsRulesAllowedMethods.

	   Filter by buckets.cors.rules.allowed_methods
	*/
	BucketsCorsRulesAllowedMethods *string

	/* BucketsCorsRulesAllowedOrigins.

	   Filter by buckets.cors.rules.allowed_origins
	*/
	BucketsCorsRulesAllowedOrigins *string

	/* BucketsCorsRulesExposeHeaders.

	   Filter by buckets.cors.rules.expose_headers
	*/
	BucketsCorsRulesExposeHeaders *string

	/* BucketsCorsRulesID.

	   Filter by buckets.cors.rules.id
	*/
	BucketsCorsRulesID *string

	/* BucketsCorsRulesMaxAgeSeconds.

	   Filter by buckets.cors.rules.max_age_seconds
	*/
	BucketsCorsRulesMaxAgeSeconds *int64

	/* BucketsEncryptionEnabled.

	   Filter by buckets.encryption.enabled
	*/
	BucketsEncryptionEnabled *bool

	/* BucketsIsConsistentEtag.

	   Filter by buckets.is_consistent_etag
	*/
	BucketsIsConsistentEtag *bool

	/* BucketsIsNasPathMutable.

	   Filter by buckets.is_nas_path_mutable
	*/
	BucketsIsNasPathMutable *bool

	/* BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays.

	   Filter by buckets.lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days
	*/
	BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64

	/* BucketsLifecycleManagementRulesBucketName.

	   Filter by buckets.lifecycle_management.rules.bucket_name
	*/
	BucketsLifecycleManagementRulesBucketName *string

	/* BucketsLifecycleManagementRulesEnabled.

	   Filter by buckets.lifecycle_management.rules.enabled
	*/
	BucketsLifecycleManagementRulesEnabled *bool

	/* BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker.

	   Filter by buckets.lifecycle_management.rules.expiration.expired_object_delete_marker
	*/
	BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool

	/* BucketsLifecycleManagementRulesExpirationObjectAgeDays.

	   Filter by buckets.lifecycle_management.rules.expiration.object_age_days
	*/
	BucketsLifecycleManagementRulesExpirationObjectAgeDays *int64

	/* BucketsLifecycleManagementRulesExpirationObjectExpiryDate.

	   Filter by buckets.lifecycle_management.rules.expiration.object_expiry_date
	*/
	BucketsLifecycleManagementRulesExpirationObjectExpiryDate *string

	/* BucketsLifecycleManagementRulesName.

	   Filter by buckets.lifecycle_management.rules.name
	*/
	BucketsLifecycleManagementRulesName *string

	/* BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions.

	   Filter by buckets.lifecycle_management.rules.non_current_version_expiration.new_non_current_versions
	*/
	BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64

	/* BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays.

	   Filter by buckets.lifecycle_management.rules.non_current_version_expiration.non_current_days
	*/
	BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64

	/* BucketsLifecycleManagementRulesObjectFilterPrefix.

	   Filter by buckets.lifecycle_management.rules.object_filter.prefix
	*/
	BucketsLifecycleManagementRulesObjectFilterPrefix *string

	/* BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan.

	   Filter by buckets.lifecycle_management.rules.object_filter.size_greater_than
	*/
	BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan *int64

	/* BucketsLifecycleManagementRulesObjectFilterSizeLessThan.

	   Filter by buckets.lifecycle_management.rules.object_filter.size_less_than
	*/
	BucketsLifecycleManagementRulesObjectFilterSizeLessThan *int64

	/* BucketsLifecycleManagementRulesObjectFilterTags.

	   Filter by buckets.lifecycle_management.rules.object_filter.tags
	*/
	BucketsLifecycleManagementRulesObjectFilterTags *string

	/* BucketsLifecycleManagementRulesSvmName.

	   Filter by buckets.lifecycle_management.rules.svm.name
	*/
	BucketsLifecycleManagementRulesSvmName *string

	/* BucketsLifecycleManagementRulesSvmUUID.

	   Filter by buckets.lifecycle_management.rules.svm.uuid
	*/
	BucketsLifecycleManagementRulesSvmUUID *string

	/* BucketsLifecycleManagementRulesUUID.

	   Filter by buckets.lifecycle_management.rules.uuid
	*/
	BucketsLifecycleManagementRulesUUID *string

	/* BucketsLogicalUsedSize.

	   Filter by buckets.logical_used_size
	*/
	BucketsLogicalUsedSize *int64

	/* BucketsName.

	   Filter by buckets.name
	*/
	BucketsName *string

	/* BucketsNasPath.

	   Filter by buckets.nas_path
	*/
	BucketsNasPath *string

	/* BucketsPolicyStatementsActions.

	   Filter by buckets.policy.statements.actions
	*/
	BucketsPolicyStatementsActions *string

	/* BucketsPolicyStatementsConditionsDelimiters.

	   Filter by buckets.policy.statements.conditions.delimiters
	*/
	BucketsPolicyStatementsConditionsDelimiters *string

	/* BucketsPolicyStatementsConditionsMaxKeys.

	   Filter by buckets.policy.statements.conditions.max_keys
	*/
	BucketsPolicyStatementsConditionsMaxKeys *int64

	/* BucketsPolicyStatementsConditionsOperator.

	   Filter by buckets.policy.statements.conditions.operator
	*/
	BucketsPolicyStatementsConditionsOperator *string

	/* BucketsPolicyStatementsConditionsPrefixes.

	   Filter by buckets.policy.statements.conditions.prefixes
	*/
	BucketsPolicyStatementsConditionsPrefixes *string

	/* BucketsPolicyStatementsConditionsSourceIps.

	   Filter by buckets.policy.statements.conditions.source_ips
	*/
	BucketsPolicyStatementsConditionsSourceIps *string

	/* BucketsPolicyStatementsConditionsUsernames.

	   Filter by buckets.policy.statements.conditions.usernames
	*/
	BucketsPolicyStatementsConditionsUsernames *string

	/* BucketsPolicyStatementsEffect.

	   Filter by buckets.policy.statements.effect
	*/
	BucketsPolicyStatementsEffect *string

	/* BucketsPolicyStatementsPrincipals.

	   Filter by buckets.policy.statements.principals
	*/
	BucketsPolicyStatementsPrincipals *string

	/* BucketsPolicyStatementsResources.

	   Filter by buckets.policy.statements.resources
	*/
	BucketsPolicyStatementsResources *string

	/* BucketsPolicyStatementsSid.

	   Filter by buckets.policy.statements.sid
	*/
	BucketsPolicyStatementsSid *string

	/* BucketsProtectionStatusDestinationIsCloud.

	   Filter by buckets.protection_status.destination.is_cloud
	*/
	BucketsProtectionStatusDestinationIsCloud *bool

	/* BucketsProtectionStatusDestinationIsExternalCloud.

	   Filter by buckets.protection_status.destination.is_external_cloud
	*/
	BucketsProtectionStatusDestinationIsExternalCloud *bool

	/* BucketsProtectionStatusDestinationIsOntap.

	   Filter by buckets.protection_status.destination.is_ontap
	*/
	BucketsProtectionStatusDestinationIsOntap *bool

	/* BucketsProtectionStatusIsProtected.

	   Filter by buckets.protection_status.is_protected
	*/
	BucketsProtectionStatusIsProtected *bool

	/* BucketsQosPolicyMaxThroughput.

	   Filter by buckets.qos_policy.max_throughput
	*/
	BucketsQosPolicyMaxThroughput *string

	/* BucketsQosPolicyMaxThroughputIops.

	   Filter by buckets.qos_policy.max_throughput_iops
	*/
	BucketsQosPolicyMaxThroughputIops *int64

	/* BucketsQosPolicyMaxThroughputMbps.

	   Filter by buckets.qos_policy.max_throughput_mbps
	*/
	BucketsQosPolicyMaxThroughputMbps *int64

	/* BucketsQosPolicyMinThroughput.

	   Filter by buckets.qos_policy.min_throughput
	*/
	BucketsQosPolicyMinThroughput *string

	/* BucketsQosPolicyMinThroughputIops.

	   Filter by buckets.qos_policy.min_throughput_iops
	*/
	BucketsQosPolicyMinThroughputIops *int64

	/* BucketsQosPolicyMinThroughputMbps.

	   Filter by buckets.qos_policy.min_throughput_mbps
	*/
	BucketsQosPolicyMinThroughputMbps *int64

	/* BucketsQosPolicyName.

	   Filter by buckets.qos_policy.name
	*/
	BucketsQosPolicyName *string

	/* BucketsQosPolicyUUID.

	   Filter by buckets.qos_policy.uuid
	*/
	BucketsQosPolicyUUID *string

	/* BucketsRetentionDefaultPeriod.

	   Filter by buckets.retention.default_period
	*/
	BucketsRetentionDefaultPeriod *string

	/* BucketsRetentionMode.

	   Filter by buckets.retention.mode
	*/
	BucketsRetentionMode *string

	/* BucketsRole.

	   Filter by buckets.role
	*/
	BucketsRole *string

	/* BucketsSize.

	   Filter by buckets.size
	*/
	BucketsSize *int64

	/* BucketsSnapshotPolicyName.

	   Filter by buckets.snapshot_policy.name
	*/
	BucketsSnapshotPolicyName *string

	/* BucketsSnapshotPolicyUUID.

	   Filter by buckets.snapshot_policy.uuid
	*/
	BucketsSnapshotPolicyUUID *string

	/* BucketsSvmName.

	   Filter by buckets.svm.name
	*/
	BucketsSvmName *string

	/* BucketsSvmUUID.

	   Filter by buckets.svm.uuid
	*/
	BucketsSvmUUID *string

	/* BucketsType.

	   Filter by buckets.type
	*/
	BucketsType *string

	/* BucketsUUID.

	   Filter by buckets.uuid
	*/
	BucketsUUID *string

	/* BucketsVersioningState.

	   Filter by buckets.versioning_state
	*/
	BucketsVersioningState *string

	/* BucketsVolumeName.

	   Filter by buckets.volume.name
	*/
	BucketsVolumeName *string

	/* BucketsVolumeUUID.

	   Filter by buckets.volume.uuid
	*/
	BucketsVolumeUUID *string

	/* CertificateName.

	   Filter by certificate.name
	*/
	CertificateName *string

	/* CertificateUUID.

	   Filter by certificate.uuid
	*/
	CertificateUUID *string

	/* Comment.

	   Filter by comment
	*/
	Comment *string

	/* DefaultUnixUser.

	   Filter by default_unix_user
	*/
	DefaultUnixUser *string

	/* DefaultWinUser.

	   Filter by default_win_user
	*/
	DefaultWinUser *string

	/* Enabled.

	   Filter by enabled
	*/
	Enabled *bool

	/* Fields.

	   Specify the fields to return.
	*/
	Fields []string

	/* IsHTTPEnabled.

	   Filter by is_http_enabled
	*/
	IsHTTPEnabled *bool

	/* IsHTTPSEnabled.

	   Filter by is_https_enabled
	*/
	IsHTTPSEnabled *bool

	/* MaxKeyTimeToLive.

	   Filter by max_key_time_to_live
	*/
	MaxKeyTimeToLive *string

	/* MaxLockRetentionPeriod.

	   Filter by max_lock_retention_period
	*/
	MaxLockRetentionPeriod *string

	/* MaxRecords.

	   Limit the number of records returned.
	*/
	MaxRecords *int64

	/* MetricDuration.

	   Filter by metric.duration
	*/
	MetricDuration *string

	/* MetricIopsOther.

	   Filter by metric.iops.other
	*/
	MetricIopsOther *int64

	/* MetricIopsRead.

	   Filter by metric.iops.read
	*/
	MetricIopsRead *int64

	/* MetricIopsTotal.

	   Filter by metric.iops.total
	*/
	MetricIopsTotal *int64

	/* MetricIopsWrite.

	   Filter by metric.iops.write
	*/
	MetricIopsWrite *int64

	/* MetricLatencyOther.

	   Filter by metric.latency.other
	*/
	MetricLatencyOther *int64

	/* MetricLatencyRead.

	   Filter by metric.latency.read
	*/
	MetricLatencyRead *int64

	/* MetricLatencyTotal.

	   Filter by metric.latency.total
	*/
	MetricLatencyTotal *int64

	/* MetricLatencyWrite.

	   Filter by metric.latency.write
	*/
	MetricLatencyWrite *int64

	/* MetricStatus.

	   Filter by metric.status
	*/
	MetricStatus *string

	/* MetricThroughputRead.

	   Filter by metric.throughput.read
	*/
	MetricThroughputRead *int64

	/* MetricThroughputTotal.

	   Filter by metric.throughput.total
	*/
	MetricThroughputTotal *int64

	/* MetricThroughputWrite.

	   Filter by metric.throughput.write
	*/
	MetricThroughputWrite *int64

	/* MetricTimestamp.

	   Filter by metric.timestamp
	*/
	MetricTimestamp *string

	/* MinLockRetentionPeriod.

	   Filter by min_lock_retention_period
	*/
	MinLockRetentionPeriod *string

	/* Name.

	   Filter by name
	*/
	Name *string

	/* OrderBy.

	   Order results by specified fields and optional [asc|desc] direction. Default direction is 'asc' for ascending.
	*/
	OrderBy []string

	/* Port.

	   Filter by port
	*/
	Port *int64

	/* ReturnRecords.

	   The default is true for GET calls.  When set to false, only the number of records is returned.

	   Default: true
	*/
	ReturnRecords *bool

	/* ReturnTimeout.

	   The number of seconds to allow the call to execute before returning.  When iterating over a collection, the default is 15 seconds.  ONTAP returns earlier if either max records or the end of the collection is reached.

	   Default: 15
	*/
	ReturnTimeout *int64

	/* SecurePort.

	   Filter by secure_port
	*/
	SecurePort *int64

	/* StatisticsIopsRawOther.

	   Filter by statistics.iops_raw.other
	*/
	StatisticsIopsRawOther *int64

	/* StatisticsIopsRawRead.

	   Filter by statistics.iops_raw.read
	*/
	StatisticsIopsRawRead *int64

	/* StatisticsIopsRawTotal.

	   Filter by statistics.iops_raw.total
	*/
	StatisticsIopsRawTotal *int64

	/* StatisticsIopsRawWrite.

	   Filter by statistics.iops_raw.write
	*/
	StatisticsIopsRawWrite *int64

	/* StatisticsLatencyRawOther.

	   Filter by statistics.latency_raw.other
	*/
	StatisticsLatencyRawOther *int64

	/* StatisticsLatencyRawRead.

	   Filter by statistics.latency_raw.read
	*/
	StatisticsLatencyRawRead *int64

	/* StatisticsLatencyRawTotal.

	   Filter by statistics.latency_raw.total
	*/
	StatisticsLatencyRawTotal *int64

	/* StatisticsLatencyRawWrite.

	   Filter by statistics.latency_raw.write
	*/
	StatisticsLatencyRawWrite *int64

	/* StatisticsStatus.

	   Filter by statistics.status
	*/
	StatisticsStatus *string

	/* StatisticsThroughputRawRead.

	   Filter by statistics.throughput_raw.read
	*/
	StatisticsThroughputRawRead *int64

	/* StatisticsThroughputRawTotal.

	   Filter by statistics.throughput_raw.total
	*/
	StatisticsThroughputRawTotal *int64

	/* StatisticsThroughputRawWrite.

	   Filter by statistics.throughput_raw.write
	*/
	StatisticsThroughputRawWrite *int64

	/* StatisticsTimestamp.

	   Filter by statistics.timestamp
	*/
	StatisticsTimestamp *string

	/* SvmName.

	   Filter by svm.name
	*/
	SvmName *string

	/* SvmUUID.

	   Filter by svm.uuid
	*/
	SvmUUID *string

	/* UsersAccessKey.

	   Filter by users.access_key
	*/
	UsersAccessKey *string

	/* UsersComment.

	   Filter by users.comment
	*/
	UsersComment *string

	/* UsersKeyExpiryTime.

	   Filter by users.key_expiry_time
	*/
	UsersKeyExpiryTime *string

	/* UsersKeyTimeToLive.

	   Filter by users.key_time_to_live
	*/
	UsersKeyTimeToLive *string

	/* UsersName.

	   Filter by users.name
	*/
	UsersName *string

	/* UsersSvmName.

	   Filter by users.svm.name
	*/
	UsersSvmName *string

	/* UsersSvmUUID.

	   Filter by users.svm.uuid
	*/
	UsersSvmUUID *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the s3 service collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceCollectionGetParams) WithDefaults() *S3ServiceCollectionGetParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the s3 service collection get params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *S3ServiceCollectionGetParams) SetDefaults() {
	var (
		returnRecordsDefault = bool(true)

		returnTimeoutDefault = int64(15)
	)

	val := S3ServiceCollectionGetParams{
		ReturnRecords: &returnRecordsDefault,
		ReturnTimeout: &returnTimeoutDefault,
	}

	val.timeout = o.timeout
	val.Context = o.Context
	val.HTTPClient = o.HTTPClient
	*o = val
}

// WithTimeout adds the timeout to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithTimeout(timeout time.Duration) *S3ServiceCollectionGetParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithContext(ctx context.Context) *S3ServiceCollectionGetParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithHTTPClient(client *http.Client) *S3ServiceCollectionGetParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBucketsAllowed adds the bucketsAllowed to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsAllowed(bucketsAllowed *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsAllowed(bucketsAllowed)
	return o
}

// SetBucketsAllowed adds the bucketsAllowed to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsAllowed(bucketsAllowed *bool) {
	o.BucketsAllowed = bucketsAllowed
}

// WithBucketsAuditEventSelectorAccess adds the bucketsAuditEventSelectorAccess to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsAuditEventSelectorAccess(bucketsAuditEventSelectorAccess *string) *S3ServiceCollectionGetParams {
	o.SetBucketsAuditEventSelectorAccess(bucketsAuditEventSelectorAccess)
	return o
}

// SetBucketsAuditEventSelectorAccess adds the bucketsAuditEventSelectorAccess to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsAuditEventSelectorAccess(bucketsAuditEventSelectorAccess *string) {
	o.BucketsAuditEventSelectorAccess = bucketsAuditEventSelectorAccess
}

// WithBucketsAuditEventSelectorPermission adds the bucketsAuditEventSelectorPermission to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsAuditEventSelectorPermission(bucketsAuditEventSelectorPermission *string) *S3ServiceCollectionGetParams {
	o.SetBucketsAuditEventSelectorPermission(bucketsAuditEventSelectorPermission)
	return o
}

// SetBucketsAuditEventSelectorPermission adds the bucketsAuditEventSelectorPermission to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsAuditEventSelectorPermission(bucketsAuditEventSelectorPermission *string) {
	o.BucketsAuditEventSelectorPermission = bucketsAuditEventSelectorPermission
}

// WithBucketsComment adds the bucketsComment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsComment(bucketsComment *string) *S3ServiceCollectionGetParams {
	o.SetBucketsComment(bucketsComment)
	return o
}

// SetBucketsComment adds the bucketsComment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsComment(bucketsComment *string) {
	o.BucketsComment = bucketsComment
}

// WithBucketsCorsRulesAllowedHeaders adds the bucketsCorsRulesAllowedHeaders to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesAllowedHeaders(bucketsCorsRulesAllowedHeaders *string) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesAllowedHeaders(bucketsCorsRulesAllowedHeaders)
	return o
}

// SetBucketsCorsRulesAllowedHeaders adds the bucketsCorsRulesAllowedHeaders to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesAllowedHeaders(bucketsCorsRulesAllowedHeaders *string) {
	o.BucketsCorsRulesAllowedHeaders = bucketsCorsRulesAllowedHeaders
}

// WithBucketsCorsRulesAllowedMethods adds the bucketsCorsRulesAllowedMethods to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesAllowedMethods(bucketsCorsRulesAllowedMethods *string) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesAllowedMethods(bucketsCorsRulesAllowedMethods)
	return o
}

// SetBucketsCorsRulesAllowedMethods adds the bucketsCorsRulesAllowedMethods to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesAllowedMethods(bucketsCorsRulesAllowedMethods *string) {
	o.BucketsCorsRulesAllowedMethods = bucketsCorsRulesAllowedMethods
}

// WithBucketsCorsRulesAllowedOrigins adds the bucketsCorsRulesAllowedOrigins to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesAllowedOrigins(bucketsCorsRulesAllowedOrigins *string) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesAllowedOrigins(bucketsCorsRulesAllowedOrigins)
	return o
}

// SetBucketsCorsRulesAllowedOrigins adds the bucketsCorsRulesAllowedOrigins to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesAllowedOrigins(bucketsCorsRulesAllowedOrigins *string) {
	o.BucketsCorsRulesAllowedOrigins = bucketsCorsRulesAllowedOrigins
}

// WithBucketsCorsRulesExposeHeaders adds the bucketsCorsRulesExposeHeaders to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesExposeHeaders(bucketsCorsRulesExposeHeaders *string) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesExposeHeaders(bucketsCorsRulesExposeHeaders)
	return o
}

// SetBucketsCorsRulesExposeHeaders adds the bucketsCorsRulesExposeHeaders to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesExposeHeaders(bucketsCorsRulesExposeHeaders *string) {
	o.BucketsCorsRulesExposeHeaders = bucketsCorsRulesExposeHeaders
}

// WithBucketsCorsRulesID adds the bucketsCorsRulesID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesID(bucketsCorsRulesID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesID(bucketsCorsRulesID)
	return o
}

// SetBucketsCorsRulesID adds the bucketsCorsRulesId to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesID(bucketsCorsRulesID *string) {
	o.BucketsCorsRulesID = bucketsCorsRulesID
}

// WithBucketsCorsRulesMaxAgeSeconds adds the bucketsCorsRulesMaxAgeSeconds to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsCorsRulesMaxAgeSeconds(bucketsCorsRulesMaxAgeSeconds *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsCorsRulesMaxAgeSeconds(bucketsCorsRulesMaxAgeSeconds)
	return o
}

// SetBucketsCorsRulesMaxAgeSeconds adds the bucketsCorsRulesMaxAgeSeconds to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsCorsRulesMaxAgeSeconds(bucketsCorsRulesMaxAgeSeconds *int64) {
	o.BucketsCorsRulesMaxAgeSeconds = bucketsCorsRulesMaxAgeSeconds
}

// WithBucketsEncryptionEnabled adds the bucketsEncryptionEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsEncryptionEnabled(bucketsEncryptionEnabled *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsEncryptionEnabled(bucketsEncryptionEnabled)
	return o
}

// SetBucketsEncryptionEnabled adds the bucketsEncryptionEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsEncryptionEnabled(bucketsEncryptionEnabled *bool) {
	o.BucketsEncryptionEnabled = bucketsEncryptionEnabled
}

// WithBucketsIsConsistentEtag adds the bucketsIsConsistentEtag to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsIsConsistentEtag(bucketsIsConsistentEtag *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsIsConsistentEtag(bucketsIsConsistentEtag)
	return o
}

// SetBucketsIsConsistentEtag adds the bucketsIsConsistentEtag to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsIsConsistentEtag(bucketsIsConsistentEtag *bool) {
	o.BucketsIsConsistentEtag = bucketsIsConsistentEtag
}

// WithBucketsIsNasPathMutable adds the bucketsIsNasPathMutable to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsIsNasPathMutable(bucketsIsNasPathMutable *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsIsNasPathMutable(bucketsIsNasPathMutable)
	return o
}

// SetBucketsIsNasPathMutable adds the bucketsIsNasPathMutable to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsIsNasPathMutable(bucketsIsNasPathMutable *bool) {
	o.BucketsIsNasPathMutable = bucketsIsNasPathMutable
}

// WithBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays adds the bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays)
	return o
}

// SetBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays adds the bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays(bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays *int64) {
	o.BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays = bucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays
}

// WithBucketsLifecycleManagementRulesBucketName adds the bucketsLifecycleManagementRulesBucketName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesBucketName(bucketsLifecycleManagementRulesBucketName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesBucketName(bucketsLifecycleManagementRulesBucketName)
	return o
}

// SetBucketsLifecycleManagementRulesBucketName adds the bucketsLifecycleManagementRulesBucketName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesBucketName(bucketsLifecycleManagementRulesBucketName *string) {
	o.BucketsLifecycleManagementRulesBucketName = bucketsLifecycleManagementRulesBucketName
}

// WithBucketsLifecycleManagementRulesEnabled adds the bucketsLifecycleManagementRulesEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesEnabled(bucketsLifecycleManagementRulesEnabled *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesEnabled(bucketsLifecycleManagementRulesEnabled)
	return o
}

// SetBucketsLifecycleManagementRulesEnabled adds the bucketsLifecycleManagementRulesEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesEnabled(bucketsLifecycleManagementRulesEnabled *bool) {
	o.BucketsLifecycleManagementRulesEnabled = bucketsLifecycleManagementRulesEnabled
}

// WithBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker adds the bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker)
	return o
}

// SetBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker adds the bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker(bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker *bool) {
	o.BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker = bucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker
}

// WithBucketsLifecycleManagementRulesExpirationObjectAgeDays adds the bucketsLifecycleManagementRulesExpirationObjectAgeDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesExpirationObjectAgeDays(bucketsLifecycleManagementRulesExpirationObjectAgeDays *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesExpirationObjectAgeDays(bucketsLifecycleManagementRulesExpirationObjectAgeDays)
	return o
}

// SetBucketsLifecycleManagementRulesExpirationObjectAgeDays adds the bucketsLifecycleManagementRulesExpirationObjectAgeDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesExpirationObjectAgeDays(bucketsLifecycleManagementRulesExpirationObjectAgeDays *int64) {
	o.BucketsLifecycleManagementRulesExpirationObjectAgeDays = bucketsLifecycleManagementRulesExpirationObjectAgeDays
}

// WithBucketsLifecycleManagementRulesExpirationObjectExpiryDate adds the bucketsLifecycleManagementRulesExpirationObjectExpiryDate to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesExpirationObjectExpiryDate(bucketsLifecycleManagementRulesExpirationObjectExpiryDate *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesExpirationObjectExpiryDate(bucketsLifecycleManagementRulesExpirationObjectExpiryDate)
	return o
}

// SetBucketsLifecycleManagementRulesExpirationObjectExpiryDate adds the bucketsLifecycleManagementRulesExpirationObjectExpiryDate to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesExpirationObjectExpiryDate(bucketsLifecycleManagementRulesExpirationObjectExpiryDate *string) {
	o.BucketsLifecycleManagementRulesExpirationObjectExpiryDate = bucketsLifecycleManagementRulesExpirationObjectExpiryDate
}

// WithBucketsLifecycleManagementRulesName adds the bucketsLifecycleManagementRulesName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesName(bucketsLifecycleManagementRulesName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesName(bucketsLifecycleManagementRulesName)
	return o
}

// SetBucketsLifecycleManagementRulesName adds the bucketsLifecycleManagementRulesName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesName(bucketsLifecycleManagementRulesName *string) {
	o.BucketsLifecycleManagementRulesName = bucketsLifecycleManagementRulesName
}

// WithBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions adds the bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions)
	return o
}

// SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions adds the bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions *int64) {
	o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions = bucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions
}

// WithBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays adds the bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays)
	return o
}

// SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays adds the bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays(bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays *int64) {
	o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays = bucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays
}

// WithBucketsLifecycleManagementRulesObjectFilterPrefix adds the bucketsLifecycleManagementRulesObjectFilterPrefix to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesObjectFilterPrefix(bucketsLifecycleManagementRulesObjectFilterPrefix *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesObjectFilterPrefix(bucketsLifecycleManagementRulesObjectFilterPrefix)
	return o
}

// SetBucketsLifecycleManagementRulesObjectFilterPrefix adds the bucketsLifecycleManagementRulesObjectFilterPrefix to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesObjectFilterPrefix(bucketsLifecycleManagementRulesObjectFilterPrefix *string) {
	o.BucketsLifecycleManagementRulesObjectFilterPrefix = bucketsLifecycleManagementRulesObjectFilterPrefix
}

// WithBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan adds the bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan(bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan(bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan)
	return o
}

// SetBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan adds the bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan(bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan *int64) {
	o.BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan = bucketsLifecycleManagementRulesObjectFilterSizeGreaterThan
}

// WithBucketsLifecycleManagementRulesObjectFilterSizeLessThan adds the bucketsLifecycleManagementRulesObjectFilterSizeLessThan to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesObjectFilterSizeLessThan(bucketsLifecycleManagementRulesObjectFilterSizeLessThan *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesObjectFilterSizeLessThan(bucketsLifecycleManagementRulesObjectFilterSizeLessThan)
	return o
}

// SetBucketsLifecycleManagementRulesObjectFilterSizeLessThan adds the bucketsLifecycleManagementRulesObjectFilterSizeLessThan to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesObjectFilterSizeLessThan(bucketsLifecycleManagementRulesObjectFilterSizeLessThan *int64) {
	o.BucketsLifecycleManagementRulesObjectFilterSizeLessThan = bucketsLifecycleManagementRulesObjectFilterSizeLessThan
}

// WithBucketsLifecycleManagementRulesObjectFilterTags adds the bucketsLifecycleManagementRulesObjectFilterTags to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesObjectFilterTags(bucketsLifecycleManagementRulesObjectFilterTags *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesObjectFilterTags(bucketsLifecycleManagementRulesObjectFilterTags)
	return o
}

// SetBucketsLifecycleManagementRulesObjectFilterTags adds the bucketsLifecycleManagementRulesObjectFilterTags to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesObjectFilterTags(bucketsLifecycleManagementRulesObjectFilterTags *string) {
	o.BucketsLifecycleManagementRulesObjectFilterTags = bucketsLifecycleManagementRulesObjectFilterTags
}

// WithBucketsLifecycleManagementRulesSvmName adds the bucketsLifecycleManagementRulesSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesSvmName(bucketsLifecycleManagementRulesSvmName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesSvmName(bucketsLifecycleManagementRulesSvmName)
	return o
}

// SetBucketsLifecycleManagementRulesSvmName adds the bucketsLifecycleManagementRulesSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesSvmName(bucketsLifecycleManagementRulesSvmName *string) {
	o.BucketsLifecycleManagementRulesSvmName = bucketsLifecycleManagementRulesSvmName
}

// WithBucketsLifecycleManagementRulesSvmUUID adds the bucketsLifecycleManagementRulesSvmUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesSvmUUID(bucketsLifecycleManagementRulesSvmUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesSvmUUID(bucketsLifecycleManagementRulesSvmUUID)
	return o
}

// SetBucketsLifecycleManagementRulesSvmUUID adds the bucketsLifecycleManagementRulesSvmUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesSvmUUID(bucketsLifecycleManagementRulesSvmUUID *string) {
	o.BucketsLifecycleManagementRulesSvmUUID = bucketsLifecycleManagementRulesSvmUUID
}

// WithBucketsLifecycleManagementRulesUUID adds the bucketsLifecycleManagementRulesUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLifecycleManagementRulesUUID(bucketsLifecycleManagementRulesUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsLifecycleManagementRulesUUID(bucketsLifecycleManagementRulesUUID)
	return o
}

// SetBucketsLifecycleManagementRulesUUID adds the bucketsLifecycleManagementRulesUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLifecycleManagementRulesUUID(bucketsLifecycleManagementRulesUUID *string) {
	o.BucketsLifecycleManagementRulesUUID = bucketsLifecycleManagementRulesUUID
}

// WithBucketsLogicalUsedSize adds the bucketsLogicalUsedSize to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsLogicalUsedSize(bucketsLogicalUsedSize *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsLogicalUsedSize(bucketsLogicalUsedSize)
	return o
}

// SetBucketsLogicalUsedSize adds the bucketsLogicalUsedSize to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsLogicalUsedSize(bucketsLogicalUsedSize *int64) {
	o.BucketsLogicalUsedSize = bucketsLogicalUsedSize
}

// WithBucketsName adds the bucketsName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsName(bucketsName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsName(bucketsName)
	return o
}

// SetBucketsName adds the bucketsName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsName(bucketsName *string) {
	o.BucketsName = bucketsName
}

// WithBucketsNasPath adds the bucketsNasPath to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsNasPath(bucketsNasPath *string) *S3ServiceCollectionGetParams {
	o.SetBucketsNasPath(bucketsNasPath)
	return o
}

// SetBucketsNasPath adds the bucketsNasPath to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsNasPath(bucketsNasPath *string) {
	o.BucketsNasPath = bucketsNasPath
}

// WithBucketsPolicyStatementsActions adds the bucketsPolicyStatementsActions to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsActions(bucketsPolicyStatementsActions *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsActions(bucketsPolicyStatementsActions)
	return o
}

// SetBucketsPolicyStatementsActions adds the bucketsPolicyStatementsActions to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsActions(bucketsPolicyStatementsActions *string) {
	o.BucketsPolicyStatementsActions = bucketsPolicyStatementsActions
}

// WithBucketsPolicyStatementsConditionsDelimiters adds the bucketsPolicyStatementsConditionsDelimiters to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsDelimiters(bucketsPolicyStatementsConditionsDelimiters *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsDelimiters(bucketsPolicyStatementsConditionsDelimiters)
	return o
}

// SetBucketsPolicyStatementsConditionsDelimiters adds the bucketsPolicyStatementsConditionsDelimiters to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsDelimiters(bucketsPolicyStatementsConditionsDelimiters *string) {
	o.BucketsPolicyStatementsConditionsDelimiters = bucketsPolicyStatementsConditionsDelimiters
}

// WithBucketsPolicyStatementsConditionsMaxKeys adds the bucketsPolicyStatementsConditionsMaxKeys to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsMaxKeys(bucketsPolicyStatementsConditionsMaxKeys *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsMaxKeys(bucketsPolicyStatementsConditionsMaxKeys)
	return o
}

// SetBucketsPolicyStatementsConditionsMaxKeys adds the bucketsPolicyStatementsConditionsMaxKeys to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsMaxKeys(bucketsPolicyStatementsConditionsMaxKeys *int64) {
	o.BucketsPolicyStatementsConditionsMaxKeys = bucketsPolicyStatementsConditionsMaxKeys
}

// WithBucketsPolicyStatementsConditionsOperator adds the bucketsPolicyStatementsConditionsOperator to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsOperator(bucketsPolicyStatementsConditionsOperator *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsOperator(bucketsPolicyStatementsConditionsOperator)
	return o
}

// SetBucketsPolicyStatementsConditionsOperator adds the bucketsPolicyStatementsConditionsOperator to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsOperator(bucketsPolicyStatementsConditionsOperator *string) {
	o.BucketsPolicyStatementsConditionsOperator = bucketsPolicyStatementsConditionsOperator
}

// WithBucketsPolicyStatementsConditionsPrefixes adds the bucketsPolicyStatementsConditionsPrefixes to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsPrefixes(bucketsPolicyStatementsConditionsPrefixes *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsPrefixes(bucketsPolicyStatementsConditionsPrefixes)
	return o
}

// SetBucketsPolicyStatementsConditionsPrefixes adds the bucketsPolicyStatementsConditionsPrefixes to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsPrefixes(bucketsPolicyStatementsConditionsPrefixes *string) {
	o.BucketsPolicyStatementsConditionsPrefixes = bucketsPolicyStatementsConditionsPrefixes
}

// WithBucketsPolicyStatementsConditionsSourceIps adds the bucketsPolicyStatementsConditionsSourceIps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsSourceIps(bucketsPolicyStatementsConditionsSourceIps *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsSourceIps(bucketsPolicyStatementsConditionsSourceIps)
	return o
}

// SetBucketsPolicyStatementsConditionsSourceIps adds the bucketsPolicyStatementsConditionsSourceIps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsSourceIps(bucketsPolicyStatementsConditionsSourceIps *string) {
	o.BucketsPolicyStatementsConditionsSourceIps = bucketsPolicyStatementsConditionsSourceIps
}

// WithBucketsPolicyStatementsConditionsUsernames adds the bucketsPolicyStatementsConditionsUsernames to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsConditionsUsernames(bucketsPolicyStatementsConditionsUsernames *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsConditionsUsernames(bucketsPolicyStatementsConditionsUsernames)
	return o
}

// SetBucketsPolicyStatementsConditionsUsernames adds the bucketsPolicyStatementsConditionsUsernames to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsConditionsUsernames(bucketsPolicyStatementsConditionsUsernames *string) {
	o.BucketsPolicyStatementsConditionsUsernames = bucketsPolicyStatementsConditionsUsernames
}

// WithBucketsPolicyStatementsEffect adds the bucketsPolicyStatementsEffect to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsEffect(bucketsPolicyStatementsEffect *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsEffect(bucketsPolicyStatementsEffect)
	return o
}

// SetBucketsPolicyStatementsEffect adds the bucketsPolicyStatementsEffect to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsEffect(bucketsPolicyStatementsEffect *string) {
	o.BucketsPolicyStatementsEffect = bucketsPolicyStatementsEffect
}

// WithBucketsPolicyStatementsPrincipals adds the bucketsPolicyStatementsPrincipals to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsPrincipals(bucketsPolicyStatementsPrincipals *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsPrincipals(bucketsPolicyStatementsPrincipals)
	return o
}

// SetBucketsPolicyStatementsPrincipals adds the bucketsPolicyStatementsPrincipals to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsPrincipals(bucketsPolicyStatementsPrincipals *string) {
	o.BucketsPolicyStatementsPrincipals = bucketsPolicyStatementsPrincipals
}

// WithBucketsPolicyStatementsResources adds the bucketsPolicyStatementsResources to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsResources(bucketsPolicyStatementsResources *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsResources(bucketsPolicyStatementsResources)
	return o
}

// SetBucketsPolicyStatementsResources adds the bucketsPolicyStatementsResources to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsResources(bucketsPolicyStatementsResources *string) {
	o.BucketsPolicyStatementsResources = bucketsPolicyStatementsResources
}

// WithBucketsPolicyStatementsSid adds the bucketsPolicyStatementsSid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsPolicyStatementsSid(bucketsPolicyStatementsSid *string) *S3ServiceCollectionGetParams {
	o.SetBucketsPolicyStatementsSid(bucketsPolicyStatementsSid)
	return o
}

// SetBucketsPolicyStatementsSid adds the bucketsPolicyStatementsSid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsPolicyStatementsSid(bucketsPolicyStatementsSid *string) {
	o.BucketsPolicyStatementsSid = bucketsPolicyStatementsSid
}

// WithBucketsProtectionStatusDestinationIsCloud adds the bucketsProtectionStatusDestinationIsCloud to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsProtectionStatusDestinationIsCloud(bucketsProtectionStatusDestinationIsCloud *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsProtectionStatusDestinationIsCloud(bucketsProtectionStatusDestinationIsCloud)
	return o
}

// SetBucketsProtectionStatusDestinationIsCloud adds the bucketsProtectionStatusDestinationIsCloud to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsProtectionStatusDestinationIsCloud(bucketsProtectionStatusDestinationIsCloud *bool) {
	o.BucketsProtectionStatusDestinationIsCloud = bucketsProtectionStatusDestinationIsCloud
}

// WithBucketsProtectionStatusDestinationIsExternalCloud adds the bucketsProtectionStatusDestinationIsExternalCloud to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsProtectionStatusDestinationIsExternalCloud(bucketsProtectionStatusDestinationIsExternalCloud *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsProtectionStatusDestinationIsExternalCloud(bucketsProtectionStatusDestinationIsExternalCloud)
	return o
}

// SetBucketsProtectionStatusDestinationIsExternalCloud adds the bucketsProtectionStatusDestinationIsExternalCloud to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsProtectionStatusDestinationIsExternalCloud(bucketsProtectionStatusDestinationIsExternalCloud *bool) {
	o.BucketsProtectionStatusDestinationIsExternalCloud = bucketsProtectionStatusDestinationIsExternalCloud
}

// WithBucketsProtectionStatusDestinationIsOntap adds the bucketsProtectionStatusDestinationIsOntap to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsProtectionStatusDestinationIsOntap(bucketsProtectionStatusDestinationIsOntap *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsProtectionStatusDestinationIsOntap(bucketsProtectionStatusDestinationIsOntap)
	return o
}

// SetBucketsProtectionStatusDestinationIsOntap adds the bucketsProtectionStatusDestinationIsOntap to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsProtectionStatusDestinationIsOntap(bucketsProtectionStatusDestinationIsOntap *bool) {
	o.BucketsProtectionStatusDestinationIsOntap = bucketsProtectionStatusDestinationIsOntap
}

// WithBucketsProtectionStatusIsProtected adds the bucketsProtectionStatusIsProtected to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsProtectionStatusIsProtected(bucketsProtectionStatusIsProtected *bool) *S3ServiceCollectionGetParams {
	o.SetBucketsProtectionStatusIsProtected(bucketsProtectionStatusIsProtected)
	return o
}

// SetBucketsProtectionStatusIsProtected adds the bucketsProtectionStatusIsProtected to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsProtectionStatusIsProtected(bucketsProtectionStatusIsProtected *bool) {
	o.BucketsProtectionStatusIsProtected = bucketsProtectionStatusIsProtected
}

// WithBucketsQosPolicyMaxThroughput adds the bucketsQosPolicyMaxThroughput to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMaxThroughput(bucketsQosPolicyMaxThroughput *string) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMaxThroughput(bucketsQosPolicyMaxThroughput)
	return o
}

// SetBucketsQosPolicyMaxThroughput adds the bucketsQosPolicyMaxThroughput to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMaxThroughput(bucketsQosPolicyMaxThroughput *string) {
	o.BucketsQosPolicyMaxThroughput = bucketsQosPolicyMaxThroughput
}

// WithBucketsQosPolicyMaxThroughputIops adds the bucketsQosPolicyMaxThroughputIops to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMaxThroughputIops(bucketsQosPolicyMaxThroughputIops *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMaxThroughputIops(bucketsQosPolicyMaxThroughputIops)
	return o
}

// SetBucketsQosPolicyMaxThroughputIops adds the bucketsQosPolicyMaxThroughputIops to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMaxThroughputIops(bucketsQosPolicyMaxThroughputIops *int64) {
	o.BucketsQosPolicyMaxThroughputIops = bucketsQosPolicyMaxThroughputIops
}

// WithBucketsQosPolicyMaxThroughputMbps adds the bucketsQosPolicyMaxThroughputMbps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMaxThroughputMbps(bucketsQosPolicyMaxThroughputMbps *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMaxThroughputMbps(bucketsQosPolicyMaxThroughputMbps)
	return o
}

// SetBucketsQosPolicyMaxThroughputMbps adds the bucketsQosPolicyMaxThroughputMbps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMaxThroughputMbps(bucketsQosPolicyMaxThroughputMbps *int64) {
	o.BucketsQosPolicyMaxThroughputMbps = bucketsQosPolicyMaxThroughputMbps
}

// WithBucketsQosPolicyMinThroughput adds the bucketsQosPolicyMinThroughput to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMinThroughput(bucketsQosPolicyMinThroughput *string) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMinThroughput(bucketsQosPolicyMinThroughput)
	return o
}

// SetBucketsQosPolicyMinThroughput adds the bucketsQosPolicyMinThroughput to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMinThroughput(bucketsQosPolicyMinThroughput *string) {
	o.BucketsQosPolicyMinThroughput = bucketsQosPolicyMinThroughput
}

// WithBucketsQosPolicyMinThroughputIops adds the bucketsQosPolicyMinThroughputIops to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMinThroughputIops(bucketsQosPolicyMinThroughputIops *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMinThroughputIops(bucketsQosPolicyMinThroughputIops)
	return o
}

// SetBucketsQosPolicyMinThroughputIops adds the bucketsQosPolicyMinThroughputIops to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMinThroughputIops(bucketsQosPolicyMinThroughputIops *int64) {
	o.BucketsQosPolicyMinThroughputIops = bucketsQosPolicyMinThroughputIops
}

// WithBucketsQosPolicyMinThroughputMbps adds the bucketsQosPolicyMinThroughputMbps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyMinThroughputMbps(bucketsQosPolicyMinThroughputMbps *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyMinThroughputMbps(bucketsQosPolicyMinThroughputMbps)
	return o
}

// SetBucketsQosPolicyMinThroughputMbps adds the bucketsQosPolicyMinThroughputMbps to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyMinThroughputMbps(bucketsQosPolicyMinThroughputMbps *int64) {
	o.BucketsQosPolicyMinThroughputMbps = bucketsQosPolicyMinThroughputMbps
}

// WithBucketsQosPolicyName adds the bucketsQosPolicyName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyName(bucketsQosPolicyName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyName(bucketsQosPolicyName)
	return o
}

// SetBucketsQosPolicyName adds the bucketsQosPolicyName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyName(bucketsQosPolicyName *string) {
	o.BucketsQosPolicyName = bucketsQosPolicyName
}

// WithBucketsQosPolicyUUID adds the bucketsQosPolicyUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsQosPolicyUUID(bucketsQosPolicyUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsQosPolicyUUID(bucketsQosPolicyUUID)
	return o
}

// SetBucketsQosPolicyUUID adds the bucketsQosPolicyUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsQosPolicyUUID(bucketsQosPolicyUUID *string) {
	o.BucketsQosPolicyUUID = bucketsQosPolicyUUID
}

// WithBucketsRetentionDefaultPeriod adds the bucketsRetentionDefaultPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsRetentionDefaultPeriod(bucketsRetentionDefaultPeriod *string) *S3ServiceCollectionGetParams {
	o.SetBucketsRetentionDefaultPeriod(bucketsRetentionDefaultPeriod)
	return o
}

// SetBucketsRetentionDefaultPeriod adds the bucketsRetentionDefaultPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsRetentionDefaultPeriod(bucketsRetentionDefaultPeriod *string) {
	o.BucketsRetentionDefaultPeriod = bucketsRetentionDefaultPeriod
}

// WithBucketsRetentionMode adds the bucketsRetentionMode to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsRetentionMode(bucketsRetentionMode *string) *S3ServiceCollectionGetParams {
	o.SetBucketsRetentionMode(bucketsRetentionMode)
	return o
}

// SetBucketsRetentionMode adds the bucketsRetentionMode to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsRetentionMode(bucketsRetentionMode *string) {
	o.BucketsRetentionMode = bucketsRetentionMode
}

// WithBucketsRole adds the bucketsRole to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsRole(bucketsRole *string) *S3ServiceCollectionGetParams {
	o.SetBucketsRole(bucketsRole)
	return o
}

// SetBucketsRole adds the bucketsRole to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsRole(bucketsRole *string) {
	o.BucketsRole = bucketsRole
}

// WithBucketsSize adds the bucketsSize to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsSize(bucketsSize *int64) *S3ServiceCollectionGetParams {
	o.SetBucketsSize(bucketsSize)
	return o
}

// SetBucketsSize adds the bucketsSize to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsSize(bucketsSize *int64) {
	o.BucketsSize = bucketsSize
}

// WithBucketsSnapshotPolicyName adds the bucketsSnapshotPolicyName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsSnapshotPolicyName(bucketsSnapshotPolicyName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsSnapshotPolicyName(bucketsSnapshotPolicyName)
	return o
}

// SetBucketsSnapshotPolicyName adds the bucketsSnapshotPolicyName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsSnapshotPolicyName(bucketsSnapshotPolicyName *string) {
	o.BucketsSnapshotPolicyName = bucketsSnapshotPolicyName
}

// WithBucketsSnapshotPolicyUUID adds the bucketsSnapshotPolicyUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsSnapshotPolicyUUID(bucketsSnapshotPolicyUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsSnapshotPolicyUUID(bucketsSnapshotPolicyUUID)
	return o
}

// SetBucketsSnapshotPolicyUUID adds the bucketsSnapshotPolicyUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsSnapshotPolicyUUID(bucketsSnapshotPolicyUUID *string) {
	o.BucketsSnapshotPolicyUUID = bucketsSnapshotPolicyUUID
}

// WithBucketsSvmName adds the bucketsSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsSvmName(bucketsSvmName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsSvmName(bucketsSvmName)
	return o
}

// SetBucketsSvmName adds the bucketsSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsSvmName(bucketsSvmName *string) {
	o.BucketsSvmName = bucketsSvmName
}

// WithBucketsSvmUUID adds the bucketsSvmUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsSvmUUID(bucketsSvmUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsSvmUUID(bucketsSvmUUID)
	return o
}

// SetBucketsSvmUUID adds the bucketsSvmUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsSvmUUID(bucketsSvmUUID *string) {
	o.BucketsSvmUUID = bucketsSvmUUID
}

// WithBucketsType adds the bucketsType to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsType(bucketsType *string) *S3ServiceCollectionGetParams {
	o.SetBucketsType(bucketsType)
	return o
}

// SetBucketsType adds the bucketsType to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsType(bucketsType *string) {
	o.BucketsType = bucketsType
}

// WithBucketsUUID adds the bucketsUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsUUID(bucketsUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsUUID(bucketsUUID)
	return o
}

// SetBucketsUUID adds the bucketsUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsUUID(bucketsUUID *string) {
	o.BucketsUUID = bucketsUUID
}

// WithBucketsVersioningState adds the bucketsVersioningState to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsVersioningState(bucketsVersioningState *string) *S3ServiceCollectionGetParams {
	o.SetBucketsVersioningState(bucketsVersioningState)
	return o
}

// SetBucketsVersioningState adds the bucketsVersioningState to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsVersioningState(bucketsVersioningState *string) {
	o.BucketsVersioningState = bucketsVersioningState
}

// WithBucketsVolumeName adds the bucketsVolumeName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsVolumeName(bucketsVolumeName *string) *S3ServiceCollectionGetParams {
	o.SetBucketsVolumeName(bucketsVolumeName)
	return o
}

// SetBucketsVolumeName adds the bucketsVolumeName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsVolumeName(bucketsVolumeName *string) {
	o.BucketsVolumeName = bucketsVolumeName
}

// WithBucketsVolumeUUID adds the bucketsVolumeUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithBucketsVolumeUUID(bucketsVolumeUUID *string) *S3ServiceCollectionGetParams {
	o.SetBucketsVolumeUUID(bucketsVolumeUUID)
	return o
}

// SetBucketsVolumeUUID adds the bucketsVolumeUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetBucketsVolumeUUID(bucketsVolumeUUID *string) {
	o.BucketsVolumeUUID = bucketsVolumeUUID
}

// WithCertificateName adds the certificateName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithCertificateName(certificateName *string) *S3ServiceCollectionGetParams {
	o.SetCertificateName(certificateName)
	return o
}

// SetCertificateName adds the certificateName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetCertificateName(certificateName *string) {
	o.CertificateName = certificateName
}

// WithCertificateUUID adds the certificateUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithCertificateUUID(certificateUUID *string) *S3ServiceCollectionGetParams {
	o.SetCertificateUUID(certificateUUID)
	return o
}

// SetCertificateUUID adds the certificateUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetCertificateUUID(certificateUUID *string) {
	o.CertificateUUID = certificateUUID
}

// WithComment adds the comment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithComment(comment *string) *S3ServiceCollectionGetParams {
	o.SetComment(comment)
	return o
}

// SetComment adds the comment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetComment(comment *string) {
	o.Comment = comment
}

// WithDefaultUnixUser adds the defaultUnixUser to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithDefaultUnixUser(defaultUnixUser *string) *S3ServiceCollectionGetParams {
	o.SetDefaultUnixUser(defaultUnixUser)
	return o
}

// SetDefaultUnixUser adds the defaultUnixUser to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetDefaultUnixUser(defaultUnixUser *string) {
	o.DefaultUnixUser = defaultUnixUser
}

// WithDefaultWinUser adds the defaultWinUser to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithDefaultWinUser(defaultWinUser *string) *S3ServiceCollectionGetParams {
	o.SetDefaultWinUser(defaultWinUser)
	return o
}

// SetDefaultWinUser adds the defaultWinUser to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetDefaultWinUser(defaultWinUser *string) {
	o.DefaultWinUser = defaultWinUser
}

// WithEnabled adds the enabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithEnabled(enabled *bool) *S3ServiceCollectionGetParams {
	o.SetEnabled(enabled)
	return o
}

// SetEnabled adds the enabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetEnabled(enabled *bool) {
	o.Enabled = enabled
}

// WithFields adds the fields to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithFields(fields []string) *S3ServiceCollectionGetParams {
	o.SetFields(fields)
	return o
}

// SetFields adds the fields to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetFields(fields []string) {
	o.Fields = fields
}

// WithIsHTTPEnabled adds the isHTTPEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithIsHTTPEnabled(isHTTPEnabled *bool) *S3ServiceCollectionGetParams {
	o.SetIsHTTPEnabled(isHTTPEnabled)
	return o
}

// SetIsHTTPEnabled adds the isHttpEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetIsHTTPEnabled(isHTTPEnabled *bool) {
	o.IsHTTPEnabled = isHTTPEnabled
}

// WithIsHTTPSEnabled adds the isHTTPSEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithIsHTTPSEnabled(isHTTPSEnabled *bool) *S3ServiceCollectionGetParams {
	o.SetIsHTTPSEnabled(isHTTPSEnabled)
	return o
}

// SetIsHTTPSEnabled adds the isHttpsEnabled to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetIsHTTPSEnabled(isHTTPSEnabled *bool) {
	o.IsHTTPSEnabled = isHTTPSEnabled
}

// WithMaxKeyTimeToLive adds the maxKeyTimeToLive to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMaxKeyTimeToLive(maxKeyTimeToLive *string) *S3ServiceCollectionGetParams {
	o.SetMaxKeyTimeToLive(maxKeyTimeToLive)
	return o
}

// SetMaxKeyTimeToLive adds the maxKeyTimeToLive to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMaxKeyTimeToLive(maxKeyTimeToLive *string) {
	o.MaxKeyTimeToLive = maxKeyTimeToLive
}

// WithMaxLockRetentionPeriod adds the maxLockRetentionPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMaxLockRetentionPeriod(maxLockRetentionPeriod *string) *S3ServiceCollectionGetParams {
	o.SetMaxLockRetentionPeriod(maxLockRetentionPeriod)
	return o
}

// SetMaxLockRetentionPeriod adds the maxLockRetentionPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMaxLockRetentionPeriod(maxLockRetentionPeriod *string) {
	o.MaxLockRetentionPeriod = maxLockRetentionPeriod
}

// WithMaxRecords adds the maxRecords to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMaxRecords(maxRecords *int64) *S3ServiceCollectionGetParams {
	o.SetMaxRecords(maxRecords)
	return o
}

// SetMaxRecords adds the maxRecords to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMaxRecords(maxRecords *int64) {
	o.MaxRecords = maxRecords
}

// WithMetricDuration adds the metricDuration to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricDuration(metricDuration *string) *S3ServiceCollectionGetParams {
	o.SetMetricDuration(metricDuration)
	return o
}

// SetMetricDuration adds the metricDuration to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricDuration(metricDuration *string) {
	o.MetricDuration = metricDuration
}

// WithMetricIopsOther adds the metricIopsOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricIopsOther(metricIopsOther *int64) *S3ServiceCollectionGetParams {
	o.SetMetricIopsOther(metricIopsOther)
	return o
}

// SetMetricIopsOther adds the metricIopsOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricIopsOther(metricIopsOther *int64) {
	o.MetricIopsOther = metricIopsOther
}

// WithMetricIopsRead adds the metricIopsRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricIopsRead(metricIopsRead *int64) *S3ServiceCollectionGetParams {
	o.SetMetricIopsRead(metricIopsRead)
	return o
}

// SetMetricIopsRead adds the metricIopsRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricIopsRead(metricIopsRead *int64) {
	o.MetricIopsRead = metricIopsRead
}

// WithMetricIopsTotal adds the metricIopsTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricIopsTotal(metricIopsTotal *int64) *S3ServiceCollectionGetParams {
	o.SetMetricIopsTotal(metricIopsTotal)
	return o
}

// SetMetricIopsTotal adds the metricIopsTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricIopsTotal(metricIopsTotal *int64) {
	o.MetricIopsTotal = metricIopsTotal
}

// WithMetricIopsWrite adds the metricIopsWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricIopsWrite(metricIopsWrite *int64) *S3ServiceCollectionGetParams {
	o.SetMetricIopsWrite(metricIopsWrite)
	return o
}

// SetMetricIopsWrite adds the metricIopsWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricIopsWrite(metricIopsWrite *int64) {
	o.MetricIopsWrite = metricIopsWrite
}

// WithMetricLatencyOther adds the metricLatencyOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricLatencyOther(metricLatencyOther *int64) *S3ServiceCollectionGetParams {
	o.SetMetricLatencyOther(metricLatencyOther)
	return o
}

// SetMetricLatencyOther adds the metricLatencyOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricLatencyOther(metricLatencyOther *int64) {
	o.MetricLatencyOther = metricLatencyOther
}

// WithMetricLatencyRead adds the metricLatencyRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricLatencyRead(metricLatencyRead *int64) *S3ServiceCollectionGetParams {
	o.SetMetricLatencyRead(metricLatencyRead)
	return o
}

// SetMetricLatencyRead adds the metricLatencyRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricLatencyRead(metricLatencyRead *int64) {
	o.MetricLatencyRead = metricLatencyRead
}

// WithMetricLatencyTotal adds the metricLatencyTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricLatencyTotal(metricLatencyTotal *int64) *S3ServiceCollectionGetParams {
	o.SetMetricLatencyTotal(metricLatencyTotal)
	return o
}

// SetMetricLatencyTotal adds the metricLatencyTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricLatencyTotal(metricLatencyTotal *int64) {
	o.MetricLatencyTotal = metricLatencyTotal
}

// WithMetricLatencyWrite adds the metricLatencyWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricLatencyWrite(metricLatencyWrite *int64) *S3ServiceCollectionGetParams {
	o.SetMetricLatencyWrite(metricLatencyWrite)
	return o
}

// SetMetricLatencyWrite adds the metricLatencyWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricLatencyWrite(metricLatencyWrite *int64) {
	o.MetricLatencyWrite = metricLatencyWrite
}

// WithMetricStatus adds the metricStatus to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricStatus(metricStatus *string) *S3ServiceCollectionGetParams {
	o.SetMetricStatus(metricStatus)
	return o
}

// SetMetricStatus adds the metricStatus to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricStatus(metricStatus *string) {
	o.MetricStatus = metricStatus
}

// WithMetricThroughputRead adds the metricThroughputRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricThroughputRead(metricThroughputRead *int64) *S3ServiceCollectionGetParams {
	o.SetMetricThroughputRead(metricThroughputRead)
	return o
}

// SetMetricThroughputRead adds the metricThroughputRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricThroughputRead(metricThroughputRead *int64) {
	o.MetricThroughputRead = metricThroughputRead
}

// WithMetricThroughputTotal adds the metricThroughputTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricThroughputTotal(metricThroughputTotal *int64) *S3ServiceCollectionGetParams {
	o.SetMetricThroughputTotal(metricThroughputTotal)
	return o
}

// SetMetricThroughputTotal adds the metricThroughputTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricThroughputTotal(metricThroughputTotal *int64) {
	o.MetricThroughputTotal = metricThroughputTotal
}

// WithMetricThroughputWrite adds the metricThroughputWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricThroughputWrite(metricThroughputWrite *int64) *S3ServiceCollectionGetParams {
	o.SetMetricThroughputWrite(metricThroughputWrite)
	return o
}

// SetMetricThroughputWrite adds the metricThroughputWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricThroughputWrite(metricThroughputWrite *int64) {
	o.MetricThroughputWrite = metricThroughputWrite
}

// WithMetricTimestamp adds the metricTimestamp to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMetricTimestamp(metricTimestamp *string) *S3ServiceCollectionGetParams {
	o.SetMetricTimestamp(metricTimestamp)
	return o
}

// SetMetricTimestamp adds the metricTimestamp to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMetricTimestamp(metricTimestamp *string) {
	o.MetricTimestamp = metricTimestamp
}

// WithMinLockRetentionPeriod adds the minLockRetentionPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithMinLockRetentionPeriod(minLockRetentionPeriod *string) *S3ServiceCollectionGetParams {
	o.SetMinLockRetentionPeriod(minLockRetentionPeriod)
	return o
}

// SetMinLockRetentionPeriod adds the minLockRetentionPeriod to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetMinLockRetentionPeriod(minLockRetentionPeriod *string) {
	o.MinLockRetentionPeriod = minLockRetentionPeriod
}

// WithName adds the name to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithName(name *string) *S3ServiceCollectionGetParams {
	o.SetName(name)
	return o
}

// SetName adds the name to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetName(name *string) {
	o.Name = name
}

// WithOrderBy adds the orderBy to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithOrderBy(orderBy []string) *S3ServiceCollectionGetParams {
	o.SetOrderBy(orderBy)
	return o
}

// SetOrderBy adds the orderBy to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetOrderBy(orderBy []string) {
	o.OrderBy = orderBy
}

// WithPort adds the port to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithPort(port *int64) *S3ServiceCollectionGetParams {
	o.SetPort(port)
	return o
}

// SetPort adds the port to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetPort(port *int64) {
	o.Port = port
}

// WithReturnRecords adds the returnRecords to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithReturnRecords(returnRecords *bool) *S3ServiceCollectionGetParams {
	o.SetReturnRecords(returnRecords)
	return o
}

// SetReturnRecords adds the returnRecords to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetReturnRecords(returnRecords *bool) {
	o.ReturnRecords = returnRecords
}

// WithReturnTimeout adds the returnTimeout to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithReturnTimeout(returnTimeout *int64) *S3ServiceCollectionGetParams {
	o.SetReturnTimeout(returnTimeout)
	return o
}

// SetReturnTimeout adds the returnTimeout to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetReturnTimeout(returnTimeout *int64) {
	o.ReturnTimeout = returnTimeout
}

// WithSecurePort adds the securePort to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithSecurePort(securePort *int64) *S3ServiceCollectionGetParams {
	o.SetSecurePort(securePort)
	return o
}

// SetSecurePort adds the securePort to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetSecurePort(securePort *int64) {
	o.SecurePort = securePort
}

// WithStatisticsIopsRawOther adds the statisticsIopsRawOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsIopsRawOther(statisticsIopsRawOther *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsIopsRawOther(statisticsIopsRawOther)
	return o
}

// SetStatisticsIopsRawOther adds the statisticsIopsRawOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsIopsRawOther(statisticsIopsRawOther *int64) {
	o.StatisticsIopsRawOther = statisticsIopsRawOther
}

// WithStatisticsIopsRawRead adds the statisticsIopsRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsIopsRawRead(statisticsIopsRawRead *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsIopsRawRead(statisticsIopsRawRead)
	return o
}

// SetStatisticsIopsRawRead adds the statisticsIopsRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsIopsRawRead(statisticsIopsRawRead *int64) {
	o.StatisticsIopsRawRead = statisticsIopsRawRead
}

// WithStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsIopsRawTotal(statisticsIopsRawTotal)
	return o
}

// SetStatisticsIopsRawTotal adds the statisticsIopsRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsIopsRawTotal(statisticsIopsRawTotal *int64) {
	o.StatisticsIopsRawTotal = statisticsIopsRawTotal
}

// WithStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsIopsRawWrite(statisticsIopsRawWrite)
	return o
}

// SetStatisticsIopsRawWrite adds the statisticsIopsRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsIopsRawWrite(statisticsIopsRawWrite *int64) {
	o.StatisticsIopsRawWrite = statisticsIopsRawWrite
}

// WithStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsLatencyRawOther(statisticsLatencyRawOther)
	return o
}

// SetStatisticsLatencyRawOther adds the statisticsLatencyRawOther to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsLatencyRawOther(statisticsLatencyRawOther *int64) {
	o.StatisticsLatencyRawOther = statisticsLatencyRawOther
}

// WithStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsLatencyRawRead(statisticsLatencyRawRead)
	return o
}

// SetStatisticsLatencyRawRead adds the statisticsLatencyRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsLatencyRawRead(statisticsLatencyRawRead *int64) {
	o.StatisticsLatencyRawRead = statisticsLatencyRawRead
}

// WithStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal)
	return o
}

// SetStatisticsLatencyRawTotal adds the statisticsLatencyRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsLatencyRawTotal(statisticsLatencyRawTotal *int64) {
	o.StatisticsLatencyRawTotal = statisticsLatencyRawTotal
}

// WithStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite)
	return o
}

// SetStatisticsLatencyRawWrite adds the statisticsLatencyRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsLatencyRawWrite(statisticsLatencyRawWrite *int64) {
	o.StatisticsLatencyRawWrite = statisticsLatencyRawWrite
}

// WithStatisticsStatus adds the statisticsStatus to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsStatus(statisticsStatus *string) *S3ServiceCollectionGetParams {
	o.SetStatisticsStatus(statisticsStatus)
	return o
}

// SetStatisticsStatus adds the statisticsStatus to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsStatus(statisticsStatus *string) {
	o.StatisticsStatus = statisticsStatus
}

// WithStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsThroughputRawRead(statisticsThroughputRawRead)
	return o
}

// SetStatisticsThroughputRawRead adds the statisticsThroughputRawRead to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsThroughputRawRead(statisticsThroughputRawRead *int64) {
	o.StatisticsThroughputRawRead = statisticsThroughputRawRead
}

// WithStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal)
	return o
}

// SetStatisticsThroughputRawTotal adds the statisticsThroughputRawTotal to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsThroughputRawTotal(statisticsThroughputRawTotal *int64) {
	o.StatisticsThroughputRawTotal = statisticsThroughputRawTotal
}

// WithStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) *S3ServiceCollectionGetParams {
	o.SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite)
	return o
}

// SetStatisticsThroughputRawWrite adds the statisticsThroughputRawWrite to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsThroughputRawWrite(statisticsThroughputRawWrite *int64) {
	o.StatisticsThroughputRawWrite = statisticsThroughputRawWrite
}

// WithStatisticsTimestamp adds the statisticsTimestamp to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithStatisticsTimestamp(statisticsTimestamp *string) *S3ServiceCollectionGetParams {
	o.SetStatisticsTimestamp(statisticsTimestamp)
	return o
}

// SetStatisticsTimestamp adds the statisticsTimestamp to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetStatisticsTimestamp(statisticsTimestamp *string) {
	o.StatisticsTimestamp = statisticsTimestamp
}

// WithSvmName adds the svmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithSvmName(svmName *string) *S3ServiceCollectionGetParams {
	o.SetSvmName(svmName)
	return o
}

// SetSvmName adds the svmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetSvmName(svmName *string) {
	o.SvmName = svmName
}

// WithSvmUUID adds the svmUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithSvmUUID(svmUUID *string) *S3ServiceCollectionGetParams {
	o.SetSvmUUID(svmUUID)
	return o
}

// SetSvmUUID adds the svmUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetSvmUUID(svmUUID *string) {
	o.SvmUUID = svmUUID
}

// WithUsersAccessKey adds the usersAccessKey to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersAccessKey(usersAccessKey *string) *S3ServiceCollectionGetParams {
	o.SetUsersAccessKey(usersAccessKey)
	return o
}

// SetUsersAccessKey adds the usersAccessKey to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersAccessKey(usersAccessKey *string) {
	o.UsersAccessKey = usersAccessKey
}

// WithUsersComment adds the usersComment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersComment(usersComment *string) *S3ServiceCollectionGetParams {
	o.SetUsersComment(usersComment)
	return o
}

// SetUsersComment adds the usersComment to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersComment(usersComment *string) {
	o.UsersComment = usersComment
}

// WithUsersKeyExpiryTime adds the usersKeyExpiryTime to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersKeyExpiryTime(usersKeyExpiryTime *string) *S3ServiceCollectionGetParams {
	o.SetUsersKeyExpiryTime(usersKeyExpiryTime)
	return o
}

// SetUsersKeyExpiryTime adds the usersKeyExpiryTime to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersKeyExpiryTime(usersKeyExpiryTime *string) {
	o.UsersKeyExpiryTime = usersKeyExpiryTime
}

// WithUsersKeyTimeToLive adds the usersKeyTimeToLive to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersKeyTimeToLive(usersKeyTimeToLive *string) *S3ServiceCollectionGetParams {
	o.SetUsersKeyTimeToLive(usersKeyTimeToLive)
	return o
}

// SetUsersKeyTimeToLive adds the usersKeyTimeToLive to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersKeyTimeToLive(usersKeyTimeToLive *string) {
	o.UsersKeyTimeToLive = usersKeyTimeToLive
}

// WithUsersName adds the usersName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersName(usersName *string) *S3ServiceCollectionGetParams {
	o.SetUsersName(usersName)
	return o
}

// SetUsersName adds the usersName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersName(usersName *string) {
	o.UsersName = usersName
}

// WithUsersSvmName adds the usersSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersSvmName(usersSvmName *string) *S3ServiceCollectionGetParams {
	o.SetUsersSvmName(usersSvmName)
	return o
}

// SetUsersSvmName adds the usersSvmName to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersSvmName(usersSvmName *string) {
	o.UsersSvmName = usersSvmName
}

// WithUsersSvmUUID adds the usersSvmUUID to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) WithUsersSvmUUID(usersSvmUUID *string) *S3ServiceCollectionGetParams {
	o.SetUsersSvmUUID(usersSvmUUID)
	return o
}

// SetUsersSvmUUID adds the usersSvmUuid to the s3 service collection get params
func (o *S3ServiceCollectionGetParams) SetUsersSvmUUID(usersSvmUUID *string) {
	o.UsersSvmUUID = usersSvmUUID
}

// WriteToRequest writes these params to a swagger request
func (o *S3ServiceCollectionGetParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.BucketsAllowed != nil {

		// query param buckets.allowed
		var qrBucketsAllowed bool

		if o.BucketsAllowed != nil {
			qrBucketsAllowed = *o.BucketsAllowed
		}
		qBucketsAllowed := swag.FormatBool(qrBucketsAllowed)
		if qBucketsAllowed != "" {

			if err := r.SetQueryParam("buckets.allowed", qBucketsAllowed); err != nil {
				return err
			}
		}
	}

	if o.BucketsAuditEventSelectorAccess != nil {

		// query param buckets.audit_event_selector.access
		var qrBucketsAuditEventSelectorAccess string

		if o.BucketsAuditEventSelectorAccess != nil {
			qrBucketsAuditEventSelectorAccess = *o.BucketsAuditEventSelectorAccess
		}
		qBucketsAuditEventSelectorAccess := qrBucketsAuditEventSelectorAccess
		if qBucketsAuditEventSelectorAccess != "" {

			if err := r.SetQueryParam("buckets.audit_event_selector.access", qBucketsAuditEventSelectorAccess); err != nil {
				return err
			}
		}
	}

	if o.BucketsAuditEventSelectorPermission != nil {

		// query param buckets.audit_event_selector.permission
		var qrBucketsAuditEventSelectorPermission string

		if o.BucketsAuditEventSelectorPermission != nil {
			qrBucketsAuditEventSelectorPermission = *o.BucketsAuditEventSelectorPermission
		}
		qBucketsAuditEventSelectorPermission := qrBucketsAuditEventSelectorPermission
		if qBucketsAuditEventSelectorPermission != "" {

			if err := r.SetQueryParam("buckets.audit_event_selector.permission", qBucketsAuditEventSelectorPermission); err != nil {
				return err
			}
		}
	}

	if o.BucketsComment != nil {

		// query param buckets.comment
		var qrBucketsComment string

		if o.BucketsComment != nil {
			qrBucketsComment = *o.BucketsComment
		}
		qBucketsComment := qrBucketsComment
		if qBucketsComment != "" {

			if err := r.SetQueryParam("buckets.comment", qBucketsComment); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesAllowedHeaders != nil {

		// query param buckets.cors.rules.allowed_headers
		var qrBucketsCorsRulesAllowedHeaders string

		if o.BucketsCorsRulesAllowedHeaders != nil {
			qrBucketsCorsRulesAllowedHeaders = *o.BucketsCorsRulesAllowedHeaders
		}
		qBucketsCorsRulesAllowedHeaders := qrBucketsCorsRulesAllowedHeaders
		if qBucketsCorsRulesAllowedHeaders != "" {

			if err := r.SetQueryParam("buckets.cors.rules.allowed_headers", qBucketsCorsRulesAllowedHeaders); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesAllowedMethods != nil {

		// query param buckets.cors.rules.allowed_methods
		var qrBucketsCorsRulesAllowedMethods string

		if o.BucketsCorsRulesAllowedMethods != nil {
			qrBucketsCorsRulesAllowedMethods = *o.BucketsCorsRulesAllowedMethods
		}
		qBucketsCorsRulesAllowedMethods := qrBucketsCorsRulesAllowedMethods
		if qBucketsCorsRulesAllowedMethods != "" {

			if err := r.SetQueryParam("buckets.cors.rules.allowed_methods", qBucketsCorsRulesAllowedMethods); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesAllowedOrigins != nil {

		// query param buckets.cors.rules.allowed_origins
		var qrBucketsCorsRulesAllowedOrigins string

		if o.BucketsCorsRulesAllowedOrigins != nil {
			qrBucketsCorsRulesAllowedOrigins = *o.BucketsCorsRulesAllowedOrigins
		}
		qBucketsCorsRulesAllowedOrigins := qrBucketsCorsRulesAllowedOrigins
		if qBucketsCorsRulesAllowedOrigins != "" {

			if err := r.SetQueryParam("buckets.cors.rules.allowed_origins", qBucketsCorsRulesAllowedOrigins); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesExposeHeaders != nil {

		// query param buckets.cors.rules.expose_headers
		var qrBucketsCorsRulesExposeHeaders string

		if o.BucketsCorsRulesExposeHeaders != nil {
			qrBucketsCorsRulesExposeHeaders = *o.BucketsCorsRulesExposeHeaders
		}
		qBucketsCorsRulesExposeHeaders := qrBucketsCorsRulesExposeHeaders
		if qBucketsCorsRulesExposeHeaders != "" {

			if err := r.SetQueryParam("buckets.cors.rules.expose_headers", qBucketsCorsRulesExposeHeaders); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesID != nil {

		// query param buckets.cors.rules.id
		var qrBucketsCorsRulesID string

		if o.BucketsCorsRulesID != nil {
			qrBucketsCorsRulesID = *o.BucketsCorsRulesID
		}
		qBucketsCorsRulesID := qrBucketsCorsRulesID
		if qBucketsCorsRulesID != "" {

			if err := r.SetQueryParam("buckets.cors.rules.id", qBucketsCorsRulesID); err != nil {
				return err
			}
		}
	}

	if o.BucketsCorsRulesMaxAgeSeconds != nil {

		// query param buckets.cors.rules.max_age_seconds
		var qrBucketsCorsRulesMaxAgeSeconds int64

		if o.BucketsCorsRulesMaxAgeSeconds != nil {
			qrBucketsCorsRulesMaxAgeSeconds = *o.BucketsCorsRulesMaxAgeSeconds
		}
		qBucketsCorsRulesMaxAgeSeconds := swag.FormatInt64(qrBucketsCorsRulesMaxAgeSeconds)
		if qBucketsCorsRulesMaxAgeSeconds != "" {

			if err := r.SetQueryParam("buckets.cors.rules.max_age_seconds", qBucketsCorsRulesMaxAgeSeconds); err != nil {
				return err
			}
		}
	}

	if o.BucketsEncryptionEnabled != nil {

		// query param buckets.encryption.enabled
		var qrBucketsEncryptionEnabled bool

		if o.BucketsEncryptionEnabled != nil {
			qrBucketsEncryptionEnabled = *o.BucketsEncryptionEnabled
		}
		qBucketsEncryptionEnabled := swag.FormatBool(qrBucketsEncryptionEnabled)
		if qBucketsEncryptionEnabled != "" {

			if err := r.SetQueryParam("buckets.encryption.enabled", qBucketsEncryptionEnabled); err != nil {
				return err
			}
		}
	}

	if o.BucketsIsConsistentEtag != nil {

		// query param buckets.is_consistent_etag
		var qrBucketsIsConsistentEtag bool

		if o.BucketsIsConsistentEtag != nil {
			qrBucketsIsConsistentEtag = *o.BucketsIsConsistentEtag
		}
		qBucketsIsConsistentEtag := swag.FormatBool(qrBucketsIsConsistentEtag)
		if qBucketsIsConsistentEtag != "" {

			if err := r.SetQueryParam("buckets.is_consistent_etag", qBucketsIsConsistentEtag); err != nil {
				return err
			}
		}
	}

	if o.BucketsIsNasPathMutable != nil {

		// query param buckets.is_nas_path_mutable
		var qrBucketsIsNasPathMutable bool

		if o.BucketsIsNasPathMutable != nil {
			qrBucketsIsNasPathMutable = *o.BucketsIsNasPathMutable
		}
		qBucketsIsNasPathMutable := swag.FormatBool(qrBucketsIsNasPathMutable)
		if qBucketsIsNasPathMutable != "" {

			if err := r.SetQueryParam("buckets.is_nas_path_mutable", qBucketsIsNasPathMutable); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != nil {

		// query param buckets.lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days
		var qrBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays int64

		if o.BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != nil {
			qrBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays = *o.BucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays
		}
		qBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays := swag.FormatInt64(qrBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays)
		if qBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.abort_incomplete_multipart_upload.after_initiation_days", qBucketsLifecycleManagementRulesAbortIncompleteMultipartUploadAfterInitiationDays); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesBucketName != nil {

		// query param buckets.lifecycle_management.rules.bucket_name
		var qrBucketsLifecycleManagementRulesBucketName string

		if o.BucketsLifecycleManagementRulesBucketName != nil {
			qrBucketsLifecycleManagementRulesBucketName = *o.BucketsLifecycleManagementRulesBucketName
		}
		qBucketsLifecycleManagementRulesBucketName := qrBucketsLifecycleManagementRulesBucketName
		if qBucketsLifecycleManagementRulesBucketName != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.bucket_name", qBucketsLifecycleManagementRulesBucketName); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesEnabled != nil {

		// query param buckets.lifecycle_management.rules.enabled
		var qrBucketsLifecycleManagementRulesEnabled bool

		if o.BucketsLifecycleManagementRulesEnabled != nil {
			qrBucketsLifecycleManagementRulesEnabled = *o.BucketsLifecycleManagementRulesEnabled
		}
		qBucketsLifecycleManagementRulesEnabled := swag.FormatBool(qrBucketsLifecycleManagementRulesEnabled)
		if qBucketsLifecycleManagementRulesEnabled != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.enabled", qBucketsLifecycleManagementRulesEnabled); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker != nil {

		// query param buckets.lifecycle_management.rules.expiration.expired_object_delete_marker
		var qrBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker bool

		if o.BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker != nil {
			qrBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker = *o.BucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker
		}
		qBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker := swag.FormatBool(qrBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker)
		if qBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.expiration.expired_object_delete_marker", qBucketsLifecycleManagementRulesExpirationExpiredObjectDeleteMarker); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesExpirationObjectAgeDays != nil {

		// query param buckets.lifecycle_management.rules.expiration.object_age_days
		var qrBucketsLifecycleManagementRulesExpirationObjectAgeDays int64

		if o.BucketsLifecycleManagementRulesExpirationObjectAgeDays != nil {
			qrBucketsLifecycleManagementRulesExpirationObjectAgeDays = *o.BucketsLifecycleManagementRulesExpirationObjectAgeDays
		}
		qBucketsLifecycleManagementRulesExpirationObjectAgeDays := swag.FormatInt64(qrBucketsLifecycleManagementRulesExpirationObjectAgeDays)
		if qBucketsLifecycleManagementRulesExpirationObjectAgeDays != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.expiration.object_age_days", qBucketsLifecycleManagementRulesExpirationObjectAgeDays); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesExpirationObjectExpiryDate != nil {

		// query param buckets.lifecycle_management.rules.expiration.object_expiry_date
		var qrBucketsLifecycleManagementRulesExpirationObjectExpiryDate string

		if o.BucketsLifecycleManagementRulesExpirationObjectExpiryDate != nil {
			qrBucketsLifecycleManagementRulesExpirationObjectExpiryDate = *o.BucketsLifecycleManagementRulesExpirationObjectExpiryDate
		}
		qBucketsLifecycleManagementRulesExpirationObjectExpiryDate := qrBucketsLifecycleManagementRulesExpirationObjectExpiryDate
		if qBucketsLifecycleManagementRulesExpirationObjectExpiryDate != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.expiration.object_expiry_date", qBucketsLifecycleManagementRulesExpirationObjectExpiryDate); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesName != nil {

		// query param buckets.lifecycle_management.rules.name
		var qrBucketsLifecycleManagementRulesName string

		if o.BucketsLifecycleManagementRulesName != nil {
			qrBucketsLifecycleManagementRulesName = *o.BucketsLifecycleManagementRulesName
		}
		qBucketsLifecycleManagementRulesName := qrBucketsLifecycleManagementRulesName
		if qBucketsLifecycleManagementRulesName != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.name", qBucketsLifecycleManagementRulesName); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != nil {

		// query param buckets.lifecycle_management.rules.non_current_version_expiration.new_non_current_versions
		var qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions int64

		if o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != nil {
			qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions = *o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions
		}
		qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions := swag.FormatInt64(qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions)
		if qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.non_current_version_expiration.new_non_current_versions", qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNewNonCurrentVersions); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != nil {

		// query param buckets.lifecycle_management.rules.non_current_version_expiration.non_current_days
		var qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays int64

		if o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != nil {
			qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays = *o.BucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays
		}
		qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays := swag.FormatInt64(qrBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays)
		if qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.non_current_version_expiration.non_current_days", qBucketsLifecycleManagementRulesNonCurrentVersionExpirationNonCurrentDays); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesObjectFilterPrefix != nil {

		// query param buckets.lifecycle_management.rules.object_filter.prefix
		var qrBucketsLifecycleManagementRulesObjectFilterPrefix string

		if o.BucketsLifecycleManagementRulesObjectFilterPrefix != nil {
			qrBucketsLifecycleManagementRulesObjectFilterPrefix = *o.BucketsLifecycleManagementRulesObjectFilterPrefix
		}
		qBucketsLifecycleManagementRulesObjectFilterPrefix := qrBucketsLifecycleManagementRulesObjectFilterPrefix
		if qBucketsLifecycleManagementRulesObjectFilterPrefix != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.object_filter.prefix", qBucketsLifecycleManagementRulesObjectFilterPrefix); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan != nil {

		// query param buckets.lifecycle_management.rules.object_filter.size_greater_than
		var qrBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan int64

		if o.BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan != nil {
			qrBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan = *o.BucketsLifecycleManagementRulesObjectFilterSizeGreaterThan
		}
		qBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan := swag.FormatInt64(qrBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan)
		if qBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.object_filter.size_greater_than", qBucketsLifecycleManagementRulesObjectFilterSizeGreaterThan); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesObjectFilterSizeLessThan != nil {

		// query param buckets.lifecycle_management.rules.object_filter.size_less_than
		var qrBucketsLifecycleManagementRulesObjectFilterSizeLessThan int64

		if o.BucketsLifecycleManagementRulesObjectFilterSizeLessThan != nil {
			qrBucketsLifecycleManagementRulesObjectFilterSizeLessThan = *o.BucketsLifecycleManagementRulesObjectFilterSizeLessThan
		}
		qBucketsLifecycleManagementRulesObjectFilterSizeLessThan := swag.FormatInt64(qrBucketsLifecycleManagementRulesObjectFilterSizeLessThan)
		if qBucketsLifecycleManagementRulesObjectFilterSizeLessThan != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.object_filter.size_less_than", qBucketsLifecycleManagementRulesObjectFilterSizeLessThan); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesObjectFilterTags != nil {

		// query param buckets.lifecycle_management.rules.object_filter.tags
		var qrBucketsLifecycleManagementRulesObjectFilterTags string

		if o.BucketsLifecycleManagementRulesObjectFilterTags != nil {
			qrBucketsLifecycleManagementRulesObjectFilterTags = *o.BucketsLifecycleManagementRulesObjectFilterTags
		}
		qBucketsLifecycleManagementRulesObjectFilterTags := qrBucketsLifecycleManagementRulesObjectFilterTags
		if qBucketsLifecycleManagementRulesObjectFilterTags != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.object_filter.tags", qBucketsLifecycleManagementRulesObjectFilterTags); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesSvmName != nil {

		// query param buckets.lifecycle_management.rules.svm.name
		var qrBucketsLifecycleManagementRulesSvmName string

		if o.BucketsLifecycleManagementRulesSvmName != nil {
			qrBucketsLifecycleManagementRulesSvmName = *o.BucketsLifecycleManagementRulesSvmName
		}
		qBucketsLifecycleManagementRulesSvmName := qrBucketsLifecycleManagementRulesSvmName
		if qBucketsLifecycleManagementRulesSvmName != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.svm.name", qBucketsLifecycleManagementRulesSvmName); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesSvmUUID != nil {

		// query param buckets.lifecycle_management.rules.svm.uuid
		var qrBucketsLifecycleManagementRulesSvmUUID string

		if o.BucketsLifecycleManagementRulesSvmUUID != nil {
			qrBucketsLifecycleManagementRulesSvmUUID = *o.BucketsLifecycleManagementRulesSvmUUID
		}
		qBucketsLifecycleManagementRulesSvmUUID := qrBucketsLifecycleManagementRulesSvmUUID
		if qBucketsLifecycleManagementRulesSvmUUID != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.svm.uuid", qBucketsLifecycleManagementRulesSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsLifecycleManagementRulesUUID != nil {

		// query param buckets.lifecycle_management.rules.uuid
		var qrBucketsLifecycleManagementRulesUUID string

		if o.BucketsLifecycleManagementRulesUUID != nil {
			qrBucketsLifecycleManagementRulesUUID = *o.BucketsLifecycleManagementRulesUUID
		}
		qBucketsLifecycleManagementRulesUUID := qrBucketsLifecycleManagementRulesUUID
		if qBucketsLifecycleManagementRulesUUID != "" {

			if err := r.SetQueryParam("buckets.lifecycle_management.rules.uuid", qBucketsLifecycleManagementRulesUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsLogicalUsedSize != nil {

		// query param buckets.logical_used_size
		var qrBucketsLogicalUsedSize int64

		if o.BucketsLogicalUsedSize != nil {
			qrBucketsLogicalUsedSize = *o.BucketsLogicalUsedSize
		}
		qBucketsLogicalUsedSize := swag.FormatInt64(qrBucketsLogicalUsedSize)
		if qBucketsLogicalUsedSize != "" {

			if err := r.SetQueryParam("buckets.logical_used_size", qBucketsLogicalUsedSize); err != nil {
				return err
			}
		}
	}

	if o.BucketsName != nil {

		// query param buckets.name
		var qrBucketsName string

		if o.BucketsName != nil {
			qrBucketsName = *o.BucketsName
		}
		qBucketsName := qrBucketsName
		if qBucketsName != "" {

			if err := r.SetQueryParam("buckets.name", qBucketsName); err != nil {
				return err
			}
		}
	}

	if o.BucketsNasPath != nil {

		// query param buckets.nas_path
		var qrBucketsNasPath string

		if o.BucketsNasPath != nil {
			qrBucketsNasPath = *o.BucketsNasPath
		}
		qBucketsNasPath := qrBucketsNasPath
		if qBucketsNasPath != "" {

			if err := r.SetQueryParam("buckets.nas_path", qBucketsNasPath); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsActions != nil {

		// query param buckets.policy.statements.actions
		var qrBucketsPolicyStatementsActions string

		if o.BucketsPolicyStatementsActions != nil {
			qrBucketsPolicyStatementsActions = *o.BucketsPolicyStatementsActions
		}
		qBucketsPolicyStatementsActions := qrBucketsPolicyStatementsActions
		if qBucketsPolicyStatementsActions != "" {

			if err := r.SetQueryParam("buckets.policy.statements.actions", qBucketsPolicyStatementsActions); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsDelimiters != nil {

		// query param buckets.policy.statements.conditions.delimiters
		var qrBucketsPolicyStatementsConditionsDelimiters string

		if o.BucketsPolicyStatementsConditionsDelimiters != nil {
			qrBucketsPolicyStatementsConditionsDelimiters = *o.BucketsPolicyStatementsConditionsDelimiters
		}
		qBucketsPolicyStatementsConditionsDelimiters := qrBucketsPolicyStatementsConditionsDelimiters
		if qBucketsPolicyStatementsConditionsDelimiters != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.delimiters", qBucketsPolicyStatementsConditionsDelimiters); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsMaxKeys != nil {

		// query param buckets.policy.statements.conditions.max_keys
		var qrBucketsPolicyStatementsConditionsMaxKeys int64

		if o.BucketsPolicyStatementsConditionsMaxKeys != nil {
			qrBucketsPolicyStatementsConditionsMaxKeys = *o.BucketsPolicyStatementsConditionsMaxKeys
		}
		qBucketsPolicyStatementsConditionsMaxKeys := swag.FormatInt64(qrBucketsPolicyStatementsConditionsMaxKeys)
		if qBucketsPolicyStatementsConditionsMaxKeys != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.max_keys", qBucketsPolicyStatementsConditionsMaxKeys); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsOperator != nil {

		// query param buckets.policy.statements.conditions.operator
		var qrBucketsPolicyStatementsConditionsOperator string

		if o.BucketsPolicyStatementsConditionsOperator != nil {
			qrBucketsPolicyStatementsConditionsOperator = *o.BucketsPolicyStatementsConditionsOperator
		}
		qBucketsPolicyStatementsConditionsOperator := qrBucketsPolicyStatementsConditionsOperator
		if qBucketsPolicyStatementsConditionsOperator != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.operator", qBucketsPolicyStatementsConditionsOperator); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsPrefixes != nil {

		// query param buckets.policy.statements.conditions.prefixes
		var qrBucketsPolicyStatementsConditionsPrefixes string

		if o.BucketsPolicyStatementsConditionsPrefixes != nil {
			qrBucketsPolicyStatementsConditionsPrefixes = *o.BucketsPolicyStatementsConditionsPrefixes
		}
		qBucketsPolicyStatementsConditionsPrefixes := qrBucketsPolicyStatementsConditionsPrefixes
		if qBucketsPolicyStatementsConditionsPrefixes != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.prefixes", qBucketsPolicyStatementsConditionsPrefixes); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsSourceIps != nil {

		// query param buckets.policy.statements.conditions.source_ips
		var qrBucketsPolicyStatementsConditionsSourceIps string

		if o.BucketsPolicyStatementsConditionsSourceIps != nil {
			qrBucketsPolicyStatementsConditionsSourceIps = *o.BucketsPolicyStatementsConditionsSourceIps
		}
		qBucketsPolicyStatementsConditionsSourceIps := qrBucketsPolicyStatementsConditionsSourceIps
		if qBucketsPolicyStatementsConditionsSourceIps != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.source_ips", qBucketsPolicyStatementsConditionsSourceIps); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsConditionsUsernames != nil {

		// query param buckets.policy.statements.conditions.usernames
		var qrBucketsPolicyStatementsConditionsUsernames string

		if o.BucketsPolicyStatementsConditionsUsernames != nil {
			qrBucketsPolicyStatementsConditionsUsernames = *o.BucketsPolicyStatementsConditionsUsernames
		}
		qBucketsPolicyStatementsConditionsUsernames := qrBucketsPolicyStatementsConditionsUsernames
		if qBucketsPolicyStatementsConditionsUsernames != "" {

			if err := r.SetQueryParam("buckets.policy.statements.conditions.usernames", qBucketsPolicyStatementsConditionsUsernames); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsEffect != nil {

		// query param buckets.policy.statements.effect
		var qrBucketsPolicyStatementsEffect string

		if o.BucketsPolicyStatementsEffect != nil {
			qrBucketsPolicyStatementsEffect = *o.BucketsPolicyStatementsEffect
		}
		qBucketsPolicyStatementsEffect := qrBucketsPolicyStatementsEffect
		if qBucketsPolicyStatementsEffect != "" {

			if err := r.SetQueryParam("buckets.policy.statements.effect", qBucketsPolicyStatementsEffect); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsPrincipals != nil {

		// query param buckets.policy.statements.principals
		var qrBucketsPolicyStatementsPrincipals string

		if o.BucketsPolicyStatementsPrincipals != nil {
			qrBucketsPolicyStatementsPrincipals = *o.BucketsPolicyStatementsPrincipals
		}
		qBucketsPolicyStatementsPrincipals := qrBucketsPolicyStatementsPrincipals
		if qBucketsPolicyStatementsPrincipals != "" {

			if err := r.SetQueryParam("buckets.policy.statements.principals", qBucketsPolicyStatementsPrincipals); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsResources != nil {

		// query param buckets.policy.statements.resources
		var qrBucketsPolicyStatementsResources string

		if o.BucketsPolicyStatementsResources != nil {
			qrBucketsPolicyStatementsResources = *o.BucketsPolicyStatementsResources
		}
		qBucketsPolicyStatementsResources := qrBucketsPolicyStatementsResources
		if qBucketsPolicyStatementsResources != "" {

			if err := r.SetQueryParam("buckets.policy.statements.resources", qBucketsPolicyStatementsResources); err != nil {
				return err
			}
		}
	}

	if o.BucketsPolicyStatementsSid != nil {

		// query param buckets.policy.statements.sid
		var qrBucketsPolicyStatementsSid string

		if o.BucketsPolicyStatementsSid != nil {
			qrBucketsPolicyStatementsSid = *o.BucketsPolicyStatementsSid
		}
		qBucketsPolicyStatementsSid := qrBucketsPolicyStatementsSid
		if qBucketsPolicyStatementsSid != "" {

			if err := r.SetQueryParam("buckets.policy.statements.sid", qBucketsPolicyStatementsSid); err != nil {
				return err
			}
		}
	}

	if o.BucketsProtectionStatusDestinationIsCloud != nil {

		// query param buckets.protection_status.destination.is_cloud
		var qrBucketsProtectionStatusDestinationIsCloud bool

		if o.BucketsProtectionStatusDestinationIsCloud != nil {
			qrBucketsProtectionStatusDestinationIsCloud = *o.BucketsProtectionStatusDestinationIsCloud
		}
		qBucketsProtectionStatusDestinationIsCloud := swag.FormatBool(qrBucketsProtectionStatusDestinationIsCloud)
		if qBucketsProtectionStatusDestinationIsCloud != "" {

			if err := r.SetQueryParam("buckets.protection_status.destination.is_cloud", qBucketsProtectionStatusDestinationIsCloud); err != nil {
				return err
			}
		}
	}

	if o.BucketsProtectionStatusDestinationIsExternalCloud != nil {

		// query param buckets.protection_status.destination.is_external_cloud
		var qrBucketsProtectionStatusDestinationIsExternalCloud bool

		if o.BucketsProtectionStatusDestinationIsExternalCloud != nil {
			qrBucketsProtectionStatusDestinationIsExternalCloud = *o.BucketsProtectionStatusDestinationIsExternalCloud
		}
		qBucketsProtectionStatusDestinationIsExternalCloud := swag.FormatBool(qrBucketsProtectionStatusDestinationIsExternalCloud)
		if qBucketsProtectionStatusDestinationIsExternalCloud != "" {

			if err := r.SetQueryParam("buckets.protection_status.destination.is_external_cloud", qBucketsProtectionStatusDestinationIsExternalCloud); err != nil {
				return err
			}
		}
	}

	if o.BucketsProtectionStatusDestinationIsOntap != nil {

		// query param buckets.protection_status.destination.is_ontap
		var qrBucketsProtectionStatusDestinationIsOntap bool

		if o.BucketsProtectionStatusDestinationIsOntap != nil {
			qrBucketsProtectionStatusDestinationIsOntap = *o.BucketsProtectionStatusDestinationIsOntap
		}
		qBucketsProtectionStatusDestinationIsOntap := swag.FormatBool(qrBucketsProtectionStatusDestinationIsOntap)
		if qBucketsProtectionStatusDestinationIsOntap != "" {

			if err := r.SetQueryParam("buckets.protection_status.destination.is_ontap", qBucketsProtectionStatusDestinationIsOntap); err != nil {
				return err
			}
		}
	}

	if o.BucketsProtectionStatusIsProtected != nil {

		// query param buckets.protection_status.is_protected
		var qrBucketsProtectionStatusIsProtected bool

		if o.BucketsProtectionStatusIsProtected != nil {
			qrBucketsProtectionStatusIsProtected = *o.BucketsProtectionStatusIsProtected
		}
		qBucketsProtectionStatusIsProtected := swag.FormatBool(qrBucketsProtectionStatusIsProtected)
		if qBucketsProtectionStatusIsProtected != "" {

			if err := r.SetQueryParam("buckets.protection_status.is_protected", qBucketsProtectionStatusIsProtected); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMaxThroughput != nil {

		// query param buckets.qos_policy.max_throughput
		var qrBucketsQosPolicyMaxThroughput string

		if o.BucketsQosPolicyMaxThroughput != nil {
			qrBucketsQosPolicyMaxThroughput = *o.BucketsQosPolicyMaxThroughput
		}
		qBucketsQosPolicyMaxThroughput := qrBucketsQosPolicyMaxThroughput
		if qBucketsQosPolicyMaxThroughput != "" {

			if err := r.SetQueryParam("buckets.qos_policy.max_throughput", qBucketsQosPolicyMaxThroughput); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMaxThroughputIops != nil {

		// query param buckets.qos_policy.max_throughput_iops
		var qrBucketsQosPolicyMaxThroughputIops int64

		if o.BucketsQosPolicyMaxThroughputIops != nil {
			qrBucketsQosPolicyMaxThroughputIops = *o.BucketsQosPolicyMaxThroughputIops
		}
		qBucketsQosPolicyMaxThroughputIops := swag.FormatInt64(qrBucketsQosPolicyMaxThroughputIops)
		if qBucketsQosPolicyMaxThroughputIops != "" {

			if err := r.SetQueryParam("buckets.qos_policy.max_throughput_iops", qBucketsQosPolicyMaxThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMaxThroughputMbps != nil {

		// query param buckets.qos_policy.max_throughput_mbps
		var qrBucketsQosPolicyMaxThroughputMbps int64

		if o.BucketsQosPolicyMaxThroughputMbps != nil {
			qrBucketsQosPolicyMaxThroughputMbps = *o.BucketsQosPolicyMaxThroughputMbps
		}
		qBucketsQosPolicyMaxThroughputMbps := swag.FormatInt64(qrBucketsQosPolicyMaxThroughputMbps)
		if qBucketsQosPolicyMaxThroughputMbps != "" {

			if err := r.SetQueryParam("buckets.qos_policy.max_throughput_mbps", qBucketsQosPolicyMaxThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMinThroughput != nil {

		// query param buckets.qos_policy.min_throughput
		var qrBucketsQosPolicyMinThroughput string

		if o.BucketsQosPolicyMinThroughput != nil {
			qrBucketsQosPolicyMinThroughput = *o.BucketsQosPolicyMinThroughput
		}
		qBucketsQosPolicyMinThroughput := qrBucketsQosPolicyMinThroughput
		if qBucketsQosPolicyMinThroughput != "" {

			if err := r.SetQueryParam("buckets.qos_policy.min_throughput", qBucketsQosPolicyMinThroughput); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMinThroughputIops != nil {

		// query param buckets.qos_policy.min_throughput_iops
		var qrBucketsQosPolicyMinThroughputIops int64

		if o.BucketsQosPolicyMinThroughputIops != nil {
			qrBucketsQosPolicyMinThroughputIops = *o.BucketsQosPolicyMinThroughputIops
		}
		qBucketsQosPolicyMinThroughputIops := swag.FormatInt64(qrBucketsQosPolicyMinThroughputIops)
		if qBucketsQosPolicyMinThroughputIops != "" {

			if err := r.SetQueryParam("buckets.qos_policy.min_throughput_iops", qBucketsQosPolicyMinThroughputIops); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyMinThroughputMbps != nil {

		// query param buckets.qos_policy.min_throughput_mbps
		var qrBucketsQosPolicyMinThroughputMbps int64

		if o.BucketsQosPolicyMinThroughputMbps != nil {
			qrBucketsQosPolicyMinThroughputMbps = *o.BucketsQosPolicyMinThroughputMbps
		}
		qBucketsQosPolicyMinThroughputMbps := swag.FormatInt64(qrBucketsQosPolicyMinThroughputMbps)
		if qBucketsQosPolicyMinThroughputMbps != "" {

			if err := r.SetQueryParam("buckets.qos_policy.min_throughput_mbps", qBucketsQosPolicyMinThroughputMbps); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyName != nil {

		// query param buckets.qos_policy.name
		var qrBucketsQosPolicyName string

		if o.BucketsQosPolicyName != nil {
			qrBucketsQosPolicyName = *o.BucketsQosPolicyName
		}
		qBucketsQosPolicyName := qrBucketsQosPolicyName
		if qBucketsQosPolicyName != "" {

			if err := r.SetQueryParam("buckets.qos_policy.name", qBucketsQosPolicyName); err != nil {
				return err
			}
		}
	}

	if o.BucketsQosPolicyUUID != nil {

		// query param buckets.qos_policy.uuid
		var qrBucketsQosPolicyUUID string

		if o.BucketsQosPolicyUUID != nil {
			qrBucketsQosPolicyUUID = *o.BucketsQosPolicyUUID
		}
		qBucketsQosPolicyUUID := qrBucketsQosPolicyUUID
		if qBucketsQosPolicyUUID != "" {

			if err := r.SetQueryParam("buckets.qos_policy.uuid", qBucketsQosPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsRetentionDefaultPeriod != nil {

		// query param buckets.retention.default_period
		var qrBucketsRetentionDefaultPeriod string

		if o.BucketsRetentionDefaultPeriod != nil {
			qrBucketsRetentionDefaultPeriod = *o.BucketsRetentionDefaultPeriod
		}
		qBucketsRetentionDefaultPeriod := qrBucketsRetentionDefaultPeriod
		if qBucketsRetentionDefaultPeriod != "" {

			if err := r.SetQueryParam("buckets.retention.default_period", qBucketsRetentionDefaultPeriod); err != nil {
				return err
			}
		}
	}

	if o.BucketsRetentionMode != nil {

		// query param buckets.retention.mode
		var qrBucketsRetentionMode string

		if o.BucketsRetentionMode != nil {
			qrBucketsRetentionMode = *o.BucketsRetentionMode
		}
		qBucketsRetentionMode := qrBucketsRetentionMode
		if qBucketsRetentionMode != "" {

			if err := r.SetQueryParam("buckets.retention.mode", qBucketsRetentionMode); err != nil {
				return err
			}
		}
	}

	if o.BucketsRole != nil {

		// query param buckets.role
		var qrBucketsRole string

		if o.BucketsRole != nil {
			qrBucketsRole = *o.BucketsRole
		}
		qBucketsRole := qrBucketsRole
		if qBucketsRole != "" {

			if err := r.SetQueryParam("buckets.role", qBucketsRole); err != nil {
				return err
			}
		}
	}

	if o.BucketsSize != nil {

		// query param buckets.size
		var qrBucketsSize int64

		if o.BucketsSize != nil {
			qrBucketsSize = *o.BucketsSize
		}
		qBucketsSize := swag.FormatInt64(qrBucketsSize)
		if qBucketsSize != "" {

			if err := r.SetQueryParam("buckets.size", qBucketsSize); err != nil {
				return err
			}
		}
	}

	if o.BucketsSnapshotPolicyName != nil {

		// query param buckets.snapshot_policy.name
		var qrBucketsSnapshotPolicyName string

		if o.BucketsSnapshotPolicyName != nil {
			qrBucketsSnapshotPolicyName = *o.BucketsSnapshotPolicyName
		}
		qBucketsSnapshotPolicyName := qrBucketsSnapshotPolicyName
		if qBucketsSnapshotPolicyName != "" {

			if err := r.SetQueryParam("buckets.snapshot_policy.name", qBucketsSnapshotPolicyName); err != nil {
				return err
			}
		}
	}

	if o.BucketsSnapshotPolicyUUID != nil {

		// query param buckets.snapshot_policy.uuid
		var qrBucketsSnapshotPolicyUUID string

		if o.BucketsSnapshotPolicyUUID != nil {
			qrBucketsSnapshotPolicyUUID = *o.BucketsSnapshotPolicyUUID
		}
		qBucketsSnapshotPolicyUUID := qrBucketsSnapshotPolicyUUID
		if qBucketsSnapshotPolicyUUID != "" {

			if err := r.SetQueryParam("buckets.snapshot_policy.uuid", qBucketsSnapshotPolicyUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsSvmName != nil {

		// query param buckets.svm.name
		var qrBucketsSvmName string

		if o.BucketsSvmName != nil {
			qrBucketsSvmName = *o.BucketsSvmName
		}
		qBucketsSvmName := qrBucketsSvmName
		if qBucketsSvmName != "" {

			if err := r.SetQueryParam("buckets.svm.name", qBucketsSvmName); err != nil {
				return err
			}
		}
	}

	if o.BucketsSvmUUID != nil {

		// query param buckets.svm.uuid
		var qrBucketsSvmUUID string

		if o.BucketsSvmUUID != nil {
			qrBucketsSvmUUID = *o.BucketsSvmUUID
		}
		qBucketsSvmUUID := qrBucketsSvmUUID
		if qBucketsSvmUUID != "" {

			if err := r.SetQueryParam("buckets.svm.uuid", qBucketsSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsType != nil {

		// query param buckets.type
		var qrBucketsType string

		if o.BucketsType != nil {
			qrBucketsType = *o.BucketsType
		}
		qBucketsType := qrBucketsType
		if qBucketsType != "" {

			if err := r.SetQueryParam("buckets.type", qBucketsType); err != nil {
				return err
			}
		}
	}

	if o.BucketsUUID != nil {

		// query param buckets.uuid
		var qrBucketsUUID string

		if o.BucketsUUID != nil {
			qrBucketsUUID = *o.BucketsUUID
		}
		qBucketsUUID := qrBucketsUUID
		if qBucketsUUID != "" {

			if err := r.SetQueryParam("buckets.uuid", qBucketsUUID); err != nil {
				return err
			}
		}
	}

	if o.BucketsVersioningState != nil {

		// query param buckets.versioning_state
		var qrBucketsVersioningState string

		if o.BucketsVersioningState != nil {
			qrBucketsVersioningState = *o.BucketsVersioningState
		}
		qBucketsVersioningState := qrBucketsVersioningState
		if qBucketsVersioningState != "" {

			if err := r.SetQueryParam("buckets.versioning_state", qBucketsVersioningState); err != nil {
				return err
			}
		}
	}

	if o.BucketsVolumeName != nil {

		// query param buckets.volume.name
		var qrBucketsVolumeName string

		if o.BucketsVolumeName != nil {
			qrBucketsVolumeName = *o.BucketsVolumeName
		}
		qBucketsVolumeName := qrBucketsVolumeName
		if qBucketsVolumeName != "" {

			if err := r.SetQueryParam("buckets.volume.name", qBucketsVolumeName); err != nil {
				return err
			}
		}
	}

	if o.BucketsVolumeUUID != nil {

		// query param buckets.volume.uuid
		var qrBucketsVolumeUUID string

		if o.BucketsVolumeUUID != nil {
			qrBucketsVolumeUUID = *o.BucketsVolumeUUID
		}
		qBucketsVolumeUUID := qrBucketsVolumeUUID
		if qBucketsVolumeUUID != "" {

			if err := r.SetQueryParam("buckets.volume.uuid", qBucketsVolumeUUID); err != nil {
				return err
			}
		}
	}

	if o.CertificateName != nil {

		// query param certificate.name
		var qrCertificateName string

		if o.CertificateName != nil {
			qrCertificateName = *o.CertificateName
		}
		qCertificateName := qrCertificateName
		if qCertificateName != "" {

			if err := r.SetQueryParam("certificate.name", qCertificateName); err != nil {
				return err
			}
		}
	}

	if o.CertificateUUID != nil {

		// query param certificate.uuid
		var qrCertificateUUID string

		if o.CertificateUUID != nil {
			qrCertificateUUID = *o.CertificateUUID
		}
		qCertificateUUID := qrCertificateUUID
		if qCertificateUUID != "" {

			if err := r.SetQueryParam("certificate.uuid", qCertificateUUID); err != nil {
				return err
			}
		}
	}

	if o.Comment != nil {

		// query param comment
		var qrComment string

		if o.Comment != nil {
			qrComment = *o.Comment
		}
		qComment := qrComment
		if qComment != "" {

			if err := r.SetQueryParam("comment", qComment); err != nil {
				return err
			}
		}
	}

	if o.DefaultUnixUser != nil {

		// query param default_unix_user
		var qrDefaultUnixUser string

		if o.DefaultUnixUser != nil {
			qrDefaultUnixUser = *o.DefaultUnixUser
		}
		qDefaultUnixUser := qrDefaultUnixUser
		if qDefaultUnixUser != "" {

			if err := r.SetQueryParam("default_unix_user", qDefaultUnixUser); err != nil {
				return err
			}
		}
	}

	if o.DefaultWinUser != nil {

		// query param default_win_user
		var qrDefaultWinUser string

		if o.DefaultWinUser != nil {
			qrDefaultWinUser = *o.DefaultWinUser
		}
		qDefaultWinUser := qrDefaultWinUser
		if qDefaultWinUser != "" {

			if err := r.SetQueryParam("default_win_user", qDefaultWinUser); err != nil {
				return err
			}
		}
	}

	if o.Enabled != nil {

		// query param enabled
		var qrEnabled bool

		if o.Enabled != nil {
			qrEnabled = *o.Enabled
		}
		qEnabled := swag.FormatBool(qrEnabled)
		if qEnabled != "" {

			if err := r.SetQueryParam("enabled", qEnabled); err != nil {
				return err
			}
		}
	}

	if o.Fields != nil {

		// binding items for fields
		joinedFields := o.bindParamFields(reg)

		// query array param fields
		if err := r.SetQueryParam("fields", joinedFields...); err != nil {
			return err
		}
	}

	if o.IsHTTPEnabled != nil {

		// query param is_http_enabled
		var qrIsHTTPEnabled bool

		if o.IsHTTPEnabled != nil {
			qrIsHTTPEnabled = *o.IsHTTPEnabled
		}
		qIsHTTPEnabled := swag.FormatBool(qrIsHTTPEnabled)
		if qIsHTTPEnabled != "" {

			if err := r.SetQueryParam("is_http_enabled", qIsHTTPEnabled); err != nil {
				return err
			}
		}
	}

	if o.IsHTTPSEnabled != nil {

		// query param is_https_enabled
		var qrIsHTTPSEnabled bool

		if o.IsHTTPSEnabled != nil {
			qrIsHTTPSEnabled = *o.IsHTTPSEnabled
		}
		qIsHTTPSEnabled := swag.FormatBool(qrIsHTTPSEnabled)
		if qIsHTTPSEnabled != "" {

			if err := r.SetQueryParam("is_https_enabled", qIsHTTPSEnabled); err != nil {
				return err
			}
		}
	}

	if o.MaxKeyTimeToLive != nil {

		// query param max_key_time_to_live
		var qrMaxKeyTimeToLive string

		if o.MaxKeyTimeToLive != nil {
			qrMaxKeyTimeToLive = *o.MaxKeyTimeToLive
		}
		qMaxKeyTimeToLive := qrMaxKeyTimeToLive
		if qMaxKeyTimeToLive != "" {

			if err := r.SetQueryParam("max_key_time_to_live", qMaxKeyTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.MaxLockRetentionPeriod != nil {

		// query param max_lock_retention_period
		var qrMaxLockRetentionPeriod string

		if o.MaxLockRetentionPeriod != nil {
			qrMaxLockRetentionPeriod = *o.MaxLockRetentionPeriod
		}
		qMaxLockRetentionPeriod := qrMaxLockRetentionPeriod
		if qMaxLockRetentionPeriod != "" {

			if err := r.SetQueryParam("max_lock_retention_period", qMaxLockRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.MaxRecords != nil {

		// query param max_records
		var qrMaxRecords int64

		if o.MaxRecords != nil {
			qrMaxRecords = *o.MaxRecords
		}
		qMaxRecords := swag.FormatInt64(qrMaxRecords)
		if qMaxRecords != "" {

			if err := r.SetQueryParam("max_records", qMaxRecords); err != nil {
				return err
			}
		}
	}

	if o.MetricDuration != nil {

		// query param metric.duration
		var qrMetricDuration string

		if o.MetricDuration != nil {
			qrMetricDuration = *o.MetricDuration
		}
		qMetricDuration := qrMetricDuration
		if qMetricDuration != "" {

			if err := r.SetQueryParam("metric.duration", qMetricDuration); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsOther != nil {

		// query param metric.iops.other
		var qrMetricIopsOther int64

		if o.MetricIopsOther != nil {
			qrMetricIopsOther = *o.MetricIopsOther
		}
		qMetricIopsOther := swag.FormatInt64(qrMetricIopsOther)
		if qMetricIopsOther != "" {

			if err := r.SetQueryParam("metric.iops.other", qMetricIopsOther); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsRead != nil {

		// query param metric.iops.read
		var qrMetricIopsRead int64

		if o.MetricIopsRead != nil {
			qrMetricIopsRead = *o.MetricIopsRead
		}
		qMetricIopsRead := swag.FormatInt64(qrMetricIopsRead)
		if qMetricIopsRead != "" {

			if err := r.SetQueryParam("metric.iops.read", qMetricIopsRead); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsTotal != nil {

		// query param metric.iops.total
		var qrMetricIopsTotal int64

		if o.MetricIopsTotal != nil {
			qrMetricIopsTotal = *o.MetricIopsTotal
		}
		qMetricIopsTotal := swag.FormatInt64(qrMetricIopsTotal)
		if qMetricIopsTotal != "" {

			if err := r.SetQueryParam("metric.iops.total", qMetricIopsTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricIopsWrite != nil {

		// query param metric.iops.write
		var qrMetricIopsWrite int64

		if o.MetricIopsWrite != nil {
			qrMetricIopsWrite = *o.MetricIopsWrite
		}
		qMetricIopsWrite := swag.FormatInt64(qrMetricIopsWrite)
		if qMetricIopsWrite != "" {

			if err := r.SetQueryParam("metric.iops.write", qMetricIopsWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyOther != nil {

		// query param metric.latency.other
		var qrMetricLatencyOther int64

		if o.MetricLatencyOther != nil {
			qrMetricLatencyOther = *o.MetricLatencyOther
		}
		qMetricLatencyOther := swag.FormatInt64(qrMetricLatencyOther)
		if qMetricLatencyOther != "" {

			if err := r.SetQueryParam("metric.latency.other", qMetricLatencyOther); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyRead != nil {

		// query param metric.latency.read
		var qrMetricLatencyRead int64

		if o.MetricLatencyRead != nil {
			qrMetricLatencyRead = *o.MetricLatencyRead
		}
		qMetricLatencyRead := swag.FormatInt64(qrMetricLatencyRead)
		if qMetricLatencyRead != "" {

			if err := r.SetQueryParam("metric.latency.read", qMetricLatencyRead); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyTotal != nil {

		// query param metric.latency.total
		var qrMetricLatencyTotal int64

		if o.MetricLatencyTotal != nil {
			qrMetricLatencyTotal = *o.MetricLatencyTotal
		}
		qMetricLatencyTotal := swag.FormatInt64(qrMetricLatencyTotal)
		if qMetricLatencyTotal != "" {

			if err := r.SetQueryParam("metric.latency.total", qMetricLatencyTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricLatencyWrite != nil {

		// query param metric.latency.write
		var qrMetricLatencyWrite int64

		if o.MetricLatencyWrite != nil {
			qrMetricLatencyWrite = *o.MetricLatencyWrite
		}
		qMetricLatencyWrite := swag.FormatInt64(qrMetricLatencyWrite)
		if qMetricLatencyWrite != "" {

			if err := r.SetQueryParam("metric.latency.write", qMetricLatencyWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricStatus != nil {

		// query param metric.status
		var qrMetricStatus string

		if o.MetricStatus != nil {
			qrMetricStatus = *o.MetricStatus
		}
		qMetricStatus := qrMetricStatus
		if qMetricStatus != "" {

			if err := r.SetQueryParam("metric.status", qMetricStatus); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputRead != nil {

		// query param metric.throughput.read
		var qrMetricThroughputRead int64

		if o.MetricThroughputRead != nil {
			qrMetricThroughputRead = *o.MetricThroughputRead
		}
		qMetricThroughputRead := swag.FormatInt64(qrMetricThroughputRead)
		if qMetricThroughputRead != "" {

			if err := r.SetQueryParam("metric.throughput.read", qMetricThroughputRead); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputTotal != nil {

		// query param metric.throughput.total
		var qrMetricThroughputTotal int64

		if o.MetricThroughputTotal != nil {
			qrMetricThroughputTotal = *o.MetricThroughputTotal
		}
		qMetricThroughputTotal := swag.FormatInt64(qrMetricThroughputTotal)
		if qMetricThroughputTotal != "" {

			if err := r.SetQueryParam("metric.throughput.total", qMetricThroughputTotal); err != nil {
				return err
			}
		}
	}

	if o.MetricThroughputWrite != nil {

		// query param metric.throughput.write
		var qrMetricThroughputWrite int64

		if o.MetricThroughputWrite != nil {
			qrMetricThroughputWrite = *o.MetricThroughputWrite
		}
		qMetricThroughputWrite := swag.FormatInt64(qrMetricThroughputWrite)
		if qMetricThroughputWrite != "" {

			if err := r.SetQueryParam("metric.throughput.write", qMetricThroughputWrite); err != nil {
				return err
			}
		}
	}

	if o.MetricTimestamp != nil {

		// query param metric.timestamp
		var qrMetricTimestamp string

		if o.MetricTimestamp != nil {
			qrMetricTimestamp = *o.MetricTimestamp
		}
		qMetricTimestamp := qrMetricTimestamp
		if qMetricTimestamp != "" {

			if err := r.SetQueryParam("metric.timestamp", qMetricTimestamp); err != nil {
				return err
			}
		}
	}

	if o.MinLockRetentionPeriod != nil {

		// query param min_lock_retention_period
		var qrMinLockRetentionPeriod string

		if o.MinLockRetentionPeriod != nil {
			qrMinLockRetentionPeriod = *o.MinLockRetentionPeriod
		}
		qMinLockRetentionPeriod := qrMinLockRetentionPeriod
		if qMinLockRetentionPeriod != "" {

			if err := r.SetQueryParam("min_lock_retention_period", qMinLockRetentionPeriod); err != nil {
				return err
			}
		}
	}

	if o.Name != nil {

		// query param name
		var qrName string

		if o.Name != nil {
			qrName = *o.Name
		}
		qName := qrName
		if qName != "" {

			if err := r.SetQueryParam("name", qName); err != nil {
				return err
			}
		}
	}

	if o.OrderBy != nil {

		// binding items for order_by
		joinedOrderBy := o.bindParamOrderBy(reg)

		// query array param order_by
		if err := r.SetQueryParam("order_by", joinedOrderBy...); err != nil {
			return err
		}
	}

	if o.Port != nil {

		// query param port
		var qrPort int64

		if o.Port != nil {
			qrPort = *o.Port
		}
		qPort := swag.FormatInt64(qrPort)
		if qPort != "" {

			if err := r.SetQueryParam("port", qPort); err != nil {
				return err
			}
		}
	}

	if o.ReturnRecords != nil {

		// query param return_records
		var qrReturnRecords bool

		if o.ReturnRecords != nil {
			qrReturnRecords = *o.ReturnRecords
		}
		qReturnRecords := swag.FormatBool(qrReturnRecords)
		if qReturnRecords != "" {

			if err := r.SetQueryParam("return_records", qReturnRecords); err != nil {
				return err
			}
		}
	}

	if o.ReturnTimeout != nil {

		// query param return_timeout
		var qrReturnTimeout int64

		if o.ReturnTimeout != nil {
			qrReturnTimeout = *o.ReturnTimeout
		}
		qReturnTimeout := swag.FormatInt64(qrReturnTimeout)
		if qReturnTimeout != "" {

			if err := r.SetQueryParam("return_timeout", qReturnTimeout); err != nil {
				return err
			}
		}
	}

	if o.SecurePort != nil {

		// query param secure_port
		var qrSecurePort int64

		if o.SecurePort != nil {
			qrSecurePort = *o.SecurePort
		}
		qSecurePort := swag.FormatInt64(qrSecurePort)
		if qSecurePort != "" {

			if err := r.SetQueryParam("secure_port", qSecurePort); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawOther != nil {

		// query param statistics.iops_raw.other
		var qrStatisticsIopsRawOther int64

		if o.StatisticsIopsRawOther != nil {
			qrStatisticsIopsRawOther = *o.StatisticsIopsRawOther
		}
		qStatisticsIopsRawOther := swag.FormatInt64(qrStatisticsIopsRawOther)
		if qStatisticsIopsRawOther != "" {

			if err := r.SetQueryParam("statistics.iops_raw.other", qStatisticsIopsRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawRead != nil {

		// query param statistics.iops_raw.read
		var qrStatisticsIopsRawRead int64

		if o.StatisticsIopsRawRead != nil {
			qrStatisticsIopsRawRead = *o.StatisticsIopsRawRead
		}
		qStatisticsIopsRawRead := swag.FormatInt64(qrStatisticsIopsRawRead)
		if qStatisticsIopsRawRead != "" {

			if err := r.SetQueryParam("statistics.iops_raw.read", qStatisticsIopsRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawTotal != nil {

		// query param statistics.iops_raw.total
		var qrStatisticsIopsRawTotal int64

		if o.StatisticsIopsRawTotal != nil {
			qrStatisticsIopsRawTotal = *o.StatisticsIopsRawTotal
		}
		qStatisticsIopsRawTotal := swag.FormatInt64(qrStatisticsIopsRawTotal)
		if qStatisticsIopsRawTotal != "" {

			if err := r.SetQueryParam("statistics.iops_raw.total", qStatisticsIopsRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsIopsRawWrite != nil {

		// query param statistics.iops_raw.write
		var qrStatisticsIopsRawWrite int64

		if o.StatisticsIopsRawWrite != nil {
			qrStatisticsIopsRawWrite = *o.StatisticsIopsRawWrite
		}
		qStatisticsIopsRawWrite := swag.FormatInt64(qrStatisticsIopsRawWrite)
		if qStatisticsIopsRawWrite != "" {

			if err := r.SetQueryParam("statistics.iops_raw.write", qStatisticsIopsRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawOther != nil {

		// query param statistics.latency_raw.other
		var qrStatisticsLatencyRawOther int64

		if o.StatisticsLatencyRawOther != nil {
			qrStatisticsLatencyRawOther = *o.StatisticsLatencyRawOther
		}
		qStatisticsLatencyRawOther := swag.FormatInt64(qrStatisticsLatencyRawOther)
		if qStatisticsLatencyRawOther != "" {

			if err := r.SetQueryParam("statistics.latency_raw.other", qStatisticsLatencyRawOther); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawRead != nil {

		// query param statistics.latency_raw.read
		var qrStatisticsLatencyRawRead int64

		if o.StatisticsLatencyRawRead != nil {
			qrStatisticsLatencyRawRead = *o.StatisticsLatencyRawRead
		}
		qStatisticsLatencyRawRead := swag.FormatInt64(qrStatisticsLatencyRawRead)
		if qStatisticsLatencyRawRead != "" {

			if err := r.SetQueryParam("statistics.latency_raw.read", qStatisticsLatencyRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawTotal != nil {

		// query param statistics.latency_raw.total
		var qrStatisticsLatencyRawTotal int64

		if o.StatisticsLatencyRawTotal != nil {
			qrStatisticsLatencyRawTotal = *o.StatisticsLatencyRawTotal
		}
		qStatisticsLatencyRawTotal := swag.FormatInt64(qrStatisticsLatencyRawTotal)
		if qStatisticsLatencyRawTotal != "" {

			if err := r.SetQueryParam("statistics.latency_raw.total", qStatisticsLatencyRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsLatencyRawWrite != nil {

		// query param statistics.latency_raw.write
		var qrStatisticsLatencyRawWrite int64

		if o.StatisticsLatencyRawWrite != nil {
			qrStatisticsLatencyRawWrite = *o.StatisticsLatencyRawWrite
		}
		qStatisticsLatencyRawWrite := swag.FormatInt64(qrStatisticsLatencyRawWrite)
		if qStatisticsLatencyRawWrite != "" {

			if err := r.SetQueryParam("statistics.latency_raw.write", qStatisticsLatencyRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsStatus != nil {

		// query param statistics.status
		var qrStatisticsStatus string

		if o.StatisticsStatus != nil {
			qrStatisticsStatus = *o.StatisticsStatus
		}
		qStatisticsStatus := qrStatisticsStatus
		if qStatisticsStatus != "" {

			if err := r.SetQueryParam("statistics.status", qStatisticsStatus); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawRead != nil {

		// query param statistics.throughput_raw.read
		var qrStatisticsThroughputRawRead int64

		if o.StatisticsThroughputRawRead != nil {
			qrStatisticsThroughputRawRead = *o.StatisticsThroughputRawRead
		}
		qStatisticsThroughputRawRead := swag.FormatInt64(qrStatisticsThroughputRawRead)
		if qStatisticsThroughputRawRead != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.read", qStatisticsThroughputRawRead); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawTotal != nil {

		// query param statistics.throughput_raw.total
		var qrStatisticsThroughputRawTotal int64

		if o.StatisticsThroughputRawTotal != nil {
			qrStatisticsThroughputRawTotal = *o.StatisticsThroughputRawTotal
		}
		qStatisticsThroughputRawTotal := swag.FormatInt64(qrStatisticsThroughputRawTotal)
		if qStatisticsThroughputRawTotal != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.total", qStatisticsThroughputRawTotal); err != nil {
				return err
			}
		}
	}

	if o.StatisticsThroughputRawWrite != nil {

		// query param statistics.throughput_raw.write
		var qrStatisticsThroughputRawWrite int64

		if o.StatisticsThroughputRawWrite != nil {
			qrStatisticsThroughputRawWrite = *o.StatisticsThroughputRawWrite
		}
		qStatisticsThroughputRawWrite := swag.FormatInt64(qrStatisticsThroughputRawWrite)
		if qStatisticsThroughputRawWrite != "" {

			if err := r.SetQueryParam("statistics.throughput_raw.write", qStatisticsThroughputRawWrite); err != nil {
				return err
			}
		}
	}

	if o.StatisticsTimestamp != nil {

		// query param statistics.timestamp
		var qrStatisticsTimestamp string

		if o.StatisticsTimestamp != nil {
			qrStatisticsTimestamp = *o.StatisticsTimestamp
		}
		qStatisticsTimestamp := qrStatisticsTimestamp
		if qStatisticsTimestamp != "" {

			if err := r.SetQueryParam("statistics.timestamp", qStatisticsTimestamp); err != nil {
				return err
			}
		}
	}

	if o.SvmName != nil {

		// query param svm.name
		var qrSvmName string

		if o.SvmName != nil {
			qrSvmName = *o.SvmName
		}
		qSvmName := qrSvmName
		if qSvmName != "" {

			if err := r.SetQueryParam("svm.name", qSvmName); err != nil {
				return err
			}
		}
	}

	if o.SvmUUID != nil {

		// query param svm.uuid
		var qrSvmUUID string

		if o.SvmUUID != nil {
			qrSvmUUID = *o.SvmUUID
		}
		qSvmUUID := qrSvmUUID
		if qSvmUUID != "" {

			if err := r.SetQueryParam("svm.uuid", qSvmUUID); err != nil {
				return err
			}
		}
	}

	if o.UsersAccessKey != nil {

		// query param users.access_key
		var qrUsersAccessKey string

		if o.UsersAccessKey != nil {
			qrUsersAccessKey = *o.UsersAccessKey
		}
		qUsersAccessKey := qrUsersAccessKey
		if qUsersAccessKey != "" {

			if err := r.SetQueryParam("users.access_key", qUsersAccessKey); err != nil {
				return err
			}
		}
	}

	if o.UsersComment != nil {

		// query param users.comment
		var qrUsersComment string

		if o.UsersComment != nil {
			qrUsersComment = *o.UsersComment
		}
		qUsersComment := qrUsersComment
		if qUsersComment != "" {

			if err := r.SetQueryParam("users.comment", qUsersComment); err != nil {
				return err
			}
		}
	}

	if o.UsersKeyExpiryTime != nil {

		// query param users.key_expiry_time
		var qrUsersKeyExpiryTime string

		if o.UsersKeyExpiryTime != nil {
			qrUsersKeyExpiryTime = *o.UsersKeyExpiryTime
		}
		qUsersKeyExpiryTime := qrUsersKeyExpiryTime
		if qUsersKeyExpiryTime != "" {

			if err := r.SetQueryParam("users.key_expiry_time", qUsersKeyExpiryTime); err != nil {
				return err
			}
		}
	}

	if o.UsersKeyTimeToLive != nil {

		// query param users.key_time_to_live
		var qrUsersKeyTimeToLive string

		if o.UsersKeyTimeToLive != nil {
			qrUsersKeyTimeToLive = *o.UsersKeyTimeToLive
		}
		qUsersKeyTimeToLive := qrUsersKeyTimeToLive
		if qUsersKeyTimeToLive != "" {

			if err := r.SetQueryParam("users.key_time_to_live", qUsersKeyTimeToLive); err != nil {
				return err
			}
		}
	}

	if o.UsersName != nil {

		// query param users.name
		var qrUsersName string

		if o.UsersName != nil {
			qrUsersName = *o.UsersName
		}
		qUsersName := qrUsersName
		if qUsersName != "" {

			if err := r.SetQueryParam("users.name", qUsersName); err != nil {
				return err
			}
		}
	}

	if o.UsersSvmName != nil {

		// query param users.svm.name
		var qrUsersSvmName string

		if o.UsersSvmName != nil {
			qrUsersSvmName = *o.UsersSvmName
		}
		qUsersSvmName := qrUsersSvmName
		if qUsersSvmName != "" {

			if err := r.SetQueryParam("users.svm.name", qUsersSvmName); err != nil {
				return err
			}
		}
	}

	if o.UsersSvmUUID != nil {

		// query param users.svm.uuid
		var qrUsersSvmUUID string

		if o.UsersSvmUUID != nil {
			qrUsersSvmUUID = *o.UsersSvmUUID
		}
		qUsersSvmUUID := qrUsersSvmUUID
		if qUsersSvmUUID != "" {

			if err := r.SetQueryParam("users.svm.uuid", qUsersSvmUUID); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

// bindParamS3ServiceCollectionGet binds the parameter fields
func (o *S3ServiceCollectionGetParams) bindParamFields(formats strfmt.Registry) []string {
	fieldsIR := o.Fields

	var fieldsIC []string
	for _, fieldsIIR := range fieldsIR { // explode []string

		fieldsIIV := fieldsIIR // string as string
		fieldsIC = append(fieldsIC, fieldsIIV)
	}

	// items.CollectionFormat: "csv"
	fieldsIS := swag.JoinByFormat(fieldsIC, "csv")

	return fieldsIS
}

// bindParamS3ServiceCollectionGet binds the parameter order_by
func (o *S3ServiceCollectionGetParams) bindParamOrderBy(formats strfmt.Registry) []string {
	orderByIR := o.OrderBy

	var orderByIC []string
	for _, orderByIIR := range orderByIR { // explode []string

		orderByIIV := orderByIIR // string as string
		orderByIC = append(orderByIC, orderByIIV)
	}

	// items.CollectionFormat: "csv"
	orderByIS := swag.JoinByFormat(orderByIC, "csv")

	return orderByIS
}
