// Code generated by go-swagger; DO NOT EDIT.

package object_store

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"encoding/json"
	"fmt"
	"io"
	"strconv"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"

	"github.com/netapp/trident/storage_drivers/ontap/api/rest/models"
)

// S3ServiceDeleteCollectionReader is a Reader for the S3ServiceDeleteCollection structure.
type S3ServiceDeleteCollectionReader struct {
	formats strfmt.Registry
}

// ReadResponse reads a server response into the received o.
func (o *S3ServiceDeleteCollectionReader) ReadResponse(response runtime.ClientResponse, consumer runtime.Consumer) (interface{}, error) {
	switch response.Code() {
	case 200:
		result := NewS3ServiceDeleteCollectionOK()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	case 202:
		result := NewS3ServiceDeleteCollectionAccepted()
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		return result, nil
	default:
		result := NewS3ServiceDeleteCollectionDefault(response.Code())
		if err := result.readResponse(response, consumer, o.formats); err != nil {
			return nil, err
		}
		if response.Code()/100 == 2 {
			return result, nil
		}
		return nil, result
	}
}

// NewS3ServiceDeleteCollectionOK creates a S3ServiceDeleteCollectionOK with default headers values
func NewS3ServiceDeleteCollectionOK() *S3ServiceDeleteCollectionOK {
	return &S3ServiceDeleteCollectionOK{}
}

/*
S3ServiceDeleteCollectionOK describes a response with status code 200, with default header values.

OK
*/
type S3ServiceDeleteCollectionOK struct {
	Payload *models.S3ServiceJobLinkResponse
}

// IsSuccess returns true when this s3 service delete collection o k response has a 2xx status code
func (o *S3ServiceDeleteCollectionOK) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service delete collection o k response has a 3xx status code
func (o *S3ServiceDeleteCollectionOK) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service delete collection o k response has a 4xx status code
func (o *S3ServiceDeleteCollectionOK) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service delete collection o k response has a 5xx status code
func (o *S3ServiceDeleteCollectionOK) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service delete collection o k response a status code equal to that given
func (o *S3ServiceDeleteCollectionOK) IsCode(code int) bool {
	return code == 200
}

// Code gets the status code for the s3 service delete collection o k response
func (o *S3ServiceDeleteCollectionOK) Code() int {
	return 200
}

func (o *S3ServiceDeleteCollectionOK) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3ServiceDeleteCollectionOK %s", 200, payload)
}

func (o *S3ServiceDeleteCollectionOK) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3ServiceDeleteCollectionOK %s", 200, payload)
}

func (o *S3ServiceDeleteCollectionOK) GetPayload() *models.S3ServiceJobLinkResponse {
	return o.Payload
}

func (o *S3ServiceDeleteCollectionOK) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3ServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3ServiceDeleteCollectionAccepted creates a S3ServiceDeleteCollectionAccepted with default headers values
func NewS3ServiceDeleteCollectionAccepted() *S3ServiceDeleteCollectionAccepted {
	return &S3ServiceDeleteCollectionAccepted{}
}

/*
S3ServiceDeleteCollectionAccepted describes a response with status code 202, with default header values.

Accepted
*/
type S3ServiceDeleteCollectionAccepted struct {
	Payload *models.S3ServiceJobLinkResponse
}

// IsSuccess returns true when this s3 service delete collection accepted response has a 2xx status code
func (o *S3ServiceDeleteCollectionAccepted) IsSuccess() bool {
	return true
}

// IsRedirect returns true when this s3 service delete collection accepted response has a 3xx status code
func (o *S3ServiceDeleteCollectionAccepted) IsRedirect() bool {
	return false
}

// IsClientError returns true when this s3 service delete collection accepted response has a 4xx status code
func (o *S3ServiceDeleteCollectionAccepted) IsClientError() bool {
	return false
}

// IsServerError returns true when this s3 service delete collection accepted response has a 5xx status code
func (o *S3ServiceDeleteCollectionAccepted) IsServerError() bool {
	return false
}

// IsCode returns true when this s3 service delete collection accepted response a status code equal to that given
func (o *S3ServiceDeleteCollectionAccepted) IsCode(code int) bool {
	return code == 202
}

// Code gets the status code for the s3 service delete collection accepted response
func (o *S3ServiceDeleteCollectionAccepted) Code() int {
	return 202
}

func (o *S3ServiceDeleteCollectionAccepted) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3ServiceDeleteCollectionAccepted %s", 202, payload)
}

func (o *S3ServiceDeleteCollectionAccepted) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3ServiceDeleteCollectionAccepted %s", 202, payload)
}

func (o *S3ServiceDeleteCollectionAccepted) GetPayload() *models.S3ServiceJobLinkResponse {
	return o.Payload
}

func (o *S3ServiceDeleteCollectionAccepted) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.S3ServiceJobLinkResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

// NewS3ServiceDeleteCollectionDefault creates a S3ServiceDeleteCollectionDefault with default headers values
func NewS3ServiceDeleteCollectionDefault(code int) *S3ServiceDeleteCollectionDefault {
	return &S3ServiceDeleteCollectionDefault{
		_statusCode: code,
	}
}

/*
	S3ServiceDeleteCollectionDefault describes a response with status code -1, with default header values.

	ONTAP Error Response Codes

| Error Code | Description |
| ---------- | ----------- |
| 92405864   | An error occurs when deleting an S3 user or bucket. The reason for failure is detailed in the error message. Follow the error codes specified for the user or bucket endpoints to see details for the failure. |
*/
type S3ServiceDeleteCollectionDefault struct {
	_statusCode int

	Payload *models.ErrorResponse
}

// IsSuccess returns true when this s3 service delete collection default response has a 2xx status code
func (o *S3ServiceDeleteCollectionDefault) IsSuccess() bool {
	return o._statusCode/100 == 2
}

// IsRedirect returns true when this s3 service delete collection default response has a 3xx status code
func (o *S3ServiceDeleteCollectionDefault) IsRedirect() bool {
	return o._statusCode/100 == 3
}

// IsClientError returns true when this s3 service delete collection default response has a 4xx status code
func (o *S3ServiceDeleteCollectionDefault) IsClientError() bool {
	return o._statusCode/100 == 4
}

// IsServerError returns true when this s3 service delete collection default response has a 5xx status code
func (o *S3ServiceDeleteCollectionDefault) IsServerError() bool {
	return o._statusCode/100 == 5
}

// IsCode returns true when this s3 service delete collection default response a status code equal to that given
func (o *S3ServiceDeleteCollectionDefault) IsCode(code int) bool {
	return o._statusCode == code
}

// Code gets the status code for the s3 service delete collection default response
func (o *S3ServiceDeleteCollectionDefault) Code() int {
	return o._statusCode
}

func (o *S3ServiceDeleteCollectionDefault) Error() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3_service_delete_collection default %s", o._statusCode, payload)
}

func (o *S3ServiceDeleteCollectionDefault) String() string {
	payload, _ := json.Marshal(o.Payload)
	return fmt.Sprintf("[DELETE /protocols/s3/services][%d] s3_service_delete_collection default %s", o._statusCode, payload)
}

func (o *S3ServiceDeleteCollectionDefault) GetPayload() *models.ErrorResponse {
	return o.Payload
}

func (o *S3ServiceDeleteCollectionDefault) readResponse(response runtime.ClientResponse, consumer runtime.Consumer, formats strfmt.Registry) error {

	o.Payload = new(models.ErrorResponse)

	// response payload
	if err := consumer.Consume(response.Body(), o.Payload); err != nil && err != io.EOF {
		return err
	}

	return nil
}

/*
S3ServiceDeleteCollectionBody s3 service delete collection body
swagger:model S3ServiceDeleteCollectionBody
*/
type S3ServiceDeleteCollectionBody struct {

	// s3 service response inline records
	S3ServiceResponseInlineRecords []*models.S3Service `json:"records,omitempty"`
}

// Validate validates this s3 service delete collection body
func (o *S3ServiceDeleteCollectionBody) Validate(formats strfmt.Registry) error {
	var res []error

	if err := o.validateS3ServiceResponseInlineRecords(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceDeleteCollectionBody) validateS3ServiceResponseInlineRecords(formats strfmt.Registry) error {
	if swag.IsZero(o.S3ServiceResponseInlineRecords) { // not required
		return nil
	}

	for i := 0; i < len(o.S3ServiceResponseInlineRecords); i++ {
		if swag.IsZero(o.S3ServiceResponseInlineRecords[i]) { // not required
			continue
		}

		if o.S3ServiceResponseInlineRecords[i] != nil {
			if err := o.S3ServiceResponseInlineRecords[i].Validate(formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// ContextValidate validate this s3 service delete collection body based on the context it is used
func (o *S3ServiceDeleteCollectionBody) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := o.contextValidateS3ServiceResponseInlineRecords(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (o *S3ServiceDeleteCollectionBody) contextValidateS3ServiceResponseInlineRecords(ctx context.Context, formats strfmt.Registry) error {

	for i := 0; i < len(o.S3ServiceResponseInlineRecords); i++ {

		if o.S3ServiceResponseInlineRecords[i] != nil {
			if err := o.S3ServiceResponseInlineRecords[i].ContextValidate(ctx, formats); err != nil {
				if ve, ok := err.(*errors.Validation); ok {
					return ve.ValidateName("info" + "." + "records" + "." + strconv.Itoa(i))
				}
				return err
			}
		}

	}

	return nil
}

// MarshalBinary interface implementation
func (o *S3ServiceDeleteCollectionBody) MarshalBinary() ([]byte, error) {
	if o == nil {
		return nil, nil
	}
	return swag.WriteJSON(o)
}

// UnmarshalBinary interface implementation
func (o *S3ServiceDeleteCollectionBody) UnmarshalBinary(b []byte) error {
	var res S3ServiceDeleteCollectionBody
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*o = res
	return nil
}
